/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.property;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.IRefBillField;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.IValueComparator;
import kd.bos.entity.validate.RequiredValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.session.impl.CodelessShareSessionServiceImpl;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeDataRangeField;
import kd.bos.nocode.ext.metadata.entity.field.SelectScope;
import kd.bos.nocode.ext.operation.validate.MinMaxCountValidator;
import kd.bos.nocode.ext.property.NoCodeProp;
import kd.bos.nocode.ext.property.annotations.PropInfo;
import kd.bos.nocode.ext.proxy.PropertyHandleUtilProxy;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.ext.validate.NoCodeRequiredValidator;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NcLocalCacheUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

@PropInfo(name="\u5173\u8054\u8868\u5355")
public class NoCodeMulRefBillProp
extends FieldProp
implements NoCodeProp,
INoCodeRefBillProp,
IRefBillField {
    private static final long serialVersionUID = -7607072286043384620L;
    private static final Log log = LogFactory.getLog(NoCodeMulRefBillProp.class);
    private static final String CACHETYPE_SHARESESSION = "CacheType_shareSession";
    private String propsDisplay;
    private int multi = 0;
    private String billEntityId;
    private int dbType = -9;
    private NoCodeDataRangeField dataRange = new NoCodeDataRangeField("0", "3");
    private SelectScope selectScope = new SelectScope();
    private String noCodeDefValue;
    private String refTableKey;

    @JsonProperty(value="PropsDisplay")
    @SimplePropertyAttribute(name="PropsDisplay")
    public String getPropsDisplay() {
        return this.propsDisplay;
    }

    public void setPropsDisplay(String displayProperty) {
        this.propsDisplay = displayProperty;
    }

    @SimplePropertyAttribute(name="Multi")
    @DefaultValueAttribute(value="0")
    public int getMulti() {
        return this.multi;
    }

    public void setMulti(int multi) {
        this.multi = multi;
    }

    public String getOrgProp() {
        return null;
    }

    @KSMethod
    @SimplePropertyAttribute
    public String getBillEntityId() {
        return this.billEntityId;
    }

    public String getDisplayProp() {
        return this.getMainDisplayProperty();
    }

    public String getNumberProp() {
        return this.getMainDisplayProperty();
    }

    public IDataEntityProperty getDispProp() {
        return null;
    }

    public String getBillEntityId(IDataModel model) {
        return this.getBillEntityId();
    }

    public IDataEntityType getComplexType() {
        return null;
    }

    public FilterCondition getFilterCondition(IDataModel model) {
        return null;
    }

    public FilterBuilder buildCoreFilter(IDataModel model) {
        return null;
    }

    public List<QFilter> buildCoreFilterByString(IDataModel model) {
        return null;
    }

    public boolean isShowOnlyAudited() {
        return false;
    }

    public QFilter getBaseDataControlOrgQFilter(IDataModel model, String entityId) {
        return null;
    }

    public String getClientType(String refPropKey) {
        return null;
    }

    public String getBillStatus() {
        return null;
    }

    public void setBillEntityId(String baseEntityName) {
        this.billEntityId = baseEntityName;
    }

    @ComplexPropertyAttribute(name="DataRange")
    public NoCodeDataRangeField getDataRange() {
        return this.dataRange;
    }

    public void setDataRange(NoCodeDataRangeField dataRange) {
        this.dataRange = dataRange;
    }

    public Object getBindingRefBillValue(Object v) {
        if (v instanceof String && StringUtils.isNotBlank((CharSequence)((String)v))) {
            DynamicObject[] dynamicObjects;
            String sValue = (String)v;
            BillEntityType dt = this.getBillEntityType();
            if (dt != null && (dynamicObjects = this.loadRefBillObjects(sValue, this.getSelectFields())) != null && dynamicObjects.length > 0) {
                String selectFields = this.getSelectFields();
                Object[] fields = selectFields.split(",");
                List<Map<String, Object>> resultData = PropertyHandleUtilProxy.toMapListRoot(dt.getName(), "$", dynamicObjects, Sets.newHashSet((Object[])fields));
                if (resultData != null && !resultData.isEmpty()) {
                    return this.packageData(resultData, (String[])fields, 1000);
                }
            }
        }
        return null;
    }

    private Object[] packageData(List<Map<String, Object>> resultData, String[] fields, int top) {
        Object[] objs = new Object[resultData.size()];
        String fid = this.getBillEntityId();
        Set hides = NoCodePermHelper.getNoViewFieldPermSet((String)fid);
        for (int i = 0; i < resultData.size(); ++i) {
            Map<String, Object> dynamicObjectMap = resultData.get(i);
            String[] arr = new String[fields.length];
            for (int j = 0; j < fields.length; ++j) {
                if (i > top && j > 0) continue;
                arr[j] = hides.contains(fields[j]) ? "" : (dynamicObjectMap.get(fields[j]) == null ? "" : String.valueOf(dynamicObjectMap.get(fields[j])));
            }
            objs[i] = arr;
        }
        return objs;
    }

    public DynamicObject[] loadRefBillObjects(String pks, String selects) {
        if (StringUtils.isBlank((CharSequence)pks)) {
            return new DynamicObject[0];
        }
        String[] split = pks.split(",");
        Object[] pkObjs = new Object[split.length];
        BillEntityType dt = this.getBillEntityType();
        if (dt == null) {
            return null;
        }
        for (int i = 0; i < split.length; ++i) {
            String sv = split[i];
            pkObjs[i] = NcEntityTypeUtil.convertPKValueType((DynamicObjectType)dt, (Object)sv);
        }
        String pkName = dt.getPrimaryKey().getName();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)dt.getName(), (String)selects, (QFilter[])new QFilter[]{new QFilter(pkName, "in", (Object)pkObjs)});
        Map id2DynObjMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(e -> e.get("id"), Function.identity()));
        ArrayList<DynamicObject> resultDynObjs = new ArrayList<DynamicObject>(dynamicObjects.length);
        for (Object pkObj : pkObjs) {
            DynamicObject dynObj = (DynamicObject)id2DynObjMap.get(pkObj);
            if (Objects.isNull(dynObj)) continue;
            resultDynObjs.add(dynObj);
        }
        return resultDynObjs.toArray(new DynamicObject[0]);
    }

    public boolean isMultiSelect() {
        return this.getMulti() > 0;
    }

    public String getSelectFields() {
        BillEntityType dt = this.getBillEntityType();
        if (dt == null) {
            return "";
        }
        ISimpleProperty primaryKey = dt.getPrimaryKey();
        ArrayList<String> props = new ArrayList<String>(10);
        props.add(primaryKey.getName());
        if (StringUtils.isNotBlank((CharSequence)this.getPropsDisplay())) {
            String[] split;
            for (String f : split = this.getPropsDisplay().split(",")) {
                if (dt.findProperty(f) == null) continue;
                props.add(f);
            }
        }
        return String.join((CharSequence)",", props);
    }

    public Class<?> getPropertyType() {
        return String.class;
    }

    public int getDbType() {
        return this.dbType;
    }

    public void setDbType(int dbType) {
        this.dbType = dbType;
    }

    public BillEntityType getBillEntityType() {
        if (!NcEntityTypeUtil.isFormExist((String)this.getBillEntityNumber())) {
            return null;
        }
        return (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.getBillEntityNumber());
    }

    public IDataEntityProperty findProperty(String propertyName) {
        BillEntityType dt = this.getBillEntityType();
        if (dt == null) {
            return null;
        }
        return this.getBillEntityType().findProperty(propertyName);
    }

    public List<AbstractValidator> getValidators() {
        String showType;
        List validators = super.getValidators();
        String string = showType = this.getCustomProperty("showType") == null ? null : this.getCustomProperty("showType").toString();
        if ("2".equals(showType) && !(this.getParent() instanceof EntryType)) {
            return validators;
        }
        validators.add(new MinMaxCountValidator((DynamicProperty)this, this.getName(), this.getDisplayName().toString()));
        if (this.isMustInput()) {
            validators.removeIf(RequiredValidator.class::isInstance);
            NoCodeRequiredValidator requiredValidator = new NoCodeRequiredValidator(this.getCompareProp(), this.getName(), this.getDisplayName().toString(), this.getValueComparator());
            validators.add(requiredValidator);
        }
        return validators;
    }

    public boolean isEnableNull() {
        return true;
    }

    public IValueComparator getValueComparator() {
        return o -> o == null || o != null && StringUtils.isEmpty((CharSequence)o.toString());
    }

    public void applyDefaultValue(IDataModel model, DynamicObject dataEntity, int rowIndex) {
        if (NcEntityTypeUtil.isFormExist((String)this.getBillFormId())) {
            this.calcDefaultValue(model, dataEntity, rowIndex, (IFieldHandle)this);
        }
    }

    @ComplexPropertyAttribute(name="SelectScope")
    public SelectScope getSelectScope() {
        return this.selectScope;
    }

    public void setSelectScope(SelectScope selectScope) {
        this.selectScope = selectScope;
    }

    @Override
    @SimplePropertyAttribute
    public String getNoCodeDefValue() {
        return this.noCodeDefValue;
    }

    public void setNoCodeDefValue(String noCodeDefValue) {
        this.noCodeDefValue = noCodeDefValue;
    }

    @SimplePropertyAttribute(name="RefTableKey")
    public String getRefTableKey() {
        return this.refTableKey;
    }

    public void setRefTableKey(String refTableKey) {
        this.refTableKey = refTableKey;
    }

    public Object getDTValueFast(DynamicObject dataEntity) {
        String value = (String)super.getDTValueFast(dataEntity);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        Boolean isNocodeShareSession = (Boolean)NcLocalCacheUtil.getOrCreateTransient((String)CACHETYPE_SHARESESSION, (String)RequestContext.get().getGlobalSessionId(), key -> new CodelessShareSessionServiceImpl().isNocodeShareSession(key));
        if (isNocodeShareSession.booleanValue()) {
            return value;
        }
        String formId = this.getBillFormId();
        String entityNumber = this.getBillEntityNumber();
        String refTableKey = this.getRefTableKey();
        if (StringUtils.isNotBlank((CharSequence)refTableKey) && FormMetadataUtils.isInnerTableRefBillProp(dataEntity, refTableKey)) {
            return value;
        }
        try {
            NoCodePermHelper.verifyFuncPermPassTemp((FuncPermItemEnum)FuncPermItemEnum.view, (String)FormMetaUtil.getAppIdByFormId((String)formId), (String)entityNumber);
        }
        catch (Exception e) {
            return null;
        }
        List permFilters = NoCodePermHelper.getDataPermFilters((String)formId);
        if (CollectionUtils.isEmpty((Collection)permFilters) || permFilters.stream().allMatch(Objects::isNull)) {
            return value;
        }
        int queryAll = -1;
        List validPkIds = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])permFilters.toArray(new QFilter[0]), (String)"", (int)-1).stream().map(String::valueOf).collect(Collectors.toList());
        return Splitter.on((String)",").splitToStream((CharSequence)value).filter(validPkIds::contains).collect(Collectors.joining(","));
    }
}

