/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.property;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.qing.AnalysisField;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.session.impl.CodelessShareSessionServiceImpl;
import kd.bos.nocode.ext.metadata.entity.field.SelectScope;
import kd.bos.nocode.ext.property.NoCodeProp;
import kd.bos.nocode.ext.property.annotations.PropInfo;
import kd.bos.nocode.ext.proxy.PropertyHandleUtilProxy;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NcLocalCacheUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

@PropInfo(name="\u5173\u8054\u8868\u5355")
public class NoCodeRefBillProp
extends RefBillProp
implements NoCodeProp,
INoCodeRefBillProp {
    private static final long serialVersionUID = 5414677622934686533L;
    private static final Log log = LogFactory.getLog(NoCodeRefBillProp.class);
    private boolean refPropIdIsString = false;
    private static final String CACHETYPE_SHARESESSION = "CacheType_shareSession";
    private static final String CACHETYPE_VERIFYFUNCPERM = "CacheType_verifyFuncPerm";
    private String propsDisplay = null;
    private SelectScope selectScope = new SelectScope();
    private String noCodeDefValue;
    private String refTableKey;

    @JsonProperty(value="PropsDisplay")
    @SimplePropertyAttribute(name="PropsDisplay")
    public String getPropsDisplay() {
        return this.propsDisplay;
    }

    public void setPropsDisplay(String displayProperty) {
        this.propsDisplay = displayProperty;
    }

    public Object getBindingRefBillValue(Object v, String displayProp) {
        if (!(v instanceof DynamicObject)) {
            return null;
        }
        BillEntityType dt = ((DynamicObject)v).getDataEntityType() instanceof BillEntityType ? (BillEntityType)((DynamicObject)v).getDataEntityType() : (BillEntityType)this.getComplexType();
        Object obj = this.getBindingRefBillValueByDynamicObject((DynamicObject)v, dt);
        return new Object[]{obj};
    }

    public Object getBindingRefBillValueFromMulRefEditor(Object v) {
        if (!(v instanceof DynamicObject)) {
            return null;
        }
        DynamicObject dynamicObjects = (DynamicObject)v;
        BillEntityType dt = ((DynamicObject)v).getDataEntityType() instanceof BillEntityType ? (BillEntityType)((DynamicObject)v).getDataEntityType() : (BillEntityType)this.getComplexType();
        String selectFields = this.getSelectFields(dt);
        Object[] fields = selectFields.split(",");
        List<Map<String, Object>> resultData = PropertyHandleUtilProxy.toMapListRoot(dt.getName(), "$", new DynamicObject[]{dynamicObjects}, Sets.newHashSet((Object[])fields));
        if (resultData != null && !resultData.isEmpty()) {
            return this.packageData(resultData, (String[])fields);
        }
        return null;
    }

    private Object[] packageData(List<Map<String, Object>> resultData, String[] fields) {
        Object[] objs = new Object[resultData.size()];
        String fid = this.getBillEntityId();
        Set hides = NoCodePermHelper.getNoViewFieldPermSet((String)fid);
        for (int i = 0; i < resultData.size(); ++i) {
            Map<String, Object> dynamicObjectMap = resultData.get(i);
            String[] arr = new String[fields.length];
            for (int j = 0; j < fields.length; ++j) {
                arr[j] = hides.contains(fields[j]) ? "" : (dynamicObjectMap.get(fields[j]) == null ? "" : String.valueOf(dynamicObjectMap.get(fields[j])));
            }
            objs[i] = arr;
        }
        return objs;
    }

    private Object getBindingRefBillValueByDynamicObject(DynamicObject obj, BillEntityType dt) {
        String selectFields = this.getSelectFields(dt);
        String[] props = selectFields.split(",");
        Object[] arr = new Object[props.length];
        ISimpleProperty primaryKey = dt.getPrimaryKey();
        for (int i = 0; i < props.length; ++i) {
            IDataEntityProperty p = dt.findProperty(props[i]);
            if (p == null || p.getValue((Object)obj) == null) {
                arr[i] = "";
                continue;
            }
            Object valueFast = p.getValue((Object)obj);
            if (primaryKey.getName().equalsIgnoreCase(props[i])) {
                arr[i] = valueFast.toString();
            } else if (valueFast instanceof OrmLocaleValue) {
                arr[i] = ((OrmLocaleValue)valueFast).getLocaleValue();
            } else if (p instanceof INoCodeRefBillProp && valueFast instanceof DynamicObject) {
                String nestDisplayProp = ((INoCodeRefBillProp)p).getMainDisplayProperty();
                DynamicObject nestRefObj = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)valueFast).getPkValue(), (String)((INoCodeRefBillProp)p).getBillEntityNumber(), (String)nestDisplayProp);
                arr[i] = nestRefObj.get(nestDisplayProp);
            } else {
                arr[i] = valueFast;
            }
            if (arr[i] != null) continue;
            arr[i] = "";
        }
        return arr;
    }

    public FilterField createFilterField(MainEntityType mainType, String propName) {
        return new FilterField(mainType, (IDataEntityProperty)this, (IDataEntityProperty)null, (IDataEntityProperty)null, (String)null);
    }

    public List<FilterField> createFilterFields(MainEntityType mainType) {
        ArrayList<FilterField> filterFields = new ArrayList<FilterField>();
        FilterField filterField = this.createFilterField(mainType, this.getName());
        filterFields.add(filterField);
        return filterFields;
    }

    public AnalysisField createAnalysisField(MainEntityType mainType, String refPropKey) {
        return new AnalysisField(mainType, (IDataEntityProperty)this, null, null, null);
    }

    public List<AnalysisField> createAnalysisFields(MainEntityType mainType) {
        ArrayList<AnalysisField> analysisFields = new ArrayList<AnalysisField>();
        AnalysisField analysisField = this.createAnalysisField(mainType, this.getName());
        if (analysisField != null) {
            analysisFields.add(analysisField);
        }
        return analysisFields;
    }

    public IDataEntityProperty findProperty(String propertyName) {
        return EntityMetadataCache.getDataEntityType((String)this.getBillEntityNumber()).findProperty(propertyName);
    }

    public String getSelectFields(BillEntityType dt) {
        ISimpleProperty primaryKey = dt.getPrimaryKey();
        ArrayList<String> props = new ArrayList<String>(10);
        props.add(primaryKey.getName());
        if (StringUtils.isNotBlank((CharSequence)this.getPropsDisplay())) {
            String[] split;
            for (String f : split = this.getPropsDisplay().split(",")) {
                if (dt.findProperty(f) == null) continue;
                props.add(f);
            }
        }
        return String.join((CharSequence)",", props);
    }

    public DynamicObject[] loadRefBillObjects(String pks, String selects) {
        if (StringUtils.isBlank((CharSequence)pks)) {
            return new DynamicObject[0];
        }
        String[] split = pks.split(",");
        Object[] pkObjs = new Object[split.length];
        BillEntityType dt = this.getBillEntityType();
        for (int i = 0; i < split.length; ++i) {
            String sv = split[i];
            pkObjs[i] = NcEntityTypeUtil.convertPKValueType((DynamicObjectType)dt, (Object)sv);
        }
        String pkName = dt.getPrimaryKey().getName();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)dt.getName(), (String)selects, (QFilter[])new QFilter[]{new QFilter(pkName, "in", (Object)pkObjs)});
        Map id2DynObjMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(e -> e.get("id"), Function.identity()));
        ArrayList<DynamicObject> resultDynObjs = new ArrayList<DynamicObject>(dynamicObjects.length);
        for (Object pkObj : pkObjs) {
            DynamicObject dynObj = (DynamicObject)id2DynObjMap.get(pkObj);
            if (Objects.isNull(dynObj)) continue;
            resultDynObjs.add(dynObj);
        }
        return resultDynObjs.toArray(new DynamicObject[0]);
    }

    public boolean isMultiSelect() {
        return false;
    }

    public BillEntityType getBillEntityType() {
        return (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.getBillEntityNumber());
    }

    @Override
    @SimplePropertyAttribute
    public String getNoCodeDefValue() {
        return this.noCodeDefValue;
    }

    public void setNoCodeDefValue(String noCodeDefValue) {
        this.noCodeDefValue = noCodeDefValue;
    }

    public DynamicSimpleProperty createRefIDProp() {
        return super.createRefIDProp();
    }

    public void setComplexType(IDataEntityType dynamicObjectType) {
        super.setComplexType(dynamicObjectType);
    }

    @JsonProperty(value="refPropIdIsString")
    @SimplePropertyAttribute(name="refPropIdIsString")
    public boolean isRefPropIdIsString() {
        return this.refPropIdIsString;
    }

    public void setRefPropIdIsString(boolean refPropIdIsString) {
        this.refPropIdIsString = refPropIdIsString;
    }

    @ComplexPropertyAttribute(name="SelectScope")
    public SelectScope getSelectScope() {
        return this.selectScope;
    }

    public void setSelectScope(SelectScope selectScope) {
        this.selectScope = selectScope;
    }

    public void applyDefaultValue(IDataModel model, DynamicObject dataEntity, int rowIndex) {
        if (NcEntityTypeUtil.isFormExist((String)this.getBillFormId())) {
            this.calcDefaultValue(model, dataEntity, rowIndex, (IFieldHandle)this);
        }
    }

    public int getDbType() {
        if (this.getRefIdProp() == null) {
            return -5;
        }
        return super.getDbType();
    }

    public Class<?> getPropertyType() {
        IDataEntityType complexType = super.getComplexType();
        if (complexType == null) {
            return Long.class;
        }
        return super.getPropertyType();
    }

    @SimplePropertyAttribute(name="RefTableKey")
    public String getRefTableKey() {
        return this.refTableKey;
    }

    public void setRefTableKey(String refTableKey) {
        this.refTableKey = refTableKey;
    }

    public Object getDTValueFast(DynamicObject dataEntity) {
        String appId;
        Object value = super.getDTValueFast(dataEntity);
        if (value == null) {
            return null;
        }
        Boolean isNocodeShareSession = (Boolean)NcLocalCacheUtil.getOrCreateTransient((String)CACHETYPE_SHARESESSION, (String)RequestContext.get().getGlobalSessionId(), key -> new CodelessShareSessionServiceImpl().isNocodeShareSession(key));
        if (isNocodeShareSession.booleanValue()) {
            return value;
        }
        String formId = this.getBillFormId();
        String entityNumber = this.getBillEntityNumber();
        String refTableKey = this.getRefTableKey();
        if (StringUtils.isNotBlank((CharSequence)refTableKey) && FormMetadataUtils.isInnerTableRefBillProp(dataEntity, refTableKey)) {
            return value;
        }
        try {
            appId = FormMetaUtil.getAppIdByFormId((String)formId);
        }
        catch (RestApiException ex) {
            return null;
        }
        String cacheKey = String.format("%s_%s", appId, entityNumber);
        Boolean isVerifyFuncPermPass = (Boolean)NcLocalCacheUtil.getOrCreateTransient((String)CACHETYPE_VERIFYFUNCPERM, (String)cacheKey, key -> this.isVerifyFuncPermPass(appId, entityNumber));
        if (!isVerifyFuncPermPass.booleanValue()) {
            return null;
        }
        List permFilters = NoCodePermHelper.getDataPermFilters((String)formId);
        if (CollectionUtils.isEmpty((Collection)permFilters) || permFilters.stream().allMatch(Objects::isNull)) {
            return value;
        }
        QFilter pkFilter = new QFilter(dataEntity.getDynamicObjectType().getPrimaryKey().getName(), "=", this.getPkValue(value));
        permFilters.add(pkFilter);
        if (QueryServiceHelper.exists((String)entityNumber, (QFilter[])permFilters.toArray(new QFilter[0]))) {
            return value;
        }
        return null;
    }

    private Boolean isVerifyFuncPermPass(String appId, String entityNumber) {
        try {
            NoCodePermHelper.verifyFuncPermPassTemp((FuncPermItemEnum)FuncPermItemEnum.view, (String)appId, (String)entityNumber);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Object getPkValue(Object value) {
        if (value instanceof DynamicObject) {
            return ((DynamicObject)value).getPkValue();
        }
        return NcEntityTypeUtil.convertPKValueType((DynamicObjectType)((DynamicObjectType)this.getComplexType()), (Object)value);
    }
}

