/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.property;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.RequiredValidator;
import kd.bos.nocode.ext.constant.RegExpEnum;
import kd.bos.nocode.ext.operation.validate.RegexValidator;
import kd.bos.nocode.ext.property.NoCodeProp;
import kd.bos.nocode.ext.property.annotations.PropInfo;
import kd.bos.nocode.ext.validate.NoCodeRequiredValidator;
import kd.bos.nocode.ext.validate.NoCodeUniqueValidator;
import org.jetbrains.annotations.NotNull;

@PropInfo(name="\u5355\u884c\u6587\u672c")
public class NoCodeTextProp
extends TextProp
implements NoCodeProp {
    private static final long serialVersionUID = 6670416887967491028L;
    private String textValidType = "none";
    private boolean unique = false;
    private String dataMasking;
    private String noCodeDefValue;

    public List<AbstractValidator> getValidators() {
        List validators = super.getValidators();
        RegExpEnum.of(this.textValidType).ifPresent(regExpEnum -> {
            String desc = ResManager.loadKDString((String)regExpEnum.getDesc(), (String)"NoCodeTextProp_0", (String)"nocode_system", (Object[])new Object[0]);
            RegexValidator validator = new RegexValidator();
            HashMap<String, Object> param = new HashMap<String, Object>(10);
            param.put("validateType", this.textValidType);
            param.put("ruleType", "RegexValidate");
            param.put("ignoreBlank", true);
            param.put("id", Uuid16.create().toString());
            param.put("description", new LocaleString(desc));
            param.put("enabled", true);
            param.put("fields", this.getFields());
            param.put("regex", regExpEnum.getServerRegex());
            param.put("message", new LocaleString(ResManager.loadKDString((String)"%s\u5931\u8d25", (String)"NoCodeTextProp_2", (String)"nocode_system", (Object[])new Object[0]), desc));
            validator.setValidation(param);
            validators.add(validator);
        });
        if (this.isMustInput()) {
            validators.removeIf(RequiredValidator.class::isInstance);
            NoCodeRequiredValidator requiredValidator = new NoCodeRequiredValidator(this.getCompareProp(), this.getName(), this.getDisplayName().toString(), this.getValueComparator());
            validators.add(requiredValidator);
        }
        if (this.unique) {
            NoCodeUniqueValidator validator = new NoCodeUniqueValidator((DynamicProperty)this, this.getName(), this.getDisplayName().toString());
            validators.add(validator);
        }
        return validators;
    }

    @NotNull
    private List<Map<String, Object>> getFields() {
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>(1);
        HashMap<String, String> field = new HashMap<String, String>(1);
        field.put("id", this.getName());
        fields.add(field);
        return fields;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="none")
    public String getTextValidType() {
        return this.textValidType;
    }

    public void setTextValidType(String textValidType) {
        this.textValidType = textValidType;
    }

    @SimplePropertyAttribute(name="Unique")
    @DefaultValueAttribute(value="false")
    public boolean getUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    @SimplePropertyAttribute(name="DataMasking")
    public String getDataMasking() {
        return this.dataMasking;
    }

    public void setDataMasking(String dataMasking) {
        this.dataMasking = dataMasking;
    }

    public List<FilterField> createFilterFields(MainEntityType mainType) {
        if (this.isPassword()) {
            return new ArrayList<FilterField>();
        }
        return super.createFilterFields(mainType);
    }

    public boolean isEnableNull() {
        return true;
    }

    public void applyDefaultValue(IDataModel model, DynamicObject dataEntity, int rowIndex) {
        this.calcDefaultValue(model, dataEntity, rowIndex, (IFieldHandle)this);
    }

    @Override
    @SimplePropertyAttribute
    public String getNoCodeDefValue() {
        return this.noCodeDefValue;
    }

    public void setNoCodeDefValue(String noCodeDefValue) {
        this.noCodeDefValue = noCodeDefValue;
    }

    @Override
    public Object formatDefValue(Object value) {
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        return value;
    }

    public void setValue(Object dataEntity, Object value) {
        super.setValue(dataEntity, this.tryConvertValue(value));
    }

    public void setFieldValue(IDataModel model, Object dataEntity, Object value) {
        super.setFieldValue(model, dataEntity, this.tryConvertValue(value));
    }

    @Override
    public Object tryConvertValue(Object value) {
        Object newValue = NoCodeProp.super.tryConvertValue(value);
        if (newValue instanceof String && ((String)newValue).length() > this.getMaxLenth()) {
            newValue = StringUtils.left((String)((String)newValue), (int)this.getMaxLenth());
        }
        return newValue;
    }
}

