/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.proxy;

import java.lang.reflect.Method;
import java.util.Collection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;

public class FuzzySearchUtilsProxy {
    private static final Log logger = LogFactory.getLog(FuzzySearchUtilsProxy.class);
    private static final Class<?> fuzzySearchUtilsClass;
    private static final Method fuzzySearchVisitor_getSearchQFilter;

    private FuzzySearchUtilsProxy() {
        throw new IllegalStateException("FuzzySearchUtilsProxy class");
    }

    public static QFilter getSearchQFilter(String formId, Collection<IDataEntityProperty> properties, String searchText) {
        try {
            return (QFilter)fuzzySearchVisitor_getSearchQFilter.invoke(null, formId, properties, searchText);
        }
        catch (Exception e) {
            logger.debug("invoke kd.bos.nocode.restapi.service.util.FuzzySearchUtils#getSearchQFilter error", (Object)e);
            throw new KDBizException(e.getMessage());
        }
    }

    static {
        try {
            fuzzySearchUtilsClass = Class.forName("kd.bos.nocode.restapi.service.util.FuzzySearchUtils");
            fuzzySearchVisitor_getSearchQFilter = fuzzySearchUtilsClass.getMethod("getSearchQFilter", String.class, Collection.class, String.class);
        }
        catch (Exception e) {
            logger.debug("static init error: {}", (Object)e.getMessage(), (Object)e);
            throw new KDBizException(e.getMessage());
        }
    }
}

