/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.dao.converter.FormMetadataConverter;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.nocode.ext.constant.ElementCategoryEnum;
import kd.bos.nocode.ext.constant.FieldStatusEnum;
import kd.bos.nocode.ext.metadata.entity.NoCodeRefBillTable;
import kd.bos.nocode.ext.metadata.entity.field.NoCodeTextField;
import kd.bos.nocode.ext.metadata.form.NoCodeBillFormAp;
import kd.bos.nocode.ext.metadata.form.control.NoCodeBizButtonAp;
import kd.bos.nocode.ext.metadata.form.control.NoCodeFieldAp;
import kd.bos.nocode.ext.metadata.form.control.NoCodeSystemAp;
import kd.bos.nocode.ext.metadata.form.control.NoCodeTextFieldAp;
import kd.bos.nocode.ext.property.NoCodeBillNoProp;
import kd.bos.nocode.ext.property.NoCodeCreateDateProp;
import kd.bos.nocode.ext.property.NoCodeCreatorProp;
import kd.bos.nocode.ext.property.NoCodeModifierProp;
import kd.bos.nocode.ext.property.NoCodeModifyDateProp;
import kd.bos.nocode.ext.property.NoCodeRefBillTableProp;
import kd.bos.nocode.mservice.NoCodeSoftDeleteService;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.servicehelper.ServiceFactory;
import kd.bos.nocode.utils.NcAppVersionUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import org.apache.commons.lang3.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class FormMetadataUtils {
    private static final Log log = LogFactory.getLog(FormMetadataUtils.class);
    private static final String KEY_SUCCESS = "success";
    private static final String MESSAGE = "message";

    private FormMetadataUtils() {
    }

    public static List<String> getHideFields(String formNumber) {
        Map<String, List<NoCodeFieldAp>> status2FieldApList = FormMetadataUtils.getStatus2FieldApList(formNumber);
        List<NoCodeFieldAp> noCodeFieldAps = status2FieldApList.get(FieldStatusEnum.HIDDEN.getCode());
        if (CollectionUtils.isEmpty(noCodeFieldAps)) {
            return new ArrayList<String>(0);
        }
        return noCodeFieldAps.stream().map(AbstractElement::getKey).collect(Collectors.toList());
    }

    public static Map<String, List<NoCodeFieldAp>> getStatus2FieldApList(String formNumber) {
        String formId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Form);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
        List items = formMetadata.getItems();
        return items.stream().filter(item -> item.getClass().isAssignableFrom(NoCodeFieldAp.class)).map(NoCodeFieldAp.class::cast).collect(Collectors.groupingBy(NoCodeFieldAp::getStatus, Collectors.toList()));
    }

    public static Map<String, String> getFieldKey2Status(String formId) {
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
        List items = formMetadata.getItems();
        return items.stream().filter(item -> NoCodeFieldAp.class.isAssignableFrom(item.getClass())).map(NoCodeFieldAp.class::cast).collect(Collectors.toMap(AbstractElement::getKey, NoCodeFieldAp::getStatus));
    }

    public static List<String> getHideFields(String formNumber, boolean includeSysFields) {
        String formId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Form);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
        List items = formMetadata.getItems();
        ArrayList<String> hideFieldList = new ArrayList<String>(5);
        for (ControlAp item2 : items) {
            if (!item2.isInvisible()) continue;
            hideFieldList.add(item2.getKey());
        }
        if (!includeSysFields) {
            return hideFieldList;
        }
        List<String> recordInfoFieldList = FormMetadataUtils.getRecordFieldList(formNumber);
        List<String> billNoFieldList = FormMetadataUtils.getBillNoFieldList(formNumber);
        items.stream().filter(item -> item instanceof NoCodeBillFormAp).map(NoCodeBillFormAp.class::cast).findFirst().ifPresent(formAp -> {
            String sysSetting = formAp.getSysSetting();
            Map sysSettingMap = (Map)SerializationUtils.fromJsonString((String)sysSetting, Map.class);
            if (!FormMetadataUtils.enableRecordInfo(sysSettingMap)) {
                hideFieldList.addAll(recordInfoFieldList);
            }
            if (!FormMetadataUtils.enableBillNo(sysSettingMap)) {
                hideFieldList.addAll(billNoFieldList);
            }
        });
        return hideFieldList;
    }

    private static List<String> getBillNoFieldList(String formNumber) {
        return EntityMetadataCache.getDataEntityType((String)formNumber).getProperties().stream().filter(FormMetadataUtils::isBillNoField).map(IMetadata::getName).collect(Collectors.toList());
    }

    private static List<String> getRecordFieldList(String formNumber) {
        return EntityMetadataCache.getDataEntityType((String)formNumber).getProperties().stream().filter(FormMetadataUtils::isRecordField).map(IMetadata::getName).collect(Collectors.toList());
    }

    private static boolean isRecordField(IDataEntityProperty property) {
        return property instanceof NoCodeCreatorProp || property instanceof NoCodeCreateDateProp || property instanceof NoCodeModifierProp || property instanceof NoCodeModifyDateProp;
    }

    private static boolean isBillNoField(IDataEntityProperty property) {
        return property instanceof NoCodeBillNoProp;
    }

    public static String getLowerCaseName(Class<?> clazz) {
        return ClassUtils.getSimpleName(clazz).toLowerCase();
    }

    public static boolean enableRecordInfo(Map<String, Object> sysSettingMap) {
        return Objects.nonNull(sysSettingMap) && Objects.nonNull(sysSettingMap.get(ElementCategoryEnum.System_CategoryRecordInfo.toString())) && (Boolean)sysSettingMap.get(ElementCategoryEnum.System_CategoryRecordInfo.toString()) != false;
    }

    public static boolean enableBillNo(Map<String, Object> sysSettingMap) {
        return Objects.nonNull(sysSettingMap) && Objects.nonNull(sysSettingMap.get(ElementCategoryEnum.System_CategoryBillNo.toString())) && (Boolean)sysSettingMap.get(ElementCategoryEnum.System_CategoryBillNo.toString()) != false;
    }

    public static boolean[] getSysFieldInDesigner(String formNumber, Map<String, IDataEntityProperty> fields) {
        boolean[] existFlags = new boolean[5];
        String formId = MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Form);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
        List items = formMetadata.getItems();
        List systemAps = items.stream().filter(item -> item instanceof NoCodeSystemAp).map(NoCodeSystemAp.class::cast).collect(Collectors.toList());
        for (NoCodeSystemAp systemAp : systemAps) {
            String key = systemAp.getKey();
            IDataEntityProperty prop = fields.get(key);
            if (prop instanceof NoCodeBillNoProp) {
                existFlags[0] = true;
                continue;
            }
            if (prop instanceof NoCodeCreatorProp) {
                existFlags[1] = true;
                continue;
            }
            if (prop instanceof NoCodeCreateDateProp) {
                existFlags[2] = true;
                continue;
            }
            if (prop instanceof NoCodeModifierProp) {
                existFlags[3] = true;
                continue;
            }
            if (!(prop instanceof NoCodeModifyDateProp)) continue;
            existFlags[4] = true;
        }
        return existFlags;
    }

    public static boolean existByFormId(String formId) {
        return NcEntityTypeUtil.isFormExist((String)formId);
    }

    public static boolean existByFormNumber(String formNumber) {
        return NcEntityTypeUtil.isFormExist((String)formNumber);
    }

    public static void setFormName(String formId, LocaleString name, String menuType) {
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Entity);
        if (Objects.isNull(formMetadata) || Objects.isNull(entityMetadata)) {
            return;
        }
        formMetadata.setName(name);
        formMetadata.getRootAp().setName(name);
        entityMetadata.setName(name);
        entityMetadata.getRootEntity().setName(name);
        MetadataWriter writer = "custom".equals(menuType) ? new MetadataWriter("DynamicFormModel") : new MetadataWriter("NoCodeModel");
        writer.save(Boolean.FALSE, new AbstractMetadata[]{formMetadata, entityMetadata});
    }

    public static boolean isNoCodeBill(String formId) {
        formId = NcEntityTypeUtil.getRealBillEntityId((String)formId);
        QFilter filter = new QFilter("id", "=", (Object)formId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"modelType", (QFilter[])new QFilter[]{filter});
        return Objects.nonNull(dynamicObject) && "NoCodeModel".equalsIgnoreCase(dynamicObject.getString("modelType"));
    }

    public static List<NoCodeBizButtonAp> getBizButtonsRuntimeMeta(String formId) {
        ArrayList<NoCodeBizButtonAp> result = new ArrayList<NoCodeBizButtonAp>();
        if (NcEntityTypeUtil.isFormExist((String)formId)) {
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)formId, (MetaCategory)MetaCategory.Form);
            return formMetadata.getItems().stream().filter(i -> i instanceof NoCodeBizButtonAp).map(NoCodeBizButtonAp.class::cast).sorted(Comparator.comparingInt(ControlAp::getIndex)).collect(Collectors.toList());
        }
        return result;
    }

    public static boolean isRefBillDeleted(INoCodeRefBillProp p) {
        return p instanceof IComplexProperty && ((IComplexProperty)p).getComplexType() == null;
    }

    public static String deleteForm(String formId, String appId) {
        try {
            String sError;
            NoCodeSoftDeleteService softDeleteService = (NoCodeSoftDeleteService)ServiceFactory.getService((String)"NoCodeSoftDeleteService");
            if (softDeleteService.isEnableByForm(formId)) {
                sError = softDeleteService.softDelete(formId);
                if (StringUtils.isNotBlank((CharSequence)sError)) {
                    return sError;
                }
            } else {
                Map delResult;
                QFilter[] filters = new QFilter[]{new QFilter("form", "=", (Object)formId)};
                DynamicObject dyc = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"id", (QFilter[])filters);
                if (dyc != null) {
                    String pkId = dyc.getString("id");
                    Object[] pkIds = new String[]{pkId};
                    MainEntityType met = EntityMetadataCache.getDataEntityType((String)"bos_devportal_unitrelform");
                    DeleteServiceHelper.delete((IDataEntityType)met, (Object[])pkIds);
                }
                if ((delResult = MetadataDao.delFormMetadata((String)formId)).get(KEY_SUCCESS) != null && !((Boolean)delResult.get(KEY_SUCCESS)).booleanValue()) {
                    String sError2 = delResult.get(MESSAGE) != null ? (String)delResult.get(MESSAGE) : ResManager.loadKDString((String)"\u5143\u6570\u636e\u6709\u4f9d\u8d56\uff0c\u5220\u9664\u5931\u8d25", (String)"FormMetadataUtils_0", (String)"bos-nocode-ext", (Object[])new Object[0]);
                    return sError2;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)appId)) {
                AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)appId);
                FormMetadataUtils.deleteMenu(appMetadata, formId);
                Map saveResult = AppMetaServiceHelper.save((AppMetadata)appMetadata);
                if (saveResult.size() > 0 && !Boolean.parseBoolean(saveResult.get(KEY_SUCCESS).toString())) {
                    sError = saveResult.get(MESSAGE).toString();
                    if (StringUtils.isEmpty((CharSequence)sError)) {
                        return ResManager.loadKDString((String)"\u5220\u9664\u83dc\u5355\u5931\u8d25", (String)"FormMetadataUtils_1", (String)"bos-nocode-ext", (Object[])new Object[0]);
                    }
                    return sError;
                }
            }
        }
        catch (Exception exception) {
            log.debug(exception.getMessage(), (Object)exception);
            return exception.getMessage();
        }
        return null;
    }

    public static void deleteMenu(AppMetadata appMetadata, String formId) {
        boolean enableSoftDelete = NcAppVersionUtil.isEnableSoftDeleteByApp((String)appMetadata.getBizappId());
        List toDels = appMetadata.getAppMenus().stream().filter(a -> formId.equalsIgnoreCase(a.getFormId())).collect(Collectors.toList());
        if (enableSoftDelete) {
            for (AppMenuElement toDel : toDels) {
                toDel.setVisible(Boolean.FALSE.toString());
            }
        } else {
            appMetadata.getAppMenus().removeAll(toDels);
        }
    }

    @NotNull
    public static List<Map<String, Object>> getTableMetas(Map<String, Object> designerMetadata) {
        HashSet<String> formSet = new HashSet<String>(10);
        FormMetadataConverter converter = new FormMetadataConverter();
        FormMetadata metadata = (FormMetadata)converter.convertTo(designerMetadata);
        EntityMetadata entityMetadata = metadata.getEntityMetadata();
        List items = entityMetadata.getItems();
        for (EntityItem item : items) {
            if (!(item instanceof NoCodeRefBillTable)) continue;
            NoCodeRefBillTable table = (NoCodeRefBillTable)item;
            formSet.add(table.getBillEntityIdEx());
        }
        ArrayList<Map<String, Object>> tableMetas = new ArrayList<Map<String, Object>>(10);
        if (!formSet.isEmpty()) {
            for (String formId : formSet) {
                if (!NcEntityTypeUtil.isFormExist((String)formId)) continue;
                Map<String, Object> meta = FormMetadataUtils.getMetadataById(formId);
                tableMetas.add(meta);
            }
        }
        return tableMetas;
    }

    public static Map<String, Object> getMetadataById(String formId) {
        String id = NcEntityTypeUtil.getRealBillEntityId((String)formId);
        Map designerMetadata = MetadataDao.loadDesignerMetadata((String)id, (String)RequestContext.get().getLang().toString());
        if (designerMetadata == null) {
            return new HashMap<String, Object>(16);
        }
        String localeId = RequestContext.get().getLang().toString();
        FormMetadataConverter converter = new FormMetadataConverter();
        FormMetadata metadata = (FormMetadata)converter.convertTo(designerMetadata);
        EntityMetadata entityMetadata = metadata.getEntityMetadata();
        List items = entityMetadata.getItems();
        Map key2Item = items.stream().collect(Collectors.toMap(AbstractElement::getKey, Function.identity()));
        List controlAps = metadata.getItems();
        Map key2Ap = controlAps.stream().collect(Collectors.toMap(AbstractElement::getKey, Function.identity()));
        if ("bos_user".equals(formId) || "bos_adminorg".equals(formId)) {
            String displayProp = "bos_user".equals(formId) ? "name,number,gender,phone,email" : "name,number";
            String[] stringArray = displayProp.split(",");
            List<String> displayKeyList = Arrays.asList(stringArray);
            for (Map.Entry entry : key2Ap.entrySet()) {
                ControlAp controlAp = (ControlAp)entry.getValue();
                EntityItem item = (EntityItem)key2Item.get(entry.getKey());
                if (!displayKeyList.contains(controlAp.getKey())) {
                    items.remove(item);
                    controlAps.remove(controlAp);
                    continue;
                }
                items.remove(item);
                controlAps.remove(controlAp);
                NoCodeTextField field = new NoCodeTextField();
                field.setId(item.getId());
                field.setKey(item.getKey());
                field.setName(item.getName());
                items.add(field);
                NoCodeTextFieldAp fieldAp = new NoCodeTextFieldAp();
                fieldAp.setId(field.getId());
                fieldAp.setFieldId(field.getId());
                fieldAp.setField((Field)field);
                fieldAp.setKey(field.getKey());
                fieldAp.setName(field.getName());
                controlAps.add(fieldAp);
            }
        } else {
            for (Map.Entry entry : key2Item.entrySet()) {
                EntityItem item = (EntityItem)entry.getValue();
                ControlAp controlAp = (ControlAp)key2Ap.get(entry.getKey());
                if (item instanceof NoCodeRefBillTable) {
                    NoCodeRefBillTable table = (NoCodeRefBillTable)item;
                    if ("1".equals(table.getSourceForm())) {
                        EntityItem refBill = (EntityItem)key2Item.get(table.getRefBillKey());
                        ControlAp refBillControlAp = (ControlAp)key2Ap.get(table.getRefBillKey());
                        items.remove(refBill);
                        controlAps.remove(refBillControlAp);
                    }
                    items.remove(item);
                    controlAps.remove(controlAp);
                    continue;
                }
                if (item == null || item.getParentId() == null || item.getParentId().length() != 3) continue;
                items.remove(item);
                controlAps.remove(controlAp);
            }
        }
        designerMetadata = metadata.buildDesignMeta(localeId);
        HashMap<String, Object> formData = new HashMap<String, Object>();
        formData.put("billEntityIdEx", formId);
        formData.put("data", designerMetadata);
        return formData;
    }

    public static boolean isInnerTableRefBillProp(DynamicObject dataEntity, String refTableKey) {
        Objects.requireNonNull(dataEntity);
        Objects.requireNonNull(refTableKey);
        String entityNumber = dataEntity.getDynamicObjectType().getName();
        if (!FormMetadataUtils.existByFormNumber(entityNumber)) {
            return false;
        }
        NoCodeRefBillTableProp property = (NoCodeRefBillTableProp)EntityMetadataCache.getDataEntityType((String)entityNumber).findProperty(refTableKey);
        return property != null && "1".equals(property.getSourceForm());
    }
}

