/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.constant.CommonConstants;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.constant.WfTaskHandleResultEnum;
import kd.bos.nocode.ext.constant.WfProcessStatusEnum;
import kd.bos.nocode.ext.constant.WfTaskTypeEnum;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfGraphCell;
import kd.bos.nocode.ext.metadata.wf.NoCodeWfNode;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeApiInvoke;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeCalculate;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeGateway;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeJudge;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeNewBill;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeUpdateBill;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.restapi.api.model.ApprovalRecord;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public abstract class WfProcessUtils {
    public static final Set<Class<?>> terminate = new HashSet();
    public static final String BOS_WF_RUNTIME_NO_OUTGOING_SEQUENCE_ERROR = "bos.wf.runtime.noOutgoingSequenceError";
    private static final String HANDLE_STATE = "handleState";
    private static final String HANDLE_STATE_DESC = "handleStateDesc";
    private static final Log logger = LogFactory.getLog(WfProcessUtils.class);

    public static Map<String, Object> getProcessStatusForList(String endType, String activityId, String activityName, boolean isRunning, String errorMessage) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        String handleState = activityId;
        String handleStateDesc = ResManager.loadKDString((String)"\u8fdb\u884c\u4e2d\uff1a", (String)"WfProcessUtils_0", (String)"bos-nocode-ext", (Object[])new Object[0]) + (StringUtils.isBlank((CharSequence)activityName) ? "" : activityName);
        if (!isRunning) {
            WfTaskHandleResultEnum taskHandleResultEnum = WfTaskHandleResultEnum.running;
            if (Objects.equals(endType, WfProcessStatusEnum.NORMAL.getId())) {
                taskHandleResultEnum = WfTaskHandleResultEnum.done;
            } else if (Objects.equals(endType, WfProcessStatusEnum.SUBMIT_WITHDRAW.getId())) {
                taskHandleResultEnum = WfTaskHandleResultEnum.withdraw;
            } else if (Objects.equals(endType, WfProcessStatusEnum.AUDIT_ABORT.getId())) {
                taskHandleResultEnum = WfTaskHandleResultEnum.terminate;
            } else if (Objects.equals(endType, WfProcessStatusEnum.EXCEPTION_TERMINATE.getId())) {
                taskHandleResultEnum = StringUtils.isNotEmpty((CharSequence)errorMessage) && errorMessage.contains(BOS_WF_RUNTIME_NO_OUTGOING_SEQUENCE_ERROR) ? WfTaskHandleResultEnum.done : WfTaskHandleResultEnum.exception_terminate;
            }
            handleState = taskHandleResultEnum.toString();
            handleStateDesc = taskHandleResultEnum.getDesc();
        }
        resultMap.put(HANDLE_STATE, handleState);
        resultMap.put(HANDLE_STATE_DESC, handleStateDesc);
        return resultMap;
    }

    public static Map<String, Object> getProcessStatusForApproval(WfProcessStatusEnum processStatus, boolean isRunning, ApprovalRecord endNode) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        WfTaskHandleResultEnum taskHandleResultEnum = WfTaskHandleResultEnum.running;
        if (!isRunning) {
            switch (processStatus) {
                case NORMAL: {
                    taskHandleResultEnum = WfTaskHandleResultEnum.end;
                    break;
                }
                case AUDIT_ABORT: {
                    taskHandleResultEnum = WfTaskHandleResultEnum.terminate;
                    break;
                }
                case SUBMIT_WITHDRAW: {
                    taskHandleResultEnum = WfTaskHandleResultEnum.withdraw;
                    break;
                }
                case EXCEPTION_TERMINATE: {
                    String errorMessage = endNode.getErrorMessage();
                    if (StringUtils.isNotEmpty((CharSequence)errorMessage) && errorMessage.contains(BOS_WF_RUNTIME_NO_OUTGOING_SEQUENCE_ERROR)) {
                        taskHandleResultEnum = WfTaskHandleResultEnum.end;
                        break;
                    }
                    taskHandleResultEnum = WfTaskHandleResultEnum.exception_terminate;
                    break;
                }
            }
        }
        resultMap.put(HANDLE_STATE, taskHandleResultEnum.toString());
        resultMap.put(HANDLE_STATE_DESC, taskHandleResultEnum.getDesc());
        return resultMap;
    }

    public static List<Map<String, Object>> getTaskListConfig(WfTaskTypeEnum wfTaskType) {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>(1);
        Map<String, Object> taskListConfig = WfProcessUtils.parseTaskConfigList(wfTaskType);
        rows.add(taskListConfig);
        return rows;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Object> parseTaskConfigList(WfTaskTypeEnum wfTaskType) {
        try (InputStream is = WfProcessUtils.class.getClassLoader().getResourceAsStream(String.format("dynamic_form/process_center_%s.json", wfTaskType.toString()));){
            if (Objects.nonNull(is)) {
                Map map = (Map)SerializationUtils.fromJsonString((String)IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8), Map.class);
                return map;
            }
            throw new RestApiException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5217\u8868\u914d\u7f6e", (String)"WfProcessUtils_1", (String)"bos-nocode-ext", (Object[])new Object[0]));
        }
        catch (IOException e) {
            throw new RestApiException(ResManager.loadKDString((String)"\u83b7\u53d6\u5217\u8868\u914d\u7f6e\u5f02\u5e38", (String)"WfProcessUtils_2", (String)"bos-nocode-ext", (Object[])new Object[0]), (Throwable)e);
        }
    }

    @NotNull
    public static String getToHandleTaskTypeDesc(String category) {
        return "AuditTask".equalsIgnoreCase(category) ? ResManager.loadKDString((String)"\u5ba1\u6279\u4efb\u52a1", (String)"WfProcessUtils_3", (String)"bos-nocode-ext", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f55\u5165\u4efb\u52a1", (String)"WfProcessUtils_4", (String)"bos-nocode-ext", (Object[])new Object[0]);
    }

    public static WfConsts.WfLockStatusEnum getWfLockStatus(String formId, Object pkId) {
        if (StringUtils.isBlank((CharSequence)formId) || pkId == null) {
            return WfConsts.WfLockStatusEnum.UNLOCK;
        }
        DynamicObject currentObj = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)formId);
        if (currentObj != null) {
            String lockStatus = currentObj.getString(WfConsts.WfLockStatusEnum.LOCK_STATUS_KEY);
            return WfConsts.WfLockStatusEnum.getByCode((String)lockStatus);
        }
        return WfConsts.WfLockStatusEnum.UNLOCK;
    }

    public static boolean isUserInputNode(String nodeId) {
        return nodeId.contains("NoCodeUserTask");
    }

    public static String removeVarSuffix(String var) {
        if (StringUtils.isNotEmpty((CharSequence)var)) {
            return var.split("@@")[0];
        }
        return var;
    }

    public static Map<String, Object> buildErrorBodyMap(String bodyStr) {
        HashMap bodyMap = Maps.newHashMap();
        bodyMap.put("", bodyStr);
        return bodyMap;
    }

    public static boolean isOAuth2Node(NoCodeWfNodeApiInvoke node) {
        return "auth".equals(node.getApiMode()) && "oauth2".equals(node.getAuthMode());
    }

    public static boolean isBasicAuthNode(NoCodeWfNodeApiInvoke node) {
        return "auth".equals(node.getApiMode()) && "basicAuth".equals(node.getAuthMode());
    }

    public static void deleteTempFormByProcInstId(Long procInstId) {
        if (Objects.nonNull(procInstId)) {
            QFilter filter = new QFilter("procInstId", "=", (Object)procInstId);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_nocode_tmpform", (String)"entityNumber", (QFilter[])filter.toArray());
            Arrays.stream(dynamicObjects).map(e -> e.getString("entityNumber")).forEach(entityNumber -> FormMetadataUtils.deleteForm(entityNumber, FormMetaUtil.getAppIdByFormNumber((String)entityNumber)));
            DeleteServiceHelper.delete((String)"bos_nocode_tmpform", (QFilter[])filter.toArray());
        }
    }

    public static void handleProcessEndEvent(KDBizEvent evt) {
        try {
            long currUserId = RequestContext.get().getCurrUserId();
            LicenseCheckResult licenseCheckResult = LicenseServiceHelper.checkUserInGroup((Long)currUserId, (Long)CommonConstants.LICENSE_NOCODE_GROUP_ID);
            if (!licenseCheckResult.getHasLicense().booleanValue()) {
                logger.info("There is no NoCode License Group, userId = {}.", (Object)currUserId);
                return;
            }
            String source = evt.getSource();
            JSONArray jsons = JSON.parseArray((String)source);
            Map paramMap = (Map)JSON.parse((String)jsons.getString(0));
            Long procInstId = (Long)paramMap.get("processInstanceId");
            WfProcessUtils.deleteTempFormByProcInstId(procInstId);
        }
        catch (Exception e) {
            logger.debug("handleProcessEndEvent Error: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static String replaceWfSpecialCombo(String expression) {
        return WfProcessUtils.replaceWfSpecialCombo(expression, false);
    }

    public static String replaceWfSpecialCombo(String expression, boolean encode) {
        if (expression.contains(WfConsts.QueryResultEnum.HasData.getCode())) {
            expression = StringUtils.replace((String)expression, (String)WfConsts.QueryResultEnum.HasData.getCode(), (String)(encode ? WfConsts.QueryResultEnum.HasData.getEncodeName() : WfConsts.QueryResultEnum.HasData.getName()));
        }
        if (expression.contains(WfConsts.QueryResultEnum.NonData.getCode())) {
            expression = StringUtils.replace((String)expression, (String)WfConsts.QueryResultEnum.NonData.getCode(), (String)(encode ? WfConsts.QueryResultEnum.NonData.getEncodeName() : WfConsts.QueryResultEnum.NonData.getName()));
        }
        if (expression.contains(WfConsts.AuditResultEnum.Consent.getCode())) {
            expression = StringUtils.replace((String)expression, (String)WfConsts.AuditResultEnum.Consent.getCode(), (String)(encode ? WfConsts.AuditResultEnum.Consent.getEncodeName() : WfConsts.AuditResultEnum.Consent.getName()));
        }
        if (expression.contains(WfConsts.AuditResultEnum.Terminate.getCode())) {
            expression = StringUtils.replace((String)expression, (String)WfConsts.AuditResultEnum.Terminate.getCode(), (String)(encode ? WfConsts.AuditResultEnum.Terminate.getEncodeName() : WfConsts.AuditResultEnum.Terminate.getName()));
        }
        return expression;
    }

    public static String getWfSpecialComboEncodeName(String comboValue) {
        if (comboValue.equals(WfConsts.QueryResultEnum.HasData.getCode())) {
            comboValue = WfConsts.QueryResultEnum.HasData.getEncodeName();
        } else if (comboValue.equals(WfConsts.QueryResultEnum.NonData.getCode())) {
            comboValue = WfConsts.QueryResultEnum.NonData.getEncodeName();
        } else if (comboValue.equals(WfConsts.AuditResultEnum.Consent.getCode())) {
            comboValue = WfConsts.AuditResultEnum.Consent.getEncodeName();
        } else if (comboValue.equals(WfConsts.AuditResultEnum.Terminate.getCode())) {
            comboValue = WfConsts.AuditResultEnum.Terminate.getEncodeName();
        }
        return comboValue;
    }

    public static List<String> getParentNodes(String targetNodeId, String rootId, List<NoCodeWfNode> nodes) {
        Map<String, List<String>> id2ParentIds = nodes.stream().collect(Collectors.toMap(NoCodeWfGraphCell::getId, WfProcessUtils::getParentIds));
        ArrayList<String> parentNodes = new ArrayList<String>(nodes.size());
        WfProcessUtils.addParentNodes(targetNodeId, rootId, parentNodes, id2ParentIds);
        parentNodes.remove(targetNodeId);
        return parentNodes;
    }

    private static List<String> getParentIds(NoCodeWfNode node) {
        ArrayList<String> result = new ArrayList<String>(16);
        Splitter splitter = Splitter.on((String)",");
        String parentId = node.getParentId();
        Optional.ofNullable(parentId).ifPresent(result::add);
        if (node instanceof NoCodeWfNodeGateway) {
            String parentIds = ((NoCodeWfNodeGateway)node).getParentIds();
            Optional.ofNullable(parentIds).ifPresent(e -> result.addAll(splitter.splitToList((CharSequence)e)));
        }
        return result;
    }

    private static void addParentNodes(String targetNodeId, String rootId, List<String> resultNodes, Map<String, List<String>> id2ParentId) {
        if (targetNodeId.equals(rootId)) {
            return;
        }
        resultNodes.add(targetNodeId);
        List<String> parentIds = id2ParentId.get(targetNodeId);
        if (CollectionUtils.isNotEmpty(parentIds)) {
            parentIds.forEach(e -> WfProcessUtils.addParentNodes(e, rootId, resultNodes, id2ParentId));
        }
    }

    static {
        terminate.add(NoCodeWfNodeCalculate.class);
        terminate.add(NoCodeWfNodeUpdateBill.class);
        terminate.add(NoCodeWfNodeNewBill.class);
        terminate.add(NoCodeWfNodeJudge.class);
        terminate.add(NoCodeWfNodeGateway.class);
    }
}

