/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.validate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.SingleFieldValidator;
import kd.bos.form.IFormView;
import kd.bos.nocode.ext.property.NoCodeRefBillTableProp;

public class NoCodeRefTableValidator
extends SingleFieldValidator {
    private NoCodeRefBillTableProp property;
    private IFormView formView;

    public NoCodeRefTableValidator(NoCodeRefBillTableProp vProperty, String fieldKey, String fieldName, IFormView formView) {
        this.property = vProperty;
        this.vProperty = vProperty;
        this.fieldName = fieldName;
        this.fieldKey = fieldKey;
        this.formView = formView;
    }

    public void validate() {
        try (EntityTraceSpan span = EntityTracer.create((String)"NoCodeRefTableValidator", (String)"validate");){
            span.addTag("validate dataEntity:", SerializationUtils.toJsonString((Object)this.dataEntities[0].getDataEntity().getDynamicObjectCollection((IDataEntityProperty)this.property)));
            if (this.isFieldRequired()) {
                for (ExtendedDataEntity extDataEntity : this.dataEntities) {
                    DynamicObjectCollection col = extDataEntity.getDataEntity().getDynamicObjectCollection((IDataEntityProperty)this.property);
                    if (!col.isEmpty()) continue;
                    this.addMessage(extDataEntity, this.buildRequiredErrMessage(), this.getErrorLevl());
                    return;
                }
            }
        }
    }

    private String buildRequiredErrMessage() {
        return ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a!", (String)"NoCodeRefTableValidator_0", (String)"bos-entity-metadata", (Object[])new Object[]{this.fieldName});
    }

    private String buildMinErrMessage(int min) {
        return ResManager.loadKDString((String)"\u201c%1$s\u201d\u81f3\u5c11\u8981\u5f55\u5165%2$s\u6761\u6570\u636e", (String)"NoCodeRefTableValidator_3", (String)"bos-entity-metadata", (Object[])new Object[]{this.fieldName, min});
    }

    private String buildMaxErrMessage(int max) {
        return ResManager.loadKDString((String)"\u201c%1$s\u201d\u6700\u591a\u53ea\u80fd\u5f55\u5165%2$s\u6761\u6570\u636e", (String)"NoCodeRefTableValidator_4", (String)"bos-entity-metadata", (Object[])new Object[]{this.fieldName, max});
    }

    private boolean isFieldRequired() {
        String fieldRequired;
        boolean isRequired = false;
        String string = fieldRequired = this.property.getCustomProperty("FieldRequired") == null ? null : this.property.getCustomProperty("FieldRequired").toString();
        if ("3".equals(fieldRequired)) {
            return true;
        }
        Map requiredMap = new HashMap();
        String requiredStr = this.formView.getPageCache().get("nocodefieldrequiredmap");
        if (StringUtils.isNotBlank((CharSequence)requiredStr)) {
            requiredMap = (Map)SerializationUtils.fromJsonString((String)requiredStr, Map.class);
        }
        if ("6".equals(requiredMap.get(this.fieldKey))) {
            isRequired = false;
        } else if ("5".equals(requiredMap.get(this.fieldKey))) {
            isRequired = true;
        } else if (StringUtils.isNotBlank((CharSequence)fieldRequired) && "2".equals(fieldRequired)) {
            isRequired = true;
        }
        if (!isRequired) {
            return false;
        }
        if (this.isFieldHide()) {
            isRequired = false;
        }
        return isRequired;
    }

    private boolean isFieldHide() {
        List fields;
        boolean isHide = false;
        String hideStr = this.formView.getPageCache().get("nocodehiddenfields");
        if (StringUtils.isNotBlank((CharSequence)hideStr) && (fields = (List)SerializationUtils.fromJsonString((String)hideStr, List.class)).contains(this.fieldKey)) {
            isHide = true;
        }
        Map stateMap = new HashMap();
        String stateStr = this.formView.getPageCache().get("nocodefieldstatemap");
        if (StringUtils.isNotBlank((CharSequence)stateStr)) {
            stateMap = (Map)SerializationUtils.fromJsonString((String)stateStr, Map.class);
        }
        if (stateMap.containsKey(this.fieldKey)) {
            isHide = !"1".equals(stateMap.get(this.fieldKey));
        }
        return isHide;
    }
}

