/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.coderule.api.ICoreCodeRuleService;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.validate.IValueComparator;
import kd.bos.entity.validate.SingleFieldValidator;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.lang.Lang;
import kd.bos.mservice.svc.picture.IPictureProp;
import kd.bos.service.ServiceFactory;
import org.apache.commons.collections4.CollectionUtils;

public class NoCodeRequiredValidator
extends SingleFieldValidator {
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";

    public NoCodeRequiredValidator(DynamicProperty vProperty, String fieldKey, String fieldName, IValueComparator valueComparator) {
        this.vProperty = vProperty;
        this.fieldName = fieldName;
        this.fieldKey = fieldKey;
        this.valueComparetor = valueComparator;
    }

    public NoCodeRequiredValidator() {
    }

    public void validate() {
        MainEntityType mainType = this.getValidateContext().getBillEntityType();
        boolean isBillNo = mainType instanceof BillEntityType && StringUtils.equals((CharSequence)this.fieldKey, (CharSequence)((BillEntityType)mainType).getBillNo());
        for (ExtendedDataEntity extDataEntity : this.dataEntities) {
            Object value = this.vProperty.getValue((Object)extDataEntity.getDataEntity());
            if (value == null && this.vProperty instanceof IPictureProp) {
                value = ((IPictureProp)this.vProperty).getDefaultImgKey();
            }
            if (isBillNo) {
                this.validateBillNo(extDataEntity);
                continue;
            }
            if (!(this.vProperty instanceof MuliLangTextProp) && this.valueComparetor.compareValue(value)) {
                String content = this.buildErrMessage(extDataEntity);
                this.addMessage(extDataEntity, content, this.getErrorLevl());
                continue;
            }
            if (!(this.vProperty instanceof MuliLangTextProp)) continue;
            List mustInputLang = this.validateContext.getMustInputLang();
            ArrayList<String> mustInputLan = new ArrayList<String>(5);
            if (value != null && StringUtils.isBlank((CharSequence)((ILocaleString)value).getLocaleValue())) {
                mustInputLan.add(Lang.get().getLangTag().replace('-', '_'));
            }
            if (CollectionUtils.isNotEmpty((Collection)mustInputLang)) {
                for (String lan : mustInputLang) {
                    if (StringUtils.isBlank((Object)value)) {
                        this.addMessage(extDataEntity, this.buildErrMessage(extDataEntity), this.getErrorLevl());
                        continue;
                    }
                    String valuelan = (String)((ILocaleString)value).get((Object)lan);
                    if (!StringUtils.isBlank((CharSequence)valuelan) || mustInputLan.contains(lan)) continue;
                    mustInputLan.add(lan);
                }
                if (mustInputLan.isEmpty()) continue;
                this.addMessage(extDataEntity, this.buildErrMessage(extDataEntity, mustInputLan), this.getErrorLevl());
                continue;
            }
            if (!this.valueComparetor.compareValue(value) && value != null) continue;
            if (!mustInputLan.isEmpty()) {
                this.addMessage(extDataEntity, this.buildErrMessage(extDataEntity, mustInputLan), this.getErrorLevl());
                continue;
            }
            this.addMessage(extDataEntity, this.buildErrMessage(extDataEntity), this.getErrorLevl());
        }
    }

    private void validateBillNo(ExtendedDataEntity extDataEntity) {
        DynamicObject billDataObj = extDataEntity.getDataEntity();
        Object billno = this.vProperty.getValue((Object)billDataObj);
        if (this.valueComparetor.compareValue(billno)) {
            String orgId = null;
            String mainOrgKey = this.getValidateContext().getBillEntityType().getMainOrg();
            if (StringUtils.isNotBlank((CharSequence)mainOrgKey)) {
                Object orgObj = billDataObj.get(mainOrgKey);
                if (orgObj instanceof DynamicObject) {
                    orgId = String.valueOf(((DynamicObject)orgObj).getPkValue());
                } else if (orgObj instanceof Long) {
                    orgId = String.valueOf(orgObj);
                }
            }
            if (!this.isSkipBillNoValidator(billDataObj, orgId)) {
                String content = this.buildErrMessage(extDataEntity);
                this.addMessage(extDataEntity, content, this.getErrorLevl());
            }
        }
    }

    private boolean isSkipBillNoValidator(DynamicObject billDataObj, String orgId) {
        if (this.getOption() != null) {
            RefObject result = new RefObject();
            boolean canGetValue = this.getOption().tryGetVariableValue("skipbillnovalidator", result);
            if (canGetValue) {
                return Boolean.parseBoolean(this.getOption().getVariableValue("skipbillnovalidator"));
            }
        }
        ICoreCodeRuleService codeRuleService = (ICoreCodeRuleService)ServiceFactory.getService(ICoreCodeRuleService.class);
        return codeRuleService.isExist(this.getEntityKey(), billDataObj, orgId);
    }

    protected String buildErrMessage(ExtendedDataEntity extDataEntity) {
        if (this.vProperty.getParent() instanceof EntryType) {
            EntryType entryType = (EntryType)this.vProperty.getParent();
            if (entryType instanceof SubEntryType) {
                String entryName = entryType.getParent().getDisplayName().toString();
                String subEntryName = entryType.getDisplayName().toString();
                return ResManager.loadKDString((String)"\u201c%1$s\u201d\uff1a\u201c%2$s\u201d\u7b2c%3$s\u884c\uff0c\u201c%4$s\u201d\u7b2c%5$s\u884c\u4e0d\u80fd\u4e3a\u7a7a", (String)"NoCodeRequiredValidator_0", (String)BOS_ENTITY_METADATA, (Object[])new Object[]{this.fieldName, entryName, extDataEntity.getRowIndex() + 1, subEntryName, extDataEntity.getSubRowIndex() + 1});
            }
            return ResManager.loadKDString((String)"\u201c%1$s\u201d\u7b2c%2$s\u884c\uff1a\u201c%3$s\u201d\u4e0d\u80fd\u4e3a\u7a7a", (String)"NoCodeRequiredValidator_1", (String)BOS_ENTITY_METADATA, (Object[])new Object[]{entryType.getDisplayName().toString(), extDataEntity.getRowIndex() + 1, this.fieldName});
        }
        return ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a", (String)"NoCodeRequiredValidator_2", (String)BOS_ENTITY_METADATA, (Object[])new Object[]{this.fieldName});
    }

    private String buildErrMessage(ExtendedDataEntity extDataEntity, List<String> langBillParams) {
        String promptLang = ValidateContext.switchLang(langBillParams);
        if (this.vProperty.getParent() instanceof EntryType) {
            EntryType entryType = (EntryType)this.vProperty.getParent();
            if (entryType instanceof SubEntryType) {
                String entryName = entryType.getParent().getDisplayName().toString();
                String subEntryName = entryType.getDisplayName().toString();
                return ResManager.loadKDString((String)"\u201c%1$s\u201d\uff1a\u201c%2$s\u201d\u7b2c%3$s\u884c\uff0c\u201c%4$s\u201d\u7b2c%5$s\u884c\u7684\u201c%6$s\u201d\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"NoCodeRequiredValidator_3", (String)this.fieldName, (Object[])new Object[]{entryName, extDataEntity.getRowIndex() + 1, subEntryName, extDataEntity.getSubRowIndex() + 1, promptLang});
            }
            return ResManager.loadKDString((String)"\u201c%1$s\u201d\u7b2c%2$s\u884c\uff1a\u201c%3$s\u201d\u7684\u201c%4$s\u201d\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"NoCodeRequiredValidator_4", (String)BOS_ENTITY_METADATA, (Object[])new Object[]{entryType.getDisplayName().toString(), extDataEntity.getRowIndex() + 1, this.fieldName, promptLang});
        }
        return ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"NoCodeRequiredValidator_5", (String)BOS_ENTITY_METADATA, (Object[])new Object[]{this.fieldName, promptLang});
    }
}

