/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.validate;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.nocode.ext.property.NoCodeRefBillTableProp;

public class NoCodeUniqueValidator
extends AbstractValidator {
    private static final String ID = "id";
    protected DynamicProperty vProperty;
    protected String fieldKey;
    protected String fieldName;

    public NoCodeUniqueValidator(DynamicProperty vProperty, String fieldKey, String fieldName) {
        this.vProperty = vProperty;
        this.fieldName = fieldName;
        this.fieldKey = fieldKey;
    }

    public void initializeConfiguration() {
        super.initializeConfiguration();
    }

    public void validate() {
        Map<Object, Long> valueCount = Arrays.stream(this.dataEntities).collect(Collectors.groupingBy(e -> this.vProperty.getValue((Object)e.getDataEntity()), Collectors.counting()));
        valueCount.remove("");
        if (valueCount.values().stream().anyMatch(v -> v > 1L)) {
            Arrays.stream(this.dataEntities).filter(e -> {
                Object value = this.vProperty.getValue((Object)e.getDataEntity());
                Long count = (Long)valueCount.get(value);
                return count != null && count > 1L;
            }).forEach(e -> this.addMessage((ExtendedDataEntity)e, this.buildErrMessage((ExtendedDataEntity)e)));
        } else if (!valueCount.isEmpty()) {
            Map<Object, List<ExtendedDataEntity>> valueMap = Arrays.stream(this.dataEntities).collect(Collectors.groupingBy(e -> this.vProperty.getValue((Object)e.getDataEntity())));
            SqlBuilder builder = new SqlBuilder();
            if (this.vProperty.getParent() instanceof EntryType && this.vProperty.getParent().getAlias() == null) {
                MainEntityType entityType = (MainEntityType)this.vProperty.getParent().getParent();
                NoCodeRefBillTableProp refTableProp = (NoCodeRefBillTableProp)entityType.getProperty(this.vProperty.getParent().getName());
                builder.append("select ", new Object[0]).append("fid", new Object[0]).append(",", new Object[0]).append(this.vProperty.getAlias(), new Object[0]).append("from ", new Object[0]).append("t_nc_" + refTableProp.getBillEntityIdEx(), new Object[0]).append("where ", new Object[0]).appendIn(this.vProperty.getAlias(), valueCount.keySet().toArray());
            } else {
                builder.append("select ", new Object[0]).append(this.vProperty.getParent().getPrimaryKey().getAlias(), new Object[0]).append(",", new Object[0]).append(this.vProperty.getAlias(), new Object[0]).append("from ", new Object[0]).append(this.vProperty.getParent().getAlias(), new Object[0]).append("where ", new Object[0]).appendIn(this.vProperty.getAlias(), valueCount.keySet().toArray());
            }
            Map query = (Map)DB.query((DBRoute)DBRoute.of((String)this.vProperty.getParent().getDBRouteKey()), (SqlBuilder)builder, rs -> {
                HashMap<Object, Object> values = new HashMap<Object, Object>(64);
                while (rs.next()) {
                    Object key = rs.getObject(1);
                    Object value = rs.getObject(2);
                    values.put(key, value);
                }
                return values;
            });
            Map<Object, Object> replace = Arrays.stream(this.dataEntities).filter(e -> query.containsKey(e.getValue(ID))).collect(Collectors.toMap(e -> e.getValue(ID), e -> this.vProperty.getValue((Object)e.getDataEntity())));
            query.putAll(replace);
            Map swap = query.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toSet())));
            swap.forEach((k, v) -> ((List)valueMap.get(k)).stream().filter(s -> !v.contains(s.getValue(ID)) || v.size() != 1).forEach(s -> this.addMessage((ExtendedDataEntity)s, this.buildErrMessage((ExtendedDataEntity)s))));
        }
    }

    protected String buildErrMessage(ExtendedDataEntity extDataEntity) {
        if (this.vProperty.getParent() instanceof EntryType) {
            return ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e2d\u201c%2$s\u201d\u7684\u7b2c%3$s\u884c\u7684\u503c\u5b58\u5728\u91cd\u590d\u3002", (String)"NoCodeUniqueValidator_0", (String)"BOS_NOCODE", (Object[])new Object[]{this.vProperty.getParent().getDisplayName().toString(), this.fieldName, extDataEntity.getRowIndex() + 1});
        }
        return ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u503c\u5b58\u5728\u91cd\u590d", (String)"NoCodeUniqueValidator_1", (String)"BOS_NOCODE", (Object[])new Object[]{this.fieldName});
    }
}

