/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ext.wf.control;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.PropertyEvent;
import kd.bos.form.control.events.PropertyListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.metadata.wf.nodes.NoCodeWfNodeApiInvoke;
import kd.bos.nocode.ext.wf.control.NoCodeWfDesignerListener;
import kd.bos.nocode.ext.wf.control.WfDesignerSyncListener;
import kd.bos.nocode.ext.wf.control.events.WfDesignerApproverEvent;
import kd.bos.nocode.ext.wf.control.events.WfDesignerBarEvent;
import kd.bos.nocode.ext.wf.control.events.WfDesignerCommonEvent;
import kd.bos.nocode.ext.wf.control.events.WfDesignerMetaSyncEvent;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.script.annotations.KSMethod;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class NoCodeWfDesigner
extends Control
implements ICloseCallBack {
    private List<NoCodeWfDesignerListener> wfDesignerListeners = new ArrayList<NoCodeWfDesignerListener>();
    private List<WfDesignerSyncListener> syncListeners = new ArrayList<WfDesignerSyncListener>();
    protected List<PropertyListener> listeners = new ArrayList<PropertyListener>();
    private Map<String, Object> content = null;
    private static final Log logger = LogFactory.getLog(NoCodeWfDesigner.class);

    @KSMethod
    public void addPropertyButtonClickListener(PropertyListener listener) {
        this.listeners.add(listener);
    }

    private void fireClick(PropertyEvent e) {
        if (this.listeners != null) {
            for (PropertyListener l : this.listeners) {
                l.click(e);
            }
        }
    }

    @KSMethod
    public void click(String itemId, String metaType, String propertyName, Map<String, Object> param) {
        PropertyEvent e = new PropertyEvent((Object)this, itemId, metaType, propertyName, param);
        this.fireClick(e);
    }

    private void fireQuery(WfDesignerCommonEvent arg) {
        if (this.wfDesignerListeners != null) {
            for (NoCodeWfDesignerListener l : this.wfDesignerListeners) {
                l.query(arg);
            }
        }
    }

    @KSMethod
    public void query(String formId, Map<String, Object> param) {
        WfDesignerCommonEvent arg = new WfDesignerCommonEvent(formId, FormMetaUtil.getRealFormIdExcludeAppId((String)formId), param);
        this.fireQuery(arg);
    }

    private void fireListconfig(WfDesignerCommonEvent arg) {
        if (this.wfDesignerListeners != null) {
            for (NoCodeWfDesignerListener l : this.wfDesignerListeners) {
                l.listconfig(arg);
            }
        }
    }

    @KSMethod
    public void listconfig(String formId) {
        WfDesignerCommonEvent arg = new WfDesignerCommonEvent(formId, FormMetaUtil.getRealFormIdExcludeAppId((String)formId), null);
        this.fireListconfig(arg);
    }

    private void fireListTreeConfig(WfDesignerCommonEvent arg) {
        if (this.wfDesignerListeners != null) {
            for (NoCodeWfDesignerListener l : this.wfDesignerListeners) {
                l.listTreeConfig(arg);
            }
        }
    }

    @KSMethod
    public void listtreeconfig(String formId) {
        WfDesignerCommonEvent arg = new WfDesignerCommonEvent(formId, FormMetaUtil.getRealFormIdExcludeAppId((String)formId), null);
        this.fireListTreeConfig(arg);
    }

    @KSMethod
    public void approverMenu(String targetNodeId) {
        this.fireParticipantMenu(targetNodeId);
    }

    private void fireParticipantMenu(String targetNodeId) {
        if (this.wfDesignerListeners != null) {
            for (NoCodeWfDesignerListener l : this.wfDesignerListeners) {
                l.participantMenu(targetNodeId);
            }
        }
    }

    @KSMethod
    public void queryApproverData(String formNumber, String type, String menuId, Map<String, Object> param) {
        WfDesignerApproverEvent arg = new WfDesignerApproverEvent(formNumber, type, menuId, param);
        this.fireQueryParticipantData(arg);
    }

    private void fireQueryParticipantData(WfDesignerApproverEvent arg) {
        if (this.wfDesignerListeners != null) {
            for (NoCodeWfDesignerListener l : this.wfDesignerListeners) {
                l.queryParticipantData(arg);
            }
        }
    }

    private void fireGetFilterItemLook(WfDesignerCommonEvent arg) {
        if (this.wfDesignerListeners != null) {
            for (NoCodeWfDesignerListener l : this.wfDesignerListeners) {
                l.getFilterItemLook(arg);
            }
        }
    }

    @KSMethod
    public void getFilterItemLook(String formId, Map<String, Object> param) {
        WfDesignerCommonEvent arg = new WfDesignerCommonEvent(formId, FormMetaUtil.getRealFormIdExcludeAppId((String)formId), param);
        this.fireGetFilterItemLook(arg);
    }

    @KSMethod
    public void addSyncListener(WfDesignerSyncListener listener) {
        this.syncListeners.add(listener);
    }

    private void fireSync(WfDesignerMetaSyncEvent syncArgs) {
        if (this.syncListeners != null) {
            for (WfDesignerSyncListener l : this.syncListeners) {
                l.sync(syncArgs);
            }
        }
    }

    @KSMethod
    public void sync(List<String> nodeIds, List<String> types, List<String> properties, Map<String, Object> param) {
        WfDesignerMetaSyncEvent syncArgs = new WfDesignerMetaSyncEvent(nodeIds, types, properties, param, false);
        this.fireSync(syncArgs);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
    }

    public void designerBarClick(String key) {
        WfDesignerBarEvent e = new WfDesignerBarEvent();
        e.setBarItemKey(key);
        for (NoCodeWfDesignerListener l : this.wfDesignerListeners) {
            l.designerBarClick(e);
        }
    }

    public void designerBarClick(String key, String pkid) {
        WfDesignerBarEvent e = new WfDesignerBarEvent();
        e.setBarItemKey(key);
        e.getParam().put("pkid", pkid);
        for (NoCodeWfDesignerListener l : this.wfDesignerListeners) {
            l.designerBarClick(e);
        }
    }

    public void addWfDesignerListeners(NoCodeWfDesignerListener barListener) {
        this.wfDesignerListeners.add(barListener);
    }

    public void open(Map<String, Object> doc) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.key, "open", new Object[]{doc});
    }

    public void postBack(Object value) {
        this.content = (Map)value;
    }

    @KSMethod
    public Map<String, Object> getContent() {
        return this.content;
    }

    @KSMethod
    public void getTriggerProcess(String formId) {
        WfDesignerCommonEvent arg = new WfDesignerCommonEvent(formId, FormMetaUtil.getRealFormIdExcludeAppId((String)formId), null);
        if (this.wfDesignerListeners != null) {
            for (NoCodeWfDesignerListener l : this.wfDesignerListeners) {
                l.getTriggerProcess(arg);
            }
        }
    }

    @KSMethod
    public void addNewRef(String formId) {
        WfDesignerCommonEvent arg = new WfDesignerCommonEvent(formId, FormMetaUtil.getRealFormIdExcludeAppId((String)formId), null);
        if (this.wfDesignerListeners != null) {
            for (NoCodeWfDesignerListener l : this.wfDesignerListeners) {
                l.addNewRef(arg);
            }
        }
    }

    @KSMethod
    public void testApi(Map<String, Object> param) {
        try {
            String jsonString = SerializationUtils.toJsonString(param);
            String testApi = (String)param.get("testApi");
            if (StringUtils.isNotEmpty((CharSequence)testApi)) {
                Map variables = (Map)SerializationUtils.fromJsonString((String)testApi, Map.class);
                for (Map.Entry entry : variables.entrySet()) {
                    String value = (String)entry.getValue();
                    value = StringEscapeUtils.escapeJson((String)value);
                    jsonString = jsonString.replace((CharSequence)entry.getKey(), value);
                }
            }
            NoCodeWfNodeApiInvoke apiInvokeNode = (NoCodeWfNodeApiInvoke)SerializationUtils.fromJsonString((String)jsonString, NoCodeWfNodeApiInvoke.class);
            this.fireTestApi(apiInvokeNode);
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Object)e);
            this.getView().showErrorNotification("testApi method param error: " + e.getMessage());
        }
    }

    private void fireTestApi(NoCodeWfNodeApiInvoke apiInvokeNode) {
        if (this.wfDesignerListeners != null) {
            for (NoCodeWfDesignerListener l : this.wfDesignerListeners) {
                l.testApi(apiInvokeNode);
            }
        }
    }

    @KSMethod
    public void getNoCodeIpList() {
        if (this.wfDesignerListeners != null) {
            for (NoCodeWfDesignerListener l : this.wfDesignerListeners) {
                l.getNoCodeIpList();
            }
        }
    }
}

