/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.metadata;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.nocode.utils.DateTimeUtils;

public interface IDateFormatSupport {
    public String getFormatType();

    default public SimpleDateFormat getFormatter() {
        String formatString;
        switch (this.getFormatType()) {
            case "1": {
                formatString = "yyyy-MM-dd";
                break;
            }
            case "2": {
                formatString = "yyyy-MM";
                break;
            }
            case "3": {
                formatString = "yyyy";
                break;
            }
            default: {
                formatString = "yyyy-MM-dd HH:mm:ss";
            }
        }
        return new SimpleDateFormat(formatString);
    }

    default public String getFormattedValue(Object value) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof String) && !(value instanceof Date)) {
            value = value.toString();
        }
        if (value instanceof String) {
            value = DateTimeUtils.loopParseSilent((String)value);
        }
        return value == null ? "" : this.getFormatter().format((Date)value);
    }
}

