/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.common.constant;

public enum RestApiErrorCode {
    OK("0", "OK"),
    ERROR("999", "Unknown"),
    DATA_DUPLICATE("601", "Find duplicate data"),
    DATA_NOTFOUND("602", "No data found"),
    DATA_INVALID("603", "Data is invalid"),
    SCRIPT_ERROR("701", "Script execution error"),
    HTTP_BAD_REQUEST("400", "Bad Request or Parameters is invalid"),
    HTTP_UNAUTHORIZED("401", "Unauthorized or Token is invalid"),
    HTTP_FORBIDDEN("403", "Forbidden, Access is denied"),
    HTTP_NOT_FOUND("404", "Not Found or Api is disabled"),
    HTTP_NOT_ALLOWED("405", "Method Not Allowed"),
    HTTP_NOT_ACCEPTABLE("406", "Not Acceptable"),
    HTTP_TOO_MANY_REQUEST("429", "Too many request"),
    HTTP_UNSUPPORTED_MEDIA_TYPE("415", "Unsupported Media Type"),
    HTTP_INTERNAL_ERROR("500", "Service is unavailable");

    private final String code;
    private final String errorMsg;

    private RestApiErrorCode(String errorCode, String errorMsg) {
        this.code = errorCode;
        this.errorMsg = errorMsg;
    }

    public String getStatusCode() {
        return this.code;
    }

    public String toString() {
        return this.errorMsg;
    }

    public static RestApiErrorCode fromStatusCode(String errorCode) {
        for (RestApiErrorCode s : RestApiErrorCode.values()) {
            if (!s.code.equals(errorCode)) continue;
            return s;
        }
        return null;
    }
}

