/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.common.result;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.util.DataUtil;

public class RestApiResult
implements Serializable {
    private static final long serialVersionUID = 1342323986837L;
    private static final int INITIALCAPACITY_4 = 4;
    private boolean status = true;
    private String errorCode = "";
    private String message;
    private Object data;
    private String traceId;

    public RestApiResult() {
    }

    public RestApiResult(boolean status, String errorCode, String message, Object data) {
        this.status = status;
        this.errorCode = errorCode;
        this.message = message;
        this.data = data;
    }

    public void fromMap(Map<String, Object> obj) {
        this.setStatus((Boolean)obj.get("status"));
        this.setMessage(DataUtil.s(obj.get("message")));
        this.setData(obj.get("data"));
        this.setErrorCode((String)obj.get("errorCode"));
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> ret = new HashMap<String, Object>(4);
        ret.put("status", this.isStatus());
        ret.put("message", this.getMessage());
        ret.put("data", this.getData());
        ret.put("errorCode", this.getErrorCode());
        return ret;
    }

    public RestApiResult fail(String msg) {
        return this.fail(msg, "fail");
    }

    public RestApiResult fail(String msg, String errorCode) {
        this.setStatus(false);
        this.setMessage(msg);
        this.setErrorCode(errorCode);
        return this;
    }

    public RestApiResult success(Object data) {
        this.setStatus(true);
        this.setData(data);
        this.setErrorCode("");
        return this;
    }

    public static RestApiResult ok(Object data) {
        return new RestApiResult().success(data);
    }

    public static RestApiResult fail(RestApiErrorCode errorCode, Object data) {
        return new RestApiResult(false, errorCode.getStatusCode(), errorCode.toString(), data);
    }

    public static RestApiResult builder() {
        return new RestApiResult();
    }

    public boolean isStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.writeObject(this.data);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        Object obj;
        this.data = obj = is.readObject();
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }
}

