/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.common.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.io.IOUtils;

public class IOUtil {
    private static final Log LOG = LogFactory.getLog(IOUtil.class);

    private IOUtil() {
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ex) {
            IOUtil.log(ex);
        }
    }

    public static void closeQuietly(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception ex) {
            IOUtil.log(ex);
        }
    }

    public static byte[] getByteArray(InputStream input) throws IOException {
        return IOUtils.toByteArray((InputStream)input);
    }

    private static void log(Exception ex) {
        LOG.debug(ex.getMessage());
    }
}

