/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimpleDateFormatSerializer;
import com.alibaba.fastjson.serializer.ToStringSerializer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.StringUtil;

public class JsonUtil {
    private static String mDateFormat;
    private static final SerializeConfig serializeConfig;
    private static final SerializerFeature[] features;
    private static final ObjectWriter objectWriter;

    private JsonUtil() {
    }

    public static String format(Object obj) {
        return JSON.toJSONString((Object)obj, (SerializeConfig)serializeConfig, (SerializerFeature[])features);
    }

    public static Object parseJson(String jsonStr) {
        return JSON.parse((String)jsonStr, (Feature[])new Feature[]{Feature.OrderedField});
    }

    public static Object toJSON(Object obj) {
        return JSON.toJSON((Object)obj);
    }

    public static <T> T parseObject(Object obj, Type type, Feature ... features) {
        if (obj == null) {
            return null;
        }
        String json = JSON.toJSONString((Object)obj);
        return (T)JSON.parseObject((String)json, (Type)type, (Feature[])features);
    }

    public static Map<String, Object> parseJson2Map(String source) {
        if (Objects.isNull(source)) {
            return new HashMap<String, Object>(16);
        }
        return (Map)JSON.parseObject((String)source, Map.class);
    }

    public static String prettyPrint(Object obj) {
        try {
            return objectWriter.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RestApiException(e);
        }
    }

    static {
        serializeConfig = new SerializeConfig();
        serializeConfig.put(Long.class, (ObjectSerializer)ToStringSerializer.instance);
        serializeConfig.put(Long.TYPE, (ObjectSerializer)ToStringSerializer.instance);
        if (StringUtil.isEmpty(mDateFormat)) {
            mDateFormat = "yyyy-MM-dd HH:mm:ss";
        }
        serializeConfig.put(Date.class, (ObjectSerializer)new SimpleDateFormatSerializer(mDateFormat));
        serializeConfig.put(Timestamp.class, (ObjectSerializer)new SimpleDateFormatSerializer(mDateFormat));
        features = new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteBigDecimalAsPlain};
        objectWriter = new ObjectMapper().writerWithDefaultPrettyPrinter();
    }
}

