/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.common.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.nocode.restapi.common.util.Pair;
import org.jetbrains.annotations.NotNull;

public class Maps<K, V> {
    private Maps() {
    }

    @NotNull
    public static <K, V> Map<K, V> of() {
        return Maps.construct(new Pair[0]);
    }

    @NotNull
    public static <K, V> Map<K, V> of(K k, V v) {
        return Maps.construct(Maps.p(k, v));
    }

    @NotNull
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2) {
        return Maps.construct(Maps.p(k1, v1), Maps.p(k2, v2));
    }

    @NotNull
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return Maps.construct(Maps.p(k1, v1), Maps.p(k2, v2), Maps.p(k3, v3));
    }

    @NotNull
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return Maps.construct(Maps.p(k1, v1), Maps.p(k2, v2), Maps.p(k3, v3), Maps.p(k4, v4));
    }

    @NotNull
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return Maps.construct(Maps.p(k1, v1), Maps.p(k2, v2), Maps.p(k3, v3), Maps.p(k4, v4), Maps.p(k5, v5));
    }

    private static <K, V> Pair<K, V> p(K k, V v) {
        return new Pair<K, V>(k, v);
    }

    private static <K, V> Map<K, V> construct(Pair<K, V> ... pairs) {
        HashMap<K, V> map = new HashMap<K, V>(16);
        for (Pair<K, V> pair : pairs) {
            map.put(pair.getKey(), pair.getValue());
        }
        return map;
    }

    @NotNull
    public static <K, V> Map<K, V> copyOf(Iterable<Pair<K, V>> iterable) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Pair<K, V> pair : iterable) {
            result.put(pair.getKey(), pair.getValue());
        }
        return result;
    }

    @NotNull
    public static <K, V> Map<K, V> copyOf(Iterator<Pair<K, V>> iterator) {
        HashMap<K, V> result = new HashMap<K, V>();
        while (iterator.hasNext()) {
            Pair<K, V> pair = iterator.next();
            result.put(pair.getKey(), pair.getValue());
        }
        return result;
    }

    @NotNull
    public static <K, V> Map<K, V> copyOf(Pair<K, V>[] pairs) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Pair<K, V> pair : pairs) {
            result.put(pair.getKey(), pair.getValue());
        }
        return result;
    }
}

