/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.common.util;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.nocode.restapi.common.util.DataUtil;
import kd.bos.orm.impl.ORMUtil;
import org.jetbrains.annotations.NotNull;

public class StringUtil {
    public static final String SEPARATOR = ",";
    public static final String STAR = "*";

    private StringUtil() {
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static String replaceNull(String str) {
        return str == null ? "" : str.trim();
    }

    public static Object replaceNull(Object str) {
        return str == null ? "" : str;
    }

    public static boolean equals(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    public static List<String> strToList(String str) {
        return StringUtil.isNotEmpty(str) ? Arrays.asList(str.split(SEPARATOR)) : null;
    }

    public static String changeFirstCharacterCase(String str, boolean capitalize) {
        if (str != null && str.length() != 0) {
            StringBuilder buf = new StringBuilder(str.length());
            if (capitalize) {
                buf.append(Character.toUpperCase(str.charAt(0)));
            } else {
                buf.append(Character.toLowerCase(str.charAt(0)));
            }
            buf.append(str.substring(1));
            return buf.toString();
        }
        return str;
    }

    public static String substring(Object obj, int maxLength) {
        String str = DataUtil.s(obj);
        if (str == null) {
            return null;
        }
        if (str.length() <= maxLength) {
            return str;
        }
        return str.substring(0, maxLength - 3) + "...";
    }

    public static int indexOfIngnoreCase(String str, String subStr) {
        String lowerStr = str.toLowerCase();
        String lowerSubStr = subStr.toLowerCase();
        return lowerStr.indexOf(lowerSubStr);
    }

    public static String replaceInvalidString(String strSource) {
        String str;
        int i;
        if (StringUtil.isEmpty(strSource)) {
            return "";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        int ch = 97;
        for (i = 0; i < 26; ++i) {
            str = String.valueOf((char)(ch + i));
            map.put(str, str);
        }
        ch = 65;
        for (i = 0; i < 26; ++i) {
            str = String.valueOf((char)(ch + i));
            map.put(str, str);
        }
        for (i = 0; i < 10; ++i) {
            str = String.valueOf(i);
            map.put(str, str);
        }
        map.put(":", ":");
        map.put("=", "=");
        map.put("/", "/");
        map.put("\\", "\\");
        map.put("_", "_");
        map.put("-", "-");
        map.put(STAR, STAR);
        StringBuilder temp = new StringBuilder();
        for (int i2 = 0; i2 < strSource.length(); ++i2) {
            if (map.get(strSource.charAt(i2) + "") == null) continue;
            temp.append((String)map.get(strSource.charAt(i2) + ""));
        }
        return temp.toString();
    }

    public static int countMatches(CharSequence str, char ch) {
        return org.apache.commons.lang3.StringUtils.countMatches((CharSequence)str, (char)ch);
    }

    public static int countMatches(CharSequence str, CharSequence sub) {
        return org.apache.commons.lang3.StringUtils.countMatches((CharSequence)str, (CharSequence)sub);
    }

    public static String cleanXSSParam(String value) {
        return value;
    }

    public static String cleanXSSContent(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        String cleanValue = value;
        cleanValue = cleanValue.replace("\"", "&quot;");
        cleanValue = cleanValue.replace("'", "&#39;");
        cleanValue = cleanValue.replace("<", "&lt;");
        cleanValue = cleanValue.replace(">", "&gt;");
        return cleanValue;
    }

    public static boolean isEmptyString(Object value) {
        if (!(value instanceof CharSequence)) {
            return false;
        }
        return org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)((CharSequence)value));
    }

    @Deprecated
    public static String escapeWildcard(String value) {
        return value == null ? null : value.replace("%", "\\%").replace("_", "\\_");
    }

    public static String escapeSQLWildcardAccordingToIDataEntityType(String value, IDataEntityType dataEntityType) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)value) || dataEntityType == null) {
            return null;
        }
        value = StringUtil.escapePercentSign(value);
        if (!ORMUtil.isEffective((IDataEntityType)dataEntityType)) {
            value = StringUtil.escapeUnderline(value);
            value = StringUtil.escapeBackSlash(value);
        }
        return value;
    }

    private static String escapePercentSign(@NotNull String value) {
        return value.replace("%", "\\%");
    }

    private static String escapeUnderline(@NotNull String value) {
        return value.replace("_", "\\_");
    }

    private static String escapeBackSlash(@NotNull String value) {
        return value.replace("\\", "\\\\");
    }

    @NotNull
    public static String removeNewLine(@NotNull String expression) {
        return expression.replace("\r\n", "").replace("\n", "");
    }

    public static boolean isNotEmptyBrackets(String filter) {
        Object[] chars = filter.split("");
        return Lists.newArrayList((Object[])chars).stream().anyMatch(c -> !"(".equals(c) && !")".equals(c));
    }
}

