/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.common.visitor;

import com.google.common.collect.ImmutableMap;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.common.visitor.DataEntityPropertyVisitor;

public abstract class AbstractDataEntityPropertyVisitor<R>
implements DataEntityPropertyVisitor<R> {
    private static final Log LOG = LogFactory.getLog(AbstractDataEntityPropertyVisitor.class);

    @Override
    public final R visit(IDataEntityProperty property, String fullName, ImmutableMap<String, Object> extraMap) {
        if (property instanceof ISimpleProperty) {
            return this.visitSimpleProperty((ISimpleProperty)property, fullName, extraMap);
        }
        if (property instanceof IComplexProperty) {
            return this.visitComplexProperty((IComplexProperty)property, fullName, extraMap);
        }
        LOG.debug("\u4e0d\u652f\u6301\u6a21\u7cca\u5339\u914d\u7684\u5c5e\u6027\u7c7b\u578b\uff1a{}", (Object)property.getClass().getName());
        return this.defaultValue(property, fullName, extraMap);
    }

    protected abstract R visitSimpleProperty(ISimpleProperty var1, String var2, ImmutableMap<String, Object> var3);

    protected abstract R visitComplexProperty(IComplexProperty var1, String var2, ImmutableMap<String, Object> var3);

    protected abstract R defaultValue(IDataEntityProperty var1, String var2, ImmutableMap<String, Object> var3);
}

