/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.nocode.entity.WfTriggerTime;

public class CronUtils {
    public static List<String> buildCronExpression(WfTriggerTime wfTriggerTime) {
        ArrayList<String> cronExList = new ArrayList<String>(16);
        ArrayList<String> items = new ArrayList<String>(Splitter.on((String)":").splitToList((CharSequence)wfTriggerTime.getTime()));
        Collections.reverse(items);
        switch (wfTriggerTime.getLoopTypeEnum()) {
            case DAY: {
                items.add("*");
                items.add("*");
                items.add("?");
                cronExList.add(String.join((CharSequence)" ", items));
                break;
            }
            case WEEK: {
                items.add("?");
                items.add("*");
                String weeks = String.join((CharSequence)",", wfTriggerTime.getDate());
                items.add(weeks);
                cronExList.add(String.join((CharSequence)" ", items));
                break;
            }
            case MONTH: {
                String dates = String.join((CharSequence)",", wfTriggerTime.getDate());
                items.add(dates);
                items.add("*");
                items.add("?");
                cronExList.add(String.join((CharSequence)" ", items));
                break;
            }
            case YEAR: {
                List<String> monthDay = wfTriggerTime.getDate();
                Map month2Days = monthDay.stream().collect(Collectors.groupingBy(e -> String.valueOf(Integer.parseInt(e.split("-")[0])), Collectors.mapping(e -> String.valueOf(Integer.parseInt(e.split("-")[1])), Collectors.toList())));
                month2Days.forEach((m, ds) -> {
                    ArrayList<String> innerItems = new ArrayList<String>(Splitter.on((String)":").splitToList((CharSequence)wfTriggerTime.getTime()));
                    Collections.reverse(innerItems);
                    innerItems.add(String.join((CharSequence)",", ds));
                    innerItems.add((String)m);
                    innerItems.add("?");
                    cronExList.add(String.join((CharSequence)" ", innerItems));
                });
                break;
            }
        }
        return cronExList;
    }
}

