/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import org.apache.commons.lang3.time.DateUtils;

public class DateTimeUtils {
    private static final Log log = LogFactory.getLog(DateTimeUtils.class);
    private static final ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();
    private static final int NUMBER_10 = 10;
    private static final int NUMBER_8 = 8;
    private static final int NUMBER_7 = 7;
    private static final int NUMBER_6 = 6;
    private static final int NUMBER_4 = 4;
    private static final int NUMBER_2 = 2;
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM = "yyyy-MM";
    public static final String YYYY = "yyyy";
    static Set<String> dateFormats = new LinkedHashSet<String>();

    private DateTimeUtils() {
        throw new IllegalStateException("DateTimeUtils class");
    }

    public static Date getNow() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        try {
            now = sdf.parse(sdf.format(now));
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u5f02\u5e38", (String)"DateTimeUtils_0", (String)"bos-nocode-common", (Object[])new Object[0]));
        }
        return now;
    }

    public static Date parseDate(String str) {
        Date date;
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        try {
            date = DateUtils.parseDate((String)str, (String[])dateFormats.toArray(new String[0]));
        }
        catch (ParseException e) {
            log.warn((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u5f02\u5e38", (String)"DateTimeUtils_0", (String)"bos-nocode-common", (Object[])new Object[0]));
        }
        return date;
    }

    public static String formatDateTime(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD_HH_MM_SS);
        return sdf.format(date);
    }

    public static LocalDate toLocalDate(Date date) {
        return date.toInstant().atZone(DEFAULT_ZONE_ID).toLocalDate();
    }

    public static boolean isLongDate(String str) {
        return str.length() > 10;
    }

    public static boolean isShortDate(String str) {
        return str.length() <= 10 && str.length() >= 8;
    }

    public static boolean isYear(String str) {
        return str.length() == 4;
    }

    public static boolean isYearMonth(String str) {
        return str.length() <= 7 && str.length() >= 6;
    }

    public static List<QFilter> getDateRangeQFilter(String fieldName, Date date) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        LocalDate localDate = DateTimeUtils.toLocalDate(date);
        LocalDateTime startOfDay = localDate.atStartOfDay();
        LocalDateTime endOfDay = localDate.atTime(LocalTime.MAX);
        filters.add(new QFilter(fieldName, ">=", (Object)Date.from(startOfDay.atZone(DEFAULT_ZONE_ID).toInstant())).and(new QFilter(fieldName, "<=", (Object)Date.from(endOfDay.atZone(DEFAULT_ZONE_ID).toInstant()))));
        return filters;
    }

    public static List<QFilter> getYearMonthRangeQFiler(String fieldName, Date date) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        LocalDate localDate = DateTimeUtils.toLocalDate(date);
        LocalDateTime start = localDate.atStartOfDay();
        LocalDateTime end = localDate.atTime(LocalTime.MAX).with(TemporalAdjusters.lastDayOfMonth());
        filters.add(new QFilter(fieldName, ">=", (Object)Date.from(start.atZone(DEFAULT_ZONE_ID).toInstant())).and(new QFilter(fieldName, "<=", (Object)Date.from(end.atZone(DEFAULT_ZONE_ID).toInstant()))));
        return filters;
    }

    public static List<QFilter> getYearRangeQFilter(String fieldName, Date date) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        LocalDate localDate = DateTimeUtils.toLocalDate(date);
        LocalDateTime start = localDate.atStartOfDay();
        LocalDateTime end = localDate.atTime(LocalTime.MAX).with(TemporalAdjusters.lastDayOfYear());
        filters.add(new QFilter(fieldName, ">=", (Object)Date.from(start.atZone(DEFAULT_ZONE_ID).toInstant())).and(new QFilter(fieldName, "<=", (Object)Date.from(end.atZone(DEFAULT_ZONE_ID).toInstant()))));
        return filters;
    }

    public static LocalDateTime getMaxLocalDateTime(Date targetDate, String value) {
        LocalDate localDate = DateTimeUtils.toLocalDate(targetDate);
        if (DateTimeUtils.isShortDate(value)) {
            return localDate.atTime(LocalTime.MAX);
        }
        if (DateTimeUtils.isYearMonth(value)) {
            return localDate.atTime(LocalTime.MAX).with(TemporalAdjusters.lastDayOfMonth());
        }
        return localDate.atTime(LocalTime.MAX).with(TemporalAdjusters.lastDayOfYear());
    }

    public static String getFormatString(String formatType) {
        String formatString = YYYY_MM_DD;
        switch (formatType) {
            case "0": {
                formatString = YYYY_MM_DD_HH_MM_SS;
                break;
            }
            case "1": {
                formatString = YYYY_MM_DD;
                break;
            }
            case "2": {
                formatString = YYYY_MM;
                break;
            }
            case "3": {
                formatString = YYYY;
                break;
            }
        }
        return formatString;
    }

    public static Date loopParse(String strDate) throws ParseException {
        boolean isSuccess = false;
        Throwable ex = null;
        Date result = null;
        for (String format : dateFormats) {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            sdf.setLenient(false);
            try {
                Date date = sdf.parse(strDate);
                int year = DateTimeUtils.toLocalDate(date).getYear();
                if (year > 9999) {
                    throw new ParseException("Out of range: " + year, 0);
                }
                isSuccess = true;
                result = date;
                break;
            }
            catch (Exception e) {
                ex = e;
            }
        }
        if (isSuccess) {
            return result;
        }
        if (ex != null) {
            log.debug("\u65e5\u671f\u683c\u5f0f\u89e3\u6790\u9519\u8bef: {}", (Object)(ex.getMessage() == null ? "" : ex.getMessage()), (Object)ex);
            throw new ParseException(ex.getMessage(), 0);
        }
        throw new ParseException(ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u9519\u8bef", (String)"DateTimeUtils_1", (String)"bos-nocode-common", (Object[])new Object[0]), 0);
    }

    public static Date loopParseSilent(String strDate) {
        try {
            return DateTimeUtils.loopParse(strDate);
        }
        catch (Exception e) {
            log.info("parse date error: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    static {
        dateFormats.add(YYYY_MM_DD_HH_MM_SS);
        dateFormats.add("yyyy/MM/dd HH:mm:ss");
        dateFormats.add("yyyyMMdd HH:mm:ss");
        dateFormats.add(YYYY_MM_DD);
        dateFormats.add("yyyy/MM/dd");
        dateFormats.add("yyyyMMdd");
        dateFormats.add(YYYY_MM);
        dateFormats.add("yyyy/MM");
        dateFormats.add("yyyyMM");
        dateFormats.add(YYYY);
    }
}

