/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.exception.KDBizException;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.converter.FormMetadataConverter;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.businessfield.BillNoField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.mservice.svc.attach.IAttachmentField;
import kd.bos.mservice.svc.picture.IPictureField;
import kd.bos.nocode.constant.WfConsts;
import kd.bos.nocode.metadata.INoCodeAddressFormatField;
import kd.bos.nocode.metadata.INoCodeAttachmentUploadField;
import kd.bos.nocode.metadata.INoCodeCreateDateField;
import kd.bos.nocode.metadata.INoCodeCreatorField;
import kd.bos.nocode.metadata.INoCodeGraphicDisplayField;
import kd.bos.nocode.metadata.INoCodeModifierField;
import kd.bos.nocode.metadata.INoCodeModifyDateField;
import kd.bos.nocode.metadata.INoCodeRefBillField;
import kd.bos.nocode.metadata.INoCodeRichTextField;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NcRuntimeMetaUtil;
import kd.bos.nocode.utils.ShowColumnInfo;

public class FieldTreeBuilder {
    protected EnumSet<Feature> _features = EnumSet.noneOf(Feature.class);
    protected EnumSet<FieldType> _ignoreFieldTypes = EnumSet.noneOf(FieldType.class);
    private FormMetadata _formMeta;
    private String _selectFields;
    private String _formId;
    private String _rootFormId;
    private int _level = 1;
    private int _topColumn = -1;
    private Function<Ctx, Map<String, Object>> _optionCustomHandle;
    private boolean _ignoreDefaultOptionHandle = false;
    private Consumer<Ctx> _infoCustomHandle;
    private boolean _ignoreDefaultInfoHandle = false;
    private String _parentKey;
    private boolean _byFormMetadata = false;
    private boolean _sysFieldAdded_billNo = false;
    private boolean _sysFieldAdded_creator = false;
    private boolean _sysFieldAdded_createdate = false;
    private boolean _sysFieldAdded_modifier = false;
    private boolean _sysFieldAdded_modifydate = false;
    IFormMetaLoader formMetaLoader = formId -> this.getFormMeta(formId);

    public FieldTreeBuilder(String formId2) {
        if (StringUtils.isBlank((CharSequence)formId2) || !NcEntityTypeUtil.isFormExist(formId2)) {
            this._formId = null;
        } else {
            this._formId = NcEntityTypeUtil.getRealBillEntityId(formId2);
            if (!NcEntityTypeUtil.isRefBillOfOrg(this._formId) && !NcEntityTypeUtil.isRefBillOfUser(this._formId)) {
                FormMetadata formMeta;
                this._formMeta = formMeta = (FormMetadata)ThreadCache.get((Object)("fieldtree_formmeta_" + this._formId), () -> this.formMetaLoader.load(this._formId));
            }
        }
    }

    public FieldTreeBuilder(FormMetadata formMeta) {
        if (formMeta == null) {
            throw new KDBizException("formMeta is null");
        }
        this._formMeta = formMeta;
        this._byFormMetadata = true;
        this._formId = this._formMeta.getId();
    }

    public FieldTreeBuilder withFeature(Feature ... features) {
        if (features == null || features.length == 0) {
            this._features = EnumSet.noneOf(Feature.class);
        } else {
            this._features = EnumSet.noneOf(Feature.class);
            for (Feature feature : features) {
                this._features.add(feature);
            }
        }
        return this;
    }

    private FieldTreeBuilder withFeature(EnumSet<Feature> features) {
        this._features = features;
        return this;
    }

    public FieldTreeBuilder withoutFieldTypes(FieldType ... fieldTypes) {
        if (fieldTypes == null || fieldTypes.length == 0) {
            this._ignoreFieldTypes = EnumSet.noneOf(FieldType.class);
        } else {
            this._ignoreFieldTypes = EnumSet.noneOf(FieldType.class);
            for (FieldType fieldType : fieldTypes) {
                this._ignoreFieldTypes.add(fieldType);
            }
        }
        return this;
    }

    private FieldTreeBuilder withoutFieldTypes(EnumSet<FieldType> fieldTypes) {
        this._ignoreFieldTypes = fieldTypes;
        return this;
    }

    public FieldTreeBuilder withSelectFields(String selectFields) {
        this._selectFields = selectFields;
        return this;
    }

    public FieldTreeBuilder withCustomOption(Function<Ctx, Map<String, Object>> optionCustomHandle, boolean ignoreDefaultHandle) {
        this._optionCustomHandle = optionCustomHandle;
        this._ignoreDefaultOptionHandle = ignoreDefaultHandle;
        return this;
    }

    public FieldTreeBuilder withCustomInfo(Consumer<Ctx> infoCustomHandle, boolean ignoreDefaultHandle, String parentKey) {
        this._infoCustomHandle = infoCustomHandle;
        this._ignoreDefaultInfoHandle = ignoreDefaultHandle;
        this._parentKey = parentKey;
        return this;
    }

    public FieldTreeBuilder withRootFormId(String rootFormId) {
        this._rootFormId = rootFormId;
        return this;
    }

    public FieldTreeBuilder withLevel(int level) {
        this._level = level;
        return this;
    }

    public FieldTreeBuilder withTopColumn(int topColumn) {
        this._topColumn = topColumn;
        return this;
    }

    public List<ShowColumnInfo> build() {
        return this.innerBuild();
    }

    private List<ShowColumnInfo> innerBuild() {
        if (StringUtils.isBlank((CharSequence)this._formId)) {
            return Collections.emptyList();
        }
        if (NcEntityTypeUtil.isRefBillOfOrg(this._formId)) {
            return this.buildOrgInfo();
        }
        if (NcEntityTypeUtil.isRefBillOfUser(this._formId)) {
            return this.buildUserInfo();
        }
        if (this.canCache()) {
            String cacheKey = this.getCacheKey();
            return (List)ThreadCache.get((Object)cacheKey, () -> this.innerBuildNormal());
        }
        return this.innerBuildNormal();
    }

    private List<ShowColumnInfo> innerBuildNormal() {
        ArrayList<ShowColumnInfo> showColumns = new ArrayList<ShowColumnInfo>();
        BillFormAp billFormAp = (BillFormAp)this._formMeta.getItems().get(0);
        for (ControlAp billFormApItem : billFormAp.getItems()) {
            if (this._topColumn > 0 && showColumns.size() >= this._topColumn) break;
            this.loopItem(billFormApItem, showColumns, null);
        }
        this.buildSysFieldInfo(showColumns);
        if (this.includePk()) {
            String dataType = "pk";
            String dataTypeCaption = NcEntityTypeUtil.getDataTypePkCap();
            ShowColumnInfo pkColumn = new ShowColumnInfo("id", "id", false, dataType, dataTypeCaption);
            pkColumn.getOption().put(Feature.IncludePK.toString(), true);
            showColumns.add(pkColumn);
        }
        return showColumns;
    }

    private boolean canCache() {
        return false;
    }

    private String getCacheKey() {
        return String.format("fieldtree_{%s}_{%s}_{%s}_{%s}_{%s}_{%s}_{%s}", this._formId, this.getRootFormId(), this._features.toString(), this._ignoreFieldTypes.toString(), this._selectFields == null ? "" : this._selectFields, this._level, this._parentKey == null ? "" : this._parentKey);
    }

    private List<ShowColumnInfo> buildOrgInfo() {
        ArrayList<ShowColumnInfo> result = new ArrayList<ShowColumnInfo>(5);
        if (this.includePk()) {
            ShowColumnInfo idInfo = new ShowColumnInfo();
            idInfo.setId("id");
            idInfo.setCaption(ResManager.loadKDString((String)"\u5185\u7801", (String)"FieldTreeBuilder_0", (String)"bos-nocode-common", (Object[])new Object[0]));
            idInfo.setVisible(true);
            idInfo.setType("pk");
            idInfo.setTypeCaption(NcEntityTypeUtil.getDataTypePkCap());
            result.add(idInfo);
        }
        ShowColumnInfo nameInfo = new ShowColumnInfo();
        nameInfo.setId("name");
        nameInfo.setCaption(ResManager.loadKDString((String)"\u540d\u79f0", (String)"FieldTreeBuilder_1", (String)"bos-nocode-common", (Object[])new Object[0]));
        nameInfo.setVisible(true);
        nameInfo.setType(this.useRealType() ? "TextField" : "text");
        nameInfo.setTypeCaption(NcEntityTypeUtil.getDataTypeTextCap());
        nameInfo.getOption().put("editorType", "MuliLangTextField");
        nameInfo.getOption().put("required", true);
        result.add(nameInfo);
        ShowColumnInfo numberInfo = new ShowColumnInfo();
        numberInfo.setId("number");
        numberInfo.setCaption(ResManager.loadKDString((String)"\u7f16\u7801", (String)"FieldTreeBuilder_2", (String)"bos-nocode-common", (Object[])new Object[0]));
        numberInfo.setVisible(true);
        numberInfo.setType(this.useRealType() ? "TextField" : "text");
        numberInfo.setTypeCaption(NcEntityTypeUtil.getDataTypeTextCap());
        numberInfo.getOption().put("editorType", "TextField");
        numberInfo.getOption().put("required", true);
        result.add(numberInfo);
        return result;
    }

    private List<ShowColumnInfo> buildUserInfo() {
        ArrayList<ShowColumnInfo> result = new ArrayList<ShowColumnInfo>(5);
        if (this.includePk()) {
            ShowColumnInfo idInfo = new ShowColumnInfo();
            idInfo.setId("id");
            idInfo.setCaption(ResManager.loadKDString((String)"\u5185\u7801", (String)"FieldTreeBuilder_0", (String)"bos-nocode-common", (Object[])new Object[0]));
            idInfo.setVisible(true);
            idInfo.setType("pk");
            idInfo.setTypeCaption(NcEntityTypeUtil.getDataTypePkCap());
            result.add(idInfo);
        }
        ShowColumnInfo nameInfo = new ShowColumnInfo();
        nameInfo.setId("name");
        nameInfo.setCaption(ResManager.loadKDString((String)"\u59d3\u540d", (String)"FieldTreeBuilder_3", (String)"bos-nocode-common", (Object[])new Object[0]));
        nameInfo.setVisible(true);
        nameInfo.setType(this.useRealType() ? "MuliLangTextField" : "text");
        nameInfo.setTypeCaption(NcEntityTypeUtil.getDataTypeTextCap());
        nameInfo.getOption().put("editorType", "MuliLangTextField");
        nameInfo.getOption().put("required", true);
        result.add(nameInfo);
        ShowColumnInfo numberInfo = new ShowColumnInfo();
        numberInfo.setId("number");
        numberInfo.setCaption(ResManager.loadKDString((String)"\u5de5\u53f7", (String)"FieldTreeBuilder_4", (String)"bos-nocode-common", (Object[])new Object[0]));
        numberInfo.setVisible(true);
        numberInfo.setType(this.useRealType() ? "TextField" : "text");
        numberInfo.setTypeCaption(NcEntityTypeUtil.getDataTypeTextCap());
        numberInfo.getOption().put("editorType", "TextField");
        numberInfo.getOption().put("required", true);
        result.add(numberInfo);
        ShowColumnInfo genderInfo = new ShowColumnInfo();
        genderInfo.setId("gender");
        genderInfo.setCaption(ResManager.loadKDString((String)"\u6027\u522b", (String)"FieldTreeBuilder_5", (String)"bos-nocode-common", (Object[])new Object[0]));
        genderInfo.setVisible(true);
        genderInfo.setType(this.useRealType() ? "ComboField" : "combo");
        genderInfo.setTypeCaption(NcEntityTypeUtil.getDataTypeComboCap());
        genderInfo.getOption().put("editorType", "ComboField");
        ArrayList<ValueMapItem> valueItems = new ArrayList<ValueMapItem>(3);
        ValueMapItem valueMapItem1 = new ValueMapItem(null, "1", new LocaleString(ResManager.loadKDString((String)"\u7537", (String)"FieldTreeBuilder_6", (String)"bos-nocode-common", (Object[])new Object[0])), true);
        valueItems.add(valueMapItem1);
        ValueMapItem valueMapItem2 = new ValueMapItem(null, "2", new LocaleString(ResManager.loadKDString((String)"\u5973", (String)"FieldTreeBuilder_7", (String)"bos-nocode-common", (Object[])new Object[0])), true);
        valueItems.add(valueMapItem2);
        ValueMapItem valueMapItem0 = new ValueMapItem(null, "0", new LocaleString(ResManager.loadKDString((String)"\u4fdd\u5bc6", (String)"FieldTreeBuilder_8", (String)"bos-nocode-common", (Object[])new Object[0])), false);
        valueItems.add(valueMapItem0);
        genderInfo.getOption().put("valueItems", valueItems);
        result.add(genderInfo);
        ShowColumnInfo phoneInfo = new ShowColumnInfo();
        phoneInfo.setId("phone");
        phoneInfo.setCaption(ResManager.loadKDString((String)"\u624b\u673a", (String)"FieldTreeBuilder_9", (String)"bos-nocode-common", (Object[])new Object[0]));
        phoneInfo.setVisible(true);
        phoneInfo.setType(this.useRealType() ? "TextField" : "text");
        phoneInfo.setTypeCaption(NcEntityTypeUtil.getDataTypeTextCap());
        phoneInfo.getOption().put("editorType", "TextField");
        result.add(phoneInfo);
        ShowColumnInfo emailInfo = new ShowColumnInfo();
        emailInfo.setId("email");
        emailInfo.setCaption(ResManager.loadKDString((String)"\u90ae\u7bb1", (String)"FieldTreeBuilder_10", (String)"bos-nocode-common", (Object[])new Object[0]));
        emailInfo.setVisible(true);
        emailInfo.setType(this.useRealType() ? "TextField" : "text");
        emailInfo.setTypeCaption(NcEntityTypeUtil.getDataTypeTextCap());
        emailInfo.getOption().put("editorType", "TextField");
        result.add(emailInfo);
        return result;
    }

    private void buildSysFieldInfo(List<ShowColumnInfo> showColumns) {
        Field billNoField;
        Optional<EntityItem> billNoFieldOpt;
        Field modifyDateField;
        Optional<EntityItem> modifyDateFieldOpt;
        Field modifierField;
        Optional<EntityItem> modifierFieldOpt;
        Field createDateField;
        Optional<EntityItem> createDateFieldOpt;
        Field creatorField;
        List<ShowColumnInfo> infos;
        Optional<EntityItem> creatorFieldOpt;
        if (!this._sysFieldAdded_creator && (creatorFieldOpt = this._formMeta.getEntityMetadata().getItems().stream().filter(i -> i instanceof INoCodeCreatorField).findFirst()).isPresent() && !(infos = this.genField(creatorField = (Field)creatorFieldOpt.get(), null)).isEmpty()) {
            showColumns.addAll(infos);
        }
        if (!this._sysFieldAdded_createdate && (createDateFieldOpt = this._formMeta.getEntityMetadata().getItems().stream().filter(i -> i instanceof INoCodeCreateDateField).findFirst()).isPresent() && !(infos = this.genField(createDateField = (Field)createDateFieldOpt.get(), null)).isEmpty()) {
            showColumns.addAll(infos);
        }
        if (!this._sysFieldAdded_modifier && (modifierFieldOpt = this._formMeta.getEntityMetadata().getItems().stream().filter(i -> i instanceof INoCodeModifierField).findFirst()).isPresent() && !(infos = this.genField(modifierField = (Field)modifierFieldOpt.get(), null)).isEmpty()) {
            showColumns.addAll(infos);
        }
        if (!this._sysFieldAdded_modifydate && (modifyDateFieldOpt = this._formMeta.getEntityMetadata().getItems().stream().filter(i -> i instanceof INoCodeModifyDateField).findFirst()).isPresent() && !(infos = this.genField(modifyDateField = (Field)modifyDateFieldOpt.get(), null)).isEmpty()) {
            showColumns.addAll(infos);
        }
        if (!this._sysFieldAdded_billNo && (billNoFieldOpt = this._formMeta.getEntityMetadata().getItems().stream().filter(i -> i instanceof BillNoField).findFirst()).isPresent() && !(infos = this.genField(billNoField = (Field)billNoFieldOpt.get(), null)).isEmpty()) {
            showColumns.addAll(infos);
        }
    }

    private void loopItem(ControlAp<?> item, List<ShowColumnInfo> showColumns, ShowColumnInfo parent) {
        List childrenList2add = showColumns;
        if (parent != null) {
            childrenList2add = (List)parent.getOption().get("children");
        }
        if (!(item instanceof EntryAp)) {
            FieldAp fieldAp;
            Field field;
            List<ShowColumnInfo> fieldInfos;
            if (item instanceof ContainerAp) {
                ContainerAp containerAp = (ContainerAp)item;
                ShowColumnInfo theParent = parent;
                ShowColumnInfo groupInfo = null;
                if (this.includeGroupContainer()) {
                    theParent = groupInfo = this.genGroup(containerAp);
                    childrenList2add.add(groupInfo);
                }
                for (ControlAp itemAp : containerAp.getItems()) {
                    this.loopItem(itemAp, showColumns, theParent);
                }
                if (groupInfo != null && ((List)groupInfo.getOption().get("children")).isEmpty()) {
                    childrenList2add.remove(groupInfo);
                }
            } else if (item instanceof FieldAp && (fieldInfos = this.genField(field = (fieldAp = (FieldAp)item).getField(), fieldAp)) != null && !fieldInfos.isEmpty()) {
                childrenList2add.addAll(fieldInfos);
                if (field instanceof INoCodeAttachmentUploadField && this.includeAttachmentDetail()) {
                    for (ShowColumnInfo fieldInfo : fieldInfos) {
                        List<ShowColumnInfo> attExtInfos = NcEntityTypeUtil.addAttachmentSubProps(childrenList2add, fieldInfo);
                        for (ShowColumnInfo attExtInfo : attExtInfos) {
                            attExtInfo.getOption().put(Feature.AttachmentDetail.toString(), true);
                        }
                    }
                }
            }
        }
    }

    private List<ShowColumnInfo> genField(Field<?> field, FieldAp fieldAp) {
        if (this.ignoreField(field)) {
            return Collections.emptyList();
        }
        if (field instanceof DateRangeField) {
            return this.genField_DateRange((DateRangeField)field, fieldAp);
        }
        ArrayList<ShowColumnInfo> result = new ArrayList<ShowColumnInfo>(1);
        ShowColumnInfo info = new ShowColumnInfo();
        String caption = field.getName() == null ? "" : field.getName().toString();
        String dataType = this.getDateType(field);
        String dataTypeCaption = NcEntityTypeUtil.getDataTypeCaption(field);
        if (StringUtils.isBlank((CharSequence)info.getCaption())) {
            info.setCaption(caption);
        } else {
            info.setCaption(info.getCaption() + "." + caption);
        }
        if (StringUtils.isBlank((CharSequence)info.getId())) {
            info.setId(field.getKey());
        } else {
            info.setId(info.getId() + "." + field.getKey());
        }
        info.setType(dataType);
        info.setTypeCaption(dataTypeCaption);
        info.setVisible(true);
        Ctx ctx = new Ctx(this._formMeta, field, fieldAp, info, this._formId, this._parentKey);
        this.applyOptionHandle(ctx);
        this.applyInfoHandle(ctx);
        result.add(info);
        if ("nocodecreatorfield".equalsIgnoreCase(info.getId())) {
            this._sysFieldAdded_creator = true;
        } else if ("nocodecreatedatefield".equalsIgnoreCase(info.getId())) {
            this._sysFieldAdded_createdate = true;
        } else if ("nocodemodifierfield".equalsIgnoreCase(info.getId())) {
            this._sysFieldAdded_modifier = true;
        } else if ("nocodemodifydatefield".equalsIgnoreCase(info.getId())) {
            this._sysFieldAdded_modifydate = true;
        } else if ("nocodebillnofield".equalsIgnoreCase(info.getId())) {
            this._sysFieldAdded_billNo = true;
        }
        return result;
    }

    private List<ShowColumnInfo> genField_DateRange(DateRangeField field, FieldAp fieldAp) {
        String dataType = this.getDateType((Field<?>)field);
        String dataTypeCaption = NcEntityTypeUtil.getDataTypeDateCap();
        String caption = field.getName() == null ? "" : field.getName().toString();
        ArrayList<ShowColumnInfo> result = new ArrayList<ShowColumnInfo>(2);
        ShowColumnInfo startInfo = new ShowColumnInfo();
        if (StringUtils.isBlank((CharSequence)startInfo.getCaption())) {
            startInfo.setCaption(caption + "." + ResManager.loadKDString((String)"\u5f00\u59cb", (String)"FieldTreeBuilder_11", (String)"BOS_NOCODE", (Object[])new Object[0]));
        } else {
            startInfo.setCaption(startInfo.getCaption() + "." + caption + "." + ResManager.loadKDString((String)"\u5f00\u59cb", (String)"FieldTreeBuilder_11", (String)"BOS_NOCODE", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)startInfo.getId())) {
            startInfo.setId(field.getStartDateFieldKey());
        } else {
            startInfo.setId(startInfo.getId() + "." + field.getStartDateFieldKey());
        }
        startInfo.setType(dataType);
        startInfo.setTypeCaption(dataTypeCaption);
        startInfo.setVisible(true);
        Ctx ctxStart = new Ctx(this._formMeta, (Field<?>)field, fieldAp, startInfo, this._formId, this._parentKey);
        this.applyOptionHandle(ctxStart);
        this.applyInfoHandle(ctxStart);
        result.add(startInfo);
        ShowColumnInfo endInfo = new ShowColumnInfo();
        if (StringUtils.isBlank((CharSequence)endInfo.getCaption())) {
            endInfo.setCaption(caption + "." + ResManager.loadKDString((String)"\u7ed3\u675f", (String)"FieldTreeBuilder_12", (String)"BOS_NOCODE", (Object[])new Object[0]));
        } else {
            endInfo.setCaption(endInfo.getCaption() + "." + caption + "." + ResManager.loadKDString((String)"\u7ed3\u675f", (String)"FieldTreeBuilder_12", (String)"BOS_NOCODE", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)endInfo.getId())) {
            endInfo.setId(field.getEndDateFieldKey());
        } else {
            endInfo.setId(endInfo.getId() + "." + field.getEndDateFieldKey());
        }
        endInfo.setType(dataType);
        endInfo.setTypeCaption(dataTypeCaption);
        endInfo.setVisible(true);
        Ctx ctxEnd = new Ctx(this._formMeta, (Field<?>)field, fieldAp, endInfo, this._formId, this._parentKey);
        this.applyOptionHandle(ctxEnd);
        this.applyInfoHandle(ctxEnd);
        result.add(endInfo);
        return result;
    }

    private void applyOptionHandle(Ctx ctx) {
        Map<String, Object> customOption;
        if (!this._ignoreDefaultOptionHandle) {
            this.applyDefaultOptionHandle(ctx.getField(), ctx.getFieldAp(), ctx.getInfo());
        }
        if (this._optionCustomHandle != null && (customOption = this._optionCustomHandle.apply(ctx)) != null && !customOption.isEmpty()) {
            ctx.getInfo().getOption().putAll(customOption);
        }
    }

    private void applyDefaultOptionHandle(Field<?> field, FieldAp fieldAp, ShowColumnInfo info) {
        Map<String, Object> customOption = NcEntityTypeUtil.defaultOptionCustom(field, fieldAp);
        if (customOption != null && !customOption.isEmpty()) {
            info.getOption().putAll(customOption);
        }
    }

    private boolean ignoreField(Field<?> field) {
        String[] split;
        if (field == null) {
            return true;
        }
        FieldType fieldType = this.getFieldType(field);
        if (fieldType == null) {
            return false;
        }
        if (WfConsts.WfLockStatusEnum.LOCK_STATUS_KEY.equalsIgnoreCase(field.getKey())) {
            return true;
        }
        if (this._ignoreFieldTypes.contains((Object)fieldType)) {
            return true;
        }
        if (field instanceof INoCodeRefBillField && !NcEntityTypeUtil.isFormExist(((INoCodeRefBillField)field).getBillEntityId())) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)this._selectFields) && !Arrays.stream(split = this._selectFields.split(",")).anyMatch(s -> s.equalsIgnoreCase(field.getKey()));
    }

    private FieldType getFieldType(Field<?> field) {
        if (StringUtils.isNotBlank((CharSequence)field.getParentId()) && !field.getParentId().equalsIgnoreCase(this._formId)) {
            return FieldType.EntryField;
        }
        if (field instanceof INoCodeCreateDateField) {
            return FieldType.NoCodeCreateDateField;
        }
        if (field instanceof INoCodeModifyDateField) {
            return FieldType.NoCodeModifyDateField;
        }
        if (field instanceof DateTimeField) {
            return FieldType.NoCodeDateField;
        }
        if (field instanceof DecimalField) {
            return FieldType.NoCodeDecimalField;
        }
        if (field instanceof IAttachmentField) {
            return FieldType.NoCodeAttachmentUploadField;
        }
        if (field instanceof IPictureField) {
            return FieldType.NoCodeImageUploadField;
        }
        if (field instanceof INoCodeRichTextField) {
            return FieldType.NoCodeRichTextField;
        }
        if (field instanceof INoCodeGraphicDisplayField) {
            return FieldType.NoCodeGraphicDisplayField;
        }
        if (field instanceof INoCodeAddressFormatField) {
            return FieldType.NoCodeAddressFormatField;
        }
        if (field instanceof TextField) {
            return FieldType.NoCodeTextField;
        }
        if (field instanceof INoCodeModifierField) {
            return FieldType.NoCodeModifierField;
        }
        if (field instanceof INoCodeCreatorField) {
            return FieldType.NoCodeCreatorField;
        }
        if (field instanceof BillNoField) {
            return FieldType.NoCodeBillNoField;
        }
        if (field instanceof ComboField) {
            return FieldType.NoCodeSelectItemField;
        }
        if (field instanceof INoCodeRefBillField) {
            if (((INoCodeRefBillField)field).isMultiSelect()) {
                return FieldType.NoCodeMulRefBillField;
            }
            return FieldType.NoCodeRefBillField;
        }
        return null;
    }

    private ShowColumnInfo genGroup(ContainerAp<?> groupAp) {
        ShowColumnInfo info = new ShowColumnInfo();
        info.setId(groupAp.getKey());
        info.setCaption(groupAp.getName().toString());
        info.setType("group");
        info.setTypeCaption(NcEntityTypeUtil.getDataTypeGroupCap());
        info.setVisible(true);
        ArrayList childColumns = new ArrayList(10);
        info.getOption().put("children", childColumns);
        info.getOption().put(Feature.GroupContainer.toString(), true);
        return info;
    }

    private void applyInfoHandle(Ctx ctx) {
        if (!this._ignoreDefaultInfoHandle) {
            this.applyDefaultInfoHandle(ctx);
        }
        if (this._infoCustomHandle != null) {
            this._infoCustomHandle.accept(ctx);
        }
    }

    private void applyDefaultInfoHandle(Ctx ctx) {
        if (this._level > 1 && ctx.getField() instanceof INoCodeRefBillField) {
            boolean isNeedExp;
            INoCodeRefBillField refBillField = (INoCodeRefBillField)ctx.getField();
            if (this.getRootFormId().equalsIgnoreCase(refBillField.getBillEntityId())) {
                ctx.getInfo().getOption().put("refSelf", true);
                return;
            }
            String showType = refBillField.getShowType();
            if (("1".equals(showType) || StringUtils.isNotBlank((CharSequence)ctx.getParentKey())) && "2".equals(showType)) {
                ctx.getInfo().getOption().put("sourceForm", "2");
            }
            boolean bl = isNeedExp = ctx.getParentKey() == null || ctx.getParentKey().split("\\.").length < this._level;
            if (isNeedExp && (!refBillField.isMultiSelect() || this.expMulRefBill())) {
                String theParentKey = ctx.getParentKey() == null ? refBillField.getKey() : ctx.getParentKey() + "." + refBillField.getKey();
                List<ShowColumnInfo> refColumns = this.buildRefBillFieldTree(refBillField.getBillEntityId(), theParentKey);
                for (ShowColumnInfo refColumn : refColumns) {
                    this.setIdWithParentKey(refColumn, theParentKey);
                }
                ctx.getInfo().getOption().put("children", refColumns);
            }
        }
    }

    private void applyDefaultInfoHandle(ShowColumnInfo info, String parentKey) {
        if (this._ignoreDefaultInfoHandle) {
            return;
        }
        if (this._level > 1 && NcEntityTypeUtil.isRefBill(info.getType())) {
            boolean isNeedExp;
            String subRefBillEntityId = (String)info.getOption().get("billEntityId");
            if (StringUtils.isBlank((CharSequence)subRefBillEntityId)) {
                return;
            }
            if (this.getRootFormId().equalsIgnoreCase(subRefBillEntityId)) {
                info.getOption().put("refSelf", true);
                return;
            }
            boolean bl = isNeedExp = parentKey == null || parentKey.split("\\.").length < this._level;
            if (isNeedExp && !NcEntityTypeUtil.isMultiRefBill(info.getType(), info.getOption())) {
                String theParentKey = parentKey == null ? info.getId() : parentKey + "." + info.getId();
                List<ShowColumnInfo> refColumns = this.buildRefBillFieldTree(subRefBillEntityId, theParentKey);
                for (ShowColumnInfo refColumn : refColumns) {
                    this.setIdWithParentKey(refColumn, theParentKey);
                }
                info.getOption().put("children", refColumns);
            }
        }
    }

    private void setIdWithParentKey(ShowColumnInfo column, String parentKey) {
        List refColumns;
        Object optionChildren;
        if (column.getId().startsWith(parentKey)) {
            return;
        }
        String subParentKey = parentKey + "." + column.getId();
        column.setId(subParentKey);
        if ("group".equalsIgnoreCase(column.getType())) {
            subParentKey = parentKey;
        }
        if ((optionChildren = column.getOption().get("children")) instanceof List && (refColumns = (List)optionChildren) != null && !refColumns.isEmpty()) {
            for (ShowColumnInfo refColumn : refColumns) {
                this.setIdWithParentKey(refColumn, subParentKey);
            }
        }
    }

    private List<ShowColumnInfo> buildRefBillFieldTree(String refBillFormId, String parentKey) {
        if (NcEntityTypeUtil.isRefBillOfUser(refBillFormId)) {
            return this.buildUserInfo();
        }
        if (NcEntityTypeUtil.isRefBillOfOrg(refBillFormId)) {
            return this.buildOrgInfo();
        }
        if (this.expMulRefBill()) {
            return this.buildRefBillFieldTreeByDesignTime(refBillFormId, parentKey);
        }
        List<ShowColumnInfo> refBillFieldTreeByRunTime = this.getRefBillFieldTreeByRunTime(refBillFormId, parentKey);
        if (refBillFieldTreeByRunTime.isEmpty()) {
            return this.buildRefBillFieldTreeByDesignTime(refBillFormId, parentKey);
        }
        return refBillFieldTreeByRunTime;
    }

    private List<ShowColumnInfo> buildRefBillFieldTreeByDesignTime(String refBillFormId, String parentKey) {
        FieldTreeBuilder fieldTreeBuilder = new FieldTreeBuilder(refBillFormId);
        List<ShowColumnInfo> showColumns = fieldTreeBuilder.withFeature(this._features).withRootFormId(this.getRootFormId()).withoutFieldTypes(this._ignoreFieldTypes).withCustomInfo(refCtx -> {
            Ctx theCtx = new Ctx(((Ctx)refCtx).formMeta, refCtx.getField(), refCtx.getFieldAp(), refCtx.getInfo(), refCtx.getFormId(), parentKey);
            this.applyDefaultInfoHandle(theCtx);
        }, true, parentKey).withLevel(this._level).build();
        return showColumns;
    }

    private String getRootFormId() {
        return StringUtils.isBlank((CharSequence)this._rootFormId) ? this._formId : this._rootFormId;
    }

    private List<ShowColumnInfo> getRefBillFieldTreeByRunTime(String refBillFormId, String parentKey) {
        List<ShowColumnInfo> infosWithoutGroup;
        boolean isNeedExpSub;
        List<ShowColumnInfo> fieldTree = NcRuntimeMetaUtil.getFieldTree(refBillFormId);
        boolean bl = isNeedExpSub = parentKey.split("\\.").length + 1 < this._level;
        if (isNeedExpSub) {
            for (ShowColumnInfo info : fieldTree) {
                this.applyDefaultInfoHandle(info, parentKey);
            }
        }
        if (fieldTree.isEmpty()) {
            return fieldTree;
        }
        if (!this.includePk()) {
            this.removeExcludeFeature_NoGroup(fieldTree, Feature.IncludePK);
        }
        if (!this.includeAttachmentDetail()) {
            this.removeExcludeFeature_NoGroup(fieldTree, Feature.AttachmentDetail);
        }
        if (!this.includeGroupContainer() && !(infosWithoutGroup = this.removeExcludeFeature_Group(fieldTree, null)).isEmpty()) {
            fieldTree.addAll(infosWithoutGroup);
        }
        return fieldTree;
    }

    private List<ShowColumnInfo> removeExcludeFeature_Group(List<ShowColumnInfo> fieldTree, ShowColumnInfo parentGroupInfo) {
        List groupInfos = fieldTree.stream().filter(t -> this.includeFeature((ShowColumnInfo)t, Feature.GroupContainer)).collect(Collectors.toList());
        List infos = fieldTree.stream().filter(t -> !this.includeFeature((ShowColumnInfo)t, Feature.GroupContainer)).collect(Collectors.toList());
        ArrayList<ShowColumnInfo> infosWithoutGroup = new ArrayList<ShowColumnInfo>(10);
        if (groupInfos.isEmpty() && parentGroupInfo != null) {
            infosWithoutGroup.addAll(fieldTree);
        } else {
            infosWithoutGroup.addAll(infos);
            for (ShowColumnInfo groupInfo : groupInfos) {
                List childen = (List)groupInfo.getOption().get("children");
                if (childen == null || childen.isEmpty()) continue;
                List<ShowColumnInfo> columnInfos = this.removeExcludeFeature_Group(childen, groupInfo);
                infosWithoutGroup.addAll(columnInfos);
            }
            fieldTree.removeIf(t -> this.includeFeature((ShowColumnInfo)t, Feature.GroupContainer));
        }
        return infosWithoutGroup;
    }

    private void removeExcludeFeature_NoGroup(List<ShowColumnInfo> fieldTree, Feature feature) {
        fieldTree.removeIf(t -> this.includeFeature((ShowColumnInfo)t, feature));
        for (ShowColumnInfo info : fieldTree) {
            List childen = (List)info.getOption().get("children");
            if (childen == null || childen.isEmpty()) continue;
            this.removeExcludeFeature_NoGroup(childen, feature);
        }
    }

    private boolean includeFeature(ShowColumnInfo info, Feature feature) {
        if (info == null || !info.getOption().containsKey(feature.toString())) {
            return false;
        }
        return (Boolean)info.getOption().getOrDefault(feature.toString(), Boolean.FALSE);
    }

    private String getDateType(Field<?> field) {
        if (this.useRealType()) {
            return field.getClass().getSimpleName();
        }
        return NcEntityTypeUtil.getDataType(field);
    }

    private boolean includeGroupContainer() {
        return this._features.contains((Object)Feature.GroupContainer);
    }

    private boolean includeAttachmentDetail() {
        return this._features.contains((Object)Feature.AttachmentDetail);
    }

    private boolean includePk() {
        return this._features.contains((Object)Feature.IncludePK);
    }

    private boolean useRealType() {
        return this._features.contains((Object)Feature.UseRealType);
    }

    private boolean expMulRefBill() {
        return this._features.contains((Object)Feature.ExpMulRefBill);
    }

    private FormMetadata convertTo(Map<String, Object> designerMetadata) {
        FormMetadataConverter formMetadataConverter = new FormMetadataConverter();
        return (FormMetadata)formMetadataConverter.convertTo(designerMetadata);
    }

    private FormMetadata getFormMeta(String formId) {
        Map designerMetadata = MetadataDao.loadDesignerMetadata((String)formId, (String)RequestContext.get().getLang().toString());
        if (designerMetadata == null || designerMetadata.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"FieldTreeBuilder_13", (String)"bos-nocode-common", (Object[])new Object[0]));
        }
        return this.convertTo(designerMetadata);
    }

    public static interface IFormMetaLoader {
        public FormMetadata load(String var1);
    }

    public static class Ctx {
        private FormMetadata formMeta;
        private Field<?> field;
        private FieldAp fieldAp;
        private ShowColumnInfo info;
        private String formId;
        private String parentKey;

        public Ctx(FormMetadata formMeta, Field<?> field, FieldAp fieldAp, ShowColumnInfo info, String formId, String parentKey) {
            this.formMeta = formMeta;
            this.field = field;
            this.fieldAp = fieldAp;
            this.info = info;
            this.formId = formId;
            this.parentKey = parentKey;
        }

        public FormMetadata getFormMeta() {
            return this.formMeta;
        }

        public Field<?> getField() {
            return this.field;
        }

        public ShowColumnInfo getInfo() {
            return this.info;
        }

        public String getFormId() {
            return this.formId;
        }

        public String getParentKey() {
            return this.parentKey;
        }

        public FieldAp getFieldAp() {
            return this.fieldAp;
        }
    }

    public static enum FieldType {
        NoCodeTextField,
        NoCodeDateField,
        NoCodeDecimalField,
        NoCodeRefBillField,
        NoCodeMulRefBillField,
        NoCodeSelectItemField,
        NoCodeAttachmentUploadField,
        NoCodeImageUploadField,
        NoCodeBillNoField,
        NoCodeCreatorField,
        NoCodeCreateDateField,
        NoCodeModifierField,
        NoCodeModifyDateField,
        NoCodeAddressFormatField,
        NoCodeRichTextField,
        NoCodeGraphicDisplayField,
        EntryField;

    }

    public static enum Feature {
        GroupContainer,
        AttachmentDetail,
        IncludePK,
        ExpMulRefBill,
        UseRealType;

    }
}

