/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.id.ID;
import kd.bos.lang.Lang;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;

public class FormMetaUtil {
    private static final String BOS_DEVP_METADATAUNIT = "bos_devp_metadataunit";
    private static final String PROP_NUMBER = "number";
    private static final String PROP_NAME = "name";
    private static final String BIZAPP = "bizapp";
    private static final String REGION_KEY = "nocode-formmetautil";
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("nocode-formmetautil", new DistributeCacheHAPolicy());
    private static final String SQL_MENU_COUNT_IN_NOCODE_CLOUND = " SELECT count(M.FID) FROM t_meta_menuruntime M INNER JOIN t_meta_bizapp A ON M.fappid = A.fid \n WHERE A.FBIZCLOUDID='2HGKCE94QELW' AND A.fvisible = '1' AND M.fformid is not null AND M.fformid <> ' '";
    private static final String SQL_ALL_FORMID_IN_NOCODE_CLOUND = " SELECT M.FFORMID FROM t_meta_menuruntime M INNER JOIN t_meta_bizapp A ON M.fappid = A.fid \n WHERE A.FBIZCLOUDID='2HGKCE94QELW' AND A.fvisible = '1' AND M.fformid is not null";
    private static final int MAX_MENU_COUNT = 10000;
    private static final String CACHE_KEY_MENUS_COUNT = "NoCode-Menus-Count";
    private static final int CACHE_KEY_MENUS_TIMEOUT = 60;
    private static final String BAS_APPSTARTED = "bas_appstarted";
    private static final String ENTITY_META = "bos_entitymeta";
    private static final String ID = "id";
    private static final String baseService_bizAppID = "83bfebc8000037ac";

    private FormMetaUtil() {
    }

    public static String getAppIdByFormId(String formId) {
        return (String)ThreadCache.get((Object)("nc.AppIdByFormId." + formId), () -> {
            if (NcEntityTypeUtil.isRefBillOfUser(formId) || NcEntityTypeUtil.isRefBillOfOrg(formId)) {
                return baseService_bizAppID;
            }
            if (formId.startsWith("bos_nocode_") || formId.startsWith("bos_nc_")) {
                return "2HGKTA7HH43C";
            }
            String realBillEntityId = NcEntityTypeUtil.getRealBillEntityId(formId);
            Map map = BusinessDataServiceHelper.loadFromCache((String)"bos_formmeta", (String)"id,bizappid", (QFilter[])new QFilter(ID, "=", (Object)realBillEntityId).toArray());
            if (Objects.isNull(map) || map.isEmpty()) {
                throw new RestApiException(ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"FormMetaUtil_0", (String)"bos-nocode-common", (Object[])new Object[0]));
            }
            DynamicObject tplInfo = (DynamicObject)new ArrayList(map.values()).get(0);
            return tplInfo.getString("bizappid");
        });
    }

    public static String getAppIdByFormNumber(String entityNumber) {
        return (String)ThreadCache.get((Object)("nc.AppIdByFormNumber." + entityNumber), () -> {
            if (NcEntityTypeUtil.isRefBillOfUser(entityNumber) || NcEntityTypeUtil.isRefBillOfOrg(entityNumber)) {
                return baseService_bizAppID;
            }
            if (entityNumber.startsWith("bos_nocode_") || entityNumber.startsWith("bos_nc_")) {
                return "2HGKTA7HH43C";
            }
            DynamicObject formMeta = BusinessDataServiceHelper.loadSingle((String)"bos_formmeta", (String)"id,bizappid", (QFilter[])new QFilter(PROP_NUMBER, "=", (Object)entityNumber).toArray());
            if (Objects.isNull(formMeta)) {
                throw new RestApiException(ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664", (String)"FormMetaUtil_0", (String)"bos-nocode-common", (Object[])new Object[0]));
            }
            return formMeta.getString("bizappid");
        });
    }

    public static String getFormNumberById(String formId) {
        return MetadataDao.getNumberById((String)formId);
    }

    public static String getFormIdByNumber(String formNumber) {
        return MetadataDao.getIdByNumber((String)formNumber, (MetaCategory)MetaCategory.Form);
    }

    public static String genIdUrlFriendly() {
        return Long.toString(kd.bos.id.ID.genLongId());
    }

    public static AppMetadata createNewAppMeta(DynamicObject appObject) {
        HashMap<String, String> nameLocals = new HashMap<String, String>();
        nameLocals.put(Lang.zh_CN.name(), ResManager.loadKDString((String)"\u9996\u9875", (String)"FormMetaUtil_1", (String)"bos-nocode-common", (Object[])new Object[0]));
        nameLocals.put(Lang.zh_TW.name(), ResManager.loadKDString((String)"\u9996\u9801", (String)"FormMetaUtil_2", (String)"bos-nocode-common", (Object[])new Object[0]));
        nameLocals.put(Lang.en_US.name(), "Home");
        LocaleString name = LocaleString.fromMap(nameLocals);
        DynamicObject unitObject = BusinessDataServiceHelper.newDynamicObject((String)BOS_DEVP_METADATAUNIT);
        unitObject.set("seq", (Object)1);
        unitObject.set(PROP_NUMBER, (Object)"MainPage");
        unitObject.set(PROP_NAME, (Object)name);
        unitObject.set("isleaf", (Object)0);
        unitObject.set(BIZAPP, appObject.get(ID));
        unitObject.set("parentunit", (Object)" ");
        unitObject.set("parentunitid", (Object)" ");
        unitObject.set("type", (Object)"1");
        DynamicObject[] objects = new DynamicObject[]{appObject, unitObject};
        return AppMetaServiceHelper.convertDynamicObjectsToAppMetadata((DynamicObject[])objects);
    }

    public static String checkMenuCount() {
        String ncp = System.getProperty("env.type.ncp", "false");
        if (Boolean.parseBoolean(ncp)) {
            return null;
        }
        String sMenusCount = (String)cache.get(CACHE_KEY_MENUS_COUNT);
        int menuCountInNoCodeCloud = 0;
        if (StringUtils.isNotBlank((CharSequence)sMenusCount)) {
            menuCountInNoCodeCloud = Integer.parseInt(sMenusCount);
        } else {
            menuCountInNoCodeCloud = FormMetaUtil.getMenuCountInNoCodeCloud();
            cache.put(CACHE_KEY_MENUS_COUNT, (Object)String.valueOf(menuCountInNoCodeCloud), 60);
        }
        if (menuCountInNoCodeCloud >= 10000) {
            return ResManager.loadKDString((String)"\u8868\u5355\u6570\u91cf\u5df2\u8fbe\u5230\u4e0a\u9650\uff0c\u65e0\u6cd5\u521b\u5efa", (String)"FormMetaUtil_3", (String)"bos-nocode-common", (Object[])new Object[0]);
        }
        return null;
    }

    public static int getMenuCountInNoCodeCloud() {
        try (EntityTraceSpan span = EntityTracer.create((String)"span-nocode", (String)"getMenuCountInNoCodeCloud");){
            int n = (Integer)DB.query((DBRoute)DBRoute.meta, (String)SQL_MENU_COUNT_IN_NOCODE_CLOUND, null, resultSet -> {
                if (resultSet.next()) {
                    return resultSet.getInt(1);
                }
                return 0;
            });
            return n;
        }
    }

    public static List<String> getAllFormIds() {
        ArrayList<String> formIds = new ArrayList<String>(1024);
        try (EntityTraceSpan span = EntityTracer.create((String)"span-nocode", (String)"getMenuCountInNoCodeCloud");){
            DB.query((DBRoute)DBRoute.meta, (String)SQL_ALL_FORMID_IN_NOCODE_CLOUND, null, resultSet -> {
                while (resultSet.next()) {
                    String formId = resultSet.getString(1);
                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)formId)) continue;
                    formIds.add(formId);
                }
                return formIds;
            });
        }
        return formIds;
    }

    public static String getRealFormIdExcludeAppId(String formId) {
        return formId.contains(",") ? formId.split(",")[1] : formId;
    }

    public static Set<String> getAllEntityNumbersByAppId(String appId) {
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)ENTITY_META, (String)PROP_NUMBER, (QFilter[])new QFilter(BIZAPP, "=", (Object)appId).toArray());
        return dynamicObjects.stream().map(e -> e.getString(PROP_NUMBER)).collect(Collectors.toSet());
    }

    public static Set<String> getMenuFormIdsByAppId(String appId) {
        return FormMetaUtil.getValidMenusByAppId(appId).stream().map(AppMenuInfo::getFormId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    public static List<AppMenuInfo> getValidMenusByAppId(String appId) {
        List appMenus = AppMetadataCache.getAppMenusInfoByAppId((String)appId);
        Set menuFormIds = appMenus.stream().filter(menu -> !BAS_APPSTARTED.equalsIgnoreCase(menu.getEntityNumber())).map(AppMenuInfo::getFormId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)ENTITY_META, (QFilter[])new QFilter(ID, "in", menuFormIds).toArray(), (String)ID, (int)(menuFormIds.size() + 1));
        Set validFormIds = pkIds.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toSet());
        return appMenus.stream().filter(menu -> !BAS_APPSTARTED.equalsIgnoreCase(menu.getEntityNumber())).filter(menu -> StringUtils.isBlank((CharSequence)menu.getFormId()) || validFormIds.contains(menu.getFormId())).collect(Collectors.toList());
    }

    public static String getValidFormName(String name) {
        return (name = StringUtil.cleanXSSParam(name)).length() > 50 ? name.substring(0, 47) + "..." : name;
    }
}

