/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.function.FunctionGroup;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;

public class FuncUtil {
    private static FunctionTypes allBillFunctionTypes = null;
    private static final Map<String, String[]> _FuncWhileList = new HashMap<String, String[]>(4);
    private static final String NOCODE_FUNC_XML_FILE = "/NoCodeFuncTypes_nocode.xml";
    public static final Set<String> DATETIME_FUNCTIONS;
    public static final String HAS_DATE_FUNC_OR_STR;
    public static final String HAS_DATE_FUNC_PATTERN_STR;
    public static final Pattern HAS_DATE_FUNC_PATTERN;

    public static synchronized FunctionTypes getNoCodeFunctionType() {
        if (allBillFunctionTypes == null) {
            FunctionTypes functionTypes = FunctionTypes.get();
            allBillFunctionTypes = new FunctionTypes();
            allBillFunctionTypes.getFunctionGroups().addAll(functionTypes.getFunctionGroups());
            allBillFunctionTypes.getFunctionTypes().addAll(functionTypes.getFunctionTypes());
            allBillFunctionTypes.getFunctionGroups().removeIf(f -> !_FuncWhileList.containsKey(f.getId()));
            FunctionTypes nocodeFunc = FuncUtil.loadNoCodeFunctionFromXml();
            if (nocodeFunc != null) {
                allBillFunctionTypes.getFunctionGroups().addAll(nocodeFunc.getFunctionGroups());
                allBillFunctionTypes.getFunctionTypes().addAll(nocodeFunc.getFunctionTypes());
            }
            allBillFunctionTypes.getFunctionGroups().sort(Comparator.comparingInt(FunctionGroup::getSeq));
            allBillFunctionTypes.getFunctionTypes().removeIf(f -> !_FuncWhileList.containsKey(f.getGroupId()));
            allBillFunctionTypes.getFunctionTypes().removeIf(f -> StringUtils.isNotBlank((CharSequence)f.getSettingFormId()) && !"DateTime".equals(f.getGroupId()));
            allBillFunctionTypes.getFunctionTypes().sort(Comparator.comparingInt(FunctionType::getSeq));
        }
        return allBillFunctionTypes;
    }

    public static FunctionManage getNoCodeFuncLib() {
        FunctionTypes functionTypes = FuncUtil.getNoCodeFunctionType();
        return FunctionManage.get((FunctionTypes)functionTypes);
    }

    private static FunctionTypes loadNoCodeFunctionFromXml() {
        URL url = FunctionTypes.class.getResource(NOCODE_FUNC_XML_FILE);
        return FunctionTypes.get((URL)url, (boolean)false);
    }

    static {
        _FuncWhileList.put("Math", new String[]{"ROUND", "ROUNDUP", "ROUNDDOWN", "ABS", "INT", "NUMBER", "NUMBERSTRING", "RemoveTailZero"});
        _FuncWhileList.put("ncp-math", new String[]{"*"});
        _FuncWhileList.put("String", new String[]{"STRING", "LEFT", "RIGHT", "SUBSTRING", "REPT", "TRIM", "LOWER", "UPPER", "FIND", "CONCAT", "SUBSTITUTE", "REPLACE", "LEN"});
        _FuncWhileList.put("DateTime", new String[]{"NOW", "TO_DATE", "DATE", "YMDDATE", "YEAR", "MONTH", "WEEK", "DAY", "QUARTER", "DATEDIF", "DATEADD", "TO_CHAR"});
        _FuncWhileList.put("ncp-adv", new String[]{"*"});
        DATETIME_FUNCTIONS = new HashSet<String>(Arrays.asList("TO_DATE", "DATE", "YEAR", "MONTH", "WEEK", "DAY", "QUARTER", "DATEDIF", "DATEADD", "TO_CHAR"));
        HAS_DATE_FUNC_OR_STR = "(" + String.join((CharSequence)"|", DATETIME_FUNCTIONS) + ")";
        HAS_DATE_FUNC_PATTERN_STR = HAS_DATE_FUNC_OR_STR + "\\(.*?\\)";
        HAS_DATE_FUNC_PATTERN = Pattern.compile(HAS_DATE_FUNC_PATTERN_STR);
    }
}

