/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import kd.bos.nocode.constant.WfConsts;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsonVarHelper {
    private static final String JSON_VAR_PREFIX = "${jsonVar.";
    private static final String PROC_VAR_PREFIX = "${proc.";
    private static final String KEY_VALUE_DELIMITER = "#keyValueDelimiter#";
    private static final String GROUP_DELIMITER = "#groupDelimiter#";

    public static String replaceProcVar2JsonVar(@NotNull String source) {
        Objects.requireNonNull(source, "source cannot be null.");
        return source.replace(PROC_VAR_PREFIX, JSON_VAR_PREFIX);
    }

    public static String extractJsonVar(String source) {
        Matcher m = WfConsts.varProcPattern.matcher(source);
        StringJoiner stringJoiner = new StringJoiner(GROUP_DELIMITER);
        HashSet<String> existedProcVarSet = new HashSet<String>(32);
        while (m.find()) {
            String procVar = m.group();
            if (existedProcVarSet.contains(procVar)) continue;
            existedProcVarSet.add(procVar);
            String jsonVar = procVar.replace(PROC_VAR_PREFIX, JSON_VAR_PREFIX);
            stringJoiner.add(jsonVar + KEY_VALUE_DELIMITER + procVar);
        }
        return stringJoiner.toString();
    }

    public static Map<String, String> parseJsonVar(@Nullable String jsonVar) {
        if (StringUtils.isBlank((CharSequence)jsonVar)) {
            return new HashMap<String, String>(0);
        }
        String[] groups = jsonVar.split(GROUP_DELIMITER);
        return Arrays.stream(groups).map(e -> e.split(KEY_VALUE_DELIMITER)).collect(Collectors.toMap(e -> e[0], e -> ((String[])e).length > 1 ? e[1] : ""));
    }
}

