/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.DBVersion;
import kd.bos.exception.KDException;
import kd.bos.nocode.utils.FormMetaUtil;
import kd.bos.nocode.utils.NcLocalCacheUtil;

public abstract class NcAppVersionUtil {
    private static final String APP_MAIN_VERSION = "001.";
    private static final String CACHETYPE_APP_VERSIONS = "CacheType_App_Versions";
    private static final String CACHE_KEY_ALL = "All";

    private NcAppVersionUtil() {
        throw new IllegalStateException("NcAppVersionUtil class");
    }

    public static String getAppVersion() {
        return APP_MAIN_VERSION + DBVersion.getVer();
    }

    public static int getNcVer(String version) {
        String[] split = version.split("\\.");
        if (split.length < 5) {
            return 0;
        }
        return Integer.parseInt(split[0]);
    }

    public static int compareNcVer(String version1, String version2) throws Exception {
        if (version1 == null || version2 == null) {
            throw new Exception("compareVersion error:illegal params.");
        }
        int ncVer1 = NcAppVersionUtil.getNcVer(version1);
        int ncVer2 = NcAppVersionUtil.getNcVer(version2);
        return ncVer1 - ncVer2;
    }

    public static int compareVersion(String version1, String version2) throws Exception {
        String[] versionArray2;
        if (version1 == null || version2 == null) {
            throw new Exception("compareVersion error:illegal params.");
        }
        String[] versionArray1 = version1.split("\\.");
        if (versionArray1.length != (versionArray2 = version2.split("\\.")).length) {
            return versionArray1.length - versionArray2.length;
        }
        int diff = 0;
        for (int idx = 0; idx < versionArray1.length && (diff = versionArray1[idx].length() - versionArray2[idx].length()) == 0 && (diff = versionArray1[idx].compareTo(versionArray2[idx])) == 0; ++idx) {
        }
        diff = diff != 0 ? diff : versionArray1.length - versionArray2.length;
        return diff;
    }

    private static Map<String, String> getAllAppVersions() {
        return NcLocalCacheUtil.getOrCreate(CACHETYPE_APP_VERSIONS, CACHE_KEY_ALL, key -> {
            String sql = "select FID,FVERSION from T_META_BIZAPP where fbizcloudId='2HGKCE94QELW'";
            ResultSetHandler action = rs -> {
                HashMap<String, String> map = new HashMap<String, String>(16);
                while (rs.next()) {
                    map.put(rs.getString("FID"), rs.getString("FVERSION"));
                }
                return map;
            };
            return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)action);
        });
    }

    private static String getAppVersion(String appId) {
        Map<String, String> allAppVersions = NcAppVersionUtil.getAllAppVersions();
        if (allAppVersions.isEmpty() || !allAppVersions.containsKey(appId)) {
            NcLocalCacheUtil.removeCacheByKey(CACHETYPE_APP_VERSIONS, CACHE_KEY_ALL);
            allAppVersions = NcAppVersionUtil.getAllAppVersions();
        }
        return allAppVersions.get(appId);
    }

    public static boolean isEnableSoftDeleteByApp(String appId) {
        return NcAppVersionUtil.isEnableNcRuntimeMetaByApp(appId);
    }

    public static boolean isEnableSoftDeleteByForm(String formId) {
        try {
            String appId = FormMetaUtil.getAppIdByFormId(formId);
            return NcAppVersionUtil.isEnableSoftDeleteByApp(appId);
        }
        catch (KDException ex) {
            return false;
        }
    }

    public static boolean isEnableNcRuntimeMetaByApp(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            return false;
        }
        String appVersion = NcAppVersionUtil.getAppVersion(appId);
        if (StringUtils.isBlank((CharSequence)appVersion)) {
            return false;
        }
        return NcAppVersionUtil.getNcVer(appVersion) > 0;
    }

    public static boolean isEnableNcRuntimeMetaByForm(String formId) {
        try {
            String appId = FormMetaUtil.getAppIdByFormId(formId);
            return NcAppVersionUtil.isEnableNcRuntimeMetaByApp(appId);
        }
        catch (KDException ex) {
            return false;
        }
    }
}

