/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SingleOrgContextHelper;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.UserProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.qing.AnalysisField;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.converter.FormMetadataConverter;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.mservice.svc.attach.IAttachmentField;
import kd.bos.mservice.svc.attach.IAttachmentProp;
import kd.bos.mservice.svc.picture.IPictureField;
import kd.bos.mservice.svc.picture.IPictureProp;
import kd.bos.nocode.NoCodeRuntimeService;
import kd.bos.nocode.metadata.ICustomOption4FieldTree;
import kd.bos.nocode.metadata.IDateFormatSupport;
import kd.bos.nocode.metadata.INoCodeAttachmentUploadField;
import kd.bos.nocode.metadata.INoCodeComboField;
import kd.bos.nocode.metadata.INoCodeOrgField;
import kd.bos.nocode.metadata.INoCodeRefBillField;
import kd.bos.nocode.metadata.INoCodeUserField;
import kd.bos.nocode.property.INoCodeAttachmentProp;
import kd.bos.nocode.property.INoCodeComboProp;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.property.INoCodeUserProp;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.utils.NcRuntimeMetaUtil;
import kd.bos.nocode.utils.NoCodeAppUtils;
import kd.bos.nocode.utils.NoCodeTreeNode;
import kd.bos.nocode.utils.ShowColumnInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import org.jetbrains.annotations.NotNull;

public abstract class NcEntityTypeUtil {
    public static final String NUMBER = "number";
    private static final String TYPE_FORMAT = "[%s]";
    private static final String API_PREFIX = "API";
    private static final Log log = LogFactory.getLog(NcEntityTypeUtil.class);
    public static final String BOS_USER_ID = "68bde9ca00000eac";
    public static final String BOS_USER_NUMBER = "bos_user";
    public static final String BOS_USER_PROPS_DISPLAY = "name,number,gender,phone,email";
    public static final String BOS_ADMIN_ORG_ID = "PKJP6FA0=V1";
    public static final String BOS_ADMIN_ORG_NUMBER = "bos_adminorg";
    public static final String BOS_ADMIN_ORG_PROPS_DISPLAY = "name,number";
    private static final String TAB = "tab";
    private static final String TAB_CURRENT_APP = "currentApp";
    private static final String TAB_OTHER_APP = "otherApp";
    private static final String TAB_PARSE_BY_DATA = "parseByData";
    private static final String BIZ_APPID = "bizappid";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String LABEL = "label";
    private static final String CHILDREN = "children";
    private static final String BOS_DEVPN_FORMMETA = "bos_devpn_formmeta";
    private static final String BOS_FORMMETA = "bos_formmeta";
    public static final int NUMBER_OF_MAP = 10;
    public static final int MAX_FORM_NUMBER_LENGTH = 25;
    public static final int LIMIT_2 = 2;
    public static final String OPTION_REQUIRED = "required";
    public static final String OPTION_ISMULTI = "isMulti";
    public static final String OPTION_EDITORTYPE = "editorType";
    public static final String OPTION_DISPLAYPROP = "displayProp";
    public static final String OPTION_REFSELF = "refSelf";
    public static final String OPTION_ATTACHMENT_FILE_TYPE = "attachmentFileType";
    public static final String OPTION_CHILDREN = "children";
    public static final String OPTION_COMPARE_TYPES = "compareTypes";
    public static final String OPTION_IS_DESENSITIZE_FIELD = "isDesensitizeField";
    public static final String OPTION_IS_ENCRYPT_FIELD = "isEncryptField";
    public static final String OPTION_BILLENTITYID = "billEntityId";
    public static final String OPTION_FORMATTYPE = "formatType";
    public static final String OPTION_API = "api";
    public static final String OPTION_CAN_JUDGE = "canJudge";
    private static final String ITEMS = "Items";
    private static final String ENTITY_META = "entitymeta";
    private static final String FORM_META = "formmeta";
    private static final String TYPE = "_Type_";
    private static final String ID2 = "Id";
    private static final String NAME2 = "Name";
    private static final String KEY2 = "Key";
    private static final String FIELDTYPE = "FieldType";
    private static final String PARENT_ID = "ParentId";
    private static final String NOCODEGROUPCONTAINERAP = "NoCodeGroupContainerAp";
    private static final String NOCODEREFBILLTABLE = "NoCodeRefBillTable";
    private static final String NOCODEDATERANGEFIELD = "NoCodeDateRangeField";
    private static final String STARTDATEFIELDKEY = "StartDateFieldKey";
    private static final String ENDDATEFIELDKEY = "EndDateFieldKey";
    public static final String NOCODE_SYS_APP_ID = "2HGKTA7HH43C";
    private static final String DATA_TYPE_SEPARATOR_CHARS = "-";
    private static final String ROOT_ID = "root_id";
    private static final String SQL_RECORD_COUNT = "SELECT count(*) FROM %s";
    private static final int MAX_RECORD_COUNT = 100000;
    private static final String CACHE_KEY_PREFIX_MAX_RECORD_COUNT = "NoCode-Max-record-";
    private static final int CACHE_KEY_RECORD_TIMEOUT = 60;
    private static final String REGION_KEY = "nocode-NcEntityTypeUtil";
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("nocode-NcEntityTypeUtil", new DistributeCacheHAPolicy());
    public static final String RULE_ERROR_CODE_DATE_RANGE = "5001";
    private static final Map<Class<?>, String> MAPPING_DICT_DATA_TYPE = new HashMap();
    private static final Map<Class<?>, String> MAPPING_DICT_DATA_TYPE_CAP = new HashMap();
    private static final Map<String, Object> MAPPING_DICT_DATA_TYPE_MOCK_DATA = new HashMap<String, Object>();
    public static final String DATA_TYPE_PK = "pk";
    public static final String DATA_TYPE_TEXT = "text";
    public static final String DATA_TYPE_TEXTAREA = "textarea";
    public static final String DATA_TYPE_NUMBER = "number";
    public static final String DATA_TYPE_DATE = "date";
    public static final String DATA_TYPE_REFBILL = "refbill";
    public static final String DATA_TYPE_GROUP = "group";
    public static final String DATA_TYPE_COMBO = "combo";
    public static final String DATA_TYPE_COMBO_PREFIX = "combo-";
    public static final String DATA_TYPE_IMAGE = "image";
    public static final String DATA_TYPE_ATTACHMENT = "attachment";
    public static final String DATA_TYPE_BOOL = "bool";
    public static final String DATA_TYPE_USER = "user";
    public static final String DATA_TYPE_ORG = "org";
    public static final String DATA_TYPE_UNKNOWN = "unknown";
    private static final Map<String, String> MAPPING_DICT_DISP_PROP = new HashMap<String, String>();
    private static final int MOCK_DATA_100000 = 100000;
    private static final long MOCK_DATA_REFBILL = 1657103146553574400L;
    public static final String MOCK_DATA_MULTI_REFBILL = "\"1657103146553574400\"";
    public static final String DATA_TYPE_MOCK_DATA_TEXT = "\"test\"";
    private static final String KEY_TITLE_FORMAT = "%s%s";

    public static String getRefBillMultiDesc() {
        return "[\u591a\u6761]";
    }

    public static String getRefBillSingleDesc() {
        return "[\u5355\u6761]";
    }

    public static String getComboMultiDesi() {
        return "[\u591a\u9009]";
    }

    public static String getComboSingleDesc() {
        return "[\u5355\u9009]";
    }

    public static String getBosUserName() {
        return "\u4eba\u5458";
    }

    public static String getBosAdminOrgNane() {
        return "\u7ec4\u7ec7";
    }

    private NcEntityTypeUtil() {
        throw new IllegalStateException("NcEntityTypeUtil class");
    }

    public static IDataEntityProperty findProperty(DynamicObjectType dt, String key) {
        if (dt.getName().equals(BOS_ADMIN_ORG_NUMBER) && "parent".equals(key)) {
            return null;
        }
        String[] keys = key.split("\\.", 2);
        IDataEntityProperty prop = (IDataEntityProperty)dt.getProperties().get((Object)keys[0]);
        if (keys.length > 1) {
            if (prop instanceof EntryProp) {
                return NcEntityTypeUtil.findProperty(((EntryProp)prop).getDynamicCollectionItemPropertyType(), keys[1]);
            }
            if (prop instanceof BasedataProp) {
                String basedataName = ((BasedataProp)prop).getComplexType().getName();
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)basedataName);
                return NcEntityTypeUtil.findProperty((DynamicObjectType)dataEntityType, keys[1]);
            }
            if (prop instanceof MulBasedataProp) {
                if ("fbasedataid".equalsIgnoreCase((keys = keys[1].split("\\.", 2))[0]) && keys.length > 1) {
                    String basedataName = ((MulBasedataProp)prop).getComplexType().getName();
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)basedataName);
                    return NcEntityTypeUtil.findProperty((DynamicObjectType)dataEntityType, keys[1]);
                }
            } else {
                if (prop instanceof INoCodeRefBillProp) {
                    return ((INoCodeRefBillProp)prop).findProperty(keys[1]);
                }
                return prop;
            }
        }
        return prop;
    }

    public static boolean existProperty(DynamicObjectType dt, String key) {
        IDataEntityProperty property = NcEntityTypeUtil.findProperty(dt, key);
        return Objects.nonNull(property);
    }

    public static List<AnalysisField> getAnalysisField(IDataEntityType dataEntityType) {
        ArrayList<AnalysisField> filterFields = new ArrayList<AnalysisField>();
        MainEntityType mainType = (MainEntityType)dataEntityType;
        for (IDataEntityProperty fieldProp : mainType.getAllFields().values()) {
            if (!(fieldProp instanceof IFieldHandle) || SingleOrgContextHelper.isFieldNeedHide((IDataEntityProperty)fieldProp)) continue;
            List list = ((IFieldHandle)fieldProp).createAnalysisFields(mainType);
            filterFields.addAll(list);
        }
        return filterFields;
    }

    public static BillEntityType getMainEntityType(String formId) {
        return (BillEntityType)ThreadCache.get((Object)("nc.MainEntityType." + formId), () -> {
            String newformNumber;
            if (StringUtils.isBlank((CharSequence)formId)) {
                return null;
            }
            String formNumber = NcEntityTypeUtil.getRealBillEntityId(formId);
            boolean isNum = StringUtils.isNumeric((CharSequence)formNumber);
            if (!isNum && StringUtils.isNotBlank((CharSequence)(newformNumber = MetadataDao.getNumberById((String)formNumber)))) {
                formNumber = newformNumber;
            }
            try {
                return (BillEntityType)EntityMetadataCache.getDataEntityType((String)formNumber);
            }
            catch (Exception ex) {
                log.warn((Throwable)ex);
                return null;
            }
        });
    }

    public static Map<String, Object> defaultOptionCustom(IDataEntityProperty property) {
        HashMap<String, Object> option = new HashMap<String, Object>();
        if (property instanceof FieldProp && ((FieldProp)property).isMustInput()) {
            option.put(OPTION_REQUIRED, true);
        }
        if (PrivacyCenterUtils.isDesensitizeField((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"LIST")) {
            option.put(OPTION_IS_DESENSITIZE_FIELD, true);
        } else if (PrivacyCenterUtils.isEncryptField((IDataEntityProperty)property)) {
            option.put(OPTION_IS_ENCRYPT_FIELD, true);
        }
        if (property instanceof IDateFormatSupport) {
            IDateFormatSupport datetimeProp = (IDateFormatSupport)property;
            option.put(OPTION_FORMATTYPE, datetimeProp.getFormatType());
        }
        if (property instanceof INoCodeRefBillProp) {
            INoCodeRefBillProp refBillProp = (INoCodeRefBillProp)property;
            option.put(OPTION_BILLENTITYID, refBillProp.getBillEntityId());
            option.put(OPTION_ISMULTI, refBillProp.isMultiSelect());
            option.put(OPTION_DISPLAYPROP, refBillProp.getPropsDisplay());
        } else if (property instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)property;
            option.put(OPTION_BILLENTITYID, basedataProp.getBaseEntityId());
            option.put(OPTION_DISPLAYPROP, basedataProp.getDisplayProp());
        } else if (property instanceof INoCodeComboProp) {
            INoCodeComboProp comboProp = (INoCodeComboProp)property;
            option.put(OPTION_ISMULTI, comboProp.isMultiSelect());
            option.put("valueItems", ((ComboProp)property).getComboItems());
        } else if (property instanceof ComboProp) {
            option.put("valueItems", ((ComboProp)property).getComboItems());
        } else if (property instanceof INoCodeAttachmentProp) {
            HashMap<String, List<ValueMapItem>> fileTypeOption = new HashMap<String, List<ValueMapItem>>(2);
            fileTypeOption.put("valueItems", ((INoCodeAttachmentProp)property).getAttachmentTypeComboItems());
            option.put(OPTION_ATTACHMENT_FILE_TYPE, fileTypeOption);
        }
        NcEntityTypeUtil.setEditType(option, property);
        return option;
    }

    public static Map<String, Object> defaultOptionCustom(Field<?> field, FieldAp fieldAp) {
        Map<String, Object> customOption;
        HashMap<String, Object> option = new HashMap<String, Object>();
        if (field.isMustInput()) {
            option.put(OPTION_REQUIRED, true);
        }
        if (field instanceof IDateFormatSupport) {
            IDateFormatSupport datetimeProp = (IDateFormatSupport)field;
            option.put(OPTION_FORMATTYPE, datetimeProp.getFormatType());
        }
        if (field instanceof INoCodeRefBillField) {
            INoCodeRefBillField refBillField = (INoCodeRefBillField)field;
            option.put(OPTION_BILLENTITYID, refBillField.getBillEntityNumber());
            option.put(OPTION_ISMULTI, refBillField.isMultiSelect());
            option.put(OPTION_DISPLAYPROP, refBillField.getPropsDisplay());
        } else if (field instanceof BasedataField) {
            BasedataField basedataField = (BasedataField)field;
            option.put(OPTION_BILLENTITYID, basedataField.getBaseEntityId());
            option.put(OPTION_DISPLAYPROP, basedataField.getDisplayProp());
        } else if (field instanceof INoCodeComboField) {
            INoCodeComboField comboField = (INoCodeComboField)field;
            option.put(OPTION_ISMULTI, comboField.isMulti());
            option.put("valueItems", comboField.getComboItems());
        } else if (field instanceof ComboField) {
            option.put("valueItems", NcEntityTypeUtil.getComboItems((ComboField)field));
        } else if (field instanceof INoCodeAttachmentUploadField) {
            HashMap<String, List<ValueMapItem>> fileTypeOption = new HashMap<String, List<ValueMapItem>>(2);
            fileTypeOption.put("valueItems", ((INoCodeAttachmentUploadField)field).getAttachmentTypeComboItems());
            option.put(OPTION_ATTACHMENT_FILE_TYPE, fileTypeOption);
        }
        if (field instanceof ICustomOption4FieldTree && (customOption = ((ICustomOption4FieldTree)field).getCustomOption()) != null && !customOption.isEmpty()) {
            option.putAll(customOption);
        }
        if (fieldAp instanceof ICustomOption4FieldTree && (customOption = ((ICustomOption4FieldTree)fieldAp).getCustomOption()) != null && !customOption.isEmpty()) {
            option.putAll(customOption);
        }
        NcEntityTypeUtil.setEditType(option, field);
        return option;
    }

    private static List<ValueMapItem> getComboItems(ComboField comboField) {
        ArrayList<ValueMapItem> valueItems = new ArrayList<ValueMapItem>(10);
        for (ComboItem comboItem : comboField.getItems()) {
            ValueMapItem valueMapItem = new ValueMapItem(comboItem.getImageKey(), comboItem.getValue(), comboItem.getCaption(), comboItem.isItemVisible());
            valueItems.add(valueMapItem);
        }
        return valueItems;
    }

    private static void setEditType(Map<String, Object> option, IDataEntityProperty property) {
        try {
            Class<?> extEntityItemTypes = Class.forName("kd.bos.nocode.ext.ExtEntityItemTypes");
            Method getFieldType = extEntityItemTypes.getMethod("getFieldType", IDataEntityProperty.class);
            try {
                String ret = (String)getFieldType.invoke(null, property);
                if (StringUtils.isNotBlank((CharSequence)ret)) {
                    option.put(OPTION_EDITORTYPE, ret);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                log.warn((Throwable)e);
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            log.warn((Throwable)e);
        }
    }

    private static void setEditType(Map<String, Object> option, Field<?> field) {
        option.put(OPTION_EDITORTYPE, field.getClass().getSimpleName());
    }

    public static List<ShowColumnInfo> addAttachmentSubProps(List<ShowColumnInfo> showColumns, ShowColumnInfo info) {
        if (info != null && ("NoCodeAttachmentUploadField".equals(info.getType()) || DATA_TYPE_ATTACHMENT.equals(info.getType()))) {
            ArrayList<ShowColumnInfo> result = new ArrayList<ShowColumnInfo>(3);
            ShowColumnInfo sizeInfo = new ShowColumnInfo();
            sizeInfo.setId(info.getId() + ".fbasedataid.size");
            sizeInfo.setCaption(info.getCaption() + ".\u5927\u5c0f");
            sizeInfo.setVisible(true);
            sizeInfo.setType("NoCodeDecimalField");
            sizeInfo.setTypeCaption("[\u6570\u5b57]");
            sizeInfo.getOption().put(OPTION_EDITORTYPE, "NoCodeDecimalField");
            result.add(sizeInfo);
            ShowColumnInfo nameInfo = new ShowColumnInfo();
            nameInfo.setId(info.getId() + ".fbasedataid.name");
            nameInfo.setCaption(info.getCaption() + ".\u540d\u79f0");
            nameInfo.setVisible(true);
            nameInfo.setType("NoCodeTextField");
            nameInfo.setTypeCaption("[\u6587\u672c]");
            nameInfo.getOption().put(OPTION_EDITORTYPE, "NoCodeTextField");
            result.add(nameInfo);
            ShowColumnInfo extInfo = new ShowColumnInfo();
            extInfo.setId(info.getId() + ".fbasedataid.type");
            extInfo.setCaption(info.getCaption() + ".\u7c7b\u578b");
            extInfo.setVisible(true);
            extInfo.setType("NoCodeSelectItemField");
            extInfo.setTypeCaption(NcEntityTypeUtil.getDataTypeComboCap() + NcEntityTypeUtil.getComboSingleDesc());
            Map<String, Object> option = extInfo.getOption();
            option.put(OPTION_EDITORTYPE, "NoCodeSelectItemField");
            if (info.getOption().containsKey(OPTION_ATTACHMENT_FILE_TYPE)) {
                Map<String, Object> attachmentOption = info.getOption();
                Map attachmentFileTypeOption = (Map)attachmentOption.get(OPTION_ATTACHMENT_FILE_TYPE);
                option.putAll(attachmentFileTypeOption);
            }
            result.add(extInfo);
            showColumns.addAll(result);
            return result;
        }
        return Collections.emptyList();
    }

    public static List<Map<String, Object>> getFormClientItems(String formId) {
        formId = NcEntityTypeUtil.getRealBillEntityNumber(formId);
        ArrayList<Map<String, Object>> itemList = new ArrayList<Map<String, Object>>(10);
        MetadataService MetadataServiceImpl = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String metadata = MetadataServiceImpl.loadClientFormMeta(formId);
        if (StringUtils.isBlank((CharSequence)metadata)) {
            return itemList;
        }
        Map formMetaMap = (Map)SerializationUtils.fromJsonString((String)metadata, Map.class);
        List items = (List)formMetaMap.get("items");
        if (items != null && !items.isEmpty() && ((Map)items.get(0)).get("items") instanceof List) {
            itemList.addAll((List)((Map)items.get(0)).get("items"));
        }
        return itemList;
    }

    public static NoCodeTreeNode buildRefBillTreeData(String currentAppId, String parentId, String ignoreCosmicForm) {
        NoCodeTreeNode root = new NoCodeTreeNode("\u5168\u90e8", ROOT_ID, "", null);
        NoCodeTreeNode userNode = new NoCodeTreeNode(NcEntityTypeUtil.getBosUserName(), BOS_USER_NUMBER, ROOT_ID, null);
        NoCodeTreeNode orgNode = new NoCodeTreeNode(NcEntityTypeUtil.getBosAdminOrgNane(), BOS_ADMIN_ORG_NUMBER, ROOT_ID, null);
        root.addChild(userNode);
        root.addChild(orgNode);
        NoCodeTreeNode currentAppNode = NcEntityTypeUtil.getCurrentAppBill(currentAppId);
        currentAppNode.getCustomParams().put(TAB_CURRENT_APP, true);
        root.addChild(currentAppNode);
        NcEntityTypeUtil.getOtherAppBill(currentAppId, root);
        if (ignoreCosmicForm == null || "false".equals(ignoreCosmicForm)) {
            NoCodeTreeNode cosmicNode = new NoCodeTreeNode("\u82cd\u7a79\u8868\u5355", "cosmic_form", ROOT_ID, null);
            root.addChild(cosmicNode);
            NoCodeAppUtils.getCloudTree(null, null, null, true, true, true, cosmicNode);
            if (StringUtils.isNotBlank((CharSequence)parentId)) {
                List<NoCodeTreeNode> nodes = NcEntityTypeUtil.getCosmicRefBillTreeData(parentId);
                NoCodeTreeNode appNode = root.getTreeNode(parentId, 10);
                appNode.setChildren(nodes);
            }
        }
        return root;
    }

    public static List<NoCodeTreeNode> getCosmicRefBillTreeData(String appId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        JSONArray modelFilterContent = new JSONArray();
        modelFilterContent.add((Object)"BaseFormModel");
        modelFilterContent.add((Object)"BillFormModel");
        QFilter modelTypeFilter = new QFilter("modeltype", "in", (Object)modelFilterContent);
        filters.add(modelTypeFilter);
        List<String> blackList = NcEntityTypeUtil.getEntityIdBlacklist();
        if (!blackList.isEmpty()) {
            filters.add(new QFilter("number", "not in", blackList));
        }
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            filters.add(new QFilter(BIZ_APPID, "=", (Object)appId));
        }
        filters.add(new QFilter("dentityid", "is not null", (Object)""));
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bos_entityobject", (String)"dentityid,name", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        ArrayList<NoCodeTreeNode> nodes = new ArrayList<NoCodeTreeNode>(map.size());
        for (DynamicObject obj : map.values()) {
            String label = obj.get(NAME) == null ? null : obj.get(NAME).toString();
            String value = obj.get("dentityid") == null ? null : obj.get("dentityid").toString();
            NoCodeTreeNode row = new NoCodeTreeNode(label, value, appId, null);
            nodes.add(row);
        }
        return nodes;
    }

    private static List<String> getEntityIdBlacklist() {
        ProductSettingService service = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        List blackEntities = service.getFormBlackList();
        Map entityMap = RunModeServiceHelper.getAllEntityBlacklist();
        if (entityMap != null && !entityMap.isEmpty()) {
            blackEntities.addAll(entityMap.values());
        }
        return blackEntities;
    }

    private static NoCodeTreeNode getCurrentAppBill(String currentAppId) {
        List<QFilter> filters = NcEntityTypeUtil.getQFilters(currentAppId, TAB_CURRENT_APP);
        DynamicObjectCollection bills = QueryServiceHelper.query((String)BOS_DEVPN_FORMMETA, (String)"id, name", (QFilter[])filters.toArray(new QFilter[0]), (String)"bizappid.name asc, bizappid asc, name asc");
        NoCodeTreeNode currentAppNode = new NoCodeTreeNode("\u5f53\u524d\u5e94\u7528", currentAppId, ROOT_ID, null);
        currentAppNode.setSelectable(false);
        for (DynamicObject obj : bills) {
            NoCodeTreeNode child = NcEntityTypeUtil.buildTreeNode(obj, currentAppId);
            currentAppNode.addChild(child);
        }
        return currentAppNode;
    }

    public static DynamicObjectCollection getCurrentAppBills(String currentAppId) {
        List<QFilter> filters = NcEntityTypeUtil.getQFilters(currentAppId, TAB_CURRENT_APP);
        DynamicObjectCollection bills = QueryServiceHelper.query((String)BOS_DEVPN_FORMMETA, (String)"id, name", (QFilter[])filters.toArray(new QFilter[0]), (String)"bizappid.name asc, bizappid asc, name asc");
        return bills;
    }

    private static NoCodeTreeNode buildTreeNode(DynamicObject obj, String appId) {
        NoCodeTreeNode treeNode = new NoCodeTreeNode();
        treeNode.setLabel(obj.get(NAME) == null ? null : obj.get(NAME).toString());
        treeNode.setValue(obj.get(ID) == null ? null : obj.get(ID).toString());
        treeNode.setChildren(null);
        treeNode.setParentId(appId);
        return treeNode;
    }

    private static void getOtherAppBill(String currentAppId, NoCodeTreeNode root) {
        List<QFilter> filters = NcEntityTypeUtil.getQFilters(currentAppId, TAB_OTHER_APP);
        DynamicObjectCollection bills = QueryServiceHelper.query((String)BOS_DEVPN_FORMMETA, (String)"id, name, bizappid, bizappid.name", (QFilter[])filters.toArray(new QFilter[0]), (String)"bizappid.name asc, bizappid asc, name asc");
        ArrayList<String> appIds = new ArrayList<String>();
        for (DynamicObject obj : bills) {
            NoCodeTreeNode appNode;
            String appName;
            String appId = obj.getString(BIZ_APPID);
            String string = appName = obj.get("bizappid.name") == null ? null : obj.get("bizappid.name").toString();
            if (!appIds.contains(appId)) {
                appNode = new NoCodeTreeNode(appName, appId, ROOT_ID, null);
                appNode.setSelectable(false);
                root.addChild(appNode);
                appIds.add(appId);
            }
            if ((appNode = root.getTreeNode(appId, 10)) == null || obj.get(ID) == null) continue;
            NoCodeTreeNode child = NcEntityTypeUtil.buildTreeNode(obj, appId);
            appNode.addChild(child);
        }
    }

    private static List<QFilter> getQFilters(String bizappId, String tab) {
        QFilter bizappFilter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        QFilter istemplateFilter = new QFilter("istemplate", "=", (Object)false);
        filters.add(istemplateFilter);
        QFilter modeltypeFilter = new QFilter("modeltype", "=", (Object)"NoCodeModel").and(new QFilter(BIZ_APPID, "!=", (Object)NOCODE_SYS_APP_ID));
        filters.add(modeltypeFilter);
        if (TAB_CURRENT_APP.equalsIgnoreCase(tab)) {
            bizappFilter = new QFilter(BIZ_APPID, "=", (Object)bizappId);
            filters.add(bizappFilter);
            Set<String> formIdsByAppId = NcEntityTypeUtil.getFormIdsByAppId(bizappId);
            QFilter formFilter = new QFilter(ID, "in", formIdsByAppId);
            filters.add(formFilter);
        } else {
            bizappFilter = new QFilter(BIZ_APPID, "!=", (Object)bizappId);
            filters.add(bizappFilter);
            Map appliedAppPerm = NoCodePermissionServiceHelper.getAppliedAppPerm(Collections.singletonList(bizappId));
            Set formids = appliedAppPerm.getOrDefault(bizappId, Collections.emptySet());
            QFilter formFilter = new QFilter(ID, "in", formids);
            filters.add(formFilter);
        }
        QFilter templateFilter = new QFilter(BIZ_APPID, "not in", NcEntityTypeUtil.queryTemplateAppIds());
        filters.add(templateFilter);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        filters.add(enableFilter);
        return filters;
    }

    public static JSONObject buildRefBillData(Map<String, Object> param, String bizappId) {
        DynamicObjectCollection bills;
        boolean needParse;
        String tab = (String)param.get(TAB);
        String value = (String)param.get(VALUE);
        if (StringUtils.isNotBlank((CharSequence)value) && value.indexOf(44) != 0) {
            value = value.split(",")[1];
        }
        if (StringUtils.isBlank((CharSequence)tab)) {
            tab = TAB_CURRENT_APP;
        }
        if (needParse = TAB_PARSE_BY_DATA.equalsIgnoreCase(tab)) {
            String appIdByValue;
            tab = TAB_CURRENT_APP;
            QFilter idFilter = new QFilter(ID, "=", (Object)value);
            bills = QueryServiceHelper.query((String)BOS_DEVPN_FORMMETA, (String)BIZ_APPID, (QFilter[])new QFilter[]{idFilter});
            if (!bills.isEmpty() && !StringUtils.equalsIgnoreCase((CharSequence)(appIdByValue = (String)((DynamicObject)bills.get(0)).get(BIZ_APPID)), (CharSequence)bizappId)) {
                tab = TAB_OTHER_APP;
            }
        }
        List<QFilter> filters = NcEntityTypeUtil.getQFilters(bizappId, tab);
        bills = QueryServiceHelper.query((String)BOS_DEVPN_FORMMETA, (String)"id, name, bizappid, bizappid.name", (QFilter[])filters.toArray(new QFilter[0]), (String)"bizappid.name asc, bizappid asc, name asc");
        JSONObject data = new JSONObject();
        JSONArray dataRows = new JSONArray();
        if (TAB_CURRENT_APP.equalsIgnoreCase(tab)) {
            NcEntityTypeUtil.buildCurrentAppBillList(bills, dataRows);
        } else {
            NcEntityTypeUtil.buildOtherAppBillTree(bills, dataRows, null, null);
        }
        data.put("data", (Object)dataRows);
        data.put(TAB, (Object)tab);
        return data;
    }

    public static JSONObject buildRefBillData(String bizappId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(TAB, TAB_CURRENT_APP);
        return NcEntityTypeUtil.buildRefBillData(param, bizappId);
    }

    public static Set<String> getFormIdsByAppId(String appId) {
        HashSet<String> formIds = new HashSet<String>();
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)appId);
        List topMenus = appMetadata.getAppMenus().stream().filter(m -> appMetadata.getId().equalsIgnoreCase(m.getParentId())).collect(Collectors.toList());
        for (AppMenuElement topMenu : topMenus) {
            NcEntityTypeUtil.recursiveMenus(formIds, topMenu, appMetadata);
        }
        return formIds;
    }

    private static void recursiveMenus(Set<String> formIds, AppMenuElement menuElement, AppMetadata appMetadata) {
        if ("bas_appstarted".equalsIgnoreCase(menuElement.getFormNumber())) {
            return;
        }
        String formId = menuElement.getFormId();
        if (StringUtils.isNotEmpty((CharSequence)formId)) {
            formIds.add(formId);
        } else {
            List childs = appMetadata.getAppMenus().stream().filter(m -> menuElement.getId().equalsIgnoreCase(m.getParentId())).collect(Collectors.toList());
            for (AppMenuElement childMenuElement : childs) {
                NcEntityTypeUtil.recursiveMenus(formIds, childMenuElement, appMetadata);
            }
        }
    }

    private static void buildCurrentAppBillList(DynamicObjectCollection bills, JSONArray dataRows) {
        JSONObject rowPerson = new JSONObject();
        rowPerson.put(VALUE, (Object)BOS_USER_NUMBER);
        rowPerson.put(LABEL, (Object)NcEntityTypeUtil.getBosUserName());
        dataRows.add((Object)rowPerson);
        JSONObject rowAdminorg = new JSONObject();
        rowAdminorg.put(VALUE, (Object)BOS_ADMIN_ORG_NUMBER);
        rowAdminorg.put(LABEL, (Object)NcEntityTypeUtil.getBosAdminOrgNane());
        dataRows.add((Object)rowAdminorg);
        for (DynamicObject bill : bills) {
            JSONObject row = new JSONObject();
            row.put(VALUE, bill.get(ID));
            row.put(LABEL, bill.get(NAME));
            dataRows.add((Object)row);
        }
    }

    private static void buildOtherAppBillTree(DynamicObjectCollection bills, JSONArray dataRows, String appId, JSONArray billRows) {
        if (appId == null) {
            String lastAppId = null;
            for (DynamicObject bill : bills) {
                String theAppId = (String)bill.get(BIZ_APPID);
                if (StringUtils.equalsIgnoreCase((CharSequence)theAppId, lastAppId)) continue;
                lastAppId = theAppId;
                JSONObject appRowData = new JSONObject();
                appRowData.put(VALUE, bill.get(BIZ_APPID));
                appRowData.put(LABEL, bill.get("bizappid.name"));
                billRows = new JSONArray();
                appRowData.put("children", (Object)billRows);
                NcEntityTypeUtil.buildOtherAppBillTree(bills, dataRows, theAppId, billRows);
                dataRows.add((Object)appRowData);
            }
        } else {
            for (DynamicObject bill : bills) {
                String theAppId = (String)bill.get(BIZ_APPID);
                if (!StringUtils.equalsIgnoreCase((CharSequence)theAppId, (CharSequence)appId)) continue;
                JSONObject row = new JSONObject();
                row.put(VALUE, bill.get(ID));
                row.put(LABEL, bill.get(NAME));
                billRows.add((Object)row);
            }
        }
    }

    public static Set<String> queryTemplateAppIds() {
        return (Set)ThreadCache.get((Object)"nc.template.app.ids", () -> {
            HashSet<String> ret = new HashSet<String>();
            QFilter filter1 = new QFilter("type", "=", (Object)"1");
            DynamicObjectCollection dys = QueryServiceHelper.query((String)"bos_nocode_templateconfig", (String)"appid", (QFilter[])new QFilter[]{filter1});
            for (DynamicObject dy : dys) {
                ret.add(dy.getString("appid"));
            }
            return ret;
        });
    }

    @Deprecated
    public static String getRealBillEntityId(String billEntityId) {
        String id = billEntityId;
        if (BOS_USER_NUMBER.equalsIgnoreCase(id)) {
            return BOS_USER_ID;
        }
        if (BOS_ADMIN_ORG_NUMBER.equalsIgnoreCase(id)) {
            return BOS_ADMIN_ORG_ID;
        }
        if (!StringUtils.isNumeric((CharSequence)id) && StringUtils.isNotEmpty((CharSequence)id)) {
            String number = MetadataDao.getIdByNumber((String)id, (MetaCategory)MetaCategory.Entity);
            if (StringUtils.isEmpty((CharSequence)number)) {
                return id;
            }
            return number;
        }
        return id;
    }

    @Deprecated
    public static String getRealBillEntityNumber(String billEntityId) {
        String id = NcEntityTypeUtil.getRealBillEntityId(billEntityId);
        if (BOS_USER_ID.equalsIgnoreCase(id)) {
            return BOS_USER_NUMBER;
        }
        if (BOS_ADMIN_ORG_ID.equalsIgnoreCase(id)) {
            return BOS_ADMIN_ORG_NUMBER;
        }
        if (!StringUtils.isNumeric((CharSequence)id) && StringUtils.isNotEmpty((CharSequence)id)) {
            String number = MetadataDao.getNumberById((String)id);
            if (StringUtils.isEmpty((CharSequence)number)) {
                return id;
            }
            return number;
        }
        return id;
    }

    @Deprecated
    public static String getRealBillEntityIdByNumber(String billEntityNumber) {
        String id = billEntityNumber;
        if (BOS_USER_NUMBER.equalsIgnoreCase(id)) {
            return BOS_USER_ID;
        }
        if (BOS_ADMIN_ORG_NUMBER.equalsIgnoreCase(id)) {
            return BOS_ADMIN_ORG_ID;
        }
        if (!StringUtils.isNumeric((CharSequence)id)) {
            return MetadataDao.getIdByNumber((String)id, (MetaCategory)MetaCategory.Entity);
        }
        return id;
    }

    public static String getFormCaption(String billEntityId) {
        String realBillEntityNumber = NcEntityTypeUtil.getRealBillEntityNumber(billEntityId);
        return (String)ThreadCache.get((Object)("nc.form.caption" + realBillEntityNumber), () -> {
            QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)realBillEntityNumber)};
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_FORMMETA, (String)NAME, (QFilter[])filters);
            if (dynamicObject == null) {
                return "";
            }
            return dynamicObject.get(NAME).toString();
        });
    }

    public static String getBillCaption(String billEntityId, Object pk, String dispPropName) {
        BillEntityType dt = NcEntityTypeUtil.getMainEntityType(billEntityId);
        if (dt == null) {
            return null;
        }
        String nameProperty = dispPropName;
        if (StringUtils.isBlank((CharSequence)nameProperty)) {
            nameProperty = NcEntityTypeUtil.getBillDisplayPropertyName((IDataEntityType)dt);
        }
        if (StringUtils.isBlank((CharSequence)nameProperty)) {
            return null;
        }
        try {
            String realBillEntityNumber = NcEntityTypeUtil.getRealBillEntityNumber(billEntityId);
            StringBuilder sb = new StringBuilder();
            for (DynamicObject obj : QueryServiceHelper.query((String)realBillEntityNumber, (String)nameProperty, (QFilter[])NcEntityTypeUtil.parseIdInFilters(dt, pk))) {
                String nameValue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if (StringUtils.isBlank((CharSequence)(nameValue = obj.getString(nameProperty)))) {
                    nameValue = DATA_TYPE_SEPARATOR_CHARS;
                }
                sb.append(nameValue);
            }
            return sb.toString();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
    }

    private static QFilter[] parseIdInFilters(BillEntityType dt, Object pk) {
        ArrayList<Object> pks = new ArrayList<Object>(10);
        if (pk instanceof String) {
            for (String k : ((String)pk).split(",")) {
                Object newPk = NcEntityTypeUtil.convertPKValueType((DynamicObjectType)dt, k);
                if (newPk == null) continue;
                pks.add(newPk);
            }
        } else {
            pks.add(pk);
        }
        QFilter pkInFilter = new QFilter(dt.getPrimaryKey().getName(), "in", pks);
        return new QFilter[]{pkInFilter};
    }

    public static String getBillDisplayPropertyName(IDataEntityType dt) {
        String nameProperty = null;
        if (dt instanceof BasedataEntityType) {
            nameProperty = ((BasedataEntityType)dt).getNameProperty();
        } else if (dt instanceof BillEntityType) {
            nameProperty = ((BillEntityType)dt).getBillNo();
        }
        if (StringUtils.isBlank((CharSequence)nameProperty)) {
            for (IDataEntityProperty property : dt.getProperties()) {
                if (property == dt.getPrimaryKey() || !(property instanceof TextProp)) continue;
                nameProperty = property.getName();
                break;
            }
        }
        return nameProperty;
    }

    public static String getDataTypePkCap() {
        return "[\u5185\u7801]";
    }

    public static String getDataTypeTextCap() {
        return "[\u6587\u672c]";
    }

    public static String getDataTypeTextareaCap() {
        return "[\u591a\u884c\u6587\u672c]";
    }

    public static String getDataTypeNumberCap() {
        return "[\u6570\u5b57]";
    }

    public static String getDataTypeDateCap() {
        return "[\u65e5\u671f]";
    }

    public static String getDataTypeRefbillCap() {
        return "[\u5173\u8054\u8868\u5355]";
    }

    public static String getDataTypeGroupCap() {
        return "[\u5206\u7ec4]";
    }

    public static String getDataTypeComboCap() {
        return "[\u9009\u9879]";
    }

    public static String getDataTypeImageCap() {
        return "[\u56fe\u7247]";
    }

    public static String getDataTypeAttachmentCap() {
        return "[\u9644\u4ef6]";
    }

    public static String getDataTypeBoolCap() {
        return "[\u903b\u8f91]";
    }

    public static String getDataTypeUserCap() {
        return "[\u4eba\u5458]";
    }

    public static String getDataTypeOrgCap() {
        return "[\u7ec4\u7ec7]";
    }

    public static String getDataTypeUnknownCap() {
        return "[\u672a\u77e5]";
    }

    public static String getText() {
        return "\u6587\u672c";
    }

    private static Class<?> getBasePropClass(IDataEntityProperty property) {
        if (property instanceof PKFieldProp) {
            return PKFieldProp.class;
        }
        if (property instanceof ComboProp) {
            return ComboProp.class;
        }
        if (property instanceof DecimalProp) {
            return DecimalProp.class;
        }
        if (property instanceof TextProp) {
            return TextProp.class;
        }
        if (property instanceof IAttachmentProp) {
            return IAttachmentProp.class;
        }
        if (property instanceof INoCodeRefBillProp) {
            return NcEntityTypeUtil.getRefBillProp(property);
        }
        if (property instanceof IPictureProp) {
            return IPictureProp.class;
        }
        if (property instanceof DateTimeProp) {
            return DateTimeProp.class;
        }
        if (property instanceof BooleanProp) {
            return BooleanProp.class;
        }
        if (property instanceof UserProp) {
            return UserProp.class;
        }
        if (property instanceof OrgProp) {
            return OrgProp.class;
        }
        return property.getClass();
    }

    private static Class<?> getBaseFieldClass(Field<?> field) {
        if (field instanceof ComboField) {
            return ComboField.class;
        }
        if (field instanceof DecimalField) {
            return DecimalField.class;
        }
        if (field instanceof TextField) {
            return TextField.class;
        }
        if (field instanceof IAttachmentField) {
            return IAttachmentField.class;
        }
        if (field instanceof IPictureField) {
            return IPictureField.class;
        }
        if (field instanceof DateTimeField) {
            return DateTimeField.class;
        }
        if (field instanceof DateRangeField) {
            return DateTimeField.class;
        }
        if (field instanceof INoCodeRefBillField) {
            return NcEntityTypeUtil.getRefBillField((INoCodeRefBillField)field);
        }
        if (field instanceof CheckBoxField) {
            return CheckBoxField.class;
        }
        return field.getClass();
    }

    @NotNull
    private static Class<?> getRefBillProp(IDataEntityProperty property) {
        String billEntityId = ((INoCodeRefBillProp)property).getBillEntityId();
        if (BOS_USER_ID.equalsIgnoreCase(billEntityId) || BOS_USER_NUMBER.equalsIgnoreCase(billEntityId) || property instanceof INoCodeUserProp) {
            return UserProp.class;
        }
        if (BOS_ADMIN_ORG_ID.equalsIgnoreCase(billEntityId) || BOS_ADMIN_ORG_NUMBER.equalsIgnoreCase(billEntityId)) {
            return OrgProp.class;
        }
        return INoCodeRefBillProp.class;
    }

    @NotNull
    private static Class<?> getRefBillField(INoCodeRefBillField field) {
        String billEntityId = field.getBillEntityId();
        if (BOS_USER_ID.equalsIgnoreCase(billEntityId) || BOS_USER_NUMBER.equalsIgnoreCase(billEntityId) || field instanceof INoCodeUserField) {
            return INoCodeUserField.class;
        }
        if (BOS_ADMIN_ORG_ID.equalsIgnoreCase(billEntityId) || BOS_ADMIN_ORG_NUMBER.equalsIgnoreCase(billEntityId) || field instanceof INoCodeOrgField) {
            return INoCodeOrgField.class;
        }
        return INoCodeRefBillField.class;
    }

    public static String getDataType(IDataEntityProperty property) {
        Class<?> cls = NcEntityTypeUtil.getBasePropClass(property);
        if (MAPPING_DICT_DATA_TYPE.containsKey(cls)) {
            String dataType = MAPPING_DICT_DATA_TYPE.get(cls);
            return dataType;
        }
        return DATA_TYPE_UNKNOWN;
    }

    public static String getDataType(Field<?> field) {
        Class<?> cls = NcEntityTypeUtil.getBaseFieldClass(field);
        if (MAPPING_DICT_DATA_TYPE.containsKey(cls)) {
            String dataType = MAPPING_DICT_DATA_TYPE.get(cls);
            return dataType;
        }
        return DATA_TYPE_UNKNOWN;
    }

    public static String getFieldType(IDataEntityProperty property) {
        Class<?> cls = NcEntityTypeUtil.getBasePropClass(property);
        if (MAPPING_DICT_DATA_TYPE.containsKey(cls)) {
            IDataEntityType parent;
            String dataType = MAPPING_DICT_DATA_TYPE.get(cls);
            if (DATA_TYPE_COMBO.equalsIgnoreCase(dataType) && (parent = property.getParent()) != null) {
                return dataType + DATA_TYPE_SEPARATOR_CHARS + parent.getName() + DATA_TYPE_SEPARATOR_CHARS + property.getName();
            }
            return dataType;
        }
        return DATA_TYPE_UNKNOWN;
    }

    public static String getDataTypeCaption(IDataEntityProperty property) {
        Class<?> cls = NcEntityTypeUtil.getBasePropClass(property);
        if (MAPPING_DICT_DATA_TYPE_CAP.containsKey(cls)) {
            String result = MAPPING_DICT_DATA_TYPE_CAP.get(cls);
            if (property instanceof INoCodeRefBillProp) {
                result = String.format(TYPE_FORMAT, ((INoCodeRefBillProp)property).getEntityName());
                String suffix = ((INoCodeRefBillProp)property).isMultiSelect() ? NcEntityTypeUtil.getRefBillMultiDesc() : NcEntityTypeUtil.getRefBillSingleDesc();
                result = result + suffix;
            } else if (property instanceof INoCodeComboProp) {
                String suffix = ((INoCodeComboProp)property).isMultiSelect() ? NcEntityTypeUtil.getComboMultiDesi() : NcEntityTypeUtil.getComboSingleDesc();
                result = result + suffix;
            }
            return result;
        }
        return NcEntityTypeUtil.getDataTypeUnknownCap() + String.format(TYPE_FORMAT, cls.getSimpleName());
    }

    public static String getDataTypeCaption(Field<?> field) {
        Class<?> cls = NcEntityTypeUtil.getBaseFieldClass(field);
        if (MAPPING_DICT_DATA_TYPE_CAP.containsKey(cls)) {
            String result = MAPPING_DICT_DATA_TYPE_CAP.get(cls);
            if (field instanceof INoCodeRefBillField) {
                result = String.format(TYPE_FORMAT, NcEntityTypeUtil.getEntityName(((INoCodeRefBillField)field).getBillEntityNumber()));
                String suffix = ((INoCodeRefBillField)field).isMultiSelect() ? NcEntityTypeUtil.getRefBillMultiDesc() : NcEntityTypeUtil.getRefBillSingleDesc();
                result = result + suffix;
            } else if (field instanceof INoCodeComboField) {
                String suffix = ((INoCodeComboField)field).isMulti() ? NcEntityTypeUtil.getComboMultiDesi() : NcEntityTypeUtil.getComboSingleDesc();
                result = result + suffix;
            }
            return result;
        }
        return NcEntityTypeUtil.getDataTypeUnknownCap() + String.format(TYPE_FORMAT, cls.getSimpleName());
    }

    public static String getDataTypeCaption(String type, Map<String, Object> option) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return NcEntityTypeUtil.getDataTypeUnknownCap();
        }
        if (type.equalsIgnoreCase(DATA_TYPE_GROUP)) {
            return NcEntityTypeUtil.getDataTypeGroupCap();
        }
        String realType = type;
        if (MAPPING_DICT_DATA_TYPE.containsValue(realType)) {
            String finalRealType = realType;
            Optional<Map.Entry> first = MAPPING_DICT_DATA_TYPE.entrySet().stream().filter(s -> ((String)s.getValue()).equalsIgnoreCase(finalRealType)).findFirst();
            if (first.isPresent()) {
                Class key = (Class)first.get().getKey();
                String result = MAPPING_DICT_DATA_TYPE_CAP.get(key);
                if (NcEntityTypeUtil.isRefBill(realType)) {
                    Object isAPI;
                    String billEntityId = option != null ? (String)option.get(OPTION_BILLENTITYID) : "";
                    String entityName = NcEntityTypeUtil.getEntityName(NcEntityTypeUtil.getRealBillEntityNumber(billEntityId));
                    if (StringUtils.isEmpty((CharSequence)entityName) && Objects.nonNull(option) && Objects.nonNull(isAPI = option.get(OPTION_API)) && Boolean.parseBoolean(isAPI.toString())) {
                        entityName = API_PREFIX;
                    }
                    result = String.format(TYPE_FORMAT, entityName);
                    String suffix = option != null && option.get(OPTION_ISMULTI) != null && (Boolean)option.get(OPTION_ISMULTI) != false ? NcEntityTypeUtil.getRefBillMultiDesc() : NcEntityTypeUtil.getRefBillSingleDesc();
                    result = result + suffix;
                }
                if (NcEntityTypeUtil.isCombo(realType)) {
                    String suffix = option != null && option.get(OPTION_ISMULTI) != null && (Boolean)option.get(OPTION_ISMULTI) != false ? NcEntityTypeUtil.getComboMultiDesi() : NcEntityTypeUtil.getComboSingleDesc();
                    result = result + suffix;
                }
                return result;
            }
        }
        return NcEntityTypeUtil.getDataTypeUnknownCap();
    }

    public static String getDataTitle(String dataTypeCaption, String name) {
        String title = name;
        if (StringUtils.isBlank((CharSequence)title)) {
            title = "\u5b57\u6bb5\u5f15\u7528\u5931\u6548";
        }
        return String.format(KEY_TITLE_FORMAT, dataTypeCaption, title);
    }

    private static boolean isCombo(String type) {
        return DATA_TYPE_COMBO.equalsIgnoreCase(type) || type.startsWith(DATA_TYPE_COMBO_PREFIX);
    }

    public static Object getMockDataByType(JSONObject varItem) {
        Map option;
        String type = (String)varItem.get((Object)"type");
        if (DATA_TYPE_REFBILL.equalsIgnoreCase(type) && (option = (Map)varItem.get((Object)"option")) != null && ((Boolean)option.get(OPTION_ISMULTI)).booleanValue()) {
            return MOCK_DATA_MULTI_REFBILL;
        }
        if (MAPPING_DICT_DATA_TYPE_MOCK_DATA.containsKey(type)) {
            return MAPPING_DICT_DATA_TYPE_MOCK_DATA.get(type);
        }
        return null;
    }

    public static String getDisplayProperties(String formNumber) {
        if (MAPPING_DICT_DISP_PROP.containsKey(formNumber)) {
            return MAPPING_DICT_DISP_PROP.get(formNumber);
        }
        return null;
    }

    public static String getSelectProperties(String formNumber) {
        IDataEntityProperty property;
        String displayProperties = NcEntityTypeUtil.getDisplayProperties(formNumber);
        if (displayProperties != null && StringUtils.isNotBlank((CharSequence)displayProperties)) {
            return displayProperties;
        }
        BillEntityType dt = NcEntityTypeUtil.getMainEntityType(formNumber);
        if (dt == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        ISimpleProperty primaryKey = dt.getPrimaryKey();
        Iterator iterator = dt.getProperties().iterator();
        while (iterator.hasNext() && (property = (IDataEntityProperty)iterator.next()) != primaryKey) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(property.getName());
        }
        return sb.toString();
    }

    public static String getSelectPropertiesIncludePkId(String formNumber) {
        String displayProperties = NcEntityTypeUtil.getDisplayProperties(formNumber);
        if (displayProperties != null && StringUtils.isNotBlank((CharSequence)displayProperties)) {
            String[] split = displayProperties.split(",");
            boolean hasId = false;
            for (String s : split) {
                if (!ID.equalsIgnoreCase(s)) continue;
                hasId = true;
                break;
            }
            if (!hasId) {
                displayProperties = "id," + displayProperties;
            }
            return displayProperties;
        }
        BillEntityType dt = NcEntityTypeUtil.getMainEntityType(formNumber);
        if (dt == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (IDataEntityProperty property : dt.getProperties()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(property.getName());
            if (!(property instanceof INoCodeRefBillProp)) continue;
            sb.append(",").append(property.getName()).append(".id");
        }
        return sb.toString();
    }

    public static List<IDataEntityProperty> getDisplayProperties(MainEntityType dt) {
        String formNumber = dt.getName();
        String displayProperties = NcEntityTypeUtil.getDisplayProperties(formNumber);
        if (StringUtils.isNotBlank((CharSequence)displayProperties)) {
            String[] split = StringUtils.split((String)displayProperties, (String)",");
            ArrayList<IDataEntityProperty> properties = new ArrayList<IDataEntityProperty>(split.length);
            for (String prop : split) {
                IDataEntityProperty property = dt.findProperty(prop);
                if (property == null) continue;
                properties.add(property);
            }
            return properties;
        }
        return dt.getProperties();
    }

    public static Object convertPKValueType(DynamicObjectType refType, Object pkValue) {
        if (pkValue == null) {
            return null;
        }
        Object pkValue2 = null;
        if (pkValue.getClass() == String.class && refType.getPrimaryKey() instanceof LongProp) {
            try {
                pkValue2 = StringUtils.isBlank((Object)pkValue) ? 0L : Long.parseLong((String)pkValue);
            }
            catch (NumberFormatException ne) {
                log.warn((Throwable)ne);
                return null;
            }
        } else {
            pkValue2 = pkValue.getClass() == Integer.class && refType.getPrimaryKey() instanceof LongProp ? Long.valueOf(Long.parseLong(String.valueOf(pkValue))) : (pkValue.getClass() != String.class && refType.getPrimaryKey() instanceof VarcharProp ? pkValue.toString() : pkValue);
        }
        return pkValue2;
    }

    public static String getUserName(Object userPk) {
        if (userPk == null) {
            return null;
        }
        BillEntityType dt = NcEntityTypeUtil.getMainEntityType(BOS_USER_ID);
        if (dt == null) {
            return null;
        }
        Object pk = NcEntityTypeUtil.convertPKValueType((DynamicObjectType)dt, userPk);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)BOS_USER_NUMBER);
        if (dynamicObject == null) {
            return null;
        }
        return dynamicObject.get(NAME).toString();
    }

    public static MainEntityType getDataEntityType(String formId) {
        String finalFormId = NcEntityTypeUtil.getRealBillEntityId(formId);
        return (MainEntityType)ThreadCache.get((Object)("nc.DataEntityType." + formId), () -> {
            MainEntityType dt;
            try {
                dt = EntityMetadataCache.getDataEntityType((String)NcEntityTypeUtil.getRealBillEntityNumber(finalFormId));
            }
            catch (Exception e) {
                log.warn((Throwable)e);
                throw new RestApiException("\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664");
            }
            return dt;
        });
    }

    public static MainEntityType getDataEntityTypeNotThrowException(String formId) {
        try {
            return NcEntityTypeUtil.getDataEntityType(formId);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return null;
        }
    }

    public static boolean isFormExist(String formId) {
        if (StringUtils.isBlank((CharSequence)formId)) {
            return false;
        }
        if (NcEntityTypeUtil.isRefBillOfUser(formId) || NcEntityTypeUtil.isRefBillOfOrg(formId)) {
            return true;
        }
        String formNumber = NcEntityTypeUtil.getRealBillEntityNumber(formId);
        return (Boolean)ThreadCache.get((Object)("nc.form." + formId), () -> {
            if (NcEntityTypeUtil.isSoftDeleted(formId)) {
                return false;
            }
            return MetadataDao.checkNumber((String)formNumber);
        });
    }

    public static boolean isSoftDeleted(String refFormId) {
        return NcRuntimeMetaUtil.isSoftDeleted(refFormId);
    }

    public static boolean isFormRecExist(String formId, String pks) {
        String entityNumber = NcEntityTypeUtil.getRealBillEntityNumber(formId);
        if (StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)pks)) {
            return false;
        }
        MainEntityType dt = NcEntityTypeUtil.getDataEntityType(formId);
        String[] split = pks.split(",");
        if (split.length == 1) {
            Object pk = NcEntityTypeUtil.convertPKValueType((DynamicObjectType)dt, split[0]);
            return QueryServiceHelper.exists((String)entityNumber, (Object)pk);
        }
        ArrayList<Object> pkList = new ArrayList<Object>(split.length);
        for (String s : split) {
            Object pk = NcEntityTypeUtil.convertPKValueType((DynamicObjectType)dt, s);
            pkList.add(pk);
        }
        QFilter[] filters = new QFilter[]{new QFilter(dt.getPrimaryKey().getName(), "in", pkList)};
        List pkids = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])filters, (String)"", (int)split.length);
        return !pkids.isEmpty() && pkids.size() == split.length;
    }

    public static boolean isRecPk(String pk) {
        if (StringUtils.isBlank((CharSequence)pk) || pk.indexOf("{") != -1 || pk.indexOf("(") != -1 || pk.indexOf(" ") != -1) {
            return false;
        }
        return StringUtils.isNumeric((CharSequence)pk);
    }

    public static List<ValueMapItem> getSelectItems(String formId, String fieldId) {
        BillEntityType dt = NcEntityTypeUtil.getMainEntityType(formId);
        if (dt == null) {
            return Collections.emptyList();
        }
        IDataEntityProperty property = dt.findProperty(fieldId);
        if (property == null || !(property instanceof ComboProp)) {
            return Collections.emptyList();
        }
        return ((ComboProp)property).getComboItems();
    }

    public static List<ValueMapItem> getSelectItems(String fullDataType) {
        String[] split = StringUtils.split((String)fullDataType, (String)DATA_TYPE_SEPARATOR_CHARS);
        if (split.length == 3) {
            String formId = split[1];
            String fieldId = split[2];
            return NcEntityTypeUtil.getSelectItems(formId, fieldId);
        }
        return Collections.emptyList();
    }

    public static String getFullDateType(IDataEntityProperty property) {
        String dataType = NcEntityTypeUtil.getDataType(property);
        if (DATA_TYPE_UNKNOWN.equalsIgnoreCase(dataType)) {
            return DATA_TYPE_UNKNOWN;
        }
        IDataEntityType parent = property.getParent();
        if (parent != null) {
            return dataType + DATA_TYPE_SEPARATOR_CHARS + parent.getName() + DATA_TYPE_SEPARATOR_CHARS + property.getName();
        }
        return dataType;
    }

    public static String checkRecordCount(String formId, int currentRecordToInsert) {
        String cacheKey = CACHE_KEY_PREFIX_MAX_RECORD_COUNT + formId;
        String sCacheRecordCount = (String)cache.get(cacheKey);
        int recordCount = 0;
        if (StringUtils.isNotBlank((CharSequence)sCacheRecordCount)) {
            recordCount = Integer.parseInt(sCacheRecordCount);
        } else {
            recordCount = NcEntityTypeUtil.getRecordCount(formId);
            cache.put(cacheKey, (Object)String.valueOf(recordCount), 60);
        }
        if (recordCount + currentRecordToInsert >= 100000) {
            return "\u6b64\u8868\u5355\u7684\u8bb0\u5f55\u6570\u91cf\u5df2\u8fbe\u5230\u4e0a\u9650\uff0c\u65e0\u6cd5\u5f55\u5165";
        }
        return null;
    }

    private static int getRecordCount(String formId) {
        if (StringUtils.isBlank((CharSequence)formId)) {
            return 0;
        }
        MainEntityType dt = NcEntityTypeUtil.getDataEntityType(formId);
        if (dt == null || StringUtils.isBlank((CharSequence)dt.getAlias())) {
            return 0;
        }
        try (EntityTraceSpan span = EntityTracer.create((String)"span-nocode", (String)"checkRecordCount");){
            String sql = String.format(SQL_RECORD_COUNT, dt.getAlias());
            int n = (Integer)DB.query((DBRoute)new DBRoute(dt.getDBRouteKey()), (String)sql, null, resultSet -> {
                if (resultSet.next()) {
                    return resultSet.getInt(1);
                }
                return 0;
            });
            return n;
        }
    }

    public static boolean isRefBill(String dataType) {
        return DATA_TYPE_REFBILL.equalsIgnoreCase(dataType) || "NoCodeMulRefBillField".equalsIgnoreCase(dataType) || "NoCodeRefBillField".equalsIgnoreCase(dataType) || DATA_TYPE_USER.equalsIgnoreCase(dataType) || "NoCodeCreatorField".equalsIgnoreCase(dataType) || "NoCodeModifierField".equalsIgnoreCase(dataType) || DATA_TYPE_ORG.equalsIgnoreCase(dataType) || DATA_TYPE_PK.equalsIgnoreCase(dataType);
    }

    public static boolean isMultiRefBill(String dataType, Map<String, Object> option) {
        if (option != null && !option.isEmpty() && NcEntityTypeUtil.isRefBill(dataType)) {
            return option.containsKey(OPTION_ISMULTI) && (Boolean)option.get(OPTION_ISMULTI) != false;
        }
        return false;
    }

    public static boolean isRefBillOfUser(String formId) {
        return BOS_USER_ID.equalsIgnoreCase(formId) || BOS_USER_NUMBER.equalsIgnoreCase(formId);
    }

    public static boolean isRefBillOfOrg(String formId) {
        return BOS_ADMIN_ORG_ID.equalsIgnoreCase(formId) || BOS_ADMIN_ORG_NUMBER.equalsIgnoreCase(formId);
    }

    public static boolean isNoCodeBill(String formId) {
        String entityNumber = NcEntityTypeUtil.getRealBillEntityNumber(formId);
        NoCodeRuntimeService service = (NoCodeRuntimeService)ServiceFactory.getService(NoCodeRuntimeService.class);
        return service.isNoCodeBill(entityNumber);
    }

    public static boolean isNoCodeBillOrUserOrOrg(String formId) {
        if (StringUtils.isBlank((CharSequence)formId)) {
            return false;
        }
        String realFormId = formId;
        if (realFormId.indexOf(",") > 0) {
            String[] split = realFormId.split(",");
            realFormId = split[split.length - 1];
        }
        if (BOS_USER_ID.equalsIgnoreCase(realFormId) || BOS_USER_NUMBER.equalsIgnoreCase(realFormId) || BOS_ADMIN_ORG_ID.equalsIgnoreCase(realFormId) || BOS_ADMIN_ORG_NUMBER.equalsIgnoreCase(realFormId)) {
            return true;
        }
        return StringUtils.isNumeric((CharSequence)realFormId) && NcEntityTypeUtil.isNoCodeBill(realFormId);
    }

    public static List<ShowColumnInfo> getShowColumnsWithGroupContainer(String formId, List<ShowColumnInfo> showColumns) {
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form);
        return NcEntityTypeUtil.getShowColumnsWithGroupContainer(formMetadata, showColumns);
    }

    public static List<ShowColumnInfo> getShowColumnsWithGroupContainer(FormMetadata formMetadata, List<ShowColumnInfo> showColumns) {
        if (formMetadata == null) {
            return showColumns;
        }
        HashMap<String, String> field2groupIdMap = new HashMap<String, String>(10);
        for (ControlAp control : formMetadata.getItems()) {
            if (!(control instanceof TabPageAp)) continue;
            String groupContainerId = control.getId();
            List child = formMetadata.getItems().stream().filter(i -> groupContainerId.equalsIgnoreCase(i.getParentId())).collect(Collectors.toList());
            for (ControlAp c : child) {
                field2groupIdMap.put(c.getId(), groupContainerId);
            }
        }
        if (!field2groupIdMap.isEmpty()) {
            // empty if block
        }
        return showColumns;
    }

    public static String getEntityName(String entityNumber) {
        if (BOS_USER_NUMBER.equals(entityNumber)) {
            return NcEntityTypeUtil.getBosUserName();
        }
        if (BOS_ADMIN_ORG_NUMBER.equals(entityNumber)) {
            return NcEntityTypeUtil.getBosAdminOrgNane();
        }
        return NcEntityTypeUtil.getFormCaption(entityNumber);
    }

    public static Object getOriginalValue(Object result) {
        if (result instanceof DynamicObject) {
            return ((DynamicObject)result).getPkValue();
        }
        return result;
    }

    public static Object getOriginalValue(IDataEntityProperty property, Object result) {
        if (property instanceof IDateFormatSupport && result instanceof Date) {
            return ((IDateFormatSupport)property).getFormattedValue(result);
        }
        return NcEntityTypeUtil.getOriginalValue(result);
    }

    private static List<Map<String, Object>> getGroupTreeFromFormMeta(String formId, FormMetadata formMeta) {
        String realBillEntityId = NcEntityTypeUtil.getRealBillEntityId(formId);
        if (formMeta == null) {
            Map<String, Object> metaDataContent = NcEntityTypeUtil.loadMetaDataContent(realBillEntityId);
            formMeta = NcEntityTypeUtil.convertTo(metaDataContent);
        }
        List formItems = formMeta.getItems();
        List entityItems = formMeta.getEntityMetadata().getItems();
        List topItems = formItems.stream().filter(i -> realBillEntityId.equalsIgnoreCase(i.getParentId())).collect(Collectors.toList());
        if (topItems.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        for (ControlAp topItem : topItems) {
            String topItemId = topItem.getId();
            String topItemKey = topItem.getKey();
            String fieldType = null;
            fieldType = topItem instanceof FieldAp ? ((FieldAp)topItem).getField().getClass().getSimpleName() : topItem.getClass().getSimpleName();
            if (NOCODEREFBILLTABLE.equalsIgnoreCase(fieldType)) continue;
            HashMap<String, Object> topItemMap = new HashMap<String, Object>(10);
            topItemMap.put(ID2, topItemKey);
            topItemMap.put(NAME2, topItem.getName().toString());
            if (topItem instanceof ContainerAp) {
                List<Map<String, Object>> childItems = NcEntityTypeUtil.expendChildGroup(topItemId, formItems, entityItems);
                if (childItems.isEmpty()) continue;
                topItemMap.put(ITEMS, childItems);
            }
            result.add(topItemMap);
        }
        return result;
    }

    private static Map<String, Object> loadMetaDataContent(String realBillEntityId) {
        return (Map)ThreadCache.get((Object)("nc.meta." + realBillEntityId), () -> MetadataDao.loadDesignerMetadata((String)realBillEntityId, (String)RequestContext.get().getLang().toString()));
    }

    private static List<Map<String, Object>> expendChildGroup(String groupId, List<ControlAp<?>> formItems, List<EntityItem<?>> entityItems) {
        List groupChild = formItems.stream().filter(i -> groupId.equalsIgnoreCase(i.getParentId())).collect(Collectors.toList());
        if (groupChild.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        for (ControlAp child : groupChild) {
            List<Map<String, Object>> childItems;
            String childId = child.getId();
            String childKey = child.getKey();
            String fieldType = null;
            fieldType = child instanceof FieldAp ? ((FieldAp)child).getField().getClass().getSimpleName() : child.getClass().getSimpleName();
            if (NOCODEREFBILLTABLE.equalsIgnoreCase(fieldType)) continue;
            if (NOCODEDATERANGEFIELD.equalsIgnoreCase(fieldType)) {
                Optional<EntityItem> first = entityItems.stream().filter(i -> childId.equalsIgnoreCase(i.getId())).findFirst();
                if (!first.isPresent()) continue;
                DateRangeField dateRangeField = (DateRangeField)first.get();
                HashMap<String, String> childMapStart = new HashMap<String, String>(3);
                childMapStart.put(ID2, dateRangeField.getStartDateFieldKey());
                childMapStart.put(NAME2, dateRangeField.getName().toString() + "." + ResManager.loadKDString((String)"\u5f00\u59cb", (String)"DateRange_Start", (String)"BOS_NOCODE", (Object[])new Object[0]));
                result.add(childMapStart);
                HashMap<String, String> childMapEnd = new HashMap<String, String>(3);
                childMapEnd.put(ID2, dateRangeField.getEndDateFieldKey());
                childMapEnd.put(NAME2, dateRangeField.getName().toString() + "." + ResManager.loadKDString((String)"\u7ed3\u675f", (String)"DateRange_End", (String)"BOS_NOCODE", (Object[])new Object[0]));
                result.add(childMapEnd);
                continue;
            }
            HashMap<String, Object> childMap = new HashMap<String, Object>(3);
            childMap.put(ID2, childKey);
            childMap.put(NAME2, child.getName().toString());
            if (child instanceof ContainerAp && !(childItems = NcEntityTypeUtil.expendChildGroup(childId, formItems, entityItems)).isEmpty()) {
                childMap.put(ITEMS, childItems);
            }
            result.add(childMap);
        }
        return result;
    }

    private static FormMetadata convertTo(Map<String, Object> designerMetadata) {
        FormMetadataConverter formMetadataConverter = new FormMetadataConverter();
        return (FormMetadata)formMetadataConverter.convertTo(designerMetadata);
    }

    public static boolean isTypeCanAssign(String srcType, String targetType, Map<String, Object> srcOption, Map<String, Object> targetOption) {
        if (StringUtils.isBlank((CharSequence)srcType) || StringUtils.isBlank((CharSequence)targetType)) {
            return false;
        }
        if (NcEntityTypeUtil.isRefBill(targetType)) {
            return NcEntityTypeUtil.isTypeCanAssign2Refbill(srcType, targetType, srcOption, targetOption);
        }
        boolean isSame = srcType.equalsIgnoreCase(targetType);
        if (isSame) {
            return true;
        }
        if (NcEntityTypeUtil.isCombo(targetType)) {
            return NcEntityTypeUtil.isCombo(srcType) || DATA_TYPE_TEXT.equalsIgnoreCase(srcType) || DATA_TYPE_TEXTAREA.equalsIgnoreCase(srcType) || "number".equalsIgnoreCase(srcType) || DATA_TYPE_DATE.equalsIgnoreCase(srcType);
        }
        if (DATA_TYPE_DATE.equalsIgnoreCase(targetType)) {
            return NcEntityTypeUtil.isCombo(srcType) || DATA_TYPE_TEXT.equalsIgnoreCase(srcType) || DATA_TYPE_TEXTAREA.equalsIgnoreCase(srcType);
        }
        if ("number".equalsIgnoreCase(targetType)) {
            return NcEntityTypeUtil.isCombo(srcType) || DATA_TYPE_TEXT.equalsIgnoreCase(srcType) || DATA_TYPE_TEXTAREA.equalsIgnoreCase(srcType);
        }
        if (DATA_TYPE_TEXTAREA.equalsIgnoreCase(targetType)) {
            return NcEntityTypeUtil.isCombo(srcType) || DATA_TYPE_TEXT.equalsIgnoreCase(srcType) || "number".equalsIgnoreCase(srcType) || DATA_TYPE_DATE.equalsIgnoreCase(srcType);
        }
        if (DATA_TYPE_TEXT.equalsIgnoreCase(targetType)) {
            return NcEntityTypeUtil.isCombo(srcType) || DATA_TYPE_TEXTAREA.equalsIgnoreCase(srcType) || "number".equalsIgnoreCase(srcType) || DATA_TYPE_DATE.equalsIgnoreCase(srcType);
        }
        return false;
    }

    public static boolean isTypeCanAssign2Refbill(String srcType, String targetType, Map<String, Object> srcOption, Map<String, Object> targetOption) {
        if (StringUtils.isBlank((CharSequence)srcType) || StringUtils.isBlank((CharSequence)targetType) || srcOption == null || targetOption == null) {
            return false;
        }
        boolean isSame = NcEntityTypeUtil.isRefbillSameType(srcOption, targetOption);
        boolean isMultiSrc = NcEntityTypeUtil.isMultiRefBill(srcOption);
        boolean isMultiTarget = NcEntityTypeUtil.isMultiRefBill(targetOption);
        if (isSame && isMultiTarget == isMultiSrc) {
            return true;
        }
        if (isSame && isMultiTarget && !isMultiSrc) {
            return true;
        }
        if (isSame && isMultiTarget != isMultiSrc) {
            return false;
        }
        return isSame;
    }

    public static boolean isTypeCanCompare2RefBill(String srcType, String targetType, Map<String, Object> srcOption, Map<String, Object> targetOption) {
        if (StringUtils.isBlank((CharSequence)srcType) || StringUtils.isBlank((CharSequence)targetType) || srcOption == null || targetOption == null) {
            return false;
        }
        return NcEntityTypeUtil.isRefbillSameType(srcOption, targetOption);
    }

    public static boolean isRefbillSameType(Map<String, Object> srcOption, Map<String, Object> targetOption) {
        if (srcOption.isEmpty() || !srcOption.containsKey(OPTION_BILLENTITYID) || srcOption.get(OPTION_BILLENTITYID) == null || targetOption.isEmpty() || !targetOption.containsKey(OPTION_BILLENTITYID)) {
            return false;
        }
        return ((String)srcOption.get(OPTION_BILLENTITYID)).equalsIgnoreCase((String)targetOption.get(OPTION_BILLENTITYID));
    }

    private static boolean isMultiRefBill(Map<String, Object> option) {
        if (option == null || option.isEmpty() || !option.containsKey(OPTION_ISMULTI)) {
            return false;
        }
        return (Boolean)option.get(OPTION_ISMULTI);
    }

    public static String getRuntimeExpression(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return null;
        }
        if (expression.indexOf("@@") == -1) {
            return expression;
        }
        return expression.split("@@")[0].trim();
    }

    static {
        MAPPING_DICT_DATA_TYPE.put(PKFieldProp.class, DATA_TYPE_PK);
        MAPPING_DICT_DATA_TYPE_CAP.put(PKFieldProp.class, NcEntityTypeUtil.getDataTypePkCap());
        MAPPING_DICT_DATA_TYPE_MOCK_DATA.put(DATA_TYPE_PK, 0);
        MAPPING_DICT_DATA_TYPE.put(TextProp.class, DATA_TYPE_TEXT);
        MAPPING_DICT_DATA_TYPE_CAP.put(TextProp.class, NcEntityTypeUtil.getDataTypeTextCap());
        MAPPING_DICT_DATA_TYPE.put(TextField.class, DATA_TYPE_TEXT);
        MAPPING_DICT_DATA_TYPE_CAP.put(TextField.class, NcEntityTypeUtil.getDataTypeTextCap());
        MAPPING_DICT_DATA_TYPE_MOCK_DATA.put(DATA_TYPE_TEXT, DATA_TYPE_MOCK_DATA_TEXT);
        MAPPING_DICT_DATA_TYPE.put(DecimalProp.class, "number");
        MAPPING_DICT_DATA_TYPE_CAP.put(DecimalProp.class, NcEntityTypeUtil.getDataTypeNumberCap());
        MAPPING_DICT_DATA_TYPE.put(DecimalField.class, "number");
        MAPPING_DICT_DATA_TYPE_CAP.put(DecimalField.class, NcEntityTypeUtil.getDataTypeNumberCap());
        MAPPING_DICT_DATA_TYPE_MOCK_DATA.put("number", 1);
        MAPPING_DICT_DATA_TYPE.put(DateTimeProp.class, DATA_TYPE_DATE);
        MAPPING_DICT_DATA_TYPE_CAP.put(DateTimeProp.class, NcEntityTypeUtil.getDataTypeDateCap());
        MAPPING_DICT_DATA_TYPE.put(DateTimeField.class, DATA_TYPE_DATE);
        MAPPING_DICT_DATA_TYPE_CAP.put(DateTimeField.class, NcEntityTypeUtil.getDataTypeDateCap());
        MAPPING_DICT_DATA_TYPE_MOCK_DATA.put(DATA_TYPE_DATE, "NOW()");
        MAPPING_DICT_DATA_TYPE.put(INoCodeRefBillProp.class, DATA_TYPE_REFBILL);
        MAPPING_DICT_DATA_TYPE_CAP.put(INoCodeRefBillProp.class, NcEntityTypeUtil.getDataTypeRefbillCap());
        MAPPING_DICT_DATA_TYPE.put(INoCodeRefBillField.class, DATA_TYPE_REFBILL);
        MAPPING_DICT_DATA_TYPE_CAP.put(INoCodeRefBillField.class, NcEntityTypeUtil.getDataTypeRefbillCap());
        MAPPING_DICT_DATA_TYPE_MOCK_DATA.put(DATA_TYPE_REFBILL, 1657103146553574400L);
        MAPPING_DICT_DATA_TYPE.put(ComboProp.class, DATA_TYPE_COMBO);
        MAPPING_DICT_DATA_TYPE_CAP.put(ComboProp.class, NcEntityTypeUtil.getDataTypeComboCap());
        MAPPING_DICT_DATA_TYPE.put(ComboField.class, DATA_TYPE_COMBO);
        MAPPING_DICT_DATA_TYPE_CAP.put(ComboField.class, NcEntityTypeUtil.getDataTypeComboCap());
        MAPPING_DICT_DATA_TYPE_MOCK_DATA.put(DATA_TYPE_COMBO, "1");
        MAPPING_DICT_DATA_TYPE.put(IPictureProp.class, DATA_TYPE_IMAGE);
        MAPPING_DICT_DATA_TYPE_CAP.put(IPictureProp.class, NcEntityTypeUtil.getDataTypeImageCap());
        MAPPING_DICT_DATA_TYPE.put(IPictureField.class, DATA_TYPE_IMAGE);
        MAPPING_DICT_DATA_TYPE_CAP.put(IPictureField.class, NcEntityTypeUtil.getDataTypeImageCap());
        MAPPING_DICT_DATA_TYPE_MOCK_DATA.put(DATA_TYPE_IMAGE, "");
        MAPPING_DICT_DATA_TYPE.put(IAttachmentProp.class, DATA_TYPE_ATTACHMENT);
        MAPPING_DICT_DATA_TYPE_CAP.put(IAttachmentProp.class, NcEntityTypeUtil.getDataTypeAttachmentCap());
        MAPPING_DICT_DATA_TYPE.put(IAttachmentField.class, DATA_TYPE_ATTACHMENT);
        MAPPING_DICT_DATA_TYPE_CAP.put(IAttachmentField.class, NcEntityTypeUtil.getDataTypeAttachmentCap());
        MAPPING_DICT_DATA_TYPE_MOCK_DATA.put(DATA_TYPE_ATTACHMENT, "");
        MAPPING_DICT_DATA_TYPE.put(BooleanProp.class, DATA_TYPE_BOOL);
        MAPPING_DICT_DATA_TYPE_CAP.put(BooleanProp.class, NcEntityTypeUtil.getDataTypeBoolCap());
        MAPPING_DICT_DATA_TYPE.put(CheckBoxField.class, DATA_TYPE_BOOL);
        MAPPING_DICT_DATA_TYPE_CAP.put(CheckBoxField.class, NcEntityTypeUtil.getDataTypeBoolCap());
        MAPPING_DICT_DATA_TYPE_MOCK_DATA.put(DATA_TYPE_BOOL, true);
        MAPPING_DICT_DATA_TYPE.put(UserProp.class, DATA_TYPE_USER);
        MAPPING_DICT_DATA_TYPE_CAP.put(UserProp.class, NcEntityTypeUtil.getDataTypeUserCap());
        MAPPING_DICT_DATA_TYPE.put(INoCodeUserField.class, DATA_TYPE_USER);
        MAPPING_DICT_DATA_TYPE_CAP.put(INoCodeUserField.class, NcEntityTypeUtil.getDataTypeUserCap());
        MAPPING_DICT_DATA_TYPE_MOCK_DATA.put(DATA_TYPE_USER, 100000);
        MAPPING_DICT_DATA_TYPE.put(OrgProp.class, DATA_TYPE_ORG);
        MAPPING_DICT_DATA_TYPE_CAP.put(OrgProp.class, NcEntityTypeUtil.getDataTypeOrgCap());
        MAPPING_DICT_DATA_TYPE.put(INoCodeOrgField.class, DATA_TYPE_ORG);
        MAPPING_DICT_DATA_TYPE_CAP.put(INoCodeOrgField.class, NcEntityTypeUtil.getDataTypeOrgCap());
        MAPPING_DICT_DATA_TYPE_MOCK_DATA.put(DATA_TYPE_ORG, 100000);
        MAPPING_DICT_DISP_PROP.put(BOS_USER_NUMBER, BOS_USER_PROPS_DISPLAY);
        MAPPING_DICT_DISP_PROP.put(BOS_ADMIN_ORG_NUMBER, BOS_ADMIN_ORG_PROPS_DISPLAY);
    }
}

