/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;

public class NcErrorUtil {
    private NcErrorUtil() {
        throw new IllegalStateException("NcErrorUtil class");
    }

    public static String getStackTrace(Exception e) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement stackTraceElement : stackTrace) {
            if (!stackTraceElement.getClassName().startsWith("kd.bos")) continue;
            sb.append(stackTraceElement).append("\r\n");
        }
        return sb.toString();
    }

    public static void showErrorNotificationDuplicatePerTrace(IFormView view, String msg) {
        if (NcErrorUtil.msgCheckExistAndCache(view, msg)) {
            return;
        }
        view.showErrorNotification(msg);
    }

    private static boolean msgCheckExistAndCache(IFormView view, String msg) {
        String cacheKey = String.format("%s_%s_%s", RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), RequestContext.get().getTraceId());
        String sMsgs = view.getPageCache().get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)sMsgs)) {
            List msgs = (List)SerializationUtils.fromJsonString((String)sMsgs, List.class);
            if (msgs.contains(msg)) {
                return true;
            }
            msgs.add(msg);
            view.getPageCache().put(cacheKey, SerializationUtils.toJsonString((Object)msgs));
        } else {
            ArrayList<String> msgs = new ArrayList<String>(1);
            msgs.add(msg);
            view.getPageCache().put(cacheKey, SerializationUtils.toJsonString(msgs));
        }
        return false;
    }
}

