/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import java.util.function.Function;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;

public class NcLocalCacheUtil {
    private static final int CACHE_TIME_OUT = 7200;
    private static final int CACHE_TIME_OUT_Transient = 180;
    private static final int CACHE_MAX_ITEM_SIZE = 100000;
    private static final int CACHE_MAX_MEM_SIZE = 300;

    private NcLocalCacheUtil() {
    }

    private static LocalMemoryCache getLocalMemoryCache(String cacheType) {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(7200);
        info.setMaxItemSize(100000);
        info.setMaxMemSize(300);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("NocodeAPI".concat(RequestContext.get().getAccountId()), cacheType, info);
    }

    private static LocalMemoryCache getLocalMemoryCacheTransient(String cacheType) {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(180);
        info.setMaxItemSize(100000);
        info.setMaxMemSize(300);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("NocodeAPI".concat(RequestContext.get().getAccountId()), cacheType, info);
    }

    public static Object getCacheByKey(String cacheType, String key) {
        return NcLocalCacheUtil.getLocalMemoryCache(cacheType).get(key);
    }

    public static void setCacheByKey(String cacheType, String key, Object value) {
        NcLocalCacheUtil.getLocalMemoryCache(cacheType).put(key, value);
    }

    public static void removeCacheByKey(String cacheType, String key) {
        NcLocalCacheUtil.getLocalMemoryCache(cacheType).remove(new String[]{key});
    }

    public static void clear(String cacheType) {
        NcLocalCacheUtil.getLocalMemoryCache(cacheType).clear();
    }

    public static <T> boolean checkIsInCache(Class<T> dataType, String key) {
        Object object = NcLocalCacheUtil.getLocalMemoryCache(dataType.getName()).get(key);
        return object != null;
    }

    public static <T> T getCacheByKey(Class<T> dataType, String key) {
        return (T)NcLocalCacheUtil.getLocalMemoryCache(dataType.getName()).get(key);
    }

    public static <T> void removeCacheByKey(Class<T> dataType, String key) {
        NcLocalCacheUtil.removeCacheByKey(dataType.getName(), key);
    }

    public static <T> void setCacheByKey(String key, T object) {
        NcLocalCacheUtil.setCacheByKey(object.getClass().getName(), key, object);
    }

    public static <T> void clear(Class<T> dataType) {
        NcLocalCacheUtil.clear(dataType.getName());
    }

    public static <T> T getOrCreateTransient(String cacheType, String key, Function<String, T> setValueFunc) {
        LocalMemoryCache localMemoryCache = NcLocalCacheUtil.getLocalMemoryCacheTransient(cacheType);
        Object result = localMemoryCache.get(key);
        if (result == null) {
            result = setValueFunc.apply(key);
            localMemoryCache.put(key, result);
        }
        return (T)result;
    }

    public static <T> T getOrCreate(String cacheType, String key, Function<String, T> setValueFunc) {
        LocalMemoryCache localMemoryCache = NcLocalCacheUtil.getLocalMemoryCache(cacheType);
        Object result = localMemoryCache.get(key);
        if (result == null) {
            result = setValueFunc.apply(key);
            localMemoryCache.put(key, result);
        }
        return (T)result;
    }
}

