/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import java.util.concurrent.Callable;
import java.util.function.Predicate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public final class NcRetryUtil {
    private static final Log log = LogFactory.getLog(NcRetryUtil.class);
    public static final RetryPolicy DEFAULT_RETRY_POLICY = NcRetryUtil.retryPolicyBuilder().maxAttempts(3).delayMillis(500).build();

    private NcRetryUtil() {
    }

    public static RetryPolicy.Builder retryPolicyBuilder() {
        return new RetryPolicy.Builder();
    }

    public static <T> T withRetry(Callable<T> action, int maxAttempts) {
        return DEFAULT_RETRY_POLICY.withRetry(action, maxAttempts);
    }

    public static <T> T withRetry(Callable<T> action) {
        return DEFAULT_RETRY_POLICY.withRetry(action);
    }

    public static <T> T withRetry(Callable<T> action, int maxAttempts, Predicate<T> isSuccess) {
        return DEFAULT_RETRY_POLICY.withRetry(action, maxAttempts, isSuccess);
    }

    public static final class RetryPolicy {
        private final int maxAttempts;
        private final int delayMillis;

        public RetryPolicy(int maxAttempts, int delayMillis) {
            this.maxAttempts = maxAttempts;
            this.delayMillis = delayMillis;
        }

        public void sleep(int attempt) {
            try {
                Thread.sleep(attempt * this.delayMillis);
            }
            catch (InterruptedException ignored) {
                log.debug(ignored.getMessage());
            }
        }

        public <T> T withRetry(Callable<T> action) {
            return this.withRetry(action, this.maxAttempts);
        }

        public <T> T withRetry(Callable<T> action, int maxAttempts) {
            int attempt = 1;
            while (true) {
                try {
                    return action.call();
                }
                catch (Exception e) {
                    if (attempt == maxAttempts) {
                        throw new RuntimeException(e);
                    }
                    log.warn(String.format("Exception was thrown on attempt %s of %s", attempt, maxAttempts), (Throwable)e);
                    this.sleep(attempt);
                    ++attempt;
                    continue;
                }
                break;
            }
        }

        public <T> T withRetry(Callable<T> action, int maxAttempts, Predicate<T> isSuccess) {
            int attempt = 1;
            while (true) {
                try {
                    T result = action.call();
                    if (isSuccess == null || isSuccess.test(result) || attempt == maxAttempts) {
                        return result;
                    }
                    this.sleep(attempt);
                }
                catch (Exception e) {
                    if (attempt == maxAttempts) {
                        throw new RuntimeException(e);
                    }
                    log.warn(String.format("Exception was thrown on attempt %s of %s", attempt, maxAttempts), (Throwable)e);
                    this.sleep(attempt);
                }
                ++attempt;
            }
        }

        public static final class Builder {
            private int maxAttempts = 3;
            private int delayMillis = 1000;

            public Builder maxAttempts(int maxAttempts) {
                this.maxAttempts = maxAttempts;
                return this;
            }

            public Builder delayMillis(int delayMillis) {
                this.delayMillis = delayMillis;
                return this;
            }

            public RetryPolicy build() {
                return new RetryPolicy(this.maxAttempts, this.delayMillis);
            }
        }
    }
}

