/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.RuntimeMetaType;
import kd.bos.nocode.utils.NcAppVersionUtil;
import kd.bos.nocode.utils.ShowColumnInfo;

public class NcRuntimeMetaUtil {
    private NcRuntimeMetaUtil() {
    }

    public static Map<String, Object> getRuntimeMeta(String formId) {
        DBRoute dbRoute = DBRoute.meta;
        String readSql = "select fdata from T_META_ENTITY where FTYPE = ? and FKEY = ? and FKEY = fnumber";
        SqlParameter typeParam = new SqlParameter("FTYPE", 4, (Object)RuntimeMetaType.NOCODE.getValue());
        SqlParameter keyParam = new SqlParameter("FKEY", 12, (Object)formId);
        ResultSetHandler action = rs -> {
            if (rs.next()) {
                String dataStr = rs.getString("fdata");
                return (Map)SerializationUtils.fromJsonString((String)dataStr, Map.class);
            }
            return Collections.emptyMap();
        };
        return (Map)DB.query((DBRoute)dbRoute, (String)readSql, (Object[])new SqlParameter[]{typeParam, keyParam}, (ResultSetHandler)action);
    }

    public static boolean isSoftDeleted(String refFormId) {
        return (Boolean)ThreadCache.get((Object)("nc.SoftDeleted." + refFormId), () -> {
            if (!NcAppVersionUtil.isEnableSoftDeleteByForm(refFormId)) {
                return false;
            }
            String sql = "select fdata from t_meta_entity where fnumber = ? and fkey = ? and ftype = ? ";
            Object[] parameters = new kd.bos.db.SqlParameter[]{new kd.bos.db.SqlParameter(":fnumber", 12, (Object)refFormId), new kd.bos.db.SqlParameter(":fkey", 12, (Object)refFormId), new kd.bos.db.SqlParameter(":ftype", 4, (Object)RuntimeMetaType.NOCODE.getValue())};
            return (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])parameters, resultSet -> {
                if (resultSet.next()) {
                    String dataStr = resultSet.getString("fdata");
                    if (StringUtils.isBlank((CharSequence)dataStr)) {
                        return false;
                    }
                    Map dataMap = (Map)SerializationUtils.fromJsonString((String)dataStr, Map.class);
                    Object isSoftDeletedObj = dataMap.get("isSoftDeleted");
                    if (isSoftDeletedObj == null) {
                        return false;
                    }
                    return Boolean.parseBoolean(isSoftDeletedObj.toString());
                }
                return false;
            });
        });
    }

    public static List<ShowColumnInfo> getFieldTree(String formId) {
        Map<String, Object> data = NcRuntimeMetaUtil.getRuntimeMeta(formId);
        if (data.isEmpty()) {
            return Collections.emptyList();
        }
        List fieldTreeMapList = (List)data.get("FieldTree");
        if (fieldTreeMapList != null && !fieldTreeMapList.isEmpty()) {
            return fieldTreeMapList.stream().map(f -> NcRuntimeMetaUtil.parseColumnInfo(f)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static ShowColumnInfo parseColumnInfo(Object obj) {
        if (obj instanceof ShowColumnInfo) {
            return (ShowColumnInfo)obj;
        }
        if (obj instanceof Map) {
            ArrayList list;
            Map map = (Map)obj;
            ShowColumnInfo info = new ShowColumnInfo();
            info.setId((String)map.get("id"));
            info.setCaption((String)map.get("caption"));
            info.setType((String)map.get("type"));
            info.setTypeCaption((String)map.get("typeCaption"));
            info.setVisible((Boolean)map.get("visible"));
            info.getOption().putAll((Map)map.get("option"));
            if (info.getOption().containsKey("children") && !(list = (ArrayList)info.getOption().get("children")).isEmpty() && list.get(0) instanceof Map) {
                ArrayList<ShowColumnInfo> newInfos = new ArrayList<ShowColumnInfo>(list.size());
                for (Object o : list) {
                    ShowColumnInfo newInfo = NcRuntimeMetaUtil.parseColumnInfo(o);
                    if (newInfo == null) continue;
                    newInfos.add(newInfo);
                }
                info.getOption().put("children", newInfos);
            }
            return info;
        }
        return null;
    }
}

