/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.utils.NoCodeTreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;

public class NoCodeAppUtils {
    private static final String ORDERBY = "sequence asc";
    private static final String INDUSTRY = "industry";
    private static final String BIZCLOUD = "bizcloud";
    private static final String CLOUD = "cloud";
    public static final String NOCODE_CLOUD_ID = "2HGKCE94QELW";
    public static final long NOCODE_OTHER_APP_ID = 1837773202850438144L;
    public static final String NOCODE_APP_ID = "2HGKTA7HH43C";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String MASTERID = "masterid";
    private static final String NUMBER = "number";
    public static final Log logger = LogFactory.getLog(NoCodeAppUtils.class);

    public static void getCloudTree(String[] bizCloudIds, String[] bizAppIds, String industryId, boolean isRuntime, boolean onlyVisible, boolean onlyDeployed, NoCodeTreeNode parentNode) {
        QFilter filter;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        ProductSettingService pService = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        List blackCloudId = pService.getCloudIdBlackList();
        List blackAppIds = pService.getAppIdBlackList();
        if (!blackCloudId.isEmpty()) {
            filterList.add(new QFilter(BIZCLOUD, "not in", (Object)blackCloudId.toArray()));
        }
        if (!blackAppIds.isEmpty()) {
            filterList.add(new QFilter("id", "not in", (Object)blackAppIds.toArray()));
        }
        if (bizAppIds != null) {
            filter = new QFilter("id", "in", (Object)bizAppIds);
            filterList.add(filter);
        } else if (bizCloudIds != null) {
            filter = new QFilter(BIZCLOUD, "in", (Object)bizCloudIds);
            filterList.add(filter);
        }
        if (StringUtils.isNotBlank((CharSequence)industryId)) {
            filter = new QFilter(INDUSTRY, "=", (Object)industryId);
            filter.or(new QFilter(INDUSTRY, "=", (Object)0));
            filterList.add(filter);
        }
        if (isRuntime) {
            filter = new QFilter("type", "!=", (Object)"2");
            filterList.add(filter);
        }
        if (isRuntime && onlyDeployed) {
            filter = new QFilter("deploystatus", "=", (Object)"2");
            filterList.add(filter);
        }
        QFilter[] filters = filterList.toArray(new QFilter[filterList.size()]);
        List<DynamicObject> apps = NoCodeAppUtils.getApps(filters, ORDERBY, isRuntime, onlyVisible);
        ArrayList<String> cloudIds = new ArrayList<String>();
        for (DynamicObject obj : apps) {
            NoCodeTreeNode cloudNode;
            DynamicObject cldObj = obj.getDynamicObject(BIZCLOUD);
            if (cldObj == null) continue;
            String cloudName = cldObj.getLocaleString("name").toString();
            String cloudId = cldObj.getString("id");
            String appName = obj.getLocaleString("name").toString();
            String appId = obj.getString("id");
            if (!cloudIds.contains(cloudId)) {
                cloudNode = new NoCodeTreeNode(cloudName, cloudId, parentNode.getValue(), null);
                parentNode.addChild(cloudNode);
                cloudIds.add(cloudId);
            }
            cloudNode = parentNode.getTreeNode(cloudId, 10);
            if (!StringUtils.isNotBlank((CharSequence)appId) || cloudNode == null) continue;
            NoCodeTreeNode appNode = new NoCodeTreeNode(appName, appId, cloudId, new ArrayList<NoCodeTreeNode>());
            cloudNode.addChild(appNode);
        }
    }

    private static List<DynamicObject> getApps(QFilter[] filters, String orderBy, boolean isRuntime, boolean onlyVisible) {
        QFilter mstEmpty;
        QFilter mstNotNUll;
        QFilter[] mstfilters;
        Map appExtends;
        filters = RunModeServiceHelper.getAppAndCloudBlacklistFilters((QFilter[])filters, (String)"id", (String)BIZCLOUD);
        Object[] newFilter = NoCodeAppUtils.appendProductCloudIdBlackQFilter(NoCodeAppUtils.appendProductAppIdBlackQFilter(filters, "id"), BIZCLOUD);
        newFilter = (QFilter[])ArrayUtils.add((Object[])newFilter, (Object)new QFilter(BIZCLOUD, "!=", (Object)NOCODE_CLOUD_ID));
        Map appsMap = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVPORTAL_BIZAPP, (String)"id,name,number,type,industry,bizcloud,sequence,visible", (QFilter[])newFilter, (String)orderBy);
        HashSet<String> extendedAppIds = new HashSet<String>();
        if (isRuntime && onlyVisible && (appExtends = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVPORTAL_BIZAPP, (String)"masterid,visible", (QFilter[])(mstfilters = new QFilter[]{mstNotNUll = new QFilter(MASTERID, "is not null", (Object)Boolean.TRUE), mstEmpty = new QFilter(MASTERID, "!=", (Object)" ")}))).size() > 0) {
            for (DynamicObject obj : appExtends.values()) {
                String masterStr = obj.getString(MASTERID);
                extendedAppIds.add(masterStr);
            }
        }
        ArrayList<DynamicObject> apps = new ArrayList<DynamicObject>();
        if (appsMap != null) {
            for (DynamicObject obj : appsMap.values()) {
                String appId = obj.getString("id");
                String appNum = obj.getString(NUMBER);
                if (isRuntime && onlyVisible) {
                    if ("portal".equals(appNum)) continue;
                    if (extendedAppIds.contains(appId)) {
                        AppInfo appInfo = AppMetadataCache.getAppInfoByNumber((String)appNum);
                        if (!appInfo.isRealRuntime()) continue;
                        obj.set("name", (Object)appInfo.getName());
                    } else {
                        boolean visible = obj.getBoolean("visible");
                        if (!visible) continue;
                    }
                }
                apps.add(obj);
            }
        }
        final Map<Object, DynamicObject> cloudsMap = NoCodeAppUtils.getClouds(null);
        try {
            Collections.sort(apps, new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    String bizCloudId2;
                    if (null == o1 && null == o2) {
                        return 0;
                    }
                    if (null == o1) {
                        return -1;
                    }
                    if (null == o2) {
                        return 1;
                    }
                    String bizCloudId1 = o1.getString("bizcloud_id");
                    if (StringUtils.equals((CharSequence)bizCloudId1, (CharSequence)(bizCloudId2 = o2.getString("bizcloud_id")))) {
                        return 0;
                    }
                    DynamicObject obj1 = (DynamicObject)cloudsMap.get(bizCloudId1);
                    DynamicObject obj2 = (DynamicObject)cloudsMap.get(bizCloudId2);
                    int seq1 = obj1 == null ? 0 : obj1.getInt("sequence");
                    int seq2 = obj2 == null ? 0 : obj2.getInt("sequence");
                    return Integer.compare(seq1, seq2);
                }
            });
        }
        catch (Exception exception) {
            logger.debug(exception.getMessage());
        }
        return apps;
    }

    private static QFilter[] appendProductAppIdBlackQFilter(QFilter[] oldAppIdFilter, String fieldName) {
        ProductSettingService productService = NoCodeAppUtils.getProductSettingService();
        List appids = productService.getAppIdBlackList();
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        if (oldAppIdFilter != null) {
            list.addAll(Arrays.asList(oldAppIdFilter));
        }
        if (!appids.isEmpty()) {
            list.add(new QFilter(fieldName, "not in", (Object)appids.toArray()));
        }
        return list.toArray(new QFilter[list.size()]);
    }

    private static Map<Object, DynamicObject> getClouds(QFilter[] filters) {
        String fields = "id,name,number,sequence";
        filters = RunModeServiceHelper.getCloudIdBlacklistFilters((QFilter[])filters, (String)"id");
        Object[] newFilter = NoCodeAppUtils.appendProductCloudIdBlackQFilter(filters, "id");
        newFilter = (QFilter[])ArrayUtils.add((Object[])newFilter, (Object)new QFilter("id", "!=", (Object)NOCODE_CLOUD_ID));
        Map cloudsMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizcloud", (String)fields, (QFilter[])newFilter, (String)ORDERBY);
        return cloudsMap;
    }

    private static QFilter[] appendProductCloudIdBlackQFilter(QFilter[] oldCloudIdFilter, String fieldName) {
        ProductSettingService productService = NoCodeAppUtils.getProductSettingService();
        List appIds = productService.getCloudIdBlackList();
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        if (oldCloudIdFilter != null) {
            list.addAll(Arrays.asList(oldCloudIdFilter));
        }
        if (!appIds.isEmpty()) {
            list.add(new QFilter(fieldName, "not in", (Object)appIds.toArray()));
        }
        return list.toArray(new QFilter[list.size()]);
    }

    private static ProductSettingService getProductSettingService() {
        ProductSettingService productService = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        return productService;
    }
}

