/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.entity.AdminOrgTreeNode;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public final class NoCodeOrgServiceHelper {
    private static final Log log = LogFactory.getLog(NoCodeOrgServiceHelper.class);
    public static final String NO_ORG = "noOrg";
    public static final String NODE_ID_EXTERNAL_USER_TYPE = "externalUserType";

    public static String getNodeNameUnknown() {
        return "\u672a\u5206\u914d\u90e8\u95e8";
    }

    public static String getNodeIdExternalUserTypeName() {
        return "\u5546\u52a1\u4f19\u4f34\u4eba\u5458";
    }

    private NoCodeOrgServiceHelper() {
    }

    public static long getRootOrgId() {
        return Long.parseLong(NoCodeOrgServiceHelper.getRootNode().getId());
    }

    public static String getRootOrgNumber() {
        return NoCodeOrgServiceHelper.getRootNode().getLongNumber();
    }

    public static String getRootNumberSuffixLike() {
        String suffixLike = NoCodeOrgServiceHelper.getRootOrgNumber() + OrgUnitServiceHelper.getOrgSeparation().getLongNumberSep() + "%";
        log.debug(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7684\u540e\u7f00\u5339\u914d\u7b26\uff1a%s", (String)"NoCodeOrgServiceHelper_2", (String)"BOS_NOCODE", (Object[])new Object[]{suffixLike}));
        return suffixLike;
    }

    public static TreeNode getRootNode() {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber("01");
        return OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
    }

    public static List<TreeNode> getRootChildren() {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber("01");
        param.setTreeBuildType(OrgTreeBuildType.FILL_HIDDEN_PARENT_ALL);
        return OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
    }

    public static List<AdminOrgTreeNode> getOrgTreeFromCosmic(boolean filter) {
        String sep = OrgUnitServiceHelper.getOrgSeparation().getLongNumberSep();
        TreeNode rootNode = NoCodeOrgServiceHelper.getRootNode();
        rootNode.setChildren(NoCodeOrgServiceHelper.getRootChildren());
        ArrayList adminOrgTreeNodes = Lists.newArrayList((Object[])new AdminOrgTreeNode[]{NoCodeOrgServiceHelper.wrapAdminOrgTreeNode(rootNode, null, sep)});
        if (filter) {
            return NoCodeOrgServiceHelper.filterNodes(adminOrgTreeNodes);
        }
        return adminOrgTreeNodes;
    }

    private static List<AdminOrgTreeNode> filterNodes(ArrayList<AdminOrgTreeNode> nodes) {
        boolean manage = NoCodePermHelper.checkUserPlatManageInNoCode();
        if (manage) {
            return nodes;
        }
        long uid = RequestContext.get().getCurrUserId();
        Set oids = NoCodePermissionServiceHelper.getSystemRoleOrgIds((long)uid, (boolean)true);
        Set<Object> scope = oids == null ? new HashSet() : oids.stream().map(String::valueOf).collect(Collectors.toSet());
        QFilter userFilter = NoCodePermissionServiceHelper.getSystemRoleUserFilter((long)uid, (boolean)false);
        DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,dpt", (QFilter[])new QFilter[]{userFilter});
        Set userOids = Arrays.stream(users).filter(dy -> dy.getDynamicObjectCollection("entryentity").stream().map(d -> d.getLong("dpt.id")).noneMatch(oid -> oids != null && oids.contains(oid))).flatMap(dy -> dy.getDynamicObjectCollection("entryentity").stream()).map(dy -> dy.getString("dpt.id")).collect(Collectors.toSet());
        scope.addAll(userOids);
        ArrayList<AdminOrgTreeNode> ret = new ArrayList<AdminOrgTreeNode>();
        nodes.forEach(node -> NoCodeOrgServiceHelper.nodeWalk(node, scope));
        nodes.forEach(NoCodeOrgServiceHelper::pruning);
        nodes.forEach(n -> NoCodeOrgServiceHelper.nodePick(n, ret));
        return ret;
    }

    private static boolean pruning(AdminOrgTreeNode root) {
        if (root == null) {
            return false;
        }
        if (root.getChildren() != null) {
            root.getChildren().removeIf(n -> !NoCodeOrgServiceHelper.pruning(n));
        }
        if (root.getWalked() == Boolean.TRUE) {
            return true;
        }
        return root.getChildren() != null && !root.getChildren().isEmpty();
    }

    private static void nodePick(AdminOrgTreeNode node, List<AdminOrgTreeNode> list) {
        if (node == null) {
            return;
        }
        if (node.getWalked() == Boolean.TRUE) {
            list.add(node);
            return;
        }
        if (node.getChildren() != null) {
            node.getChildren().forEach(n -> NoCodeOrgServiceHelper.nodePick(n, list));
        }
    }

    private static void nodeWalk(AdminOrgTreeNode node, Set<String> oids) {
        if (node == null) {
            return;
        }
        if (oids.contains(node.getId())) {
            node.setWalked(true);
        }
        if (node.getChildren() != null) {
            node.getChildren().forEach(n -> NoCodeOrgServiceHelper.nodeWalk(n, oids));
        }
    }

    private static AdminOrgTreeNode wrapAdminOrgTreeNode(TreeNode treeNode, TreeNode parent, String sep) {
        AdminOrgTreeNode adminOrgTreeNode = new AdminOrgTreeNode();
        adminOrgTreeNode.setId(treeNode.getId());
        adminOrgTreeNode.setNumber(NoCodeOrgServiceHelper.getNumber(treeNode.getLongNumber(), sep));
        adminOrgTreeNode.setName(treeNode.getText());
        adminOrgTreeNode.setParentId(treeNode.getParentid());
        adminOrgTreeNode.setParentName(Objects.isNull(parent) ? "" : parent.getText());
        adminOrgTreeNode.setLeaf(treeNode.isLeaf());
        List children = treeNode.getChildren();
        if (!treeNode.isLeaf() && CollectionUtils.isNotEmpty((Collection)children)) {
            List<AdminOrgTreeNode> wrappedChildren = children.stream().map(e -> NoCodeOrgServiceHelper.wrapAdminOrgTreeNode(e, treeNode, sep)).collect(Collectors.toList());
            adminOrgTreeNode.setChildren(wrappedChildren);
        }
        if (Objects.isNull(parent)) {
            adminOrgTreeNode.getChildren().add(NoCodeOrgServiceHelper.getNoOrgNode(treeNode));
            adminOrgTreeNode.getChildren().add(NoCodeOrgServiceHelper.getExternalUserType(treeNode));
        }
        return adminOrgTreeNode;
    }

    private static AdminOrgTreeNode getNoOrgNode(TreeNode rootNode) {
        AdminOrgTreeNode adminOrgTreeNode = new AdminOrgTreeNode();
        adminOrgTreeNode.setId(NO_ORG);
        adminOrgTreeNode.setNumber(NO_ORG);
        adminOrgTreeNode.setName(NoCodeOrgServiceHelper.getNodeNameUnknown());
        adminOrgTreeNode.setParentId(rootNode.getId());
        adminOrgTreeNode.setParentName(rootNode.getText());
        adminOrgTreeNode.setLeaf(Boolean.TRUE);
        return adminOrgTreeNode;
    }

    private static AdminOrgTreeNode getExternalUserType(TreeNode rootNode) {
        AdminOrgTreeNode adminOrgTreeNode = new AdminOrgTreeNode();
        adminOrgTreeNode.setId(NODE_ID_EXTERNAL_USER_TYPE);
        adminOrgTreeNode.setNumber(NODE_ID_EXTERNAL_USER_TYPE);
        adminOrgTreeNode.setName(NoCodeOrgServiceHelper.getNodeIdExternalUserTypeName());
        adminOrgTreeNode.setParentId(rootNode.getId());
        adminOrgTreeNode.setParentName(rootNode.getText());
        adminOrgTreeNode.setLeaf(Boolean.FALSE);
        adminOrgTreeNode.setChildren(NoCodeOrgServiceHelper.getOtherUserTypeNode());
        return adminOrgTreeNode;
    }

    private static List<AdminOrgTreeNode> getOtherUserTypeNode() {
        QFilter externalUserTypeFilter = NoCodeOrgServiceHelper.getExternalUserTypeFilter();
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter visibleFilter = new QFilter("isvisible", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{enableFilter, visibleFilter, externalUserTypeFilter};
        Map typeMap = BusinessDataServiceHelper.loadFromCache((String)"bos_usertype", (String)"id,number,name", (QFilter[])filters, (String)"number");
        if (typeMap.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList typeNodes = Lists.newArrayListWithCapacity((int)typeMap.size());
        for (DynamicObject typeObj : typeMap.values()) {
            AdminOrgTreeNode adminOrgTreeNode = new AdminOrgTreeNode();
            adminOrgTreeNode.setId(NODE_ID_EXTERNAL_USER_TYPE + typeObj.getString("id"));
            adminOrgTreeNode.setNumber(NODE_ID_EXTERNAL_USER_TYPE + typeObj.getString("id"));
            adminOrgTreeNode.setName(typeObj.getString("name"));
            adminOrgTreeNode.setParentId(NODE_ID_EXTERNAL_USER_TYPE);
            adminOrgTreeNode.setParentName(NoCodeOrgServiceHelper.getNodeIdExternalUserTypeName());
            adminOrgTreeNode.setLeaf(Boolean.TRUE);
            typeNodes.add(adminOrgTreeNode);
        }
        return typeNodes;
    }

    private static QFilter getExternalUserTypeFilter() {
        return new QFilter("category", "=", (Object)"2");
    }

    private static String getNumber(String longNumber, String sep) {
        int lastIndex = longNumber.lastIndexOf(sep);
        return lastIndex == -1 ? longNumber : longNumber.substring(lastIndex + 1);
    }

    public static long getOrgIdByOrgNumber(String orgNumber) {
        QFilter filter = new QFilter("number", "=", (Object)orgNumber);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_adminorg", (String)"id", (QFilter[])filter.toArray());
        if (Objects.nonNull(dynamicObject)) {
            return dynamicObject.getLong("id");
        }
        return -1L;
    }
}

