/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.Maps;
import kd.bos.nocode.utils.FuncPermItemEnum;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.ShareInputMode;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.nocode.model.AppManageTypeEnum;
import kd.bos.permission.nocode.model.AppUseTypeEnum;
import kd.bos.permission.nocode.model.PermItemEnum;
import kd.bos.permission.nocode.model.Role;
import kd.bos.permission.nocode.model.RolePerm;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.permission.nocode.NoCodePermissionServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class NoCodePermHelper {
    private static final String ROLE_NAME_SPLIT_REG = "\\$";
    private static final String ROLE_NAME_SPLIT = "$";
    private static final String ID = "id";
    protected static ExecutorService pool = ThreadPools.newExecutorService((String)"NoCode-Perm-Query-Thread", (int)3);
    private static final String BOS_DEVPN_FORMMETA = "bos_devpn_formmeta";
    private static final String BIZ_APPID = "bizappid";
    private static final Log logger = LogFactory.getLog(NoCodePermHelper.class);

    private NoCodePermHelper() {
        throw new IllegalStateException("NoCodePermHelper class");
    }

    public static void verifyPlatManage() {
        long uid = RequestContext.get().getCurrUserId();
        boolean admin = PermissionServiceHelper.isAdminUser((long)uid);
        if (admin) {
            return;
        }
        NoCodePermHelper.verifyManage(uid, "2HGKTA7HH43C");
    }

    public static void verifyManage(String appid) {
        NoCodePermHelper.verifyManage(RequestContext.get().getCurrUserId(), appid);
    }

    public static void verifyManage(Long user, String appid) {
        boolean check = NoCodePermHelper.checkUserAppManageInNoCode(user, appid);
        if (!check) {
            throw new RestApiException(ResManager.loadKDString((String)"\u6743\u9650\u4e0d\u8db3", (String)"NoCodePermHelper_0", (String)"bos-nocode-common", (Object[])new Object[0]));
        }
    }

    public static void verifyUsePermPassTemp(String appid) {
        if (NcEntityTypeUtil.queryTemplateAppIds().contains(appid)) {
            return;
        }
        NoCodePermHelper.verifyUsePerm(appid);
    }

    public static void verifyUsePerm(String appid) {
        NoCodePermHelper.verifyUsePerm(RequestContext.get().getCurrUserId(), appid);
    }

    public static void verifyUsePerm(Long user, String appid) {
        boolean check = NoCodePermHelper.checkUserAppUseInNoCode(user, appid);
        if (!check) {
            throw new RestApiException(ResManager.loadKDString((String)"\u6743\u9650\u4e0d\u8db3", (String)"NoCodePermHelper_0", (String)"bos-nocode-common", (Object[])new Object[0]));
        }
    }

    public static boolean isShare(String appid, String formId, String shareId) {
        try (EntityTraceSpan span = EntityTracer.create((String)"NoCodePermHelper", (String)"isShare");){
            String s;
            DynamicObject dy;
            span.addLocaleTag("appid=", (Object)appid);
            span.addLocaleTag("formId=", (Object)formId);
            span.addLocaleTag("shareId=", (Object)shareId);
            if (StringUtils.isNotEmpty((String)shareId) && (dy = BusinessDataServiceHelper.loadSingle((Object)(s = shareId.split("_")[0]), (String)"bos_svc_share")) != null) {
                Date expiretime = dy.getDate("expiretime");
                if (System.currentTimeMillis() > expiretime.getTime()) {
                    boolean bl = false;
                    return bl;
                }
                String context = dy.getString("sharecontext_tag");
                if (StringUtils.isEmpty((String)context)) {
                    boolean bl = false;
                    return bl;
                }
                JSONObject json = JSONObject.parseObject((String)context);
                span.addLocaleTag("json=", (Object)json);
                if (StringUtils.isNotEmpty((String)appid) && json.containsKey((Object)"appId") && !appid.equals(json.getString("appId"))) {
                    boolean bl = false;
                    return bl;
                }
                if (StringUtils.isNotEmpty((String)formId) && json.containsKey((Object)"formId") && !formId.equals(json.getString("formId"))) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static boolean isValidShareId(String shareId) {
        if (StringUtils.isNotEmpty((String)shareId)) {
            String s = shareId.split("_")[0];
            return QueryServiceHelper.exists((String)"bos_svc_share", (Object)s);
        }
        return false;
    }

    public static boolean isViewShare(String shareId) {
        String s;
        DynamicObject dy;
        if (StringUtils.isNotEmpty((String)shareId) && (dy = BusinessDataServiceHelper.loadSingle((Object)(s = shareId.split("_")[0]), (String)"bos_svc_share")) != null) {
            JSONObject json;
            String context = dy.getString("sharecontext_tag");
            if (context.contains("?")) {
                context = context.substring(0, context.indexOf(63));
            }
            return (json = JSONObject.parseObject((String)context)).containsKey((Object)"type") && json.getString("type").equals("view");
        }
        return false;
    }

    public static boolean isAddShare(String shareId) {
        String s;
        DynamicObject dy;
        if (StringUtils.isNotEmpty((String)shareId) && (dy = BusinessDataServiceHelper.loadSingle((Object)(s = shareId.split("_")[0]), (String)"bos_svc_share")) != null) {
            JSONObject json;
            String context = dy.getString("sharecontext_tag");
            if (context.contains("?")) {
                context = context.substring(0, context.indexOf(63));
            }
            return (json = JSONObject.parseObject((String)context)).containsKey((Object)"type") && json.getString("type").equals("addNew");
        }
        return false;
    }

    public static ShareInputMode getAddShareMode(String shareId) {
        String s;
        DynamicObject dy;
        if (StringUtils.isNotEmpty((String)shareId) && (dy = BusinessDataServiceHelper.loadSingle((Object)(s = shareId.split("_")[0]), (String)"bos_svc_share")) != null) {
            JSONObject json;
            String mode;
            String context = dy.getString("sharecontext_tag");
            if (context.contains("?")) {
                context = context.substring(0, context.indexOf(63));
            }
            return StringUtils.isEmpty((String)(mode = (json = JSONObject.parseObject((String)context)).getString("inputMode"))) ? ShareInputMode.ALWAYS : ShareInputMode.find(mode);
        }
        return ShareInputMode.ALWAYS;
    }

    public static boolean checkDataPermInNoCode(String formId, Object pkId) {
        return NoCodePermHelper.checkDataPermInNoCode(formId, pkId, PermItemEnum.of((String)FuncPermItemEnum.view.getId()));
    }

    public static boolean checkDataEditPermInNoCode(String formId, Object pkId) {
        return NoCodePermHelper.checkDataPermInNoCode(formId, pkId, PermItemEnum.of((String)FuncPermItemEnum.edit.getId()));
    }

    public static boolean checkDataDelPermInNoCode(String formId, Object pkId) {
        return NoCodePermHelper.checkDataPermInNoCode(formId, pkId, PermItemEnum.of((String)FuncPermItemEnum.delete.getId()));
    }

    public static boolean checkDataPermInNoCode(String formId, Object pkId, PermItemEnum itemEnum) {
        if (pkId == null) {
            return false;
        }
        if (!NoCodePermHelper.isNoCodeForm(formId)) {
            return true;
        }
        long uid = RequestContext.get().getCurrUserId();
        try {
            QFilter filter = NoCodePermissionServiceHelper.getDataRuleFilter((long)uid, (String)formId, (PermItemEnum)itemEnum);
            if (filter == null) {
                return true;
            }
            QFilter idFilter = new QFilter(ID, "=", (Object)Long.parseLong(pkId.toString()));
            DynamicObject[] ids = BusinessDataServiceHelper.load((String)formId, (String)ID, (QFilter[])new QFilter[]{idFilter, filter});
            return ids.length > 0;
        }
        catch (Exception e) {
            throw new RestApiException(RestApiErrorCode.ERROR, e.getMessage(), e);
        }
    }

    public static Map<String, Boolean> checkAllDataPermInNoCode(String formId, Object pkId) {
        if (pkId == null) {
            return Collections.emptyMap();
        }
        if (!NoCodePermHelper.isNoCodeForm(formId)) {
            return Maps.of(FuncPermItemEnum.view.getId(), true, FuncPermItemEnum.edit.getId(), true, FuncPermItemEnum.delete.getId(), true);
        }
        long uid = RequestContext.get().getCurrUserId();
        ArrayList list = Lists.newArrayList((Object[])new String[]{FuncPermItemEnum.view.getId(), FuncPermItemEnum.edit.getId(), FuncPermItemEnum.delete.getId()});
        try {
            Map filters = NoCodePermissionServiceHelper.getDataRuleFilters((long)uid, (String)formId, (List)list);
            HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
            QFilter idFilter = new QFilter(ID, "=", (Object)Long.parseLong(pkId.toString()));
            for (String item : list) {
                QFilter filter = (QFilter)filters.get(item);
                if (filter == null) {
                    ret.put(item, true);
                    continue;
                }
                DynamicObject[] ids = BusinessDataServiceHelper.load((String)formId, (String)ID, (QFilter[])new QFilter[]{idFilter, filter});
                ret.put(item, ids.length > 0);
            }
            return ret;
        }
        catch (Exception e) {
            throw new RestApiException(RestApiErrorCode.ERROR, e.getMessage(), e);
        }
    }

    public static Set<String> getNoViewFieldPermSet(String formId) {
        if (!NoCodePermHelper.isNoCodeForm(formId)) {
            return Collections.emptySet();
        }
        long uid = RequestContext.get().getCurrUserId();
        try {
            Map fieldPermMap = NoCodePermissionServiceHelper.getNoPermProperties((long)uid, (String)formId);
            return fieldPermMap.getOrDefault(FuncPermItemEnum.view.getId(), Collections.emptySet());
        }
        catch (Exception e) {
            throw new RestApiException(RestApiErrorCode.ERROR, e.getMessage(), e);
        }
    }

    public static Set<String> getNoEditFieldPermSet(String formId) {
        if (!NoCodePermHelper.isNoCodeForm(formId)) {
            return Collections.emptySet();
        }
        long uid = RequestContext.get().getCurrUserId();
        try {
            Map fieldPermMap = NoCodePermissionServiceHelper.getNoPermProperties((long)uid, (String)formId);
            return fieldPermMap.getOrDefault(FuncPermItemEnum.edit.getId(), Collections.emptySet());
        }
        catch (Exception e) {
            throw new RestApiException(RestApiErrorCode.ERROR, e.getMessage(), e);
        }
    }

    public static Set<String> getNoInputFieldPermSet(String formId) {
        if (!NoCodePermHelper.isNoCodeForm(formId)) {
            return Collections.emptySet();
        }
        long uid = RequestContext.get().getCurrUserId();
        try {
            Map fieldPermMap = NoCodePermissionServiceHelper.getNoPermProperties((long)uid, (String)formId);
            return fieldPermMap.getOrDefault(FuncPermItemEnum.input.getId(), Collections.emptySet());
        }
        catch (Exception e) {
            throw new RestApiException(RestApiErrorCode.ERROR, e.getMessage(), e);
        }
    }

    public static boolean checkFuncPermInNoCode(FuncPermItemEnum item, String formid) {
        return NoCodePermHelper.checkFuncPerm(item, formid);
    }

    public static boolean checkFuncPerm(FuncPermItemEnum item, String formid) {
        return NoCodePermHelper.checkFuncPerm(item, formid, RequestContext.get().getCurrUserId());
    }

    public static boolean checkFuncPerm(FuncPermItemEnum item, String formid, long uid) {
        if (!NoCodePermHelper.isNoCodeForm(formid)) {
            return true;
        }
        try {
            return NoCodePermissionServiceHelper.getPermItems((long)uid, (String)formid).contains(item.getId());
        }
        catch (Exception e) {
            throw new RestApiException(RestApiErrorCode.ERROR, e.getMessage(), e);
        }
    }

    public static boolean checkFuncPerm(FuncPermItemEnum item, String formid, long uid, String appId) {
        if (!NoCodePermHelper.isNoCodeForm(formid)) {
            return true;
        }
        try {
            return NoCodePermissionServiceHelper.getPermItems((long)uid, (String)appId, (String)formid).contains(item.getId());
        }
        catch (Exception e) {
            throw new RestApiException(RestApiErrorCode.ERROR, e.getMessage(), e);
        }
    }

    private static boolean isNoCodeForm(String entityNumber) {
        if ("bos_user".equals(entityNumber) || "68bde9ca00000eac".equals(entityNumber) || "bos_adminorg".equals(entityNumber) || "PKJP6FA0=V1".equals(entityNumber)) {
            return false;
        }
        return StringUtils.isNumeric((String)entityNumber);
    }

    public static void verifyFuncPermPassTemp(FuncPermItemEnum item, String appid, String entityNumber) {
        if (!NoCodePermHelper.isNoCodeForm(entityNumber)) {
            boolean check = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), null, (String)entityNumber, (String)item.getId());
            if (!check) {
                throw new RestApiException(ResManager.loadKDString((String)"\u6743\u9650\u4e0d\u8db3", (String)"NoCodePermHelper_0", (String)"bos-nocode-common", (Object[])new Object[0]));
            }
            return;
        }
        if (NcEntityTypeUtil.queryTemplateAppIds().contains(appid)) {
            return;
        }
        NoCodePermHelper.verifyFuncPerm(RequestContext.get().getCurrUserId(), item, entityNumber);
    }

    public static void verifyFuncPerm(FuncPermItemEnum item, String formid) {
        NoCodePermHelper.verifyFuncPerm(RequestContext.get().getCurrUserId(), item, formid);
    }

    public static void verifyFuncPerm(Long user, FuncPermItemEnum item, String formid) {
        boolean check = NoCodePermHelper.checkFuncPerm(item, formid, user);
        if (!check) {
            throw new RestApiException(ResManager.loadKDString((String)"\u6743\u9650\u4e0d\u8db3", (String)"NoCodePermHelper_0", (String)"bos-nocode-common", (Object[])new Object[0]));
        }
    }

    @NotNull
    public static List<QFilter> getDataPermFilters(String formId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!NoCodePermHelper.isNoCodeForm(formId)) {
            return filters;
        }
        long userId = RequestContext.get().getCurrUserId();
        try {
            logger.info("\u8c03\u7528\u6570\u636e\u6743\u9650\u4e4b\u524dfilters={}", filters);
            filters.add(NoCodePermissionServiceHelper.getDataRuleFilter((long)userId, (String)formId, (PermItemEnum)PermItemEnum.of((String)FuncPermItemEnum.view.getId())));
            logger.info("\u8c03\u7528\u6570\u636e\u6743\u9650\u4e4b\u540efilters={}", filters);
            return filters;
        }
        catch (Exception e) {
            throw new RestApiException(RestApiErrorCode.ERROR, e.getMessage(), e);
        }
    }

    public static Map<String, Object> queryManagePerm(String appId) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        long uid = RequestContext.get().getCurrUserId();
        CompletableFuture<Boolean> manage = CompletableFuture.supplyAsync(() -> NoCodePermHelper.checkUserAppManageInNoCode(uid, appId), pool);
        CompletableFuture<Boolean> use = CompletableFuture.supplyAsync(() -> NoCodePermHelper.checkUserAppUseInNoCode(uid, appId), pool);
        CompletableFuture.allOf(manage, use).join();
        try {
            result.put("manage", manage.get());
            result.put("use", use.get());
        }
        catch (Exception e) {
            throw new RestApiException(e);
        }
        return result;
    }

    public static boolean checkUserAppCreateInNoCode() {
        long uid = RequestContext.get().getCurrUserId();
        return NoCodePermHelper.checkUserPlatManageInNoCode() || NoCodePermHelper.checkUserAppUseInNoCode(uid, "2HGKTA7HH43C");
    }

    public static boolean checkUserPlatManageInNoCode() {
        long uid = RequestContext.get().getCurrUserId();
        return PermissionServiceHelper.isAdminUser((long)uid) || NoCodePermHelper.checkUserAppManageInNoCode(uid, "2HGKTA7HH43C");
    }

    public static boolean checkUserAppManageInNoCode(Long uid, String appId) {
        try {
            return NoCodePermissionServiceHelper.getManageAppIds((long)uid).contains(appId);
        }
        catch (Exception e) {
            throw new RestApiException(RestApiErrorCode.ERROR, e.getMessage(), e);
        }
    }

    public static boolean checkUserAppUseInNoCode(Long uid, String appId) {
        try {
            return NoCodePermissionServiceHelper.getUsableAppIds((long)uid).contains(appId);
        }
        catch (Exception e) {
            throw new RestApiException(RestApiErrorCode.ERROR, e.getMessage(), e);
        }
    }

    public static void queryFuncPermItems(String formId, HashMap<String, Object> ret) {
        long uid = RequestContext.get().getCurrUserId();
        try {
            NoCodePermissionServiceHelper.getPermItems((long)uid, (String)formId).stream().filter(e -> FuncPermItemEnum.getById(e) != null).forEach(entry -> ret.put(FuncPermItemEnum.getById(entry).getNumber(), true));
            Arrays.stream(FuncPermItemEnum.values()).filter(i -> !ret.containsKey(i.getNumber())).forEach(i -> ret.put(i.getNumber(), false));
        }
        catch (Exception e2) {
            throw new RestApiException(RestApiErrorCode.ERROR, e2.getMessage(), e2);
        }
    }

    public static void changeAdminRole(String appId, long userId, long oldUserId) {
        List roles = NoCodePermissionServiceHelper.getRoleByAppId((String)appId);
        Optional<Role> admin = roles.stream().filter(Role::isSystem).findFirst();
        Role role = admin.get();
        RolePerm rolePerm = NoCodePermissionServiceHelper.getRolePerm((String)role.getId());
        rolePerm.getAssignUserIds().remove(oldUserId);
        if (rolePerm.getAssignUserIds().add(userId)) {
            NoCodePermissionServiceHelper.saveRolePerm((RolePerm)rolePerm);
            if (!rolePerm.getErrors().isEmpty()) {
                logger.debug("\u751f\u6210\u5e94\u7528\u7ba1\u7406\u5458\u5931\u8d25:\n" + JSONObject.toJSONString((Object)rolePerm.getErrors()));
                throw new RestApiException(ResManager.loadKDString((String)"\u751f\u6210\u5e94\u7528\u7ba1\u7406\u5458\u5931\u8d25:", (String)"NoCodePermHelper_1", (String)"bos-nocode-common", (Object[])new Object[0]) + JSONObject.toJSONString((Object)rolePerm.getErrors()));
            }
        }
    }

    public static void genAdminRole(String appid) {
        List roles = NoCodePermissionServiceHelper.getRoleByAppId((String)appid);
        Optional<Role> admin = roles.stream().filter(Role::isSystem).findFirst();
        long uid = RequestContext.get().getCurrUserId();
        if (!admin.isPresent()) {
            NoCodePermHelper.genAdminRole(uid, appid);
        } else {
            Role role = admin.get();
            RolePerm rolePerm = NoCodePermissionServiceHelper.getRolePerm((String)role.getId());
            if (rolePerm.getAssignUserIds().add(uid)) {
                NoCodePermissionServiceHelper.saveRolePerm((RolePerm)rolePerm);
                if (!rolePerm.getErrors().isEmpty()) {
                    logger.debug("\u751f\u6210\u5e94\u7528\u7ba1\u7406\u5458\u5931\u8d25:\n" + JSONObject.toJSONString((Object)rolePerm.getErrors()));
                    throw new RestApiException(ResManager.loadKDString((String)"\u751f\u6210\u5e94\u7528\u7ba1\u7406\u5458\u5931\u8d25:", (String)"NoCodePermHelper_1", (String)"bos-nocode-common", (Object[])new Object[0]) + JSONObject.toJSONString((Object)rolePerm.getErrors()));
                }
            }
        }
    }

    public static void genAdminRole(Long uid, String appid) {
        RolePerm role = new RolePerm();
        role.setAppId(appid);
        role.setSortCode(0);
        role.setSystem(true);
        role.setAppUseType(AppUseTypeEnum.ALL);
        role.setAppManageType(AppManageTypeEnum.ALL);
        role.setName(ResManager.loadKDString((String)"\u7ba1\u7406\u5458", (String)"NoCodePermHelper_2", (String)"bos-nocode-common", (Object[])new Object[0]));
        role.setAssignUserIds(Collections.singleton(uid));
        NoCodePermissionServiceHelper.saveRolePerm((RolePerm)role);
        if (!role.getErrors().isEmpty()) {
            logger.debug("\u751f\u6210\u5e94\u7528\u7ba1\u7406\u5458\u5931\u8d25:\n" + JSONObject.toJSONString((Object)role.getErrors()));
            throw new RestApiException(ResManager.loadKDString((String)"\u751f\u6210\u5e94\u7528\u7ba1\u7406\u5458\u5931\u8d25:", (String)"NoCodePermHelper_1", (String)"bos-nocode-common", (Object[])new Object[0]) + JSONObject.toJSONString((Object)role.getErrors()));
        }
    }

    public static void delAppRoles(String appId) {
        pool.execute(() -> NoCodePermissionServiceHelper.getRoleByAppId((String)appId).forEach(NoCodePermissionServiceHelper::deleteRole));
    }

    public static String getRoleName(String origin) {
        return origin.split(ROLE_NAME_SPLIT_REG)[0];
    }

    public static String setRoleName(String origin, String id) {
        return origin + ROLE_NAME_SPLIT + id;
    }

    public static boolean checkPublishEnt(String appId, String formId) {
        if (!NoCodePermHelper.isCrossApp(appId, formId)) {
            return true;
        }
        Map appliedAppPerm = NoCodePermissionServiceHelper.getAppliedAppPerm(Collections.singletonList(appId));
        Set formids = appliedAppPerm.getOrDefault(appId, Collections.emptySet());
        return formids.contains(formId);
    }

    private static boolean isCrossApp(String appId, String formId) {
        QFilter idFilter = new QFilter(ID, "=", (Object)formId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)BOS_DEVPN_FORMMETA, (String)BIZ_APPID, (QFilter[])new QFilter[]{idFilter});
        return Objects.nonNull(dynamicObject) && !appId.equalsIgnoreCase(dynamicObject.getString(BIZ_APPID));
    }

    public static QFilter[] combinePermFilter(String appId, String formId, QFilter[] filters) {
        try {
            List<QFilter> permFilters;
            if (!NcEntityTypeUtil.queryTemplateAppIds().contains(appId) && CollectionUtils.isNotEmpty(permFilters = NoCodePermHelper.getDataPermFilters(formId))) {
                filters = (QFilter[])ArrayUtils.addAll((Object[])filters, (Object[])permFilters.toArray(new QFilter[0]));
                logger.debug("\u6743\u9650\u8fc7\u6ee4\u5668filter={}", (Object)Arrays.toString(permFilters.toArray()));
            }
            return filters;
        }
        catch (Exception e) {
            logger.debug("combine perm filter error: {}", (Object)e.getMessage(), (Object)e);
            return filters;
        }
    }
}

