/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;

public class NoCodeTreeNode
implements Serializable {
    private String label;
    private String value;
    private String parentId;
    private boolean selectable = true;
    private List<NoCodeTreeNode> children = new ArrayList<NoCodeTreeNode>();
    private Map<String, Object> customParams = new HashMap<String, Object>();

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public NoCodeTreeNode() {
    }

    public NoCodeTreeNode(String label, String value, String parentId, List<NoCodeTreeNode> children) {
        this.label = label;
        this.value = value;
        this.parentId = parentId;
        this.children = children;
    }

    public NoCodeTreeNode getTreeNode(String id, int maxLevel) {
        if (StringUtils.equalsIgnoreCase((CharSequence)this.getValue(), (CharSequence)id)) {
            return this;
        }
        if (maxLevel > 0 && this.getChildren() != null) {
            for (NoCodeTreeNode child : this.getChildren()) {
                NoCodeTreeNode node = child.getTreeNode(id, maxLevel - 1);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    public void addChild(NoCodeTreeNode child) {
        if (this.children == null) {
            this.children = new ArrayList<NoCodeTreeNode>();
        }
        this.children.add(child);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public List<NoCodeTreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<NoCodeTreeNode> children) {
        this.children = children;
    }

    public Map<String, Object> getCustomParams() {
        return this.customParams;
    }

    public void setCustomParams(Map<String, Object> customParams) {
        this.customParams = customParams;
    }
}

