/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.security.SecureRandom;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.utils.NcHttpClientUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.PasswordEncryptUtil;

public abstract class OpenApiAuthUtil {
    private static final Log logger = LogFactory.getLog(OpenApiAuthUtil.class);
    private static final String PW_PATTERN = "^(?![A-Za-z0-9_]+$)(?![a-z0-9_\\W]+$)(?![A-Za-z_\\W]+$)(?![A-Z0-9_\\W]+$)[a-zA-Z0-9_\\W]{16,50}$";
    private static final String[] a = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static final String[] b = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    private static final String[] c = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final String[] d = new String[]{"~", "!", "@", "#", "$", "^", "&", "*", "+", "=", "-", ",", "?", ":"};
    private static final String _cacheType = "nocode_openapi_access_token";
    private static final String _cacheKey_access_token = "nocode_openapi_access_token";
    private static final String ACCESS_TOKEN = "access_token";
    private static int default_connectionTimeout = Integer.getInteger("httpclient.connectionTimeout", 30000);
    private static int default_readTimeout = Integer.getInteger("httpclient.readTimeout", 60000);

    public static Map<String, Object> getAccessToken() {
        JSONObject resData;
        HashMap<String, Object> map = new HashMap<String, Object>();
        String accessToken = "";
        accessToken = OpenApiAuthUtil.getCacheToken();
        if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
            map.put(ACCESS_TOKEN, accessToken);
            return map;
        }
        String urlCosmic = UrlService.getDomainContextUrl();
        String getAppTokenUrl = urlCosmic + "/api/getAppToken.do";
        String getAccessTokenUrl = urlCosmic + "/api/login.do";
        String appToken = "";
        HashMap<String, String> header = new HashMap<String, String>();
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("appId", "nocode");
        body.put("appSecuret", OpenApiAuthUtil.getOrCreateSC());
        body.put("tenantid", RequestContext.get().getTenantId());
        body.put("accountId", RequestContext.get().getAccountId());
        body.put("language", RequestContext.get().getLang());
        String res = null;
        try {
            res = NcHttpClientUtils.postjson(getAppTokenUrl, header, body, default_connectionTimeout, default_readTimeout, true);
        }
        catch (IOException e) {
            logger.debug("getAccessTokenByAppId et:" + e.getMessage());
        }
        JSONObject resb = JSON.parseObject((String)res);
        if ("success".equalsIgnoreCase(resb.getString("state"))) {
            JSONObject resData2 = resb.getJSONObject("data");
            if (resData2 != null && StringUtils.isNotEmpty((CharSequence)resData2.getString("app_token"))) {
                appToken = resData2.getString("app_token");
            }
        } else if ("error".equalsIgnoreCase(resb.getString("state"))) {
            map.put("request", resb);
            map.put(ACCESS_TOKEN, null);
            return map;
        }
        header = new HashMap();
        body = new HashMap();
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getUserId(), (String)"bos_user");
        if (ObjectUtils.isEmpty((Object)user.get("phone"))) {
            map.put("request", "user phone is null");
            map.put(ACCESS_TOKEN, null);
            return map;
        }
        body.put("user", user.get("phone"));
        body.put("apptoken", appToken);
        body.put("tenantid", RequestContext.get().getTenantId());
        body.put("accountId", RequestContext.get().getAccountId());
        body.put("usertype", "Mobile");
        res = null;
        try {
            res = NcHttpClientUtils.postjson(getAccessTokenUrl, header, body, default_connectionTimeout, default_readTimeout, true);
        }
        catch (IOException e) {
            logger.debug("et:" + e.getMessage());
        }
        resb = JSON.parseObject((String)res);
        if ("success".equalsIgnoreCase(resb.getString("state")) && (resData = resb.getJSONObject("data")) != null && StringUtils.isNotEmpty((CharSequence)resData.getString(ACCESS_TOKEN))) {
            accessToken = resData.getString(ACCESS_TOKEN);
            OpenApiAuthUtil.cacheAccessToken(accessToken);
            map.put(ACCESS_TOKEN, accessToken);
            return map;
        }
        return map;
    }

    public static String getOrCreateSC() {
        String sql = "select FID, fbackimage from t_meta_bizcloud where FID = ? ";
        Object[] sqlParas = new SqlParameter[]{new SqlParameter("FID", 12, (Object)"2HGKCE94QELW")};
        String scExist = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])sqlParas, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws SQLException {
                String sc = null;
                while (rs.next()) {
                    sc = rs.getString("fbackimage");
                }
                return sc;
            }
        });
        if (StringUtils.isBlank((CharSequence)scExist)) {
            String newSc = null;
            for (int i = 0; i < 5; ++i) {
                String s = OpenApiAuthUtil.generatePwCode();
                if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                newSc = s;
                break;
            }
            if (StringUtils.isNotBlank(newSc)) {
                String sqlU = "update t_meta_bizcloud set fbackimage = ? where fid = ?";
                DB.execute((DBRoute)DBRoute.meta, (String)sqlU, (Object[])new SqlParameter[]{new SqlParameter("fbackimage", 12, (Object)Encrypters.encode((String)newSc)), new SqlParameter("FID", 12, (Object)"2HGKCE94QELW")});
                String encryptePw = PasswordEncryptUtil.getEncryptePasswordWithSalt((String)newSc);
                String sqlOpenApp = "update t_open_3rdapps set fsyspwd = ? where fid = ?";
                DB.execute((DBRoute)DBRoute.basedata, (String)sqlOpenApp, (Object[])new SqlParameter[]{new SqlParameter("fsyspwd", 12, (Object)encryptePw), new SqlParameter("fid", -5, (Object)1837773202850438144L)});
            }
            return newSc;
        }
        return Encrypters.decode((String)scExist);
    }

    public static String generatePwCode() {
        SecureRandom secureRandom = new SecureRandom();
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        OpenApiAuthUtil.orderlyList(list, secureRandom);
        OpenApiAuthUtil.disorderList(list, secureRandom, sb);
        list.clear();
        if (sb.toString().matches(PW_PATTERN)) {
            return sb.toString();
        }
        return null;
    }

    private static void orderlyList(List<String> list, SecureRandom secureRandom) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            String a1 = a[secureRandom.nextInt(a.length)];
            String b1 = b[secureRandom.nextInt(b.length)];
            String c1 = c[secureRandom.nextInt(c.length)];
            String d1 = d[secureRandom.nextInt(d.length)];
            list.add(i + n, a1);
            list.add(i + ++n, b1);
            list.add(i + ++n, c1);
            list.add(i + ++n, d1);
        }
    }

    private static StringBuilder disorderList(List<String> list, SecureRandom secureRandom, StringBuilder sb) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            int index = secureRandom.nextInt(list.size());
            String str = list.get(index);
            sb.append(str);
            list.remove(index);
        }
        return sb;
    }

    private static void cacheAccessToken(String token) {
        String apptokenTimeout = System.getProperty("apptoken.timeout");
        int timeout = 7200;
        if (StringUtils.isNotEmpty((CharSequence)apptokenTimeout)) {
            timeout = Integer.parseInt(apptokenTimeout);
        }
        try {
            CacheConfigInfo localConfig = new CacheConfigInfo();
            localConfig.setTimeout(timeout - 100);
            LocalMemoryCache localcache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(OpenApiAuthUtil.getCacheRegion(), "nocode_openapi_access_token", localConfig);
            localcache.put("nocode_openapi_access_token", (Object)token);
        }
        catch (Exception e) {
            logger.debug("getLocalcache failed:" + e.getMessage());
        }
    }

    public static String getCacheToken() {
        try {
            LocalMemoryCache localcache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(OpenApiAuthUtil.getCacheRegion(), "nocode_openapi_access_token");
            Object token = localcache.get("nocode_openapi_access_token");
            return token == null ? null : token.toString();
        }
        catch (Exception e) {
            logger.debug("getLocalcache failed:" + e.getMessage());
            return null;
        }
    }

    private static String getCacheRegion() {
        return "nocode_OpenAPI".concat(RequestContext.get().getAccountId());
    }
}

