/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.LongProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.info.OrderByInfo;
import kd.bos.nocode.restapi.common.util.JsonUtil;
import kd.bos.nocode.utils.NcEntityTypeUtil;
import kd.bos.nocode.utils.NoCodeTreeNode;
import kd.bos.nocode.utils.OpenApiAuthUtil;
import kd.bos.nocode.utils.ShowColumnInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.url.UrlService;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public abstract class OpenApiUtil {
    private static final Log logger = LogFactory.getLog(OpenApiUtil.class);
    private static final String OPENAPI_APILIST = "openapi_apilist";
    private static final String ROOT_ID = "root_id";
    public static final int NUMBER_OF_MAP = 10;
    public static final String OPTION_MUSTINPUT = "mustInput";
    public static final String OPTION_CANORDER = "canOrder";
    public static final String OPTION_ONLYORDER = "onlyOrder";
    private static final String OPENAPI_MESSAGE = "OpenApi-Message";
    private static final String UTF8 = "UTF-8";
    public static final String LIMIT_FLOW_MESSAGE = "Too many request, Flow Limit is exceed.";
    private static final Set<String> DATETYPE_SUPPERED = new HashSet<String>(Arrays.asList("Long", "int", "Short", "Integer", "Decimal", "Double", "Float", "String", "Boolean", "DateTime", "Date"));
    private static final String OPEN_SYS_PARAMS_APPID = "W3NF+MX967M";
    private static final String OPEN_SYS_PARAMS_VIEW_TYPE = "15";
    private static final Long OPEN_SYS_PARAMS_ORG_ID = 100000L;
    private static final Long OPEN_SYS_PARAMS_ACT_BOOK_ID = 0L;
    private static final String MAX_PAGE_SIZE = "api_query_maxpagesize";
    private static final String ACCESS_TOKEN = "accessToken";
    private static final String X_OPENAPI_QUERYID = "X-OpenApi-QueryId";
    private static final Integer TIME_OUT = 60000;
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String APPLICATION_JSON = "application/json";
    private static final String MESSAGE = "message";
    private static final String TIMES = "times";
    private static final String STATUSCODE = "statusCode";
    private static final String KAPI = "/kapi";
    private static final String DATA = "data";
    private static final String ROWS = "rows";
    private static final String LASTPAGE = "lastPage";
    private static final String ERRORCODE = "errorCode";
    public static final String OPTION_API_OUT_PROP_NAME = "Api_OutPropName";

    public static boolean isApiExist(String apiId) {
        if (StringUtils.isBlank((CharSequence)apiId)) {
            return false;
        }
        MainEntityType dt = NcEntityTypeUtil.getDataEntityType(OPENAPI_APILIST);
        Object apiPk = NcEntityTypeUtil.convertPKValueType((DynamicObjectType)dt, apiId);
        return QueryServiceHelper.exists((String)OPENAPI_APILIST, (Object)apiPk);
    }

    public static String getFormIdByApiId(String apiId) {
        if (StringUtils.isBlank((CharSequence)apiId)) {
            return null;
        }
        DynamicObject apiObj = OpenApiUtil.getOpenApiDefine(apiId, null);
        if (apiObj == null) {
            return null;
        }
        return apiObj.getString("bizobject.id");
    }

    public static String getFormCaptionByApiId(String apiId) {
        if (StringUtils.isBlank((CharSequence)apiId)) {
            return null;
        }
        DynamicObject apiObj = OpenApiUtil.getOpenApiDefine(apiId, null);
        if (apiObj == null) {
            return null;
        }
        return apiObj.getString("bizobject.name");
    }

    public static NoCodeTreeNode buildRefOpenApiTreeData(String httpmethod) {
        NoCodeTreeNode root = new NoCodeTreeNode(ResManager.loadKDString((String)"\u5168\u90e8", (String)"OpenApiUtil_0", (String)"bos-nocode-common", (Object[])new Object[0]), ROOT_ID, "", null);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        QFilter serviceTypeFilter = new QFilter("apiservicetype", "=", (Object)Character.valueOf('0'));
        filters.add(serviceTypeFilter);
        QFilter bizobjectFilter = new QFilter("bizobject", "is not null", null);
        filters.add(bizobjectFilter);
        QFilter statusFilter = new QFilter("status", "=", (Object)Character.valueOf('C'));
        filters.add(statusFilter);
        QFilter versionFilter = new QFilter("version", "=", (Object)Character.valueOf('2'));
        filters.add(versionFilter);
        QFilter httpmethodFilter = new QFilter("httpmethod", "=", (Object)httpmethod);
        filters.add(httpmethodFilter);
        DynamicObjectCollection apis = QueryServiceHelper.query((String)OPENAPI_APILIST, (String)"id,number,name,httpmethod,operation,urlformat,bizobject.id, bizobject.name, appid.id, appid.name,appid.bizcloud.name,appid.bizcloud.id", (QFilter[])filters.toArray(new QFilter[0]), (String)"appid.bizcloud.name asc, appid.name asc, bizobject.name asc, name asc");
        NoCodeTreeNode lastCloudNode = null;
        NoCodeTreeNode lastAppNode = null;
        NoCodeTreeNode lastBizObjNode = null;
        for (DynamicObject obj : apis) {
            String cloudName = obj.getString("appid.bizcloud.name");
            String cloudId = obj.getString("appid.bizcloud.id");
            String appName = obj.getString("appid.name");
            String appId = obj.getString("appid.id");
            String bizObjName = obj.getString("bizobject.name");
            String bizObjId = obj.getString("bizobject.id");
            if (StringUtils.isBlank((CharSequence)cloudName) || StringUtils.isBlank((CharSequence)appName) || StringUtils.isBlank((CharSequence)bizObjName)) continue;
            if (lastCloudNode == null || !lastCloudNode.getLabel().equalsIgnoreCase(cloudName)) {
                lastCloudNode = new NoCodeTreeNode(cloudName, cloudId, ROOT_ID, null);
                root.addChild(lastCloudNode);
                lastCloudNode.setSelectable(false);
            }
            if (lastAppNode == null || !lastAppNode.getLabel().equalsIgnoreCase(appName)) {
                lastAppNode = new NoCodeTreeNode(appName, appId, cloudId, null);
                lastAppNode.setSelectable(false);
                lastCloudNode.addChild(lastAppNode);
            }
            if (lastBizObjNode == null || !lastBizObjNode.getLabel().equalsIgnoreCase(bizObjName)) {
                lastBizObjNode = new NoCodeTreeNode(bizObjName, bizObjId, appId, null);
                lastBizObjNode.setSelectable(false);
                lastAppNode.addChild(lastBizObjNode);
            }
            String apiId = obj.getString("id");
            String apiName = obj.getString("name");
            NoCodeTreeNode apiNode = new NoCodeTreeNode(apiName, apiId, bizObjId, null);
            lastBizObjNode.addChild(apiNode);
        }
        return root;
    }

    public static boolean isOpenApiListItem(String apiId) {
        return QueryServiceHelper.exists((String)OPENAPI_APILIST, (Object)apiId);
    }

    public static List<ShowColumnInfo> getOpenApiInParams(String apiId, boolean includeOrder) {
        DynamicObjectCollection orderbyEntry;
        MainEntityType dt = NcEntityTypeUtil.getDataEntityType(OPENAPI_APILIST);
        DynamicObject apiObj = OpenApiUtil.getOpenApiDefine(apiId, null);
        if (apiObj == null) {
            return null;
        }
        DynamicObjectCollection bodyentryentity = (DynamicObjectCollection)apiObj.get("bodyentryentity");
        if (bodyentryentity == null || bodyentryentity.isEmpty()) {
            return null;
        }
        ArrayList<ShowColumnInfo> columnInfos = new ArrayList<ShowColumnInfo>(bodyentryentity.size());
        DynamicObjectCollection filterEntity = (DynamicObjectCollection)apiObj.get("filter_entity");
        for (DynamicObject bodyEntry : bodyentryentity) {
            String paramname = bodyEntry.getString("paramname");
            boolean must = bodyEntry.getBoolean("must");
            String paramType = bodyEntry.getString("paramtype");
            String example = bodyEntry.getString("example");
            String body_level = bodyEntry.getString("body_level");
            String objpropname = bodyEntry.getString("objpropname");
            String is_body_custom = bodyEntry.getString("is_body_custom");
            String body_data_model = bodyEntry.getString("body_data_model");
            String is_req_mul_value = bodyEntry.getString("is_req_mul_value");
            String bodyparamdes = bodyEntry.getString("bodyparamdes");
            IDataEntityProperty filterItemProperty = null;
            Optional<DynamicObject> filterItem = filterEntity.stream().filter(fe -> objpropname.equalsIgnoreCase(fe.getString("filter_value"))).findFirst();
            if (filterItem.isPresent()) {
                DynamicObject filterItemObj = filterItem.get();
                String filterColumn = filterItemObj.getString("filter_column");
                filterItemProperty = dt.findProperty(filterColumn);
            }
            ShowColumnInfo info = new ShowColumnInfo();
            info.setId(paramname);
            info.setCaption(bodyparamdes);
            OpenApiUtil.parseTypeOption(info, paramType, filterItemProperty);
            if (must) {
                info.getOption().put(OPTION_MUSTINPUT, Boolean.TRUE);
            }
            columnInfos.add(info);
        }
        if (includeOrder && (orderbyEntry = (DynamicObjectCollection)apiObj.get("orderby_entry")) != null && !orderbyEntry.isEmpty()) {
            for (DynamicObject bodyEntry : orderbyEntry) {
                String orderField = bodyEntry.getString("order_field");
                if (columnInfos.stream().anyMatch(c -> c.getId().equalsIgnoreCase(orderField))) continue;
                String orderDesc = bodyEntry.getString("order_desc");
                IDataEntityProperty property = dt.findProperty(orderField);
                if (property == null) continue;
                ShowColumnInfo info = new ShowColumnInfo();
                info.setId(orderField);
                info.setCaption(orderDesc);
                OpenApiUtil.parseTypeOption(info, null, property);
                columnInfos.add(info);
            }
        }
        return columnInfos;
    }

    public static List<OrderByInfo> getOpenApiOrderInfo(String apiId) {
        MainEntityType dt = NcEntityTypeUtil.getDataEntityType(OPENAPI_APILIST);
        DynamicObject apiObj = OpenApiUtil.getOpenApiDefine(apiId, null);
        if (apiObj == null) {
            return null;
        }
        DynamicObjectCollection orderbyEntry = (DynamicObjectCollection)apiObj.get("orderby_entry");
        if (orderbyEntry == null || orderbyEntry.isEmpty()) {
            return null;
        }
        ArrayList<OrderByInfo> orderByInfos = new ArrayList<OrderByInfo>(orderbyEntry.size());
        for (DynamicObject bodyEntry : orderbyEntry) {
            String orderField = bodyEntry.getString("order_field");
            String orderMode = bodyEntry.getString("order_mode");
            String orderDesc = bodyEntry.getString("order_desc");
            OrderByInfo info = new OrderByInfo();
            info.setNumber(orderField);
            info.setName(orderDesc);
            info.setAsc("asc".equalsIgnoreCase(orderMode));
            orderByInfos.add(info);
        }
        return orderByInfos;
    }

    public static List<ShowColumnInfo> getOpenApiOutParams(String apiId) {
        MainEntityType dt = NcEntityTypeUtil.getDataEntityType(OPENAPI_APILIST);
        DynamicObject apiObj = OpenApiUtil.getOpenApiDefine(apiId, null);
        if (apiObj == null) {
            return null;
        }
        DynamicObjectCollection respentryentity = (DynamicObjectCollection)apiObj.get("respentryentity");
        if (respentryentity == null || respentryentity.isEmpty()) {
            return null;
        }
        ArrayList<ShowColumnInfo> columnInfos = new ArrayList<ShowColumnInfo>(respentryentity.size());
        for (DynamicObject bodyEntry : respentryentity) {
            String paramname = bodyEntry.getString("respparamname");
            String respdes = bodyEntry.getString("respdes");
            String paramType = bodyEntry.getString("respparamtype");
            String body_level = bodyEntry.getString("resp_level");
            String objpropname = bodyEntry.getString("respobjpropname");
            if (!"1".equalsIgnoreCase(body_level) || !OpenApiUtil.isSupperType(paramType)) continue;
            IDataEntityProperty filterItemProperty = null;
            if (StringUtils.isBlank((CharSequence)objpropname)) {
                filterItemProperty = dt.findProperty(objpropname);
            }
            ShowColumnInfo info = new ShowColumnInfo();
            info.setId(paramname);
            info.setCaption(respdes);
            OpenApiUtil.parseTypeOption(info, paramType, filterItemProperty);
            if (!paramname.equalsIgnoreCase(objpropname)) {
                info.getOption().put(OPTION_API_OUT_PROP_NAME, objpropname);
            }
            info.getOption().put("ownerFormId", apiId);
            info.getOption().put("cannotSelect", true);
            columnInfos.add(info);
        }
        ISimpleProperty primaryKey = dt.getPrimaryKey();
        if (primaryKey != null) {
            ShowColumnInfo pkInfo = columnInfos.stream().filter(c -> c.getId().equalsIgnoreCase(primaryKey.getName())).findFirst().orElseGet(() -> null);
            String dataType = NcEntityTypeUtil.getDataType((IDataEntityProperty)primaryKey);
            String dataTypeCaption = NcEntityTypeUtil.getDataTypeCaption((IDataEntityProperty)primaryKey);
            if (pkInfo == null) {
                pkInfo = new ShowColumnInfo(primaryKey.getName(), primaryKey.getName(), false, dataType, dataTypeCaption);
                columnInfos.add(pkInfo);
            } else {
                pkInfo.setType(dataType);
                pkInfo.setTypeCaption(dataTypeCaption);
                pkInfo.setVisible(false);
            }
            pkInfo.getOption().put("ownerFormId", apiId);
            pkInfo.getOption().put("cannotSelect", true);
        }
        return columnInfos;
    }

    private static boolean isSupperType(String paramType) {
        return DATETYPE_SUPPERED.stream().anyMatch(t -> t.equalsIgnoreCase(paramType));
    }

    private static DynamicObject getOpenApiDefine(String apiId, MainEntityType dt) {
        if (StringUtils.isBlank((CharSequence)apiId)) {
            return null;
        }
        if (dt == null) {
            dt = NcEntityTypeUtil.getDataEntityType(OPENAPI_APILIST);
        }
        Object id = NcEntityTypeUtil.convertPKValueType((DynamicObjectType)dt, apiId);
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)OPENAPI_APILIST);
    }

    private static void parseTypeOption(ShowColumnInfo info, String paramType, IDataEntityProperty prop) {
        String type = null;
        if (prop != null) {
            Object valueItemsObj;
            info.getOption().putAll(NcEntityTypeUtil.defaultOptionCustom(prop));
            type = NcEntityTypeUtil.getDataType(prop);
            if ("pk".equalsIgnoreCase(type)) {
                type = prop instanceof LongProp ? "number" : "text";
            } else if ("combo".equalsIgnoreCase(type) && (!((valueItemsObj = info.getOption().get("valueItems")) instanceof List) || ((List)valueItemsObj).isEmpty())) {
                type = "text";
                info.getOption().put("editorType", "TextField");
                info.getOption().remove("valueItems");
            }
        }
        if (StringUtils.isBlank(type)) {
            if ("Date".equalsIgnoreCase(paramType)) {
                type = "date";
                info.getOption().put("formatType", "1");
            } else if ("DateTime".equalsIgnoreCase(paramType)) {
                type = "date";
                info.getOption().put("formatType", "0");
            } else if ("Boolean".equalsIgnoreCase(paramType)) {
                type = "combo";
                info.getOption().put("valueItems", CheckBoxEnum.getComboItems());
            } else {
                type = "Decimal".equalsIgnoreCase(paramType) || "Float".equalsIgnoreCase(paramType) || "Double".equalsIgnoreCase(paramType) || "Long".equalsIgnoreCase(paramType) || "Integer".equalsIgnoreCase(paramType) || "int".equalsIgnoreCase(paramType) ? "number" : "text";
            }
        }
        info.setType(type);
        info.setTypeCaption(NcEntityTypeUtil.getDataTypeCaption(type, info.getOption()));
    }

    public static Map<String, Object> getDataByOpenApi(String apiId, String formId, Map<Object, String> paramMap, Integer topNumber, boolean isMulti) {
        if (isMulti) {
            return OpenApiUtil.getDataByOpenApi2Multi(apiId, formId, paramMap, topNumber);
        }
        return OpenApiUtil.getDataByOpenApi2One(apiId, paramMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getDataByOpenApi2One(String apiId, Map<Object, String> paramMap) {
        DynamicObject apiObj = OpenApiUtil.getOpenApiDefine(apiId, null);
        if (apiObj == null) {
            return null;
        }
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = null;
        try {
            Map<String, Object> map = OpenApiAuthUtil.getAccessToken();
            if (null == map.get("access_token")) {
                throw new KDBizException(map.get("request").toString());
            }
            String accessToken = map.get("access_token").toString();
            httpClient = HttpClientBuilder.create().build();
            Map<Object, String> pixedParamMap = OpenApiUtil.fixupParamValue(apiObj, paramMap);
            String fullUrl = OpenApiUtil.urlFormart(true, apiObj.getString("urlformat"), pixedParamMap, false);
            fullUrl = fullUrl + (fullUrl.indexOf(63) != -1 ? "&" : "?") + "pageNo=1&pageSize=1";
            Long startTime = System.currentTimeMillis();
            logger.info(fullUrl);
            response = OpenApiUtil.doGet(fullUrl, accessToken);
            Long endTime = System.currentTimeMillis();
            JSONObject jsonObject = OpenApiUtil.convertResponse2JSONObject(response, fullUrl);
            int statusCode = response.getStatusLine().getStatusCode();
            if (!jsonObject.containsKey((Object)MESSAGE)) {
                Header[] messages;
                for (Header header : messages = response.getHeaders(OPENAPI_MESSAGE)) {
                    if (!header.getName().equals(OPENAPI_MESSAGE)) continue;
                    String message = URLDecoder.decode(header.getValue(), UTF8);
                    jsonObject.put(MESSAGE, (Object)message);
                }
            }
            long time = endTime - startTime;
            jsonObject.put(TIMES, (Object)time);
            jsonObject.put(STATUSCODE, (Object)statusCode);
            JSONObject jSONObject = jsonObject;
            return jSONObject;
        }
        catch (Exception ex) {
            logger.warn((Throwable)ex);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                    httpClient.close();
                }
                catch (IOException e) {
                    logger.warn((Throwable)e);
                }
            }
        }
        return null;
    }

    public static Map<String, Object> getDataByOpenApi2Multi(String apiId, String formId, Map<Object, String> paramMap, Integer topNumber) {
        DynamicObject apiObj = OpenApiUtil.getOpenApiDefine(apiId, null);
        if (apiObj == null) {
            return null;
        }
        try {
            Map<String, Object> map = OpenApiAuthUtil.getAccessToken();
            if (null == map.get("access_token")) {
                throw new KDBizException(map.get("request").toString());
            }
            String accessToken = map.get("access_token").toString();
            Integer totalCount = topNumber;
            if (totalCount <= 0) {
                totalCount = 1000;
            }
            Long startTime = System.currentTimeMillis();
            Map<Object, String> pixedParamMap = OpenApiUtil.fixupParamValue(apiObj, paramMap);
            String fullUrl = OpenApiUtil.urlFormart(true, apiObj.getString("urlformat"), pixedParamMap, false);
            int maxPageSize = OpenApiUtil.getMaxPageSize();
            int pageNo = 1;
            JSONArray rows = new JSONArray();
            StringBuilder sbError = new StringBuilder();
            String errorCode = "0";
            int remainCount = totalCount;
            while (remainCount > 0) {
                Map<String, Object> dataPerPage = OpenApiUtil.getDataByOpenApi2MultiByPageNo(accessToken, fullUrl, maxPageSize, pageNo);
                if (dataPerPage != null && !dataPerPage.isEmpty()) {
                    Map data;
                    if (!"0".equalsIgnoreCase((String)dataPerPage.get(ERRORCODE)) && dataPerPage.get(MESSAGE) != null) {
                        if (((String)dataPerPage.get(MESSAGE)).contains(LIMIT_FLOW_MESSAGE)) {
                            Thread.sleep(300L);
                            continue;
                        }
                        sbError.append(dataPerPage.get(MESSAGE));
                        errorCode = (String)dataPerPage.get(ERRORCODE);
                    }
                    if ((data = (Map)dataPerPage.get(DATA)) != null && !data.isEmpty()) {
                        JSONArray r = (JSONArray)data.get(ROWS);
                        if (rows.size() + r.size() > totalCount) {
                            for (Object o : r) {
                                if (rows.size() < totalCount) {
                                    rows.add(o);
                                    continue;
                                }
                                break;
                            }
                        } else {
                            rows.addAll((Collection)((JSONArray)data.get(ROWS)));
                        }
                    }
                }
                remainCount -= maxPageSize;
                if (OpenApiUtil.isLastPage(dataPerPage)) break;
                ++pageNo;
            }
            HashMap<String, JSONArray> data = new HashMap<String, JSONArray>();
            data.put(ROWS, rows);
            Long endTime = System.currentTimeMillis();
            long time = endTime - startTime;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(TIMES, (Object)time);
            jsonObject.put(ERRORCODE, (Object)errorCode);
            jsonObject.put(MESSAGE, (Object)sbError.toString());
            jsonObject.put(DATA, data);
            return jsonObject;
        }
        catch (Exception ex) {
            logger.warn((Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> getDataByOpenApi2MultiByPageNo(String accessToken, String fullUrl, int maxPageSize, int pageNo) {
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClientBuilder.create().build();
            fullUrl = fullUrl + (fullUrl.indexOf(63) != -1 ? "&" : "?") + "pageNo=" + pageNo + "&pageSize=" + maxPageSize;
            Long startTime = System.currentTimeMillis();
            logger.info(fullUrl);
            response = OpenApiUtil.doGet(fullUrl, accessToken);
            Long endTime = System.currentTimeMillis();
            JSONObject jsonObject = OpenApiUtil.convertResponse2JSONObject(response, fullUrl);
            int statusCode = response.getStatusLine().getStatusCode();
            if (!jsonObject.containsKey((Object)MESSAGE)) {
                Header[] messages;
                for (Header header : messages = response.getHeaders(OPENAPI_MESSAGE)) {
                    if (!header.getName().equals(OPENAPI_MESSAGE)) continue;
                    String message = URLDecoder.decode(header.getValue(), UTF8);
                    jsonObject.put(MESSAGE, (Object)message);
                }
            }
            long time = endTime - startTime;
            jsonObject.put(TIMES, (Object)time);
            jsonObject.put(STATUSCODE, (Object)statusCode);
            JSONObject jSONObject = jsonObject;
            return jSONObject;
        }
        catch (Exception ex) {
            logger.warn((Throwable)ex);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                    httpClient.close();
                }
                catch (IOException e) {
                    logger.warn((Throwable)e);
                }
            }
        }
        return null;
    }

    private static JSONObject convertResponse2JSONObject(CloseableHttpResponse response, String fullUrl) {
        if (response == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38", (String)"OpenApiUtil_3", (String)"bos-nocode-common", (Object[])new Object[0]));
        }
        String result = null;
        try {
            result = EntityUtils.toString((HttpEntity)response.getEntity());
            logger.debug("nocode: queryByApi url:" + fullUrl + ";data:" + result);
        }
        catch (IOException e) {
            logger.warn((Throwable)e);
        }
        if (result == null) {
            return new JSONObject();
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = (JSONObject)JsonUtil.parseJson(result);
        }
        catch (Exception ex) {
            logger.warn((Throwable)ex);
            jsonObject = new JSONObject();
        }
        if (jsonObject == null) {
            jsonObject = new JSONObject();
        }
        return jsonObject;
    }

    private static boolean isLastPage(Map<String, Object> jsonObject) {
        boolean isLastPage = false;
        if (jsonObject == null) {
            return isLastPage;
        }
        Map data = (Map)jsonObject.get(DATA);
        if (data != null && !data.isEmpty()) {
            isLastPage = (Boolean)data.get(LASTPAGE);
        }
        return isLastPage;
    }

    private static int getMaxPageSize() {
        int iMaxCount = 1000;
        String queryMaxCount = OpenApiUtil.getOpenApiSystemParam(MAX_PAGE_SIZE, "api.mqc", "1000");
        if (queryMaxCount != null) {
            try {
                iMaxCount = Integer.parseInt(queryMaxCount);
                if (iMaxCount <= 0 || iMaxCount > 2000) {
                    iMaxCount = 1000;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return iMaxCount;
    }

    private static String getOpenApiSystemParam(String key, String mcKey, String defaultValue) {
        Object result;
        if (RequestContext.get() == null) {
            return null;
        }
        AppParam appParam = new AppParam(OPEN_SYS_PARAMS_APPID, OPEN_SYS_PARAMS_VIEW_TYPE, OPEN_SYS_PARAMS_ORG_ID, OPEN_SYS_PARAMS_ACT_BOOK_ID);
        Map paramMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        if (paramMap != null && (result = paramMap.getOrDefault(key, null)) != null) {
            return result.toString();
        }
        if (StringUtils.isNotBlank((CharSequence)mcKey)) {
            System.getProperty(mcKey, defaultValue);
        }
        return defaultValue;
    }

    private static Map<Object, String> fixupParamValue(DynamicObject apiObj, Map<Object, String> paramMap) {
        if (paramMap == null || paramMap.isEmpty()) {
            return paramMap;
        }
        DynamicObjectCollection bodyentryentity = (DynamicObjectCollection)apiObj.get("bodyentryentity");
        if (bodyentryentity == null || bodyentryentity.isEmpty()) {
            return paramMap;
        }
        HashMap<Object, String> newParamMap = new HashMap<Object, String>(paramMap.size());
        for (Map.Entry<Object, String> objectStringEntry : paramMap.entrySet()) {
            String fieldName = objectStringEntry.getValue();
            Object value = objectStringEntry.getKey();
            if (StringUtils.isBlank((CharSequence)fieldName) || value == null) continue;
            Object newValue = value;
            Optional<DynamicObject> first = bodyentryentity.stream().filter(b -> fieldName.equalsIgnoreCase(b.getString("paramname"))).findFirst();
            if (first.isPresent()) {
                DynamicObject obj = first.get();
                String paramType = obj.getString("paramtype");
                if ("Long".equalsIgnoreCase(paramType)) {
                    try {
                        newValue = Long.parseLong(value.toString());
                    }
                    catch (Exception ex) {
                        newValue = 0;
                        logger.warn((Throwable)ex);
                    }
                } else if ("Integer".equalsIgnoreCase(paramType) || "int".equalsIgnoreCase(paramType)) {
                    try {
                        newValue = Integer.parseInt(value.toString());
                    }
                    catch (Exception ex) {
                        newValue = 0;
                        logger.warn((Throwable)ex);
                    }
                }
            }
            newParamMap.put(newValue, fieldName);
        }
        return newParamMap;
    }

    private static String urlFormart(boolean isGetMethod, String urlFormat, Object preData, boolean isQueryParam) {
        String urlCosmic = UrlService.getDomainContextUrl();
        String preUrl = KAPI + urlFormat;
        if (isGetMethod) {
            Map<String, Object> getDataMap = OpenApiUtil.getMethodData(preData);
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Object> entry : getDataMap.entrySet()) {
                String value;
                if (sb.length() > 0) {
                    sb.append('&');
                }
                if ((value = entry.getKey()) instanceof JSONArray) {
                    JSONArray valArray = (JSONArray)value;
                    for (int i = 0; i < valArray.size(); ++i) {
                        sb.append(i == 0 ? "" : Character.valueOf('&')).append(entry.getValue()).append('=').append(valArray.get(i));
                    }
                    continue;
                }
                sb.append(entry.getValue()).append('=').append((Object)value);
            }
            if (isQueryParam) {
                return sb.toString().trim();
            }
            sb.insert(0, '?');
            sb.insert(0, preUrl);
            sb.insert(0, urlCosmic);
            String json = sb.toString().trim();
            return json;
        }
        String urlvalue = urlCosmic + preUrl;
        return urlvalue;
    }

    private static Map<String, Object> getMethodData(Object preData) {
        if (!(preData instanceof Map)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef", (String)"OpenApiUtil_4", (String)"bos-nocode-common", (Object[])new Object[0]));
        }
        Map map = (Map)preData;
        HashMap<String, Object> getDataMap = (HashMap<String, Object>)map.get(DATA);
        if (getDataMap == null) {
            getDataMap = new HashMap<String, Object>(map.size());
        }
        for (Map.Entry entry : map.entrySet()) {
            if (DATA.equals(entry.getKey())) continue;
            getDataMap.put((String)entry.getKey(), entry.getValue());
        }
        return getDataMap;
    }

    private static CloseableHttpResponse doGet(String url, String accessToken) throws Exception {
        if (null == RequestContext.get().getApi3rdAppId()) {
            RequestContext.get().setApi3rdAppId(QueryServiceHelper.queryOne((String)"openapi_3rdapps", (String)"id", (QFilter[])new QFilter("number", "=", (Object)"nocode").toArray()).getString("id"));
        }
        String fullUrl = url.replace(' ', '+').replace("\"", "");
        URIBuilder uriBuilder = new URIBuilder(fullUrl);
        HttpGet httpGet = new HttpGet(uriBuilder.build());
        httpGet.setHeader(CONTENT_TYPE, APPLICATION_FORM_URLENCODED);
        if (null != accessToken && accessToken.length() <= 50) {
            accessToken = RequestContext.get().getYzjAppTicket();
        }
        httpGet.setHeader(ACCESS_TOKEN, accessToken);
        httpGet.setHeader(X_OPENAPI_QUERYID, "true");
        RequestConfig requestConfig = OpenApiUtil.getRequestConfig();
        httpGet.setConfig(requestConfig);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        return response;
    }

    private static CloseableHttpResponse doPost(String url, String reqStr, String accessToken) throws IOException {
        if (null == RequestContext.get().getApi3rdAppId()) {
            RequestContext.get().setApi3rdAppId(QueryServiceHelper.queryOne((String)"openapi_3rdapps", (String)"id", (QFilter[])new QFilter("number", "=", (Object)"nocode").toArray()).getString("id"));
        }
        HashMap<String, String> header = new HashMap<String, String>(2);
        header.put(CONTENT_TYPE, APPLICATION_JSON);
        header.put(ACCESS_TOKEN, accessToken);
        HttpPost httpPost = new HttpPost(url);
        String reqString = reqStr;
        StringEntity entity = new StringEntity(reqString, UTF8);
        RequestConfig requestConfig = OpenApiUtil.getRequestConfig();
        httpPost.setConfig(requestConfig);
        httpPost.setEntity((HttpEntity)entity);
        Set entrySet = header.entrySet();
        entrySet.stream().forEach(it -> httpPost.setHeader((String)it.getKey(), (String)it.getValue()));
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        return response;
    }

    private static RequestConfig getRequestConfig() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(TIME_OUT.intValue()).setRedirectsEnabled(true).build();
        return requestConfig;
    }

    public static enum CheckBoxEnum {
        TRUE("true", ResManager.loadKDString((String)"\u662f", (String)"OpenApiUtil_1", (String)"bos-nocode-common", (Object[])new Object[0])),
        FALSE("false", ResManager.loadKDString((String)"\u5426", (String)"OpenApiUtil_2", (String)"bos-nocode-common", (Object[])new Object[0]));

        private final String code;
        private final String name;

        private CheckBoxEnum(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public static CheckBoxEnum getByCode(String code) {
            for (CheckBoxEnum value : CheckBoxEnum.values()) {
                if (!value.getCode().equalsIgnoreCase(code)) continue;
                return value;
            }
            return FALSE;
        }

        public static List<ValueMapItem> getComboItems() {
            ArrayList<ValueMapItem> comboItems = new ArrayList<ValueMapItem>();
            ValueMapItem trueItem = new ValueMapItem();
            trueItem.setValue(TRUE.getCode());
            trueItem.setName(new LocaleString(TRUE.getName()));
            comboItems.add(trueItem);
            ValueMapItem falseItem = new ValueMapItem();
            falseItem.setValue(FALSE.getCode());
            falseItem.setName(new LocaleString(FALSE.getName()));
            comboItems.add(falseItem);
            return comboItems;
        }
    }
}

