/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class RuleServiceHelper {
    private static final Log log = LogFactory.getLog(RuleServiceHelper.class);
    private static final String EXPRESSION = "expression";
    public static final String RELATION_FORM_ID = "relationFormId";

    public static void delRules(String ... formIds) {
        RuleServiceHelper.delRules(Arrays.asList(formIds));
    }

    public static void delRules(Collection<String> formIds) {
        QFilter filter = new QFilter("formid", "in", formIds);
        DeleteServiceHelper.delete((String)"bos_nocode_rule", (QFilter[])new QFilter[]{filter});
    }

    public static void cloneRules(String oid, String nid) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(oid, nid);
        RuleServiceHelper.cloneRules(map);
    }

    public static void cloneRules(Map<String, String> formIdRefMap) {
        if (!formIdRefMap.isEmpty()) {
            QFilter filter = new QFilter("formid", "in", formIdRefMap.keySet());
            String selectFields = "id,name,formid,expression,depfldkeys,trueaction,affectfldkeys,creater,modifier,createdate,modifydate,ruletype,valuetype";
            DynamicObject[] collections = BusinessDataServiceHelper.load((String)"bos_nocode_rule", (String)selectFields, (QFilter[])new QFilter[]{filter});
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
            for (DynamicObject collection : collections) {
                Map valueMap;
                String relationFormId;
                DynamicObject clone = (DynamicObject)OrmUtils.clone((IDataEntityBase)collection, (boolean)false, (boolean)true);
                clone.set("formid", (Object)formIdRefMap.get(clone.getString("formid")));
                clone.set("creater", (Object)RequestContext.get().getCurrUserId());
                clone.set("modifier", (Object)RequestContext.get().getCurrUserId());
                clone.set("createdate", collection.get("createdate"));
                String expression = collection.getString(EXPRESSION);
                if ("0".equals(clone.get("ruletype")) || StringUtils.isBlank((CharSequence)expression)) {
                    list.add(clone);
                    continue;
                }
                Map expressionMap = (Map)SerializationUtils.fromJsonString((String)expression, Map.class);
                Integer valueType = (Integer)expressionMap.get("valueType");
                if (Objects.nonNull(valueType) && valueType == 2 && StringUtils.isNotEmpty((CharSequence)(relationFormId = (String)(valueMap = (Map)expressionMap.get("value")).get(RELATION_FORM_ID)))) {
                    String newFormId = formIdRefMap.get(relationFormId);
                    valueMap.put(RELATION_FORM_ID, StringUtils.isBlank((CharSequence)newFormId) ? relationFormId : newFormId);
                    clone.set(EXPRESSION, (Object)SerializationUtils.toJsonString((Object)expressionMap));
                }
                list.add(clone);
            }
            if (!list.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
            }
        }
    }
}

