/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class URLCodecUtils {
    private static final Log logger = LogFactory.getLog(URLCodecUtils.class);

    public static String encode(String val) {
        try {
            return URLEncoder.encode(val, "UTF-8").replace("+", "%20").replace("%21", "!").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%2A", "*");
        }
        catch (Exception e) {
            return val;
        }
    }

    public static String decode(String val) {
        try {
            return URLDecoder.decode(val, "UTF-8");
        }
        catch (Exception e) {
            return val;
        }
    }

    public static String encodeQueryString(String url) {
        try {
            int startIndex = url.indexOf("?");
            if (startIndex == -1) {
                return url;
            }
            String queryString = url.substring(startIndex + 1);
            String[] params = queryString.split("&");
            HashMap<String, String> paramMap = new HashMap<String, String>(params.length);
            for (String param : params) {
                String value;
                String key;
                int i = param.indexOf("=");
                if (i == -1) {
                    key = param;
                    value = "";
                } else {
                    key = param.substring(0, i);
                    value = param.substring(i + 1);
                }
                paramMap.put(key, value);
            }
            StringBuilder encodedQuery = new StringBuilder();
            for (Map.Entry entry : paramMap.entrySet()) {
                if (encodedQuery.length() > 0) {
                    encodedQuery.append("&");
                }
                encodedQuery.append(URLCodecUtils.encode((String)entry.getKey()));
                encodedQuery.append("=");
                encodedQuery.append(URLCodecUtils.encode((String)entry.getValue()));
            }
            String urlSpec = url.substring(0, startIndex) + "?" + encodedQuery;
            return new URL(urlSpec).toString();
        }
        catch (Exception e) {
            logger.debug("encodeQueryString error: {}", (Object)e.getMessage(), (Object)e);
            return url;
        }
    }
}

