/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.entity.WorkflowHttpResponse;
import kd.bos.nocode.restapi.common.util.NameValuePair;
import kd.bos.nocode.utils.URLCodecUtils;
import kd.bos.util.StringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorkflowHttpClientUtils {
    private static final Log logger = LogFactory.getLog(WorkflowHttpClientUtils.class);
    private static final String SCHEME_HTTPS = "https";

    private static CloseableHttpClient createHttpClient(int connectionTimeout, int readTimeout) {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(readTimeout).setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(connectionTimeout).build();
        return HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
    }

    private static CloseableHttpClient wrapperHttpClient(int connectionTimeout, int readTimeout) {
        try {
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            };
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{trustManager}, null);
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(ctx, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("standard-strict").setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(connectionTimeout).setSocketTimeout(readTimeout).setExpectContinueEnabled(Boolean.TRUE.booleanValue()).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Collections.singletonList("Basic")).build();
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register(SCHEME_HTTPS, (Object)socketFactory).build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).build();
        }
        catch (Exception ex) {
            logger.debug("\u5305\u88c5\u65e0\u8bc1\u4e66\u6821\u9a8c\u5ba2\u6237\u7aef\u5931\u8d25: " + ex.getMessage(), (Object)ex);
            return null;
        }
    }

    @NotNull
    public static WorkflowHttpResponse get(String url, Map<String, String> headers, int connectionTimeout, int readTimeout, boolean sslAuth) throws Exception {
        url = URLCodecUtils.encodeQueryString(url);
        WorkflowHttpResponse workflowHttpResponse = new WorkflowHttpResponse();
        try (CloseableHttpClient client = WorkflowHttpClientUtils.getHttpClient(url, connectionTimeout, readTimeout, sslAuth);){
            if (client == null) {
                WorkflowHttpResponse workflowHttpResponse2 = workflowHttpResponse;
                return workflowHttpResponse2;
            }
            HttpGet request = new HttpGet();
            request.setURI(new URI(url));
            WorkflowHttpClientUtils.setRequestHeaders((AbstractHttpMessage)request, headers);
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
                WorkflowHttpClientUtils.handleHttpResponse((HttpResponse)response, workflowHttpResponse);
            }
        }
        return workflowHttpResponse;
    }

    @NotNull
    public static WorkflowHttpResponse postFormData(String url, Map<String, String> headers, List<FormDataEntity> formDataEntities, int connectionTimeout, int readTimeout, boolean ignoreSSL) throws Exception {
        url = URLCodecUtils.encodeQueryString(url);
        WorkflowHttpResponse workflowHttpResponse = new WorkflowHttpResponse();
        try (CloseableHttpClient client = WorkflowHttpClientUtils.getHttpClient(url, connectionTimeout, readTimeout, ignoreSSL);){
            if (client == null) {
                WorkflowHttpResponse workflowHttpResponse2 = workflowHttpResponse;
                return workflowHttpResponse2;
            }
            HttpPost httpPost = new HttpPost(url);
            WorkflowHttpClientUtils.setRequestHeaders((AbstractHttpMessage)httpPost, headers);
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            if (CollectionUtils.isNotEmpty(formDataEntities)) {
                for (FormDataEntity e : formDataEntities) {
                    InputStream valueInputStream = e.getValueInputStream();
                    Throwable throwable = null;
                    try {
                        if (valueInputStream != null) {
                            multipartEntityBuilder.addPart(e.getKey(), (ContentBody)new InputStreamBody(valueInputStream, e.getFileName()));
                            continue;
                        }
                        multipartEntityBuilder.addPart(e.getKey(), (ContentBody)new StringBody(e.getValueString(), ContentType.TEXT_PLAIN));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (valueInputStream == null) continue;
                        if (throwable != null) {
                            try {
                                valueInputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        valueInputStream.close();
                    }
                }
            }
            httpPost.setEntity(multipartEntityBuilder.build());
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);){
                WorkflowHttpClientUtils.handleHttpResponse((HttpResponse)response, workflowHttpResponse);
            }
        }
        return workflowHttpResponse;
    }

    @NotNull
    public static WorkflowHttpResponse postJson(String url, Map<String, String> headers, String json, int connectionTimeout, int readTimeout, boolean sslAuth) throws Exception {
        url = URLCodecUtils.encodeQueryString(url);
        WorkflowHttpResponse workflowHttpResponse = new WorkflowHttpResponse();
        try (CloseableHttpClient client = WorkflowHttpClientUtils.getHttpClient(url, connectionTimeout, readTimeout, sslAuth);){
            if (client == null) {
                WorkflowHttpResponse workflowHttpResponse2 = workflowHttpResponse;
                return workflowHttpResponse2;
            }
            HttpPost httpPost = new HttpPost(url);
            WorkflowHttpClientUtils.setRequestHeaders((AbstractHttpMessage)httpPost, headers);
            json = StringUtils.isEmpty((String)json) ? "" : json;
            StringEntity se = new StringEntity(json, ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)se);
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);){
                WorkflowHttpClientUtils.handleHttpResponse((HttpResponse)response, workflowHttpResponse);
            }
        }
        return workflowHttpResponse;
    }

    private static void setRequestHeaders(AbstractHttpMessage request, Map<String, String> headers) {
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    @Nullable
    private static CloseableHttpClient getHttpClient(String url, int connectionTimeout, int readTimeout, boolean sslAuth) {
        URI uri = URI.create(url);
        CloseableHttpClient client = SCHEME_HTTPS.equals(uri.getScheme()) && !sslAuth ? WorkflowHttpClientUtils.wrapperHttpClient(connectionTimeout, readTimeout) : WorkflowHttpClientUtils.createHttpClient(connectionTimeout, readTimeout);
        return client;
    }

    private static void handleHttpResponse(HttpResponse response, WorkflowHttpResponse workflowHttpResponse) throws IOException {
        workflowHttpResponse.setResponseBody(EntityUtils.toString((HttpEntity)response.getEntity()));
        List<NameValuePair> responseHeaders = Arrays.stream(response.getAllHeaders()).map(e -> new NameValuePair(e.getName(), e.getValue())).collect(Collectors.toList());
        String headerStr = responseHeaders.stream().map(e -> e.getName() + "=" + e.getValue()).collect(Collectors.joining(","));
        Map<String, String> originHeaders = Arrays.stream(response.getAllHeaders()).collect(Collectors.toMap(org.apache.http.NameValuePair::getName, org.apache.http.NameValuePair::getValue, (v1, v2) -> v2));
        workflowHttpResponse.setOriginHeaders(originHeaders);
        workflowHttpResponse.setResponseHeaders(responseHeaders);
        workflowHttpResponse.setStatusCode(String.valueOf(response.getStatusLine().getStatusCode()));
        workflowHttpResponse.setSuccess(Boolean.TRUE);
    }

    public static class FormDataEntity {
        private final String key;
        private String valueString;
        private InputStream valueInputStream;
        private String fileName;

        public FormDataEntity(String key, String value) {
            this.key = key;
            this.valueString = value;
        }

        public FormDataEntity(String key, InputStream value, String fileName) {
            this.key = key;
            this.valueInputStream = value;
            this.fileName = fileName;
        }

        public String getKey() {
            return this.key;
        }

        public String getValueString() {
            return this.valueString;
        }

        public InputStream getValueInputStream() {
            return this.valueInputStream;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

