/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.ws;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.constant.MessageType;
import kd.bos.nocode.ws.MessageParam;
import kd.bos.nocode.ws.MessageParamType;
import kd.bos.servicehelper.pushMessage.PushServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.servicehelper.workflow.NoCodeWorkflowServiceHelper;

public class WsMessageSender {
    private static final Log logger = LogFactory.getLog(WsMessageSender.class);
    private static final int DURATION_MILLIS = 5000;

    private WsMessageSender() {
    }

    public static void sendUnreadMessage(long userId) {
        MessageParam messageParam = new MessageParam(MessageParamType.MESSAGE_CENTER);
        Long unReadMessageCount = MessageCenterServiceHelper.getNoCodeFlowUnReadMessageCount((String)String.valueOf(userId));
        Long toHandleTaskCount = NoCodeWorkflowServiceHelper.getNoCodeFlowTaskCountByType((String)String.valueOf(userId), (String)"toHandle");
        long unreadCount = unReadMessageCount + toHandleTaskCount;
        messageParam.put("unReadCount", unreadCount);
        logger.debug("unReadMessageCount={}, toHandleTaskCount={}, unreadCount={}", new Object[]{unReadMessageCount, toHandleTaskCount, unreadCount});
        PushServiceHelper.sendWebSocketAction((String)"NoCodeSystemMsg", (Object)messageParam, (List)Lists.newArrayList((Object[])new String[]{String.valueOf(userId)}));
    }

    public static void sendMessageNotice(long userId, long msgId, String title, String message, MessageType messageType, Map<String, Object> params) {
        MessageParam messageParam = new MessageParam(MessageParamType.MESSAGE_NOTICE);
        messageParam.put("id", String.valueOf(msgId));
        messageParam.put("title", title);
        messageParam.put("message", message);
        messageParam.put("type", messageType.toString());
        messageParam.put("showParams", params);
        messageParam.put("duration", 5000);
        logger.debug("messageParam={}", (Object)messageParam);
        PushServiceHelper.sendWebSocketAction((String)"NoCodeSystemMsg", (Object)messageParam, (List)Lists.newArrayList((Object[])new String[]{String.valueOf(userId)}));
    }
}

