/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.handle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.StringUtil;
import kd.bos.nocode.restapi.handle.PropertyHandle;
import kd.bos.nocode.restapi.handle.PropertyHandleUtil;
import org.apache.commons.collections4.MapUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPropertyHandle<T extends IDataEntityProperty>
implements PropertyHandle {
    private static final Log logger = LogFactory.getLog(AbstractPropertyHandle.class);
    protected String entityName;
    protected Object id;
    protected final T prop;
    protected final String propName;
    protected String parentFullPropName;
    protected Map<String, Set<String>> prefixMap;
    protected Set<String> select;

    protected AbstractPropertyHandle(T prop) {
        if (prop == null) {
            throw new RestApiException(ResManager.loadKDString((String)"\u5c5e\u6027 prop \u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractPropertyHandle_0", (String)"bos-nocode-format", (Object[])new Object[0]));
        }
        this.prop = prop;
        this.propName = prop.getName();
    }

    public String getParentFullPropName() {
        return "$".equals(this.parentFullPropName) || StringUtil.isEmpty((String)this.parentFullPropName) ? "" : this.parentFullPropName.trim();
    }

    public String getCurrFullPropName() {
        String parentFullPropNameLocal = this.getParentFullPropName();
        return "".equals(parentFullPropNameLocal) ? this.propName : parentFullPropNameLocal + "." + this.propName;
    }

    @Override
    public void copyValue(DynamicObject source, Map<String, Object> target, boolean useFormatStringValue) {
        this.checkNull(source, target);
        try {
            if (useFormatStringValue) {
                target.put(this.propName, this.formatStringValue(source));
            } else {
                target.put(this.propName, this.formatValue(source));
            }
        }
        catch (Exception e) {
            String errMsg = this.getPropertyFormatErrorMsg();
            logger.debug(errMsg, (Object)e);
            throw new RestApiException(errMsg, (Throwable)e);
        }
    }

    @Override
    public void copyValue(Row source, Map<String, Object> target, boolean useFormatStringValue) {
        this.checkNull(source, target);
        try {
            if (useFormatStringValue) {
                target.put(this.getCurrFullPropName(), this.formatStringValue(source));
            } else {
                target.put(this.getCurrFullPropName(), this.formatValue(source));
            }
        }
        catch (Exception e) {
            String errMsg = this.getPropertyFormatErrorMsg();
            logger.debug(errMsg, (Object)e);
            throw new RestApiException(errMsg, (Throwable)e);
        }
    }

    @NotNull
    private String getPropertyFormatErrorMsg() {
        return ResManager.loadKDString((String)"\u5c5e\u6027 ", (String)"AbstractPropertyHandle_1", (String)"bos-nocode-format", (Object[])new Object[0]) + this.getCurrFullPropName() + ResManager.loadKDString((String)" : \u8d4b\u503c\u5931\u8d25", (String)"AbstractPropertyHandle_2", (String)"bos-nocode-format", (Object[])new Object[0]);
    }

    @Override
    public void copyValue(List<DynamicObject> sourceList, DynamicObject target) {
        this.checkNull(sourceList, target);
        if (sourceList.isEmpty()) {
            target.set(this.prop, null);
        } else {
            try {
                target.set(this.prop, sourceList.get(0).get(this.getCurrFullPropName()));
            }
            catch (Exception e) {
                String errMsg = this.getPropertyFormatErrorMsg();
                logger.debug(errMsg, (Object)e);
                throw new RestApiException(errMsg, (Throwable)e);
            }
        }
    }

    @Override
    public Object formatValue(DynamicObject source) {
        return source.get(this.propName);
    }

    @Override
    public List<Object> formatValue(List<Object> sourceValueList) {
        boolean isDesensitizeField = PrivacyCenterUtils.isDesensitizeField(this.prop, (String)Lang.get().toString(), (String)"LIST");
        if (isDesensitizeField) {
            ArrayList<Object> deSensitizeValueList = new ArrayList<Object>(sourceValueList.size());
            for (Object value : sourceValueList) {
                Object desensitizeValue = PrivacyCenterUtils.getDesensitizeValue(this.prop, (String)Lang.get().toString(), (String)"LIST", null, (Object)value);
                deSensitizeValueList.add(desensitizeValue);
            }
            return deSensitizeValueList;
        }
        return sourceValueList;
    }

    @Override
    public String formatStringValue(DynamicObject source) {
        Object formatValue = this.formatValue(source);
        if (formatValue == null) {
            return "";
        }
        return formatValue.toString();
    }

    @Override
    public Object formatValue(Row source) {
        return source.get(this.getCurrFullPropName());
    }

    @Override
    public String formatStringValue(Row source) {
        Object formatValue = this.formatValue(source);
        if (Objects.isNull(formatValue)) {
            return "";
        }
        return formatValue.toString();
    }

    protected Map<String, Object> toMap(DynamicObject source) {
        Map<String, Object> map = PropertyHandleUtil.toMap(this.id, this.entityName, this.getCurrFullPropName(), source, this.prefixMap, false);
        if (map == null) {
            return new HashMap<String, Object>(0);
        }
        if (this.prop instanceof MaterielProp) {
            Object masterIdObj = source.get("masterid");
            if (masterIdObj instanceof DynamicObject) {
                DynamicObject masterid = (DynamicObject)masterIdObj;
                map.put("number", masterid.get("number"));
                map.put("name", masterid.getLocaleString("name").getLocaleValue());
            }
        } else if (this.prop instanceof ModifierProp) {
            map.put("name", source.getLocaleString("name").getLocaleValue());
        } else if (this.prop instanceof CreaterProp) {
            map.put("name", source.getLocaleString("name").getLocaleValue());
        } else {
            try {
                ILocaleString localeName = source.getLocaleString("name");
                if (Objects.nonNull(localeName)) {
                    map.put("name", localeName.getLocaleValue());
                }
            }
            catch (Exception e) {
                throw new RestApiException(ResManager.loadKDString((String)"\u8d4b\u503c\u5f02\u5e38\uff1aentityName=%1$s,propName=%2$s", (String)"AbstractPropertyHandle_3", (String)"bos-nocode-format", (Object[])new Object[]{this.entityName, this.propName}));
            }
        }
        Map<String, Object> selectProp = this.getSelectProp(map);
        return MapUtils.isEmpty(selectProp) ? null : selectProp;
    }

    protected Map<String, Object> getSelectProp(Map<String, Object> map) {
        if (map == null) {
            return new HashMap<String, Object>(0);
        }
        Set<String> set = this.prefixMap.get(this.getCurrFullPropName());
        if (set == null) {
            set = new HashSet<String>(1);
        }
        set.add("id");
        set.add("name");
        HashMap<String, Object> selectMap = new HashMap<String, Object>(set.size());
        for (String key : set) {
            selectMap.put(key, map.get(key));
        }
        return selectMap;
    }

    protected boolean isCurrPropHasChildProp() {
        return this.prefixMap.containsKey(this.getCurrFullPropName());
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public void setParentFullPropName(String parentFullPropName) {
        this.parentFullPropName = parentFullPropName;
    }

    public Map<String, Set<String>> getPrefixMap() {
        return this.prefixMap;
    }

    public void setPrefixMap(Map<String, Set<String>> prefixMap) {
        this.prefixMap = prefixMap;
    }

    protected <SRC, TAR> void checkNull(SRC sourceList, TAR target) {
        if (sourceList == null) {
            throw new RestApiException(ResManager.loadKDString((String)"\u5c5e\u6027 %s : \u6e90\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractPropertyHandle_4", (String)"bos-nocode-format", (Object[])new Object[]{this.getCurrFullPropName()}));
        }
        if (target == null) {
            throw new RestApiException(ResManager.loadKDString((String)"\u5c5e\u6027 %s : \u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a", (String)"AbstractPropertyHandle_5", (String)"bos-nocode-format", (Object[])new Object[]{this.getCurrFullPropName()}));
        }
    }

    public Set<String> getSelect() {
        return this.select;
    }

    public void setSelect(Set<String> select) {
        this.select = select;
    }

    protected <K> List<DynamicObject> distinctByProp(Collection<DynamicObject> collection, Predicate<? super DynamicObject> filter, Function<? super DynamicObject, ? extends K> keyMapper) {
        if (collection == null) {
            return Collections.emptyList();
        }
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        Stream<DynamicObject> stream = collection.stream();
        if (filter != null) {
            stream = stream.filter(filter);
        }
        return new ArrayList<DynamicObject>(stream.collect(Collectors.toMap(keyMapper, Function.identity(), (oldVal, newVal) -> oldVal)).values());
    }
}

