/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.handle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.metadata.NoCodeBillEntityType;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.restapi.common.util.ComparatorUtil;
import kd.bos.nocode.restapi.handle.DynamicPropertyUtil;
import kd.bos.nocode.restapi.handle.PropertyHandle;
import kd.bos.nocode.restapi.handle.PropertyHandleFactory;
import org.jetbrains.annotations.NotNull;

@Deprecated
public abstract class DataSetPropertyHandleUtils {
    private static final Log logger = LogFactory.getLog(DataSetPropertyHandleUtils.class);
    static Map<Class<? extends IDataEntityProperty>, Class<?>> PROP_TO_TARGET_TYPE = new HashMap(16);

    private DataSetPropertyHandleUtils() {
    }

    public static List<Map<String, Object>> toMapListRoot(String entityName, DataSet sources, Set<String> selectFieldSet) {
        return DataSetPropertyHandleUtils.toMapListRoot(entityName, "$", sources, selectFieldSet);
    }

    public static List<Map<String, Object>> toMapListRoot(String entityName, String fullParentPropName, DataSet sources, Set<String> selectFieldSet) {
        return DataSetPropertyHandleUtils.toMapListRootByColumn(entityName, fullParentPropName, sources, selectFieldSet);
    }

    public static List<Map<String, Object>> toMapListRootByColumn(String entityName, String fullParentPropName, DataSet sources, Set<String> selectFieldSet) {
        Map<String, Set<String>> prefixMap = DataSetPropertyHandleUtils.getPrefixMap(selectFieldSet);
        if (Objects.isNull(sources)) {
            return Collections.emptyList();
        }
        int length = sources.copy().count("id", Boolean.FALSE.booleanValue());
        if (length == 0) {
            return Collections.emptyList();
        }
        Set<String> set = prefixMap.get(fullParentPropName);
        if (set == null) {
            set = new HashSet<String>(1);
        }
        set.add("id");
        HashMap<String, List> columnDataMap = new HashMap<String, List>(16);
        DataEntityPropertyCollection properties = DataSetPropertyHandleUtils.getDataEntityProperties(entityName, fullParentPropName);
        for (String field : set) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)field);
            if (Objects.isNull(property) || DynamicPropertyUtil.notIncludeProperty(property)) continue;
            PropertyHandle propertyHandle = PropertyHandleFactory.createHandle(0L, entityName, fullParentPropName, property, prefixMap);
            List<Object> columnData = DataSetPropertyHandleUtils.toColumnData(sources, field, propertyHandle, properties, length);
            columnDataMap.put(field, columnData);
        }
        int rowSize = ((List)columnDataMap.get("id")).size();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(rowSize);
        int i = 0;
        while (i < rowSize) {
            int tempI = i++;
            HashMap map = new HashMap(selectFieldSet.size());
            columnDataMap.forEach((key, value) -> map.put(key, value.get(tempI)));
            list.add(map);
        }
        return list;
    }

    private static List<Object> toColumnData(DataSet sources, String field, PropertyHandle propertyHandle, DataEntityPropertyCollection properties, int length) {
        ArrayList<Object> sourceValueList = new ArrayList<Object>(length);
        try (DataSet sourceCopy = sources.copy();){
            while (sourceCopy.hasNext()) {
                Row row = sourceCopy.next();
                IDataEntityProperty dp = (IDataEntityProperty)properties.get((Object)field);
                if (dp instanceof NoCodeRefBillProp && ((NoCodeRefBillProp)dp).getComplexType() == null) {
                    List<Object> list = null;
                    return list;
                }
                sourceValueList.add(row.get(field));
            }
        }
        return propertyHandle.formatValue(sourceValueList);
    }

    public static Map<String, Object> toMap(String entityName, Row source, Set<String> selectFieldSet) {
        return DataSetPropertyHandleUtils.toMap(entityName, source, "$", selectFieldSet);
    }

    public static Map<String, Object> toMap(String entityName, Row source, String parentPropName, Set<String> selectFieldSet) {
        Map<String, Set<String>> prefixMap = DataSetPropertyHandleUtils.getPrefixMap(selectFieldSet);
        String pk = EntityMetadataCache.getDataEntityType((String)entityName).getPrimaryKey().getName();
        return DataSetPropertyHandleUtils.toMap(source.get(pk), entityName, parentPropName, source, prefixMap, false);
    }

    public static Map<String, Set<String>> getPrefixMap(Set<String> selectFieldSet) {
        Map prefixMap = selectFieldSet.stream().sorted(ComparatorUtil.getStringComparator()).collect(Collectors.groupingBy(it -> {
            int endIndex = it.lastIndexOf(46);
            if (endIndex != -1) {
                return it.substring(0, endIndex);
            }
            return "$";
        }, LinkedHashMap::new, Collectors.mapping(it -> {
            int indexOf = it.lastIndexOf(46);
            if (indexOf != -1) {
                return it.substring(indexOf + 1);
            }
            return it;
        }, Collectors.toCollection(LinkedHashSet::new))));
        logger.debug("prefixMap={}", (Object)prefixMap);
        return prefixMap;
    }

    private static Map<String, Object> toMap(Object id, String entityName, String fullParentPropName, Row source, Map<String, Set<String>> prefixMap, boolean useFormatStringValue) {
        if (source == null) {
            return Collections.emptyNavigableMap();
        }
        Set<String> set = DataSetPropertyHandleUtils.getFormatFieldSet(fullParentPropName, prefixMap);
        DataEntityPropertyCollection properties = DataSetPropertyHandleUtils.getDataEntityProperties(entityName, fullParentPropName);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(set.size());
        for (String s : set) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)s);
            if (property == null || DynamicPropertyUtil.notIncludeProperty(property)) continue;
            PropertyHandle propertyHandle = PropertyHandleFactory.createHandle(id, entityName, fullParentPropName, property, prefixMap, Boolean.TRUE);
            propertyHandle.copyValue(source, map, useFormatStringValue);
        }
        if (DataSetPropertyHandleUtils.isNotMainTable(fullParentPropName)) {
            Map<String, Object> mainTableRow = DataSetPropertyHandleUtils.toMap(entityName, source, "$", prefixMap.get("$"));
            map.putAll(mainTableRow);
        }
        return map;
    }

    @NotNull
    public static Set<String> getFormatFieldSet(String fullParentPropName, Map<String, Set<String>> prefixMap) {
        Set<String> set = prefixMap.get(fullParentPropName);
        if (set == null) {
            set = new HashSet<String>(1);
        }
        set.add("id");
        return set;
    }

    static DataEntityPropertyCollection getDataEntityProperties(String entityName, String fullParentPropName) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        if (DataSetPropertyHandleUtils.isNotMainTable(fullParentPropName)) {
            dataEntityType = (IDataEntityType)((NoCodeBillEntityType)dataEntityType).getAllEntities().get(fullParentPropName);
        }
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        logger.debug("properties={}", properties.stream().map(IMetadata::getName).collect(Collectors.toList()));
        return properties;
    }

    private static boolean isMainTable(String fullParentPropName) {
        return "$".equalsIgnoreCase(fullParentPropName);
    }

    public static boolean isNotMainTable(String fullParentPropName) {
        return !DataSetPropertyHandleUtils.isMainTable(fullParentPropName);
    }

    public static Map<Class<? extends IDataEntityProperty>, Class<?>> getPropToTargetType() {
        return PROP_TO_TARGET_TYPE;
    }

    static {
        PROP_TO_TARGET_TYPE.put(TextProp.class, String.class);
        PROP_TO_TARGET_TYPE.put(DecimalProp.class, BigDecimal.class);
        PROP_TO_TARGET_TYPE.put(BigIntProp.class, Long.TYPE);
        PROP_TO_TARGET_TYPE.put(ComboProp.class, String.class);
        PROP_TO_TARGET_TYPE.put(DateTimeProp.class, Long.TYPE);
        PROP_TO_TARGET_TYPE.put(PictureProp.class, String.class);
        PROP_TO_TARGET_TYPE.put(NoCodeMulRefBillProp.class, String.class);
        PROP_TO_TARGET_TYPE.put(NoCodeRefBillProp.class, String.class);
    }
}

