/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.handle;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.util.FormMetadataUtils;
import kd.bos.nocode.property.INoCodeRefBillProp;
import kd.bos.nocode.restapi.handle.DataSetPropertyHandleUtils;
import kd.bos.nocode.restapi.handle.DynamicPropertyUtil;
import kd.bos.nocode.restapi.handle.NoCodeDataFormatter;
import kd.bos.nocode.restapi.handle.PropertyHandle;
import kd.bos.nocode.restapi.handle.PropertyHandleFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class NoCodeQingDataFormatter
implements NoCodeDataFormatter<Row, Map<String, Object>> {
    private static final Log logger = LogFactory.getLog(NoCodeQingDataFormatter.class);
    private static final String ID = "id";
    private final String entityNumber;
    private final String entryPropName;
    private final Map<String, Set<String>> prefixMap;
    private final QFilter filter;
    private final Set<String> formatFieldSet;
    private final Map<String, DynamicObject> refObjs = Maps.newHashMap();
    private final DataEntityPropertyCollection properties;

    public NoCodeQingDataFormatter(String entityNumber, Set<String> formatFieldSet, QFilter filter) {
        this(entityNumber, "$", formatFieldSet, filter);
    }

    public NoCodeQingDataFormatter(String entityNumber, String entryPropName, Set<String> formatFieldSet, QFilter filter) {
        logger.debug("initialization parameters: entityNumber={}, entryPropName={}, formatFieldSet={}, filter={}", new Object[]{entityNumber, entryPropName, formatFieldSet, filter});
        this.entityNumber = entityNumber;
        this.filter = filter;
        this.entryPropName = entryPropName;
        this.formatFieldSet = formatFieldSet;
        this.prefixMap = DataSetPropertyHandleUtils.getPrefixMap(formatFieldSet);
        this.properties = DataSetPropertyHandleUtils.getDataEntityProperties(entityNumber, entryPropName);
        this.initRefObjs();
    }

    private void initRefObjs() {
        List<INoCodeRefBillProp> refBillPropList = this.getRefBillPropList();
        Map<String, Set<String>> refEntityNumber2DisplayProps = NoCodeQingDataFormatter.getRefEntityNumber2DisplayProps(refBillPropList);
        Map<String, Set<String>> refEntityNumber2MainTableFields = NoCodeQingDataFormatter.getRefEntityNumber2MainTableFields(refBillPropList);
        Map<String, String> mainTableField2RefEntityNumber = this.getMainTableField2RefEntityNumber(refBillPropList);
        logger.debug("mainTableField2RefEntityNumber={}, refEntityNumber2MainTableFields={}, refEntityNumber2DisplayProps={}", new Object[]{mainTableField2RefEntityNumber, refEntityNumber2MainTableFields, refEntityNumber2DisplayProps});
        Set<String> mainTableFields = mainTableField2RefEntityNumber.keySet();
        String selectFields = NoCodeQingDataFormatter.getSelectFields(mainTableFields);
        Set<String> refBillEntityNumbers = refEntityNumber2MainTableFields.keySet();
        HashMap refEntityNumber2PkIds = Maps.newHashMapWithExpectedSize((int)refEntityNumber2DisplayProps.size());
        try (DataSet mainRows = QueryServiceHelper.queryDataSet((String)"NoCodeQingDataFormatter", (String)this.entityNumber, (String)selectFields, (QFilter[])new QFilter[]{this.filter}, (String)"");){
            for (Row mainRow : mainRows) {
                for (String mainTableField : mainTableFields) {
                    String ids = mainRow.getString(mainTableField);
                    if (StringUtils.isBlank((CharSequence)ids)) continue;
                    List idList = Splitter.on((String)",").splitToList((CharSequence)ids);
                    String refEntityNumber = mainTableField2RefEntityNumber.get(mainTableField);
                    for (String s : idList) {
                        refEntityNumber2PkIds.computeIfAbsent(refEntityNumber, k -> Sets.newHashSet()).add(Long.parseLong(s));
                    }
                }
            }
        }
        for (String refEntityNumber : refBillEntityNumbers) {
            DynamicObject[] loaded;
            Set pkIds = (Set)refEntityNumber2PkIds.get(refEntityNumber);
            if (!FormMetadataUtils.existByFormNumber((String)refEntityNumber) || CollectionUtils.isEmpty((Collection)pkIds)) {
                logger.debug(ResManager.loadKDString((String)"\u8868\u5355%s\u4e0d\u5b58\u5728\u6216\u8005\u8fd9\u4e2a\u8868\u5355\u6ca1\u6709\u8981\u67e5\u7684\u6570\u636e\uff0cpkIds=%s", (String)"NoCodeQingDataFormatter_0", (String)"BOS_NOCODE", (Object[])new Object[]{refEntityNumber, pkIds}));
                continue;
            }
            Set<String> refTableFields = refEntityNumber2DisplayProps.get(refEntityNumber);
            QFilter idFilter = new QFilter(ID, "in", (Object)pkIds);
            for (DynamicObject dynamicObject : loaded = BusinessDataServiceHelper.load((String)refEntityNumber, (String)NoCodeQingDataFormatter.getSelectFields(refTableFields), (QFilter[])idFilter.toArray())) {
                String cacheKey = refEntityNumber + ":" + dynamicObject.getString(ID);
                if (this.refObjs.containsKey(cacheKey)) continue;
                this.refObjs.put(cacheKey, dynamicObject);
            }
        }
    }

    @NotNull
    private Map<String, String> getMainTableField2RefEntityNumber(List<INoCodeRefBillProp> refBillPropList) {
        return refBillPropList.stream().collect(Collectors.toMap(INoCodeRefBillProp::getName, INoCodeRefBillProp::getBillEntityNumber));
    }

    @NotNull
    private static String getSelectFields(Set<String> fieldSet) {
        fieldSet = Sets.newHashSet(fieldSet);
        fieldSet.add(ID);
        return String.join((CharSequence)",", fieldSet);
    }

    @NotNull
    private static Map<String, Set<String>> getRefEntityNumber2MainTableFields(List<INoCodeRefBillProp> refBillPropList) {
        return refBillPropList.stream().collect(Collectors.groupingBy(INoCodeRefBillProp::getBillEntityNumber, Collectors.mapping(INoCodeRefBillProp::getName, Collectors.toSet())));
    }

    @NotNull
    private static Map<String, Set<String>> getRefEntityNumber2DisplayProps(List<INoCodeRefBillProp> refBillPropList) {
        return refBillPropList.stream().collect(Collectors.groupingBy(INoCodeRefBillProp::getBillEntityNumber, Collectors.mapping(INoCodeRefBillProp::getMainDisplayProperty, Collectors.toSet())));
    }

    @NotNull
    private List<INoCodeRefBillProp> getRefBillPropList() {
        return this.formatFieldSet.stream().map(arg_0 -> ((DataEntityPropertyCollection)this.properties).get(arg_0)).filter(p -> NoCodeQingDataFormatter.needFormat(p) && p instanceof INoCodeRefBillProp).map(INoCodeRefBillProp.class::cast).filter(p -> !FormMetadataUtils.isRefBillDeleted((INoCodeRefBillProp)p)).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> format(Row source) {
        if (source == null) {
            return Maps.newHashMap();
        }
        Object id = source.get(ID);
        Set<String> fieldSet = DataSetPropertyHandleUtils.getFormatFieldSet(this.entryPropName, this.prefixMap);
        LinkedHashMap<String, Object> formattedDataRow = new LinkedHashMap<String, Object>(fieldSet.size());
        for (String field : fieldSet) {
            IDataEntityProperty property = (IDataEntityProperty)this.properties.get((Object)field);
            if (NoCodeQingDataFormatter.notNeedFormat(property)) continue;
            if (property instanceof INoCodeRefBillProp) {
                this.formatRefBillProp(source, id, formattedDataRow, field, (INoCodeRefBillProp)property);
                continue;
            }
            PropertyHandle propertyHandle = PropertyHandleFactory.createHandle(id, this.entityNumber, this.entryPropName, property, this.prefixMap, Boolean.TRUE);
            propertyHandle.copyValue(source, formattedDataRow, (boolean)Boolean.FALSE);
        }
        return formattedDataRow;
    }

    private void formatRefBillProp(Row source, Object id, Map<String, Object> formattedDataRow, String field, INoCodeRefBillProp prop) {
        String idStr = source.getString(field);
        if (StringUtils.isEmpty((CharSequence)idStr) || FormMetadataUtils.isRefBillDeleted((INoCodeRefBillProp)prop)) {
            formattedDataRow.put(field, "");
            return;
        }
        List idList = Splitter.on((String)",").splitToList((CharSequence)idStr);
        String refBillNumber = prop.getBillEntityNumber();
        String mainDisplayProperty = prop.getMainDisplayProperty();
        DynamicProperty MainDisplayFieldProp = EntityMetadataCache.getDataEntityType((String)refBillNumber).getProperty(mainDisplayProperty);
        if (MainDisplayFieldProp instanceof INoCodeRefBillProp) {
            PropertyHandle refBillHandle = PropertyHandleFactory.createHandle(id, this.entityNumber, this.entryPropName, (IDataEntityProperty)prop, this.prefixMap, Boolean.TRUE);
            refBillHandle.copyValue(source, formattedDataRow, (boolean)Boolean.TRUE);
        } else {
            StringJoiner stringJoiner = new StringJoiner(",");
            for (String pkId : idList) {
                DynamicObject dynamicObject = this.refObjs.get(refBillNumber + ":" + pkId);
                if (dynamicObject == null) continue;
                Object o = dynamicObject.get(mainDisplayProperty);
                stringJoiner.add(o.toString());
            }
            formattedDataRow.put(field, stringJoiner.toString());
        }
    }

    private static boolean notNeedFormat(IDataEntityProperty property) {
        return !NoCodeQingDataFormatter.needFormat(property);
    }

    private static boolean needFormat(IDataEntityProperty property) {
        return Objects.nonNull(property) && !DynamicPropertyUtil.notIncludeProperty(property);
    }
}

