/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.handle;

import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.nocode.ext.property.NoCodeAttachmentProp;
import kd.bos.nocode.ext.property.NoCodeComboProp;
import kd.bos.nocode.ext.property.NoCodeDecimalProp;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.ext.property.NoCodeTextProp;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.handle.AbstractPropertyHandle;
import kd.bos.nocode.restapi.handle.PropertyHandle;
import kd.bos.nocode.restapi.handle.prop.AttachmentPropHandle;
import kd.bos.nocode.restapi.handle.prop.BasedataPropHandle;
import kd.bos.nocode.restapi.handle.prop.ComboPropHandle;
import kd.bos.nocode.restapi.handle.prop.CommonPropHandle;
import kd.bos.nocode.restapi.handle.prop.DateTimePropHandle;
import kd.bos.nocode.restapi.handle.prop.DecimalPropHandle;
import kd.bos.nocode.restapi.handle.prop.EntryPropHandle;
import kd.bos.nocode.restapi.handle.prop.ItemClassTypePropHandle;
import kd.bos.nocode.restapi.handle.prop.MulBasedataPropHandle;
import kd.bos.nocode.restapi.handle.prop.MulRefBillPropHandle;
import kd.bos.nocode.restapi.handle.prop.MuliLangTextPropHandle;
import kd.bos.nocode.restapi.handle.prop.NoCodeComboPropHandle;
import kd.bos.nocode.restapi.handle.prop.RefBillPropHandle;
import kd.bos.nocode.restapi.handle.prop.TextPropHandle;
import kd.bos.nocode.restapi.handle.prop.qing.DateTimePropQingHandle;
import kd.bos.nocode.restapi.handle.prop.qing.NoCodeComboPropQingHandle;

public class PropertyHandleFactory {
    private PropertyHandleFactory() {
    }

    public static PropertyHandle createHandle(Object id, String entityName, String fullParentPropName, IDataEntityProperty property, Map<String, Set<String>> prefixMap) {
        return PropertyHandleFactory.createHandle(id, entityName, fullParentPropName, property, prefixMap, false);
    }

    public static PropertyHandle createHandle(Object id, String entityName, String fullParentPropName, IDataEntityProperty property, Map<String, Set<String>> prefixMap, boolean isQing) {
        PropertyHandle propertyHandle = PropertyHandleFactory.getPropertyHandle(fullParentPropName, property, isQing);
        AbstractPropertyHandle abstractPropertyHandle = (AbstractPropertyHandle)propertyHandle;
        abstractPropertyHandle.setId(id);
        abstractPropertyHandle.setEntityName(entityName);
        abstractPropertyHandle.setParentFullPropName(fullParentPropName);
        abstractPropertyHandle.setPrefixMap(prefixMap);
        return propertyHandle;
    }

    public static PropertyHandle createHandle(String fullParentPropName, IDataEntityProperty property, Set<String> select) {
        PropertyHandle propertyHandle = PropertyHandleFactory.getPropertyHandle(fullParentPropName, property);
        AbstractPropertyHandle abstractPropertyHandle = (AbstractPropertyHandle)propertyHandle;
        abstractPropertyHandle.setParentFullPropName(fullParentPropName);
        abstractPropertyHandle.setSelect(select);
        return propertyHandle;
    }

    public static PropertyHandle getPropertyHandle(String fullParentPropName, IDataEntityProperty property) {
        return PropertyHandleFactory.getPropertyHandle(fullParentPropName, property, false);
    }

    public static PropertyHandle getPropertyHandle(String fullParentPropName, IDataEntityProperty property, boolean isQing) {
        AbstractPropertyHandle propertyHandle;
        if (property instanceof MuliLangTextProp) {
            propertyHandle = new MuliLangTextPropHandle((MuliLangTextProp)property);
        } else if (property instanceof EntryProp) {
            propertyHandle = new EntryPropHandle((EntryProp)property);
        } else if (property instanceof BasedataProp) {
            propertyHandle = new BasedataPropHandle((BasedataProp)property);
        } else if (property instanceof NoCodeAttachmentProp) {
            propertyHandle = new AttachmentPropHandle((NoCodeAttachmentProp)property);
        } else if (property instanceof MulBasedataProp) {
            propertyHandle = new MulBasedataPropHandle((MulBasedataProp)property);
        } else if (property instanceof ItemClassTypeProp) {
            propertyHandle = new ItemClassTypePropHandle((ItemClassTypeProp)property);
        } else if (property instanceof NoCodeRefBillProp) {
            propertyHandle = new RefBillPropHandle((NoCodeRefBillProp)property);
        } else if (property instanceof NoCodeMulRefBillProp) {
            propertyHandle = new MulRefBillPropHandle((NoCodeMulRefBillProp)property);
        } else if (property instanceof NoCodeComboProp) {
            propertyHandle = PropertyHandleFactory.getNoCodeComboPropHandle((NoCodeComboProp)property, isQing);
        } else if (property instanceof DateTimeProp) {
            propertyHandle = PropertyHandleFactory.getDateTimePropHandle((DateTimeProp)property, isQing);
        } else if (property instanceof NoCodeDecimalProp) {
            propertyHandle = new DecimalPropHandle((NoCodeDecimalProp)property);
        } else if (property instanceof NoCodeTextProp) {
            propertyHandle = new TextPropHandle((NoCodeTextProp)property);
        } else if (property instanceof ComboProp) {
            propertyHandle = new ComboPropHandle((ComboProp)property);
        } else {
            if (!(property instanceof DynamicProperty)) {
                throw new RestApiException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5c5e\u6027 %1$s.%2$s\u7c7b\u578b %3$s", (String)"PropertyHandleFactory_1", (String)"bos-nocode-format", (Object[])new Object[]{fullParentPropName, property.getName(), property.getClass().getName()}));
            }
            propertyHandle = new CommonPropHandle(property);
        }
        return propertyHandle;
    }

    public static AbstractPropertyHandle<?> getDateTimePropHandle(DateTimeProp property, boolean isQing) {
        AbstractPropertyHandle propertyHandle = isQing ? new DateTimePropQingHandle(property) : new DateTimePropHandle(property);
        return propertyHandle;
    }

    private static AbstractPropertyHandle<?> getNoCodeComboPropHandle(NoCodeComboProp property, boolean isQing) {
        AbstractPropertyHandle propertyHandle = isQing ? new NoCodeComboPropQingHandle(property) : new NoCodeComboPropHandle(property);
        return propertyHandle;
    }

    public static PropertyHandle tryGetPropertyHandle(IDataEntityProperty property) {
        if (!(property instanceof DynamicProperty)) {
            return null;
        }
        PropertyHandle propertyHandle = PropertyHandleFactory.getPropertyHandle(property.getName(), property);
        if (propertyHandle instanceof CommonPropHandle) {
            return null;
        }
        return propertyHandle;
    }
}

