/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.handle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.nocode.ext.metadata.NoCodeBillEntityType;
import kd.bos.nocode.ext.property.NoCodeComboProp;
import kd.bos.nocode.ext.property.NoCodeDecimalProp;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.restapi.common.util.CollectionUtil;
import kd.bos.nocode.restapi.common.util.ComparatorUtil;
import kd.bos.nocode.restapi.handle.DynamicPropertyUtil;
import kd.bos.nocode.restapi.handle.PropertyHandle;
import kd.bos.nocode.restapi.handle.PropertyHandleFactory;
import kd.bos.nocode.restapi.handle.prop.CommonPropHandle;

public class PropertyHandleUtil {
    private PropertyHandleUtil() {
    }

    public static List<Map<String, Object>> toMapListRoot2RefBill(String entityName, String fullParentPropName, DynamicObject[] sources, Set<String> selectFieldSet) {
        Map<String, Set<String>> prefixMap = PropertyHandleUtil.getPrefixMap(selectFieldSet);
        if (sources == null || sources.length == 0) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(sources.length);
        for (DynamicObject source : sources) {
            Map<String, Object> map = PropertyHandleUtil.toMap(source.getPkValue(), entityName, fullParentPropName, source, prefixMap, true);
            if (CollectionUtil.isEmpty(map)) continue;
            list.add(map);
        }
        return list;
    }

    public static List<Map<String, Object>> formatCustomJsonMap(String entityName, String fullParentPropName, DynamicObject[] sources, Set<String> selectFieldSet) {
        if (sources == null || sources.length == 0) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(sources.length);
        for (DynamicObject source : sources) {
            Map<String, Object> map = PropertyHandleUtil.formatCustomJsonMap(source.getPkValue(), entityName, fullParentPropName, source, selectFieldSet);
            if (CollectionUtil.isEmpty(map)) continue;
            list.add(map);
        }
        return list;
    }

    public static List<Map<String, Object>> toMapListRoot(String entityName, String fullParentPropName, DynamicObject[] sources, Set<String> selectFieldSet) {
        Map<String, Set<String>> prefixMap = PropertyHandleUtil.getPrefixMap(selectFieldSet);
        if (sources == null || sources.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(sources.length);
        for (DynamicObject source : sources) {
            Map<String, Object> map = PropertyHandleUtil.toMap(source.getPkValue(), entityName, fullParentPropName, source, prefixMap, false);
            if (CollectionUtil.isEmpty(map)) continue;
            list.add(map);
        }
        return list;
    }

    public static List<Map<String, Object>> toMapListRootForQingData(String entityName, String fullParentPropName, DynamicObject[] sources, Set<String> selectFieldSet) {
        Map<String, Set<String>> prefixMap = PropertyHandleUtil.getPrefixMap(selectFieldSet);
        if (sources == null || sources.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(sources.length);
        for (DynamicObject source : sources) {
            Map<String, Object> map = PropertyHandleUtil.toMap(source.getPkValue(), entityName, fullParentPropName, source, prefixMap, false, true);
            if (CollectionUtil.isEmpty(map)) continue;
            list.add(map);
        }
        return list;
    }

    private static Map<String, Set<String>> getPrefixMap(Set<String> selectFieldSet) {
        HashMap<String, Set<String>> prefixMap = new HashMap<String, Set<String>>(16);
        prefixMap.put("$", selectFieldSet);
        LinkedHashMap tmpMap = selectFieldSet.stream().sorted(ComparatorUtil.getStringComparator()).collect(Collectors.groupingBy(it -> {
            int endIndex = it.lastIndexOf(46);
            if (endIndex != -1) {
                return it.substring(0, endIndex);
            }
            return "$";
        }, LinkedHashMap::new, Collectors.mapping(it -> {
            int indexOf = it.lastIndexOf(46);
            if (indexOf != -1) {
                return it.substring(indexOf + 1);
            }
            return it;
        }, Collectors.toCollection(LinkedHashSet::new))));
        tmpMap.remove("$");
        prefixMap.putAll(tmpMap);
        return prefixMap;
    }

    public static List<Map<String, Object>> toMapList(Object id, String entityName, String fullParentPropName, DynamicObjectCollection sources, Map<String, Set<String>> prefixMap, boolean useFormatStringValue) {
        if (sources == null || sources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(sources.size());
        for (DynamicObject source : sources) {
            Map<String, Object> map = PropertyHandleUtil.toMap(id, entityName, fullParentPropName, source, prefixMap, useFormatStringValue);
            if (CollectionUtil.isEmpty(map)) continue;
            list.add(map);
        }
        return list;
    }

    public static Map<String, Object> toMap(Object id, String entityName, String fullParentPropName, DynamicObject source, Set<String> selectFieldSet, boolean useFormatStringValue) {
        Map<String, Set<String>> prefixMap = PropertyHandleUtil.getPrefixMap(selectFieldSet);
        return PropertyHandleUtil.toMap(id, entityName, fullParentPropName, source, prefixMap, useFormatStringValue);
    }

    public static Map<String, Object> formatCustomJsonMap(Object id, String entityName, String fullParentPropName, DynamicObject source, Set<String> selectFieldSet) {
        Map<String, Set<String>> prefixMap = PropertyHandleUtil.getPrefixMap(selectFieldSet);
        if (source == null) {
            return Collections.emptyNavigableMap();
        }
        Set<String> set = prefixMap.get(fullParentPropName);
        if (set == null) {
            set = new HashSet<String>(1);
        }
        set.add("id");
        IDataEntityType dataEntityType = source.getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(set.size());
        for (String s : set) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)s);
            if (property == null || DynamicPropertyUtil.notIncludeProperty(property)) continue;
            PropertyHandle propertyHandle = PropertyHandleFactory.createHandle(id, entityName, fullParentPropName, property, prefixMap, false);
            if (property instanceof NoCodeComboProp || property instanceof NoCodeDecimalProp) {
                propertyHandle = new CommonPropHandle(property);
            }
            propertyHandle.copyValue(source, map, false);
        }
        return map;
    }

    public static Map<String, Object> toMap(Object id, String entityName, String fullParentPropName, DynamicObject source, Map<String, Set<String>> prefixMap, boolean useFormatStringValue) {
        return PropertyHandleUtil.toMap(id, entityName, fullParentPropName, source, prefixMap, useFormatStringValue, false);
    }

    public static Map<String, Object> toMap(Object id, String entityName, String fullParentPropName, DynamicObject source, Map<String, Set<String>> prefixMap, boolean useFormatStringValue, boolean isQing) {
        if (source == null) {
            return Collections.emptyNavigableMap();
        }
        Set<String> set = prefixMap.get(fullParentPropName);
        if (set == null) {
            set = new HashSet<String>(1);
        }
        set.add("id");
        IDataEntityType dataEntityType = source.getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(set.size());
        for (String s : set) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)s);
            if (property == null || DynamicPropertyUtil.notIncludeProperty(property)) continue;
            PropertyHandle propertyHandle = PropertyHandleFactory.createHandle(id, entityName, fullParentPropName, property, prefixMap, isQing);
            propertyHandle.copyValue(source, map, useFormatStringValue);
        }
        return map;
    }

    public static List<Map<String, Object>> toMapListRootByColumn(String entityName, String fullParentPropName, DynamicObject[] sources, Set<String> selectFieldSet) {
        Map<String, Set<String>> prefixMap = PropertyHandleUtil.getPrefixMap(selectFieldSet);
        if (sources == null || sources.length == 0) {
            return Collections.emptyList();
        }
        Set<String> set = prefixMap.get(fullParentPropName);
        if (set == null) {
            set = new HashSet<String>(1);
        }
        set.add("id");
        HashMap<String, List> columnDataMap = new HashMap<String, List>(16);
        DataEntityPropertyCollection properties = PropertyHandleUtil.getDataEntityProperties(entityName, fullParentPropName);
        for (String field : set) {
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)field);
            if (Objects.isNull(property) || DynamicPropertyUtil.notIncludeProperty(property)) continue;
            PropertyHandle propertyHandle = PropertyHandleFactory.createHandle(0L, entityName, fullParentPropName, property, prefixMap);
            List<Object> columnData = PropertyHandleUtil.toColumnData(sources, field, propertyHandle);
            columnDataMap.put(field, columnData);
        }
        int rowSize = ((List)columnDataMap.get("id")).size();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(rowSize);
        int i = 0;
        while (i < rowSize) {
            int tempI = i++;
            HashMap map = new HashMap(selectFieldSet.size());
            columnDataMap.forEach((key, value) -> map.put(key, value.get(tempI)));
            list.add(map);
        }
        return list;
    }

    private static List<Object> toColumnData(DynamicObject[] sources, String field, PropertyHandle propertyHandle) {
        List<Object> sourceValueList = Arrays.stream(sources).map(e -> {
            IDataEntityProperty dp = (IDataEntityProperty)e.getDataEntityType().getProperties().get((Object)field);
            if (dp instanceof NoCodeRefBillProp && ((NoCodeRefBillProp)dp).getComplexType() == null) {
                return null;
            }
            return e.get(field);
        }).collect(Collectors.toList());
        return propertyHandle.formatValue(sourceValueList);
    }

    private static DataEntityPropertyCollection getDataEntityProperties(String entityName, String fullParentPropName) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        if (PropertyHandleUtil.isNotMainTable(fullParentPropName)) {
            dataEntityType = (IDataEntityType)((NoCodeBillEntityType)dataEntityType).getAllEntities().get(fullParentPropName);
        }
        return dataEntityType.getProperties();
    }

    private static boolean isMainTable(String fullParentPropName) {
        return "$".equalsIgnoreCase(fullParentPropName);
    }

    private static boolean isNotMainTable(String fullParentPropName) {
        return !PropertyHandleUtil.isMainTable(fullParentPropName);
    }
}

