/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.handle.prop;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.property.NoCodeAttachmentProp;
import kd.bos.nocode.restapi.common.constant.RestApiErrorCode;
import kd.bos.nocode.restapi.common.exception.RestApiException;
import kd.bos.nocode.restapi.common.util.CollectionUtil;
import kd.bos.nocode.restapi.common.util.DataUtil;
import kd.bos.nocode.restapi.handle.AbstractPropertyHandle;
import kd.bos.nocode.restapi.handle.QueryApiFormatUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;

public class AttachmentPropHandle
extends AbstractPropertyHandle<NoCodeAttachmentProp> {
    private static final Log logger = LogFactory.getLog(AttachmentPropHandle.class);
    private static final String ATT_STATUS = "status";
    private static final String ATT_URL = "url";
    private static final String ATT_PREVIEW_URL = "previewurl";
    private static final String ATT_TEMPFILE = "tempfile";
    private static final String ATT_CREATOR = "creator";
    private static final String ATT_DESCRIPTION = "description";
    private static final String ATT_UPLOADING = "uploading";
    private static final String ATT_SUCCESS = "success";
    private static final String ATT_ERROR = "error";
    private static final String ATT_CANCEL = "canceled";
    private static final String ATT_UPLOADING_STATUS = "A";
    private static final String ATT_SUCCESS_STATUS = "B";
    private static final String ATT_ERROR_STATUS = "C";
    private static final String ATT_CANCEL_STATUS = "D";
    private static final int ATT_OFFICIAL = 1;
    private static final String DOWNLOAD_DO = "download.do";
    private static final String PREVIEW_DO = "preview.do";
    private static final String ATT_ENTITYID = "bd_attachment";

    public AttachmentPropHandle(NoCodeAttachmentProp prop) {
        super(prop);
    }

    private void getAttObjs(DynamicObject attObj, HashMap<String, Object> map) {
        int tempfile;
        String path = attObj.getString(ATT_URL);
        if (path.contains("path=")) {
            path = StringUtils.substringAfter((String)path, (String)"path=");
            if ((path = URLDecoder.decode(path)).contains("&")) {
                path = StringUtils.substringBefore((String)path, (String)"&");
            }
        }
        if ((tempfile = attObj.getInt(ATT_TEMPFILE)) == 1) {
            String url;
            try {
                url = URLEncoder.encode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.warn((Throwable)e);
                throw new RestApiException((Throwable)e, RestApiErrorCode.HTTP_INTERNAL_ERROR, ResManager.loadKDString((String)"URL\u7f16\u7801\u5931\u8d25%s", (String)"AttachmentPropHandle_0", (String)"bos-nocode-format", (Object[])new Object[]{e.getMessage()}), new Object[0]);
            }
            String attUrl = UrlService.getAttachmentFullUrl((String)url);
            map.put(ATT_URL, attUrl);
            map.put(ATT_PREVIEW_URL, attUrl.replace(DOWNLOAD_DO, PREVIEW_DO));
        }
        if (ATT_SUCCESS_STATUS.equals(attObj.get(ATT_STATUS))) {
            map.put(ATT_STATUS, ATT_SUCCESS);
        } else if (ATT_UPLOADING_STATUS.equals(attObj.get(ATT_STATUS))) {
            map.put(ATT_STATUS, ATT_UPLOADING);
        } else if (ATT_ERROR_STATUS.equals(attObj.get(ATT_STATUS))) {
            map.put(ATT_STATUS, ATT_ERROR);
        } else if (ATT_CANCEL_STATUS.equals(attObj.get(ATT_STATUS))) {
            map.put(ATT_STATUS, ATT_CANCEL);
        }
        DynamicObject userinfo = attObj.getDynamicObject(ATT_CREATOR);
        if (userinfo != null) {
            map.put(ATT_CREATOR, userinfo.getLocaleString("name"));
        } else {
            map.put(ATT_CREATOR, new Locale(""));
        }
        map.put(ATT_DESCRIPTION, attObj.getLocaleString(ATT_DESCRIPTION) != null ? attObj.getLocaleString(ATT_DESCRIPTION) : new Locale(""));
    }

    @Override
    public void copyValue(List<DynamicObject> sourceList, DynamicObject target) {
        super.checkNull(sourceList, target);
        String currFullPropName = this.getCurrFullPropName();
        List<DynamicObject> srcList = this.distinctByProp(sourceList, it -> DataUtil.l((Object)it.get(currFullPropName)) > 0L && DataUtil.l((Object)it.getString(currFullPropName + "." + "fbasedataid")) > 0L, it -> it.getString(currFullPropName) + it.getString(currFullPropName + "." + "fbasedataid"));
        if (CollectionUtil.isEmpty(srcList)) {
            return;
        }
        DynamicObjectCollection value = target.getDynamicObjectCollection(this.prop);
        for (DynamicObject src : srcList) {
            DynamicProperty fbasedataidProp;
            DynamicObject addNew = value.addNew();
            if (this.select.contains(currFullPropName)) {
                if (this.prop != null) {
                    addNew.set("fpkid", src.get(currFullPropName));
                } else {
                    addNew.set("pkid", src.get(currFullPropName));
                }
            }
            if ((fbasedataidProp = addNew.getDynamicObjectType().getProperty("fbasedataid")) == null) continue;
            String entityId = ((BasedataProp)fbasedataidProp).getBaseEntityId();
            DynamicObject obj = QueryApiFormatUtil.queryObjToLoadObj(Collections.singletonList(src), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityId), (Set<String>)this.select, currFullPropName + "." + "fbasedataid");
            addNew.set((IDataEntityProperty)fbasedataidProp, (Object)obj);
        }
        target.set(this.prop, (Object)value);
    }

    @Override
    public Object formatValue(DynamicObject source) {
        try {
            DynamicObjectCollection sources = (DynamicObjectCollection)((NoCodeAttachmentProp)this.prop).getValue((Object)source);
            return this.formatValue0(sources);
        }
        catch (Exception e) {
            logger.debug("\u9644\u4ef6\u8d4b\u503c\u5f02\u5e38", (Object)e);
            return new ArrayList(0);
        }
    }

    @Override
    public List<Object> formatValue(List<Object> sourceValueList) {
        return sourceValueList.stream().map(e -> this.formatValue0((DynamicObjectCollection)e)).collect(Collectors.toList());
    }

    private Object formatValue0(DynamicObjectCollection sources) {
        ArrayList<Map<String, Object>> list = null;
        if (sources != null) {
            list = new ArrayList<Map<String, Object>>();
            for (DynamicObject obj : sources) {
                DynamicObject attachment = (DynamicObject)obj.get("fbasedataid");
                Map<String, Object> attMap = this.packageAttMap(attachment);
                if (attMap.isEmpty()) continue;
                list.add(attMap);
            }
        }
        return list;
    }

    private Map<String, Object> packageAttMap(DynamicObject attachment) {
        if (attachment == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Object> attMap = new HashMap<String, Object>();
        this.getAttObjs(attachment, attMap);
        attMap.put("createtime", attachment.getDate("createtime").getTime());
        attMap.put(ATT_DESCRIPTION, attachment.getLocaleString(ATT_DESCRIPTION).getLocaleValue());
        DynamicObject creator = attachment.getDynamicObject(ATT_CREATOR);
        if (creator != null) {
            attMap.put(ATT_CREATOR, creator.getString("name"));
        }
        attMap.put("name", attachment.getLocaleString("name").getLocaleValue());
        attMap.put("filesource", attachment.get("filesource"));
        ILocaleString fileName = (ILocaleString)attachment.get("name");
        if (fileName != null && StringUtils.isBlank((CharSequence)((CharSequence)fileName.getItem(Lang.get().toString())))) {
            LocaleString newString = new LocaleString();
            Iterator iterator = fileName.values().iterator();
            if (iterator.hasNext()) {
                newString.put((Object)Lang.get().toString(), iterator.next());
                attMap.put("name", newString.getLocaleValue());
            }
        }
        String type = String.valueOf(attachment.get("type"));
        attMap.put("type", type);
        attMap.put("size", attachment.get("size"));
        attMap.put("visible", "1111");
        attMap.put(ATT_TEMPFILE, attachment.get(ATT_TEMPFILE));
        attMap.put("uid", attachment.get("uid"));
        attMap.put("attPkId", attachment.getPkValue());
        return attMap;
    }

    @Override
    public Object formatValue(Row source) {
        DynamicObject attachment;
        Map<String, Object> attMap;
        Object oValue = super.formatValue(source);
        if (oValue != null && !(attMap = this.packageAttMap(attachment = BusinessDataServiceHelper.loadSingle((Object)oValue, (String)ATT_ENTITYID))).isEmpty()) {
            return attMap;
        }
        return oValue;
    }
}

