/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.handle.prop;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.nocode.ext.property.NoCodeDecimalProp;
import kd.bos.nocode.restapi.handle.AbstractPropertyHandle;
import kd.bos.nocode.utils.DecimalUtil;

public class DecimalPropHandle
extends AbstractPropertyHandle<NoCodeDecimalProp> {
    public DecimalPropHandle(NoCodeDecimalProp prop) {
        super(prop);
    }

    @Override
    public Object formatValue(DynamicObject source) {
        BigDecimal decimal = source.getBigDecimal(this.propName);
        return DecimalUtil.formatByProp((NoCodeDecimalProp)this.prop, decimal, false);
    }

    @Override
    public List<Object> formatValue(List<Object> sourceValueList) {
        return sourceValueList.stream().map(e -> this.formatValue0((BigDecimal)e)).collect(Collectors.toList());
    }

    private Object formatValue0(BigDecimal decimal) {
        String value;
        int scale = ((NoCodeDecimalProp)this.prop).getScale();
        if (Objects.nonNull(decimal)) {
            decimal = decimal.setScale(scale);
            DecimalFormat format = null;
            if (((NoCodeDecimalProp)this.prop).getThousandsSeparator()) {
                StringBuilder pattern = new StringBuilder("##,##0");
                if (scale > 0) {
                    pattern.append(".");
                    while (scale-- > 0) {
                        pattern.append("0");
                    }
                }
                format = new DecimalFormat(pattern.toString());
                value = format.format(decimal);
            } else {
                value = decimal.toPlainString();
            }
            if (!((NoCodeDecimalProp)this.prop).isDigit()) {
                value = value + "%";
            }
        } else {
            value = null;
        }
        return value;
    }

    private Object formatValue1(BigDecimal decimal, boolean useFormatStringValue) {
        String value;
        int scale = ((NoCodeDecimalProp)this.prop).getScale();
        if (Objects.nonNull(decimal)) {
            decimal = decimal.setScale(scale);
            DecimalFormat format = null;
            if (useFormatStringValue && ((NoCodeDecimalProp)this.prop).getThousandsSeparator()) {
                StringBuilder pattern = new StringBuilder("##,##0");
                if (scale > 0) {
                    pattern.append(".");
                    while (scale-- > 0) {
                        pattern.append("0");
                    }
                }
                format = new DecimalFormat(pattern.toString());
                value = format.format(decimal);
            } else {
                value = decimal.toPlainString();
            }
            if (!((NoCodeDecimalProp)this.prop).isDigit()) {
                value = value + "%";
            }
        } else {
            value = null;
        }
        return value;
    }

    @Override
    public String formatStringValue(Row source) {
        Object v = this.formatValue(source);
        if (v instanceof BigDecimal) {
            return DecimalUtil.formatByProp((NoCodeDecimalProp)this.prop, (BigDecimal)v, true);
        }
        return String.valueOf(v);
    }

    @Override
    public String formatStringValue(DynamicObject source) {
        BigDecimal decimal = source.getBigDecimal(this.propName);
        return DecimalUtil.formatByProp((NoCodeDecimalProp)this.prop, decimal, true);
    }
}

