/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.handle.prop;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.nocode.restapi.common.util.CollectionUtil;
import kd.bos.nocode.restapi.common.util.DataUtil;
import kd.bos.nocode.restapi.handle.AbstractPropertyHandle;
import kd.bos.nocode.restapi.handle.QueryApiFormatUtil;
import kd.bos.orm.util.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class EntryPropHandle
extends AbstractPropertyHandle<EntryProp> {
    public EntryPropHandle(EntryProp prop) {
        super(prop);
    }

    @Override
    public void copyValue(DynamicObject source, Map<String, Object> target, boolean useFormatStringValue) {
        DynamicObjectCollection sources = source.getDynamicObjectCollection(this.propName);
        target.put(this.propName, this.formatValue0(sources));
    }

    @NotNull
    private String formatValue0(DynamicObjectCollection sources) {
        HashMap<String, Integer> valueMap = new HashMap<String, Integer>(2);
        int size = CollectionUtils.isEmpty((Collection)sources) ? 0 : sources.size();
        valueMap.put("total", size);
        return SerializationUtils.toJsonString(valueMap);
    }

    @Override
    public List<Object> formatValue(List<Object> sourceValueList) {
        return sourceValueList.stream().map(e -> this.formatValue0((DynamicObjectCollection)e)).collect(Collectors.toList());
    }

    @Override
    public void copyValue(List<DynamicObject> sourceList, DynamicObject target) {
        this.checkNull(sourceList, target);
        String currFullPropName = this.getCurrFullPropName();
        List<DynamicObject> srcList = this.distinctByProp(sourceList, it -> DataUtil.l((Object)it.get(currFullPropName)) > 0L, it -> it.getString(currFullPropName));
        if (CollectionUtil.isEmpty(srcList)) {
            return;
        }
        DynamicObjectCollection value = target.getDynamicObjectCollection(this.prop);
        for (DynamicObject src : srcList) {
            List<DynamicObject> srcSubList = sourceList.stream().filter(it -> DataUtil.l((Object)it.get(currFullPropName)) > 0L && it.getString(currFullPropName).equals(src.getString(currFullPropName))).collect(Collectors.toList());
            QueryApiFormatUtil.queryObjToLoadObj(srcSubList, value, (Set<String>)this.select, currFullPropName);
        }
        target.set(this.prop, (Object)value);
    }
}

