/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.handle.prop;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.property.NoCodeMulRefBillProp;
import kd.bos.nocode.restapi.handle.AbstractPropertyHandle;
import kd.bos.nocode.restapi.handle.PropertyHandle;
import kd.bos.nocode.restapi.handle.PropertyHandleFactory;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.orm.util.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class MulRefBillPropHandle
extends AbstractPropertyHandle<NoCodeMulRefBillProp> {
    private static final Log logger = LogFactory.getLog(MulRefBillPropHandle.class);
    public static final String NULL_PROP_VALUE_HINT = "-";
    private boolean hide = false;

    public MulRefBillPropHandle(NoCodeMulRefBillProp prop) {
        super(prop);
        String field = prop.getMainDisplayProperty();
        String fid = prop.getBillEntityId();
        if (StringUtils.isNotEmpty((CharSequence)fid) && StringUtils.isNotEmpty((CharSequence)field)) {
            Set hides = NoCodePermHelper.getNoViewFieldPermSet((String)fid);
            this.hide = hides.contains(field);
        }
    }

    @Override
    public Object formatValue(DynamicObject source) {
        String value = source.getString(this.propName);
        Object[] dynamicObjects = ((NoCodeMulRefBillProp)this.prop).loadRefBillObjects(value, ((NoCodeMulRefBillProp)this.prop).getMainDisplayProperty());
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return "";
        }
        ArrayList<String> values = new ArrayList<String>(dynamicObjects.length);
        for (Object dynamicObject : dynamicObjects) {
            IDataEntityProperty mainDispProp = (IDataEntityProperty)dynamicObject.getDataEntityType().getProperties().get((Object)((NoCodeMulRefBillProp)this.prop).getMainDisplayProperty());
            if (Objects.isNull(mainDispProp)) continue;
            Object mainValue = mainDispProp.getValue(dynamicObject);
            PropertyHandle dtPropertyHandle = PropertyHandleFactory.tryGetPropertyHandle(mainDispProp);
            if (Objects.nonNull(dtPropertyHandle)) {
                this.add2Values(values, (DynamicObject)dynamicObject, dtPropertyHandle);
                continue;
            }
            if (mainValue instanceof ILocaleString) {
                values.add(((ILocaleString)mainValue).getLocaleValue());
                continue;
            }
            if (StringUtils.isBlank((Object)mainValue)) {
                values.add(NULL_PROP_VALUE_HINT);
                continue;
            }
            values.add(mainValue.toString());
        }
        return String.join((CharSequence)",", values);
    }

    private void add2Values(List<String> values, DynamicObject dynamicObject, PropertyHandle dtPropertyHandle) {
        String formatValue = dtPropertyHandle.formatStringValue(dynamicObject);
        if (StringUtils.isNotBlank((CharSequence)formatValue)) {
            values.add(formatValue);
        } else {
            values.add(NULL_PROP_VALUE_HINT);
        }
    }

    @Override
    public Object formatValue(Row source) {
        String value = source.getString(this.getCurrFullPropName());
        DynamicObject[] dynamicObjects = ((NoCodeMulRefBillProp)this.prop).loadRefBillObjects(value, ((NoCodeMulRefBillProp)this.prop).getMainDisplayProperty());
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return "";
        }
        ArrayList<String> values = new ArrayList<String>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            IDataEntityProperty mainDispProp = (IDataEntityProperty)dynamicObject.getDataEntityType().getProperties().get((Object)((NoCodeMulRefBillProp)this.prop).getMainDisplayProperty());
            if (mainDispProp == null) continue;
            Object mainValue = mainDispProp.getValue((Object)dynamicObject);
            PropertyHandle dtPropertyHandle = PropertyHandleFactory.tryGetPropertyHandle(mainDispProp);
            if (dtPropertyHandle != null) {
                this.add2Values(values, dynamicObject, dtPropertyHandle);
                continue;
            }
            if (mainValue instanceof ILocaleString) {
                values.add(((ILocaleString)mainValue).getLocaleValue());
                continue;
            }
            if (mainValue == null || mainValue instanceof String && StringUtils.isBlank((CharSequence)((String)mainValue))) {
                values.add(NULL_PROP_VALUE_HINT);
                continue;
            }
            values.add(mainValue.toString());
        }
        return String.join((CharSequence)",", values);
    }

    @Override
    public List<Object> formatValue(List<Object> sourceValueList) {
        ArrayList<Object> targetValueList = new ArrayList<Object>(sourceValueList.size());
        DynamicObject[] dynamicObjects = this.getAllRefBillObjects(sourceValueList);
        Map<Long, String> id2MainDisplayProp = Arrays.stream(dynamicObjects).collect(Collectors.toMap(e -> e.getLong("id"), this::getMainDisplayProp, (key1, key2) -> key1));
        for (Object sourceValue : sourceValueList) {
            String valueStr = (String)sourceValue;
            if (StringUtils.isBlank((CharSequence)valueStr)) {
                targetValueList.add("");
                continue;
            }
            List valueStrList = Splitter.on((String)",").splitToList((CharSequence)valueStr);
            ArrayList<String> showValueList = new ArrayList<String>(valueStrList.size());
            for (String s : valueStrList) {
                try {
                    String o = id2MainDisplayProp.get(Long.parseLong(s));
                    showValueList.add(o);
                }
                catch (NumberFormatException ne) {
                    logger.warn((Throwable)ne);
                    showValueList.add(ResManager.loadKDString((String)"\u9519\u8bef\u6570\u636e", (String)"MulRefBillPropHandle_0", (String)"bos-nocode-format", (Object[])new Object[0]));
                }
            }
            String targetValue = showValueList.stream().filter(StringUtils::isNotBlank).collect(Collectors.joining(","));
            targetValueList.add(targetValue);
        }
        return targetValueList;
    }

    private String getMainDisplayProp(DynamicObject e) {
        IDataEntityProperty mainDispProp = (IDataEntityProperty)e.getDataEntityType().getProperties().get((Object)((NoCodeMulRefBillProp)this.prop).getMainDisplayProperty());
        if (Objects.isNull(mainDispProp) || this.hide) {
            return "";
        }
        Object mainValue = mainDispProp.getValue((Object)e);
        PropertyHandle dtPropertyHandle = PropertyHandleFactory.tryGetPropertyHandle(mainDispProp);
        if (Objects.nonNull(dtPropertyHandle)) {
            return this.getNestedValue(e, dtPropertyHandle);
        }
        if (mainValue instanceof ILocaleString) {
            return MulRefBillPropHandle.getStringOrHintValue(((ILocaleString)mainValue).getLocaleValue());
        }
        if (mainValue == null || mainValue instanceof String && StringUtils.isBlank((CharSequence)((String)mainValue))) {
            return NULL_PROP_VALUE_HINT;
        }
        return mainValue.toString();
    }

    private DynamicObject[] getAllRefBillObjects(List<Object> sourceValueList) {
        List queryValueList = sourceValueList.stream().map(String.class::cast).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(queryValueList)) {
            return new DynamicObject[0];
        }
        String value = String.join((CharSequence)",", queryValueList);
        Object[] dynamicObjects = ((NoCodeMulRefBillProp)this.prop).loadRefBillObjects(value, ((NoCodeMulRefBillProp)this.prop).getMainDisplayProperty());
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return new DynamicObject[0];
        }
        return dynamicObjects;
    }

    private String getNestedValue(DynamicObject dynamicObject, PropertyHandle dtPropertyHandle) {
        String formatValue = dtPropertyHandle.formatStringValue(dynamicObject);
        return MulRefBillPropHandle.getStringOrHintValue(formatValue);
    }

    @NotNull
    private static String getStringOrHintValue(String formatValue) {
        if (StringUtils.isNotBlank((CharSequence)formatValue)) {
            return formatValue;
        }
        return NULL_PROP_VALUE_HINT;
    }

    @Override
    public void copyValue(DynamicObject source, Map<String, Object> target, boolean useFormatStringValue) {
        super.copyValue(source, target, useFormatStringValue);
        target.put(this.propName + ".id", source.get(this.propName));
        target.put(this.propName + "_id", source.get(this.propName));
    }
}

