/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.nocode.restapi.handle.prop;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.nocode.ext.property.NoCodeRefBillProp;
import kd.bos.nocode.restapi.common.util.DataUtil;
import kd.bos.nocode.restapi.handle.AbstractPropertyHandle;
import kd.bos.nocode.restapi.handle.PropertyHandle;
import kd.bos.nocode.restapi.handle.PropertyHandleFactory;
import kd.bos.nocode.restapi.handle.QueryApiFormatUtil;
import kd.bos.nocode.utils.NoCodePermHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.jetbrains.annotations.Nullable;

public class RefBillPropHandle
extends AbstractPropertyHandle<NoCodeRefBillProp> {
    private static final Log log = LogFactory.getLog(RefBillPropHandle.class);
    private static final String NULL_PROP_VALUE_HINT = "-";
    private boolean hide = false;

    public RefBillPropHandle(NoCodeRefBillProp prop) {
        super(prop);
        String field = prop.getMainDisplayProperty();
        String fid = prop.getBillEntityId();
        if (StringUtils.isNotEmpty((CharSequence)fid) && StringUtils.isNotEmpty((CharSequence)field)) {
            try {
                Set hides = NoCodePermHelper.getNoViewFieldPermSet((String)fid);
                this.hide = hides.contains(field);
            }
            catch (KDException ex) {
                log.debug(ex.getMessage());
                this.hide = true;
            }
        }
    }

    @Override
    public void copyValue(List<DynamicObject> sourceList, DynamicObject target) {
        super.checkNull(sourceList, target);
        String currFullPropName = this.getCurrFullPropName();
        List<DynamicObject> srcList = this.distinctByProp(sourceList, it -> DataUtil.l((Object)it.get(currFullPropName)) > 0L, it -> it.getString(currFullPropName));
        DynamicObject value = QueryApiFormatUtil.queryObjToLoadObj(srcList, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)((NoCodeRefBillProp)this.prop).getBillEntityId()), (Set<String>)this.select, currFullPropName);
        if (value != null) {
            value.set("id", srcList.get(0).get(this.getCurrFullPropName()));
        }
        target.set(this.prop, (Object)value);
    }

    @Override
    public Object formatValue(DynamicObject source) {
        DynamicObject object = source.getDynamicObject(this.propName);
        return this.formatValue0(object, false);
    }

    @Override
    public List<Object> formatValue(List<Object> sourceValueList) {
        return sourceValueList.stream().map(e -> this.formatValue0((DynamicObject)e, false)).collect(Collectors.toList());
    }

    @Nullable
    private Object formatValue0(DynamicObject object, boolean useFormatStringValue) {
        Object value = null;
        if (Objects.isNull(object)) {
            return value;
        }
        String propsDisplay = ((NoCodeRefBillProp)this.prop).getPropsDisplay();
        if (StringUtils.isBlank((CharSequence)propsDisplay)) {
            return value;
        }
        String mainPropertyName = propsDisplay.split(",")[0];
        IDataEntityProperty mainProperty = (IDataEntityProperty)object.getDataEntityType().getProperties().get((Object)mainPropertyName);
        if (Objects.isNull(mainProperty)) {
            return value;
        }
        if (object.getDataEntityType() instanceof RefEntityType && object.getDataEntityType().getPrimaryKey() != null) {
            if (this.hide) {
                return "";
            }
            RefEntityType refEntityType = (RefEntityType)object.getDataEntityType();
            Object refPk = refEntityType.getPrimaryKey().getValue((Object)object);
            if (refPk != null) {
                String v;
                DynamicObject refDynObj = BusinessDataServiceHelper.loadSingle((Object)refPk, (String)refEntityType.getName(), (String)mainPropertyName);
                MainEntityType refDt = EntityMetadataCache.getDataEntityType((String)refEntityType.getName());
                IDataEntityProperty refProp = refDt.findProperty(mainPropertyName);
                PropertyHandle refDtPropertyHandle = PropertyHandleFactory.tryGetPropertyHandle(refProp);
                if (Objects.nonNull(refDtPropertyHandle) && StringUtils.isEmpty((CharSequence)(v = refDtPropertyHandle.formatStringValue(refDynObj)))) {
                    return NULL_PROP_VALUE_HINT;
                }
            }
        }
        value = mainProperty.getValue((Object)object);
        PropertyHandle dtPropertyHandle = PropertyHandleFactory.tryGetPropertyHandle(mainProperty);
        if (Objects.nonNull(dtPropertyHandle)) {
            value = dtPropertyHandle.formatStringValue(object);
        } else if (value instanceof ILocaleString) {
            value = ((ILocaleString)value).getLocaleValue();
        }
        if (value == null || value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
            return NULL_PROP_VALUE_HINT;
        }
        return value;
    }

    @Override
    public Object formatValue(Row source) {
        long object = (Long)source.get(this.getCurrFullPropName());
        Object value = null;
        if (object == 0L) {
            return null;
        }
        DynamicObject dynamicObject = null;
        try {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)object, (String)((NoCodeRefBillProp)this.prop).getBillEntityId());
        }
        catch (Exception e) {
            log.debug("\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0cobject={}", (Object)object, (Object)e);
            return value;
        }
        String propsDisplay = ((NoCodeRefBillProp)this.prop).getPropsDisplay();
        if (StringUtils.isBlank((CharSequence)propsDisplay)) {
            return value;
        }
        String mainPropertyName = propsDisplay.split(",")[0];
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)((NoCodeRefBillProp)this.prop).getBillEntityId());
        IDataEntityProperty mainProperty = (IDataEntityProperty)dataEntityType.getProperties().get((Object)mainPropertyName);
        if (mainProperty != null) {
            value = mainProperty.getValue((Object)dynamicObject);
            PropertyHandle dtPropertyHandle = PropertyHandleFactory.tryGetPropertyHandle(mainProperty);
            if (dtPropertyHandle != null) {
                Object formatValue = dtPropertyHandle.formatValue(dynamicObject);
                if (formatValue != null) {
                    value = formatValue;
                }
            } else if (value instanceof ILocaleString) {
                value = ((ILocaleString)value).getLocaleValue();
            }
        }
        if (value == null || value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
            return NULL_PROP_VALUE_HINT;
        }
        return value;
    }

    @Override
    public String formatStringValue(DynamicObject source) {
        DynamicObject object = source.getDynamicObject(this.propName);
        return (String)this.formatValue0(object, true);
    }

    @Override
    public void copyValue(DynamicObject source, Map<String, Object> target, boolean useFormatStringValue) {
        super.copyValue(source, target, useFormatStringValue);
        DynamicObject object = source.getDynamicObject(this.propName);
        if (object != null) {
            target.put(this.propName + ".id", object.getPkValue());
            target.put(this.propName + "_id", object.getPkValue());
        } else {
            target.put(this.propName + ".id", null);
            target.put(this.propName + "_id", null);
        }
    }
}

